/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#include "window_list.h"

WindowList::WindowList(QWorkspace *work_space, QWidget * parent ):QComboBox(parent)
{
	connect( this, SIGNAL(activated ( int  ) ), this, SLOT(itemClicked_callback ( int  ) ) );
	connect(work_space,SIGNAL(windowActivated(QWidget *)), this, SLOT(window_activated_callback(QWidget *) ));
	this->work_space=work_space;
	setIconSize(QSize(32,32));
}

void WindowList::itemClicked_callback ( int item ) 
{
	QWidget *widget=itemData(item).value<QWidget*>();
	work_space->setActiveWindow(widget);
}

void WindowList::showPopup()
{
	clear();
	QWidgetList widget_list=work_space->windowList(QWorkspace::StackingOrder);
	for(int i=0;i<widget_list.size();i++)
	{
		QWidget *widget=widget_list.at(i);
		addItem(widget->windowIcon(),widget->windowTitle(),qVariantFromValue(widget));
	}
	QComboBox::showPopup();
}

void WindowList::window_activated_callback(QWidget *widget)
{
	clear();
	addItem(widget->windowIcon(),widget->windowTitle(),qVariantFromValue(widget));
}


