#ifndef Counter_h
#define Counter_h

// $Id: Counter.h,v 1.18 2013/04/29 07:13:16 hupereir Exp $

/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include <QString>
#include <QPair>

//! Object counter
class Counter {

    public:

    //! counter name and counts pair
    typedef QPair<QString, int> Pair;

    //! constructor
    Counter( const QString& name );

    //! constructor
    Counter( const Counter& counter );

    //! destructor
    virtual ~Counter( void );

    //! retrieves counter count
    int count( void ) const;

    private:

    //! pointer to integer counter
    int* count_;

};

#endif
