/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKEVIEWFINDERSETTINGSCONTROL_H
#define FAKEVIEWFINDERSETTINGSCONTROL_H

#include <QCameraViewfinderSettingsControl>

class FakeCameraService;

class FakeViewfinderSettingsControl : public QCameraViewfinderSettingsControl
{
public:
    FakeViewfinderSettingsControl(FakeCameraService *service, QObject *parent = 0);
    ~FakeViewfinderSettingsControl();

    bool isViewfinderParameterSupported(ViewfinderParameter parameter) const ;
    void setViewfinderParameter(ViewfinderParameter parameter, const QVariant & value);
    QVariant viewfinderParameter(ViewfinderParameter parameter) const;

private:
    FakeCameraService *m_service;
};

#endif // AALVIEWFINDERSETTINGSCONTROL_H
