/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7 */
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;

/* Initialize Ruby runtime support */
SWIGRUNTIME(void)
SWIG_Ruby_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
SWIGRUNTIME(void)
SWIG_Ruby_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
SWIGRUNTIME(VALUE)
SWIG_Ruby_NewPointerObj(void *ptr, swig_type_info *type, int own)
{
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
	return Qnil;
    
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Create a new class instance (always owned) */
SWIGRUNTIME(VALUE)
SWIG_Ruby_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
SWIGRUNTIME(char *)
SWIG_Ruby_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return StringValuePtr(stype);
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_Ruby_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_type_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else {
    Data_Get_Struct(obj, void, *ptr);
  }
  
  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (*ptr == 0)
            rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
          return 0;
        }
    }
    if ((c = SWIG_MangleStr(obj)) == NULL) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    *ptr = SWIG_TypeCast(tc, *ptr);
  }
  return 0;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME(void *)
SWIG_Ruby_MustGetPtr(VALUE obj, swig_type_info *ty, int argnum, int flags)
{
  void *result;
  SWIG_ConvertPtr(obj, &result, ty, flags | SWIG_POINTER_EXCEPTION);
  return result;
}

/* Check convert */
SWIGRUNTIME(int)
SWIG_Ruby_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

SWIGRUNTIME(VALUE)
SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
SWIGRUNTIME(void)
SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = StringValuePtr(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_Array swig_types[0] 
#define  SWIGTYPE_p_SampleTdouble_t swig_types[1] 
#define  SWIGTYPE_p_std__vectorTdouble_t swig_types[2] 
#define  SWIGTYPE_p_HandleTQuote_t swig_types[3] 
#define  SWIGTYPE_p_RelinkableHandleTQuote_t swig_types[4] 
#define  SWIGTYPE_p_FixedSwapLeg swig_types[5] 
#define  SWIGTYPE_p_FloatingSwapLeg swig_types[6] 
#define  SWIGTYPE_p_FdEuropean swig_types[7] 
#define  SWIGTYPE_p_Optimizer swig_types[8] 
#define  SWIGTYPE_p_RateHelper swig_types[9] 
#define  SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t swig_types[10] 
#define  SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t swig_types[11] 
#define  SWIGTYPE_p_Constraint swig_types[12] 
#define  SWIGTYPE_p_BoundaryConstraint swig_types[13] 
#define  SWIGTYPE_p_NoConstraint swig_types[14] 
#define  SWIGTYPE_p_PositiveConstraint swig_types[15] 
#define  SWIGTYPE_p_CashFlow swig_types[16] 
#define  SWIGTYPE_p_ICGaussianRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t swig_types[17] 
#define  SWIGTYPE_p_HaltonRsg swig_types[18] 
#define  SWIGTYPE_p_SampleTPath_t swig_types[19] 
#define  SWIGTYPE_p_SafeBicubicSpline swig_types[20] 
#define  SWIGTYPE_p_SafeNaturalMonotonicCubicSpline swig_types[21] 
#define  SWIGTYPE_p_SafeNaturalCubicSpline swig_types[22] 
#define  SWIGTYPE_p_Path swig_types[23] 
#define  SWIGTYPE_p_Statistics swig_types[24] 
#define  SWIGTYPE_p_RiskStatistics swig_types[25] 
#define  SWIGTYPE_p_DirichletBCHandle swig_types[26] 
#define  SWIGTYPE_p_NeumannBCHandle swig_types[27] 
#define  SWIGTYPE_p_ExtendedDiscountCurveHandle swig_types[28] 
#define  SWIGTYPE_p_BlackCapFloorEngineHandle swig_types[29] 
#define  SWIGTYPE_p_SimpleCashFlowHandle swig_types[30] 
#define  SWIGTYPE_p_BjerksundStenslandApproximationEngineHandle swig_types[31] 
#define  SWIGTYPE_p_BaroneAdesiWhaleyApproximationEngineHandle swig_types[32] 
#define  SWIGTYPE_p_MCEuropeanEngineHandle swig_types[33] 
#define  SWIGTYPE_p_BinomialVanillaEngineHandle swig_types[34] 
#define  SWIGTYPE_p_DiscountCurveHandle swig_types[35] 
#define  SWIGTYPE_p_SimpleQuoteHandle swig_types[36] 
#define  SWIGTYPE_p_ImpliedTermStructureHandle swig_types[37] 
#define  SWIGTYPE_p_ZeroSpreadedTermStructureHandle swig_types[38] 
#define  SWIGTYPE_p_ForwardSpreadedTermStructureHandle swig_types[39] 
#define  SWIGTYPE_p_EuropeanExerciseHandle swig_types[40] 
#define  SWIGTYPE_p_AmericanExerciseHandle swig_types[41] 
#define  SWIGTYPE_p_BermudanExerciseHandle swig_types[42] 
#define  SWIGTYPE_p_BlackVarianceSurfaceHandle swig_types[43] 
#define  SWIGTYPE_p_BlackScholesStochasticProcessHandle swig_types[44] 
#define  SWIGTYPE_p_Merton76StochasticProcessHandle swig_types[45] 
#define  SWIGTYPE_p_StockHandle swig_types[46] 
#define  SWIGTYPE_p_AnalyticEuropeanEngineHandle swig_types[47] 
#define  SWIGTYPE_p_IntegralEngineHandle swig_types[48] 
#define  SWIGTYPE_p_HullWhiteHandle swig_types[49] 
#define  SWIGTYPE_p_BlackKarasinskiHandle swig_types[50] 
#define  SWIGTYPE_p_BlackSwaptionEngineHandle swig_types[51] 
#define  SWIGTYPE_p_HandleTBoundaryCondition_t swig_types[52] 
#define  SWIGTYPE_p_DPlus swig_types[53] 
#define  SWIGTYPE_p_ICGaussianRngTKnuthUniformRng_InverseCumulativeNormal_t swig_types[54] 
#define  SWIGTYPE_p_std__vectorTHandleTRateHelper_t_t swig_types[55] 
#define  SWIGTYPE_p_std__vectorTHandleTCalibrationHelper_t_t swig_types[56] 
#define  SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t swig_types[57] 
#define  SWIGTYPE_p_SequenceStatisticsTStatistics_t swig_types[58] 
#define  SWIGTYPE_p_CliquetOptionPricer swig_types[59] 
#define  SWIGTYPE_p_Simplex swig_types[60] 
#define  SWIGTYPE_p_PricingEngine swig_types[61] 
#define  SWIGTYPE_p_ContinuousGeometricAPO swig_types[62] 
#define  SWIGTYPE_p_DiscreteGeometricAPO swig_types[63] 
#define  SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t swig_types[64] 
#define  SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t swig_types[65] 
#define  SWIGTYPE_p_SampleTMultiPath_t swig_types[66] 
#define  SWIGTYPE_p_BlackModel swig_types[67] 
#define  SWIGTYPE_p_HandleTIndex_t swig_types[68] 
#define  SWIGTYPE_p_LexicographicalView swig_types[69] 
#define  SWIGTYPE_p_HandleTShortRateModel_t swig_types[70] 
#define  SWIGTYPE_p_HandleTBlackModel_t swig_types[71] 
#define  SWIGTYPE_p_GaussianPathGenerator_old swig_types[72] 
#define  SWIGTYPE_p_std__vectorTDate_t swig_types[73] 
#define  SWIGTYPE_p_ICGaussianRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t swig_types[74] 
#define  SWIGTYPE_p_ICGaussianRngTLecuyerUniformRng_InverseCumulativeNormal_t swig_types[75] 
#define  SWIGTYPE_p_McMaxBasket swig_types[76] 
#define  SWIGTYPE_p_GaussianMultiPathGenerator swig_types[77] 
#define  SWIGTYPE_p_GaussianLowDiscrepancySequenceGenerator swig_types[78] 
#define  SWIGTYPE_p_GaussianRandomSequenceGenerator swig_types[79] 
#define  SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator swig_types[80] 
#define  SWIGTYPE_p_UniformRandomSequenceGenerator swig_types[81] 
#define  SWIGTYPE_p_GaussianRandomGenerator swig_types[82] 
#define  SWIGTYPE_p_UniformRandomGenerator swig_types[83] 
#define  SWIGTYPE_p_TridiagonalOperator swig_types[84] 
#define  SWIGTYPE_p_SVD swig_types[85] 
#define  SWIGTYPE_p_DMinus swig_types[86] 
#define  SWIGTYPE_p_DPlusDMinus swig_types[87] 
#define  SWIGTYPE_p_CumulativeNormalDistribution swig_types[88] 
#define  SWIGTYPE_p_NormalDistribution swig_types[89] 
#define  SWIGTYPE_p_StochasticProcess swig_types[90] 
#define  SWIGTYPE_p_Schedule swig_types[91] 
#define  SWIGTYPE_p_HandleTPricingEngine_t swig_types[92] 
#define  SWIGTYPE_p_std__vectorTHandleTQuote_t_t swig_types[93] 
#define  SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t swig_types[94] 
#define  SWIGTYPE_p_HistoryEntry swig_types[95] 
#define  SWIGTYPE_p_ICGaussianRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t swig_types[96] 
#define  SWIGTYPE_p_ICGaussianRngTKnuthUniformRng_MoroInverseCumulativeNormal_t swig_types[97] 
#define  SWIGTYPE_p_ICGaussianRsgTHaltonRsg_MoroInverseCumulativeNormal_t swig_types[98] 
#define  SWIGTYPE_p_Period swig_types[99] 
#define  SWIGTYPE_p_Calendar swig_types[100] 
#define  SWIGTYPE_p_JointCalendar swig_types[101] 
#define  SWIGTYPE_p_HandleTCapFlatVolatilityStructure_t swig_types[102] 
#define  SWIGTYPE_p_HandleTSwaptionVolatilityStructure_t swig_types[103] 
#define  SWIGTYPE_p_HandleTTermStructure_t swig_types[104] 
#define  SWIGTYPE_p_HandleTBlackVolTermStructure_t swig_types[105] 
#define  SWIGTYPE_p_HandleTLocalVolTermStructure_t swig_types[106] 
#define  SWIGTYPE_p_RelinkableHandleTTermStructure_t swig_types[107] 
#define  SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t swig_types[108] 
#define  SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t swig_types[109] 
#define  SWIGTYPE_p_RubyObserver swig_types[110] 
#define  SWIGTYPE_p_RelinkableHandleTSwaptionVolatilityStructure_t swig_types[111] 
#define  SWIGTYPE_p_RelinkableHandleTCapFlatVolatilityStructure_t swig_types[112] 
#define  SWIGTYPE_p_Ridder swig_types[113] 
#define  SWIGTYPE_p_SobolRsg swig_types[114] 
#define  SWIGTYPE_p_McDiscreteArithmeticASO swig_types[115] 
#define  SWIGTYPE_p_std__vectorTPeriod_t swig_types[116] 
#define  SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t swig_types[117] 
#define  SWIGTYPE_p_TimeBasket swig_types[118] 
#define  SWIGTYPE_p_McBasket swig_types[119] 
#define  SWIGTYPE_p_McEverest swig_types[120] 
#define  SWIGTYPE_p_HandleTCalibrationHelper_t swig_types[121] 
#define  SWIGTYPE_p_HandleTRateHelper_t swig_types[122] 
#define  SWIGTYPE_p_HandleTPayoff_t swig_types[123] 
#define  SWIGTYPE_p_BoundaryCondition swig_types[124] 
#define  SWIGTYPE_p_FalsePosition swig_types[125] 
#define  SWIGTYPE_p_TermStructure swig_types[126] 
#define  SWIGTYPE_p_BlackVolTermStructure swig_types[127] 
#define  SWIGTYPE_p_LocalVolTermStructure swig_types[128] 
#define  SWIGTYPE_p_SwaptionVolatilityStructure swig_types[129] 
#define  SWIGTYPE_p_CapFlatVolatilityStructure swig_types[130] 
#define  SWIGTYPE_p_Instrument swig_types[131] 
#define  SWIGTYPE_p_KronrodIntegral swig_types[132] 
#define  SWIGTYPE_p_SimpsonIntegral swig_types[133] 
#define  SWIGTYPE_p_TrapezoidIntegral swig_types[134] 
#define  SWIGTYPE_p_SegmentIntegral swig_types[135] 
#define  SWIGTYPE_p_Index swig_types[136] 
#define  SWIGTYPE_p_Quote swig_types[137] 
#define  SWIGTYPE_p_McHimalaya swig_types[138] 
#define  SWIGTYPE_p_Payoff swig_types[139] 
#define  SWIGTYPE_p_DayCounter swig_types[140] 
#define  SWIGTYPE_p_McPagoda swig_types[141] 
#define  SWIGTYPE_p_MultiPath swig_types[142] 
#define  SWIGTYPE_p_Observable swig_types[143] 
#define  SWIGTYPE_p_Date swig_types[144] 
#define  SWIGTYPE_p_HandleTStochasticProcess_t swig_types[145] 
#define  SWIGTYPE_p_History swig_types[146] 
#define  SWIGTYPE_p_LexicographicalViewColumn swig_types[147] 
#define  SWIGTYPE_p_BoxMullerGaussianRngTMersenneTwisterUniformRng_t swig_types[148] 
#define  SWIGTYPE_p_ConjugateGradient swig_types[149] 
#define  SWIGTYPE_p_std__vectorTint_t swig_types[150] 
#define  SWIGTYPE_p_EuropeanOption swig_types[151] 
#define  SWIGTYPE_p_FdDividendEuropeanOption swig_types[152] 
#define  SWIGTYPE_p_FdAmericanOption swig_types[153] 
#define  SWIGTYPE_p_FdDividendAmericanOption swig_types[154] 
#define  SWIGTYPE_p_FdShoutOption swig_types[155] 
#define  SWIGTYPE_p_FdDividendShoutOption swig_types[156] 
#define  SWIGTYPE_p_FdBermudanOption swig_types[157] 
#define  SWIGTYPE_p_DiscreteGeometricASO swig_types[158] 
#define  SWIGTYPE_p_SampleTArray_t swig_types[159] 
#define  SWIGTYPE_p_Matrix swig_types[160] 
#define  SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t swig_types[161] 
#define  SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t swig_types[162] 
#define  SWIGTYPE_p_BoxMullerGaussianRngTKnuthUniformRng_t swig_types[163] 
#define  SWIGTYPE_p_BoxMullerGaussianRngTLecuyerUniformRng_t swig_types[164] 
#define  SWIGTYPE_p_CLGaussianRngTMersenneTwisterUniformRng_t swig_types[165] 
#define  SWIGTYPE_p_CLGaussianRngTKnuthUniformRng_t swig_types[166] 
#define  SWIGTYPE_p_CLGaussianRngTLecuyerUniformRng_t swig_types[167] 
#define  SWIGTYPE_p_OptimizationMethod swig_types[168] 
#define  SWIGTYPE_p_SafeBilinearInterpolation swig_types[169] 
#define  SWIGTYPE_p_SafeLogLinearInterpolation swig_types[170] 
#define  SWIGTYPE_p_SafeLinearInterpolation swig_types[171] 
#define  SWIGTYPE_p_DZero swig_types[172] 
#define  SWIGTYPE_p_Secant swig_types[173] 
#define  SWIGTYPE_p_HandleTCashFlow_t swig_types[174] 
#define  SWIGTYPE_p_ICGaussianRsgTHaltonRsg_InverseCumulativeNormal_t swig_types[175] 
#define  SWIGTYPE_p_MoroInverseCumulativeNormal swig_types[176] 
#define  SWIGTYPE_p_InverseCumulativeNormal swig_types[177] 
#define  SWIGTYPE_p_Brent swig_types[178] 
#define  SWIGTYPE_p_HandleTExercise_t swig_types[179] 
#define  SWIGTYPE_p_McDiscreteArithmeticAPO swig_types[180] 
#define  SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t swig_types[181] 
#define  SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t swig_types[182] 
#define  SWIGTYPE_p_CalibrationHelper swig_types[183] 
#define  SWIGTYPE_p_Bisection swig_types[184] 
#define  SWIGTYPE_p_ShortRateModel swig_types[185] 
#define  SWIGTYPE_p_CompoundForwardHandle swig_types[186] 
#define  SWIGTYPE_p_CollarHandle swig_types[187] 
#define  SWIGTYPE_p_FloorHandle swig_types[188] 
#define  SWIGTYPE_p_CapHandle swig_types[189] 
#define  SWIGTYPE_p_ParCouponHandle swig_types[190] 
#define  SWIGTYPE_p_FixedRateCouponHandle swig_types[191] 
#define  SWIGTYPE_p_XiborHandle swig_types[192] 
#define  SWIGTYPE_p_SwapHandle swig_types[193] 
#define  SWIGTYPE_p_FlatForwardHandle swig_types[194] 
#define  SWIGTYPE_p_BlackConstantVolHandle swig_types[195] 
#define  SWIGTYPE_p_LocalConstantVolHandle swig_types[196] 
#define  SWIGTYPE_p_VanillaOptionHandle swig_types[197] 
#define  SWIGTYPE_p_PlainVanillaPayoffHandle swig_types[198] 
#define  SWIGTYPE_p_PercentageStrikePayoffHandle swig_types[199] 
#define  SWIGTYPE_p_CashOrNothingPayoffHandle swig_types[200] 
#define  SWIGTYPE_p_AssetOrNothingPayoffHandle swig_types[201] 
#define  SWIGTYPE_p_SuperSharePayoffHandle swig_types[202] 
#define  SWIGTYPE_p_DepositRateHelperHandle swig_types[203] 
#define  SWIGTYPE_p_FraRateHelperHandle swig_types[204] 
#define  SWIGTYPE_p_FuturesRateHelperHandle swig_types[205] 
#define  SWIGTYPE_p_SwapRateHelperHandle swig_types[206] 
#define  SWIGTYPE_p_PiecewiseFlatForwardHandle swig_types[207] 
#define  SWIGTYPE_p_SwaptionHelperHandle swig_types[208] 
#define  SWIGTYPE_p_CapHelperHandle swig_types[209] 
#define  SWIGTYPE_p_JamshidianSwaptionHandle swig_types[210] 
#define  SWIGTYPE_p_TreeSwaptionHandle swig_types[211] 
#define  SWIGTYPE_p_TreeCapFloorHandle swig_types[212] 
#define  SWIGTYPE_p_SimpleSwapHandle swig_types[213] 
#define  SWIGTYPE_p_SwaptionHandle swig_types[214] 
#define  SWIGTYPE_p_SwaptionVolatilityMatrixHandle swig_types[215] 
#define  SWIGTYPE_p_CapFlatVolatilityVectorHandle swig_types[216] 
#define  SWIGTYPE_p_MersenneTwisterUniformRng swig_types[217] 
#define  SWIGTYPE_p_KnuthUniformRng swig_types[218] 
#define  SWIGTYPE_p_LecuyerUniformRng swig_types[219] 
#define  SWIGTYPE_p_HandleTObservable_t swig_types[220] 
#define  SWIGTYPE_p_SteepestDescent swig_types[221] 
#define  SWIGTYPE_p_HandleTInstrument_t swig_types[222] 
#define  SWIGTYPE_p_XiborManager swig_types[223] 
#define  SWIGTYPE_p_MatrixRow swig_types[224] 
#define  SWIGTYPE_p_Exercise swig_types[225] 
static swig_type_info *swig_types[227];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_QuantLibc
#define SWIG_name    "QuantLibc"

static VALUE mQuantLibc;

#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_exception_(int code, const char *msg) {
    switch (code) {
        case SWIG_MemoryError:
            rb_raise(rb_eNoMemError, msg);
            break;
        case SWIG_IOError:
            rb_raise(rb_eIOError, msg);
            break;
        case SWIG_RuntimeError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        case SWIG_IndexError:
            rb_raise(rb_eIndexError, msg);
            break;
        case SWIG_TypeError:
            rb_raise(rb_eTypeError, msg);
            break;
        case SWIG_DivisionByZero:
            rb_raise(rb_eZeroDivError, msg);
            break;
        case SWIG_OverflowError:
            rb_raise(rb_eRangeError, msg);
            break;
        case SWIG_SyntaxError:
            rb_raise(rb_eSyntaxError, msg);
            break;
        case SWIG_ValueError:
            rb_raise(rb_eArgError, msg);
            break;
        case SWIG_SystemError:
            rb_raise(rb_eFatal, msg);
            break;
        case SWIG_UnknownError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        default:
            break;
    }
}

#define SWIG_exception(a, b) SWIG_exception_((a), (b))


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000306f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <string>

#define SWIG_FLOAT_P(x) ((TYPE(x) == T_FLOAT) || FIXNUM_P(x))

bool SWIG_BOOL_P(VALUE) {
    // dummy test, RTEST should take care of everything
    return true;
}
bool SWIG_RB2BOOL(VALUE x) {
    return RTEST(x);
}
VALUE SWIG_BOOL2RB(bool b) {
    return b ? Qtrue : Qfalse;
}
double SWIG_NUM2DBL(VALUE x) {
    return (FIXNUM_P(x) ? FIX2INT(x) : NUM2DBL(x));
}
bool SWIG_STRING_P(VALUE x) {
    return TYPE(x) == T_STRING;
}
std::string SWIG_RB2STR(VALUE x) {
    return std::string(StringValuePtr(x));
}
VALUE SWIG_STR2RB(const std::string& s) {
    return rb_str_new2(s.c_str());
}


#include <string>


#include <vector>
#include <algorithm>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// generally useful classes
using QuantLib::Error;
using QuantLib::RelinkableHandle;
using QuantLib::IntegerFormatter;
using QuantLib::DoubleFormatter;
using QuantLib::StringFormatter;
#if !defined(HAVE_BOOST)
using QuantLib::Handle;
#endif
using QuantLib::IsNull;


using QuantLib::Observer;
using QuantLib::Observable;

bool HandlelObservable_g_isNull___(Handle<Observable > *self){
            return IsNull(*self);
        }

swig_class cObservable;
static void free_HandlelObservable_g___(Handle<Observable > *);

// C++ wrapper for Ruby observer
class RubyObserver : public Observer {
  public:
	RubyObserver(VALUE callback)
    : callback_(callback) {}
    void mark() { ((void (*)(VALUE))(rb_gc_mark))(callback_); }
    void update() {
        ID method = rb_intern("call");
        rb_funcall(callback_,method,0);
    }
  private:
	VALUE callback_;
    // inhibit copies
    RubyObserver(const RubyObserver&) {}
    RubyObserver& operator=(const RubyObserver&) { return *this; }
};

void markRubyObserver(void* p) {
    RubyObserver* o = static_cast<RubyObserver*>(p);
    o->mark();
}


swig_class cObserver;
static void free_RubyObserver(RubyObserver *);

using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Size;


using QuantLib::Array;
using QuantLib::Matrix;
using QuantLib::ArrayFormatter;
using QuantLib::IndexError;

std::string Array___str__(Array *self){
            return ArrayFormatter::toString(self->begin(),self->end());
        }
Array Array___add__(Array *self,Array const &a){
            return Array(*self+a);
        }
Array Array___sub__(Array *self,Array const &a){
            return Array(*self-a);
        }
Array Array___mul____SWIG_0(Array *self,double a){
            return Array(*self*a);
        }
double Array___mul____SWIG_1(Array *self,Array const &a){
            return QuantLib::DotProduct(*self,a);
        }
Array Array___mul____SWIG_2(Array *self,Matrix const &a){
            return *self*a;
        }
Array Array___div__(Array *self,double a){
            return Array(*self/a);
        }
void Array_each(Array *self){
            for (unsigned int i=0; i<self->size(); i++)
                rb_yield(rb_float_new((*self)[i]));
        }
double Array___getitem__(Array *self,int i){
            int size_ = static_cast<int>(self->size());
            if (i>=0 && i<size_) {
                return (*self)[i];
            } else if (i<0 && -i<=size_) {
                return (*self)[size_+i];
            } else {
                throw IndexError("Array index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }
void Array___setitem__(Array *self,int i,double x){
            int size_ = static_cast<int>(self->size());
            if (i>=0 && i<size_) {
                (*self)[i] = x;
            } else if (i<0 && -i<=size_) {
                (*self)[size_+i] = x;
            } else {
                throw IndexError("Array index out of range");
            }
        }

swig_class cArray;
static void free_Array(Array *);

typedef QuantLib::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator 
    LexicographicalViewColumn;

double LexicographicalViewColumn___getitem__(LexicographicalViewColumn *self,int i){
            return (*self)[i];
        }
void LexicographicalViewColumn___setitem__(LexicographicalViewColumn *self,int i,double x){
            (*self)[i] = x;
        }

swig_class cLexicographicalViewColumn;
static void free_LexicographicalViewColumn(LexicographicalViewColumn *);
LexicographicalView *new_LexicographicalView(Array &a,Size xSize){
            return new LexicographicalView(a.begin(),a.end(),xSize);
        }
std::string LexicographicalView___str__(LexicographicalView *self){
            std::string s;
            for (int j=0; j<static_cast<int>(self->ySize()); j++) {
                s += "\n";
                for (int i=0; i<static_cast<int>(self->xSize()); i++) {
                    if (i != 0)
                        s += ",";
                    s += DoubleFormatter::toString((*self)[i][j]);
                }
            }
            s += "\n";
            return s;
        }
LexicographicalViewColumn LexicographicalView___getitem__(LexicographicalView *self,Size i){
            return (*self)[i];
        }

swig_class cLexicographicalView;
static void free_LexicographicalView(LexicographicalView *);

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::matrixSqrt;
using QuantLib::SVD;

double MatrixRow___getitem__(MatrixRow *self,int i){
            return (*self)[i];
        }
void MatrixRow___setitem__(MatrixRow *self,int i,double x){
            (*self)[i] = x;
        }

swig_class cMatrixRow;
static void free_MatrixRow(MatrixRow *);
std::string Matrix___str__(Matrix *self){
            std::string s;
            for (Size j=0; j<self->rows(); j++) {
                s += "\n";
                s += QuantLib::DoubleFormatter::toString((*self)[j][0]);
                for (Size i=1; i<self->columns(); i++) {
                    s += ",";
                    s += QuantLib::DoubleFormatter::toString((*self)[j][i]);
                }
            }
            s += "\n";
            return s;
        }
Matrix Matrix___add__(Matrix *self,Matrix const &m){
            return *self+m;
        }
Matrix Matrix___sub__(Matrix *self,Matrix const &m){
            return *self-m;
        }
Matrix Matrix___mul____SWIG_0(Matrix *self,double x){
            return *self*x;
        }
Array Matrix___mul____SWIG_1(Matrix *self,Array const &x){
            return *self*x;
        }
Matrix Matrix___mul____SWIG_2(Matrix *self,Matrix const &x){
            return *self*x;
        }
Matrix Matrix___div__(Matrix *self,double x){
            return *self/x;
        }
MatrixRow Matrix___getitem__(Matrix *self,Size i){
            return (*self)[i];
        }

swig_class cMatrix;
static void free_Matrix(Matrix *);

swig_class cSVD;
static void free_SVD(SVD *);

using QuantLib::CostFunction;


class UnaryFunction {
  public:
    double operator()(double x) const {
        return NUM2DBL(rb_yield(rb_float_new(x)));
    }
};

class RubyCostFunction : public CostFunction {
  public:
    double value(const Array& x) const {
        VALUE a = rb_ary_new2(x.size());
        for (Size i=0; i<x.size(); i++)
            rb_ary_store(a,i,rb_float_new(x[i]));
        return NUM2DBL(rb_yield(a));
    }
};


using QuantLib::Quote;
using QuantLib::MarketElement;

bool HandlelQuote_g_isNull___(Handle<Quote > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelQuote_g_asObservable___(Handle<Quote > *self){
        return Handle<Observable>(*self);
    }

swig_class cQuote;
static void free_HandlelQuote_g___(Handle<Quote > *);
Handle<Observable > RelinkableHandlelQuote_g_asObservable___(RelinkableHandle<Quote > *self){
        return Handle<Observable>(*self);
    }

swig_class cQuoteHandle;
static void free_RelinkableHandlelQuote_g___(RelinkableHandle<Quote > *);

using QuantLib::SimpleQuote;
typedef Handle<Quote> SimpleQuoteHandle;

SimpleQuoteHandle *new_SimpleQuoteHandle(double value){
            return new SimpleQuoteHandle(new SimpleQuote(value));
        }
void SimpleQuoteHandle_setValue(SimpleQuoteHandle *self,double value){
            #if defined(HAVE_BOOST)
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
            #else
            Handle<SimpleQuote>(*self)->setValue(value);
            #endif
        }

swig_class cSimpleQuote;
static void free_SimpleQuoteHandle(SimpleQuoteHandle *);
Handle<Quote > std_vectorlHandlelQuote_g_g_pop___(std::vector<Handle<Quote > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Handle<Quote > x = self->back();
                self->pop_back();
                return x;
            }
Handle<Quote > &std_vectorlHandlelQuote_g_g___getitem_____(std::vector<Handle<Quote > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelQuote_g_g___setitem_____(std::vector<Handle<Quote > > *self,int i,Handle<Quote > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelQuote_g_g_each___(std::vector<Handle<Quote > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Handle<Quote >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_HandleTQuote_t, 0));
                }
            }

swig_class cQuoteVector;
static void free_std_vectorlHandlelQuote_g_g___(std::vector<Handle<Quote > > *);
RelinkableHandle<Quote > std_vectorlRelinkableHandlelQuote_g_g_pop___(std::vector<RelinkableHandle<Quote > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                RelinkableHandle<Quote > x = self->back();
                self->pop_back();
                return x;
            }
RelinkableHandle<Quote > &std_vectorlRelinkableHandlelQuote_g_g___getitem_____(std::vector<RelinkableHandle<Quote > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlRelinkableHandlelQuote_g_g___setitem_____(std::vector<RelinkableHandle<Quote > > *self,int i,RelinkableHandle<Quote > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlRelinkableHandlelQuote_g_g_each___(std::vector<RelinkableHandle<Quote > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    RelinkableHandle<Quote >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_RelinkableHandleTQuote_t, 0));
                }
            }

swig_class cQuoteHandleVector;
static void free_std_vectorlRelinkableHandlelQuote_g_g___(std::vector<RelinkableHandle<Quote > > *);

using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;

Weekday weekdayFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "sun" || s == "sunday")
        return QuantLib::Sunday;
    else if (s == "mon" || s == "monday")
        return QuantLib::Monday;
    else if (s == "tue" || s == "tuesday")
        return QuantLib::Tuesday;
    else if (s == "wed" || s == "wednesday")
        return QuantLib::Wednesday;
    else if (s == "thu" || s == "thursday")
        return QuantLib::Thursday;
    else if (s == "fri" || s == "friday")
        return QuantLib::Friday;
    else if (s == "sat" || s == "saturday")
        return QuantLib::Saturday;
    else
        throw Error("unknown weekday");
}
 
std::string stringFromWeekday(Weekday w) {
    switch (w) {
      case QuantLib::Sunday:    return "Sunday";
      case QuantLib::Monday:    return "Monday";
      case QuantLib::Tuesday:   return "Tuesday";
      case QuantLib::Wednesday: return "Wednesday";
      case QuantLib::Thursday:  return "Thursday";
      case QuantLib::Friday:    return "Friday";
      case QuantLib::Saturday:  return "Saturday";
      default:                  throw Error("unknown weekday");
    }
}


using QuantLib::Month;


using QuantLib::TimeUnit;

TimeUnit timeunitFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "d" || s == "day" || s == "days")
        return QuantLib::Days;
    else if (s == "w" || s == "week" || s == "weeks")
        return QuantLib::Weeks;
    else if (s == "m" || s == "month" || s == "months")
        return QuantLib::Months;
    else if (s == "y" || s == "year" || s == "years")
        return QuantLib::Years;
    else 
        throw Error("unknown time unit");
}

std::string stringFromTimeunit(TimeUnit u) {
    switch (u) {
      case QuantLib::Days:   return "days";
      case QuantLib::Weeks:  return "weeks";
      case QuantLib::Months: return "months";
      case QuantLib::Years:  return "years";
      default:               throw Error("unknown time unit");
    }
}


using QuantLib::Period;
using QuantLib::PeriodParser; 

Period *new_Period__SWIG_1(std::string const &str){
	    return new Period(PeriodParser::parse(str));
	}
std::string Period___str__(Period *self){
            std::string s = IntegerFormatter::toString(self->length());
            switch (self->units()) {
              case QuantLib::Days:
                return s + " day(s)";
              case QuantLib::Weeks:
                return s + " week(s)";
              case QuantLib::Months:
                return s + " month(s)";
              case QuantLib::Years:
                return s + " year(s)";
              default:
                return "Unknown period";
            }
            QL_DUMMY_RETURN(std::string());
        }
std::string Period___repr__(Period *self){
            std::string s = IntegerFormatter::toString(self->length());
            switch (self->units()) {
              case QuantLib::Days:
                return s + "D";
              case QuantLib::Weeks:
                return s + "W";
              case QuantLib::Months:
                return s + "M";
              case QuantLib::Years:
                return s + "Y";
              default:
                return "Unknown period";
            }
            QL_DUMMY_RETURN(std::string());
        }
int Period___cmp__(Period *self,Period const &other){
	   if (*self < other)
	      return -1;
	   if (*self == other)
	      return 0;
	   return 1;
	}

swig_class cPeriod;
static void free_Period(Period *);
Period std_vectorlPeriod_g_pop___(std::vector<Period > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Period x = self->back();
                self->pop_back();
                return x;
            }
Period &std_vectorlPeriod_g___getitem_____(std::vector<Period > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlPeriod_g___setitem_____(std::vector<Period > *self,int i,Period const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlPeriod_g_each___(std::vector<Period > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Period* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_Period, 0));
                }
            }

swig_class cPeriodVector;
static void free_std_vectorlPeriod_g___(std::vector<Period > *);

using QuantLib::Date;
using QuantLib::DateFormatter;
using QuantLib::DateParser; 

Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
	    return new Date(DateParser::parse(str,fmt));
	}
int Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
std::string Date___str__(Date *self){
            return DateFormatter::toString(*self);
        }
std::string Date___repr__(Date *self){
	   return "Date(" +
	      IntegerFormatter::toString(self->dayOfMonth()) +
	      "," +
	      IntegerFormatter::toString(int(self->month())) +
	      "," +
	      IntegerFormatter::toString(self->year()) +
	      ")";
	}
std::string Date_ISO(Date *self){
            return DateFormatter::toString(*self,DateFormatter::ISO);
        }
long Date_operator_s_____SWIG_1(Date *self,Date const &other){
            return *self - other;
        }
int Date___cmp__(Date *self,Date const &other){
            if (*self < other)
                return -1;
            else if (*self == other)
                return 0;
            else 
                return 1;
        }
Date Date_succ(Date *self){
            return self->plusDays(1);
        }

swig_class cDate;
static void free_Date(Date *);
Date std_vectorlDate_g_pop___(std::vector<Date > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Date x = self->back();
                self->pop_back();
                return x;
            }
Date &std_vectorlDate_g___getitem_____(std::vector<Date > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlDate_g___setitem_____(std::vector<Date > *self,int i,Date const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlDate_g_each___(std::vector<Date > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Date* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_Date, 0));
                }
            }

swig_class cDateVector;
static void free_std_vectorlDate_g___(std::vector<Date > *);

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;
using QuantLib::Actual360;
using QuantLib::Actual365;
using QuantLib::Thirty360;
using QuantLib::ActualActual;
using QuantLib::SimpleDayCounter;

DayCounter *new_DayCounter(std::string s){
            s = StringFormatter::toLowercase(s);
            if (s == "act365" || s == "act/365")
                return new DayCounter(Actual365());
            else if (s == "act360" || s == "act/360")
                return new DayCounter(Actual360());
            else if (s == "30/360" || s == "30/360us")
                return new DayCounter(Thirty360(Thirty360::USA));
            else if (s == "30e/360" || s == "30/360e" || s == "30/360eu")
                return new DayCounter(Thirty360(Thirty360::European));
            else if (s == "30/360i" || s == "30/360it")
                return new DayCounter(Thirty360(Thirty360::Italian));
            else if (s == "actact" || s == "act/act" || 
                     s == "act/act(b)" || s == "act/act (bond)")
                return new DayCounter(ActualActual(ActualActual::Bond));
            else if (s == "actacte" || s == "act/act(e)" 
                     || s == "act/act(Euro)")
                return new DayCounter(ActualActual(ActualActual::Euro));
            else if (s == "actacth" || s == "act/act(h)" 
                     || s == "act/act (ISDA)")
                return new DayCounter(ActualActual(ActualActual::Historical));
            else if (s == "simple")
                return new DayCounter(SimpleDayCounter());
            else
                throw Error("Unknown day counter: " + s);
            QL_DUMMY_RETURN((DayCounter*)(0));
        }
std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
bool DayCounter___eq__(DayCounter *self,DayCounter const &other){
            return (*self) == other;
        }

swig_class cDayCounter;
static void free_DayCounter(DayCounter *);

using QuantLib::Currency;
using QuantLib::CurrencyFormatter;


Currency currencyFromString(std::string s) {
    s = StringFormatter::toUppercase(s);
    if (s == "ARS")      return QuantLib::ARS;
    else if (s == "ATS") return QuantLib::ATS;
    else if (s == "AUD") return QuantLib::AUD;
    else if (s == "BDT") return QuantLib::BDT;
    else if (s == "BEF") return QuantLib::BEF;
    else if (s == "BGL") return QuantLib::BGL;
    else if (s == "BRL") return QuantLib::BRL;
    else if (s == "BYB") return QuantLib::BYB;
    else if (s == "CAD") return QuantLib::CAD;
    else if (s == "CHF") return QuantLib::CHF;
    else if (s == "CLP") return QuantLib::CLP;
    else if (s == "CNY") return QuantLib::CNY;
    else if (s == "COP") return QuantLib::COP;
    else if (s == "CYP") return QuantLib::CYP;
    else if (s == "CZK") return QuantLib::CZK;
    else if (s == "DEM") return QuantLib::DEM;
    else if (s == "DKK") return QuantLib::DKK;
    else if (s == "EEK") return QuantLib::EEK;
    else if (s == "EUR") return QuantLib::EUR;
    else if (s == "GBP") return QuantLib::GBP;
    else if (s == "GRD") return QuantLib::GRD;
    else if (s == "HKD") return QuantLib::HKD;
    else if (s == "HUF") return QuantLib::HUF;
    else if (s == "ILS") return QuantLib::ILS;
    else if (s == "INR") return QuantLib::INR;
    else if (s == "IQD") return QuantLib::IQD;
    else if (s == "IRR") return QuantLib::IRR;
    else if (s == "ISK") return QuantLib::ISK;
    else if (s == "ITL") return QuantLib::ITL;
    else if (s == "JPY") return QuantLib::JPY;
    else if (s == "KRW") return QuantLib::KRW;
    else if (s == "KWD") return QuantLib::KWD;
    else if (s == "LTL") return QuantLib::LTL;
    else if (s == "LVL") return QuantLib::LVL;
    else if (s == "MTL") return QuantLib::MTL;
    else if (s == "MXP") return QuantLib::MXP;
    else if (s == "NOK") return QuantLib::NOK;
    else if (s == "NPR") return QuantLib::NPR;
    else if (s == "NZD") return QuantLib::NZD;
    else if (s == "PKR") return QuantLib::PKR;
    else if (s == "PLN") return QuantLib::PLN;
    else if (s == "ROL") return QuantLib::ROL;
    else if (s == "SAR") return QuantLib::SAR;
    else if (s == "SEK") return QuantLib::SEK;
    else if (s == "SGD") return QuantLib::SGD;
    else if (s == "SIT") return QuantLib::SIT;
    else if (s == "SKK") return QuantLib::SKK;
    else if (s == "THB") return QuantLib::THB;
    else if (s == "TRL") return QuantLib::TRL;
    else if (s == "TTD") return QuantLib::TTD;
    else if (s == "TWD") return QuantLib::TWD;
    else if (s == "USD") return QuantLib::USD;
    else if (s == "VEB") return QuantLib::VEB;
    else if (s == "ZAR") return QuantLib::ZAR;
    else throw Error("unknown currency: " + s);
}

std::string currencyToString(Currency c) {
    return CurrencyFormatter::toString(c);

}


using QuantLib::TermStructure;

bool HandlelTermStructure_g_isNull___(Handle<TermStructure > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelTermStructure_g_asObservable___(Handle<TermStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cTermStructure;
static void free_HandlelTermStructure_g___(Handle<TermStructure > *);
Handle<Observable > RelinkableHandlelTermStructure_g_asObservable___(RelinkableHandle<TermStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cTermStructureHandle;
static void free_RelinkableHandlelTermStructure_g___(RelinkableHandle<TermStructure > *);

using QuantLib::ImpliedTermStructure;
typedef Handle<TermStructure> ImpliedTermStructureHandle;

ImpliedTermStructureHandle *new_ImpliedTermStructureHandle(RelinkableHandle<TermStructure > const &curveHandle,Date const &todaysDate,Date const &referenceDate){
            return new ImpliedTermStructureHandle(
                new ImpliedTermStructure(curveHandle, todaysDate, 
                                         referenceDate));
        }

swig_class cImpliedTermStructure;
static void free_ImpliedTermStructureHandle(ImpliedTermStructureHandle *);

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef Handle<TermStructure> ZeroSpreadedTermStructureHandle;
typedef Handle<TermStructure> ForwardSpreadedTermStructureHandle;

ZeroSpreadedTermStructureHandle *new_ZeroSpreadedTermStructureHandle(RelinkableHandle<TermStructure > const &curveHandle,RelinkableHandle<Quote > const &spreadHandle){
	        return new ZeroSpreadedTermStructureHandle(
	            new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }

swig_class cZeroSpreadedTermStructure;
static void free_ZeroSpreadedTermStructureHandle(ZeroSpreadedTermStructureHandle *);
ForwardSpreadedTermStructureHandle *new_ForwardSpreadedTermStructureHandle(RelinkableHandle<TermStructure > const &curveHandle,RelinkableHandle<Quote > const &spreadHandle){
	        return new ForwardSpreadedTermStructureHandle(
	            new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

swig_class cForwardSpreadedTermStructure;
static void free_ForwardSpreadedTermStructureHandle(ForwardSpreadedTermStructureHandle *);

using QuantLib::FlatForward;
typedef Handle<TermStructure> FlatForwardHandle;

FlatForwardHandle *new_FlatForwardHandle__SWIG_0(Date const &todaysDate,Date const &referenceDate,RelinkableHandle<Quote > const &forward,DayCounter const &dayCounter){
            return new FlatForwardHandle(
                new FlatForward(todaysDate,referenceDate,forward,dayCounter));
        }
FlatForwardHandle *new_FlatForwardHandle__SWIG_1(Date const &todaysDate,Date const &referenceDate,double forward,DayCounter const &dayCounter){
            return new FlatForwardHandle(
                new FlatForward(todaysDate,referenceDate,forward,dayCounter));
        }

swig_class cFlatForward;
static void free_FlatForwardHandle(FlatForwardHandle *);

using QuantLib::BlackModel;

bool HandlelBlackModel_g_isNull___(Handle<BlackModel > *self){
            return IsNull(*self);
        }
Handle<BlackModel > *new_HandlelBlackModel_g___(RelinkableHandle<Quote > const &volatility,RelinkableHandle<TermStructure > const &termStructure){
        return new Handle<BlackModel>(
            new BlackModel(volatility,termStructure));
    }

swig_class cBlackModel;
static void free_HandlelBlackModel_g___(Handle<BlackModel > *);

using QuantLib::Calendar;
using QuantLib::TARGET;
using QuantLib::NewYork;
using QuantLib::London;
using QuantLib::Milan;
using QuantLib::Frankfurt;
using QuantLib::Zurich;
using QuantLib::Helsinki;
using QuantLib::Johannesburg;
using QuantLib::Wellington;
using QuantLib::Tokyo;
using QuantLib::Toronto;
using QuantLib::Sydney;
using QuantLib::Budapest;
using QuantLib::Oslo;
using QuantLib::Copenhagen;
using QuantLib::Stockholm;
using QuantLib::Warsaw;
using QuantLib::NullCalendar;
using QuantLib::JointCalendar;


using QuantLib::RollingConvention;

RollingConvention rollconvFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "f" || s == "fol" || s == "following")
        return QuantLib::Following;
    else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
        return QuantLib::ModifiedFollowing;
    else if (s == "p" || s == "pre" || s == "preceding")
        return QuantLib::Preceding;
    else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
        return QuantLib::ModifiedPreceding;
    else if (s == "mer" ||s == "mendref" || s == "monthendreference")
        return QuantLib::MonthEndReference;
    else 
        throw Error("unknown rolling convention");
}

std::string rollconvToString(RollingConvention rc) {
    switch (rc) {
      case QuantLib::Following:
        return "Following";
      case QuantLib::ModifiedFollowing:
        return "ModifiedFollowing";
      case QuantLib::Preceding:
        return "Preceding";
      case QuantLib::ModifiedPreceding:
        return "ModifiedPreceding";
      case QuantLib::MonthEndReference:
        return "MonthEndReference";
      default:
        throw Error("unknown rolling convention");
    }
}


using QuantLib::JointCalendarRule;
using QuantLib::JoinBusinessDays;

JointCalendarRule joinRuleFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "h" || s == "holidays" || s == "joinholidays")
        return QuantLib::JoinHolidays;
    else if (s == "b" ||s == "businessdays" || s == "joinbusinessdays")
        return QuantLib::JoinBusinessDays;
    else 
        throw Error("unknown joint calendar rule");
}

std::string joinRuleToString(JointCalendarRule jr) {
    switch (jr) {
      case QuantLib::JoinHolidays:
        return "JoinHolidays";
      case QuantLib::JoinBusinessDays:
        return "JoinBusinessDays";
      default:
        throw Error("unknown joint calendar rule");
    }
}

Calendar *new_Calendar(std::string const &name){
            std::string s = StringFormatter::toLowercase(name);
            if (s == "target" || s == "euro" || s == "eur")
                return new Calendar(TARGET());
            else if (s == "newyork" || s == "ny" || s == "nyc")
                return new Calendar(NewYork());
            else if (s == "london" || s == "lon")
                return new Calendar(London());
            else if (s == "milan" || s == "mil")
                return new Calendar(Milan());
            else if (s == "frankfurt" || s == "fft")
                return new Calendar(Frankfurt());
            else if (s == "zurich" || s == "zur")
                return new Calendar(Zurich());
            else if (s == "helsinki")
                return new Calendar(Helsinki());
            else if (s == "johannesburg" || s == "jhb")
                return new Calendar(Johannesburg());
            else if (s == "wellington")
                return new Calendar(Wellington());
            else if (s == "tokyo")
                return new Calendar(Tokyo());
            else if (s == "toronto")
                return new Calendar(Toronto());
            else if (s == "sydney")
                return new Calendar(Sydney());
            else if (s == "budapest")
                return new Calendar(Budapest());
            else if (s == "copenhagen")
                return new Calendar(Copenhagen());
            else if (s == "oslo")
                return new Calendar(Oslo());
            else if (s == "stockholm")
                return new Calendar(Stockholm());
            else if (s == "warsaw")
                return new Calendar(Warsaw());
            else if (s == "null")
                return new Calendar(NullCalendar());
            else
                throw Error("Unknown calendar: " + name);
            QL_DUMMY_RETURN((Calendar*)(0));
        }
std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
bool Calendar___eq__(Calendar *self,Calendar const &other){
            return (*self) == other;
        }

swig_class cCalendar;
static void free_Calendar(Calendar *);

swig_class cJointCalendar;
static void free_JointCalendar(JointCalendar *);

using QuantLib::Exercise;
typedef Exercise::Type ExerciseType;

Exercise::Type exerciseTypeFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "e" || s == "european")
        return Exercise::European;
    else if (s == "a" || s == "american")
        return Exercise::American;
    else if (s == "b" || s == "bermudan")
        return Exercise::Bermudan;
    else
        throw Error("unknown exercise type: "+s);
}

std::string exerciseTypeToString(Exercise::Type t) {
    switch (t) {
      case Exercise::European:
        return "European";
      case Exercise::American:
        return "American";
      case Exercise::Bermudan:
        return "Bermudan";
      default:
        throw Error("unknown exercise type");
    }
}

bool HandlelExercise_g_isNull___(Handle<Exercise > *self){
            return IsNull(*self);
        }

swig_class cExercise;
static void free_HandlelExercise_g___(Handle<Exercise > *);

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef Handle<Exercise> EuropeanExerciseHandle;
typedef Handle<Exercise> AmericanExerciseHandle;
typedef Handle<Exercise> BermudanExerciseHandle;

EuropeanExerciseHandle *new_EuropeanExerciseHandle(Date const &date){
            return new EuropeanExerciseHandle(new EuropeanExercise(date));
        }

swig_class cEuropeanExercise;
static void free_EuropeanExerciseHandle(EuropeanExerciseHandle *);
AmericanExerciseHandle *new_AmericanExerciseHandle(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry){
            return new AmericanExerciseHandle(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }

swig_class cAmericanExercise;
static void free_AmericanExerciseHandle(AmericanExerciseHandle *);
BermudanExerciseHandle *new_BermudanExerciseHandle(std::vector<Date > const &dates,bool payoffAtExpiry){
            return new BermudanExerciseHandle(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

swig_class cBermudanExercise;
static void free_BermudanExerciseHandle(BermudanExerciseHandle *);

using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;

bool HandlelBlackVolTermStructure_g_isNull___(Handle<BlackVolTermStructure > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelBlackVolTermStructure_g_asObservable___(Handle<BlackVolTermStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cBlackVolTermStructure;
static void free_HandlelBlackVolTermStructure_g___(Handle<BlackVolTermStructure > *);
Handle<Observable > RelinkableHandlelBlackVolTermStructure_g_asObservable___(RelinkableHandle<BlackVolTermStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cBlackVolTermStructureHandle;
static void free_RelinkableHandlelBlackVolTermStructure_g___(RelinkableHandle<BlackVolTermStructure > *);
bool HandlelLocalVolTermStructure_g_isNull___(Handle<LocalVolTermStructure > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelLocalVolTermStructure_g_asObservable___(Handle<LocalVolTermStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cLocalVolTermStructure;
static void free_HandlelLocalVolTermStructure_g___(Handle<LocalVolTermStructure > *);
Handle<Observable > RelinkableHandlelLocalVolTermStructure_g_asObservable___(RelinkableHandle<LocalVolTermStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cLocalVolTermStructureHandle;
static void free_RelinkableHandlelLocalVolTermStructure_g___(RelinkableHandle<LocalVolTermStructure > *);

using QuantLib::BlackConstantVol;
typedef Handle<BlackVolTermStructure> BlackConstantVolHandle;

BlackConstantVolHandle *new_BlackConstantVolHandle__SWIG_0(Date const &referenceDate,double volatility,DayCounter const &dayCounter){
            return new BlackConstantVolHandle(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
BlackConstantVolHandle *new_BlackConstantVolHandle__SWIG_1(Date const &referenceDate,RelinkableHandle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolHandle(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }

swig_class cBlackConstantVol;
static void free_BlackConstantVolHandle(BlackConstantVolHandle *);

using QuantLib::BlackVarianceSurface;
typedef BlackVarianceSurface::Extrapolation VolExtrapolationType;
typedef Handle<BlackVolTermStructure> BlackVarianceSurfaceHandle;

VolExtrapolationType volExTypeFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "const" || s == "constant")
        return BlackVarianceSurface::ConstantExtrapolation;
    else if (s == "" || s == "default")
        return BlackVarianceSurface::InterpolatorDefaultExtrapolation;
    else
        throw Error("unknown extrapolation type: "+s);
}

std::string volExTypeToString(VolExtrapolationType t) {
    switch (t) {
      case BlackVarianceSurface::ConstantExtrapolation:
        return "constant";
      case BlackVarianceSurface::InterpolatorDefaultExtrapolation:
        return "default";
      default:
        throw Error("unknown extrapolation type");
    }
}

BlackVarianceSurfaceHandle *new_BlackVarianceSurfaceHandle(Date const &referenceDate,std::vector<Date > const &dates,std::vector<double > const &strikes,Matrix const &blackVols,VolExtrapolationType lower,VolExtrapolationType upper,DayCounter const &dayCounter){
            return new BlackVarianceSurfaceHandle(
                new BlackVarianceSurface(referenceDate,dates,strikes,
                                         blackVols,lower,upper,dayCounter));
        }

swig_class cBlackVarianceSurface;
static void free_BlackVarianceSurfaceHandle(BlackVarianceSurfaceHandle *);

using QuantLib::LocalConstantVol;
typedef Handle<LocalVolTermStructure> LocalConstantVolHandle;

LocalConstantVolHandle *new_LocalConstantVolHandle__SWIG_0(Date const &referenceDate,double volatility,DayCounter const &dayCounter){
            return new LocalConstantVolHandle(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
LocalConstantVolHandle *new_LocalConstantVolHandle__SWIG_1(Date const &referenceDate,RelinkableHandle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolHandle(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }

swig_class cLocalConstantVol;
static void free_LocalConstantVolHandle(LocalConstantVolHandle *);

using QuantLib::StochasticProcess;

bool HandlelStochasticProcess_g_isNull___(Handle<StochasticProcess > *self){
            return IsNull(*self);
        }

swig_class cStochasticProcess;
static void free_HandlelStochasticProcess_g___(Handle<StochasticProcess > *);

using QuantLib::BlackScholesStochasticProcess;
using QuantLib::Merton76StochasticProcess;
typedef Handle<StochasticProcess> BlackScholesStochasticProcessHandle;
typedef Handle<StochasticProcess> Merton76StochasticProcessHandle;

BlackScholesStochasticProcessHandle *new_BlackScholesStochasticProcessHandle(RelinkableHandle<Quote > const &stateVariable,RelinkableHandle<TermStructure > const &dividendTS,RelinkableHandle<TermStructure > const &riskFreeTS,RelinkableHandle<BlackVolTermStructure > const &volTS){
          return new BlackScholesStochasticProcessHandle(
                              new BlackScholesStochasticProcess(stateVariable,
                                                                dividendTS,
                                                                riskFreeTS,
                                                                volTS));
      }

swig_class cBlackScholesStochasticProcess;
static void free_BlackScholesStochasticProcessHandle(BlackScholesStochasticProcessHandle *);
Merton76StochasticProcessHandle *new_Merton76StochasticProcessHandle(RelinkableHandle<Quote > const &stateVariable,RelinkableHandle<TermStructure > const &dividendTS,RelinkableHandle<TermStructure > const &riskFreeTS,RelinkableHandle<BlackVolTermStructure > const &volTS,RelinkableHandle<Quote > const &jumpIntensity,RelinkableHandle<Quote > const &meanLogJump,RelinkableHandle<Quote > const &jumpVolatility){
            return new Merton76StochasticProcessHandle(
                              new Merton76StochasticProcess(stateVariable,
                                                            dividendTS,
                                                            riskFreeTS,
                                                            volTS,
                                                            jumpIntensity,
                                                            meanLogJump,
                                                            jumpVolatility));
      }

swig_class cMerton76StochasticProcess;
static void free_Merton76StochasticProcessHandle(Merton76StochasticProcessHandle *);

using QuantLib::PricingEngine;

bool HandlelPricingEngine_g_isNull___(Handle<PricingEngine > *self){
            return IsNull(*self);
        }

swig_class cPricingEngine;
static void free_HandlelPricingEngine_g___(Handle<PricingEngine > *);

using QuantLib::Instrument;

bool HandlelInstrument_g_isNull___(Handle<Instrument > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelInstrument_g_asObservable___(Handle<Instrument > *self){
        return Handle<Observable>(*self);
    }

swig_class cInstrument;
static void free_HandlelInstrument_g___(Handle<Instrument > *);

using QuantLib::Stock;
typedef Handle<Instrument> StockHandle;

StockHandle *new_StockHandle(RelinkableHandle<Quote > const &quote){
            return new StockHandle(new Stock(quote));
        }

swig_class cStock;
static void free_StockHandle(StockHandle *);

using QuantLib::Option;
typedef Option::Type OptionType;

Option::Type optionTypeFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "c" || s == "call")
        return Option::Call;
    else if (s == "p" || s == "put")
        return Option::Put;
    else if (s == "s" || s == "straddle")
        return Option::Straddle;
    else
        throw Error("unknown option type: "+s);
}

std::string optionTypeToString(Option::Type t) {
    switch (t) {
      case Option::Call:
        return "Call";
      case Option::Put:
        return "Put";
      case Option::Straddle:
        return "Straddle";
      default:
        throw Error("unknown option type");
    }
}


using QuantLib::Payoff;

bool HandlelPayoff_g_isNull___(Handle<Payoff > *self){
            return IsNull(*self);
        }

swig_class cPayoff;
static void free_HandlelPayoff_g___(Handle<Payoff > *);

using QuantLib::VanillaOption;
typedef Handle<Instrument> VanillaOptionHandle;

VanillaOptionHandle *new_VanillaOptionHandle(Handle<StochasticProcess > const &process,Handle<Payoff > const &payoff,Handle<Exercise > const &exercise,Handle<PricingEngine > const &engine){
            #if defined(HAVE_BOOST)
            Handle<QL::StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<QL::StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "Wrong payoff given");
            Handle<BlackScholesStochasticProcess> bsProcess =
                boost::dynamic_pointer_cast<BlackScholesStochasticProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Wrong stochastic process given");
            #else
            Handle<QL::StrikedTypePayoff> stPayoff = payoff;
            Handle<BlackScholesStochasticProcess> bsProcess = process;
            #endif
            return new VanillaOptionHandle(
                new VanillaOption(bsProcess,stPayoff,exercise,engine));
        }
double VanillaOptionHandle_errorEstimate(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->errorEstimate();
            #else
            return Handle<VanillaOption>(*self)->errorEstimate();
            #endif
        }
double VanillaOptionHandle_delta(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
            #else
            return Handle<VanillaOption>(*self)->delta();
            #endif
        }
double VanillaOptionHandle_gamma(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
            #else
            return Handle<VanillaOption>(*self)->gamma();
            #endif
        }
double VanillaOptionHandle_theta(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
            #else
            return Handle<VanillaOption>(*self)->theta();
            #endif
        }
double VanillaOptionHandle_vega(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
            #else
            return Handle<VanillaOption>(*self)->vega();
            #endif
        }
double VanillaOptionHandle_rho(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
            #else
            return Handle<VanillaOption>(*self)->rho();
            #endif
        }
double VanillaOptionHandle_dividendRho(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
            #else
            return Handle<VanillaOption>(*self)->dividendRho();
            #endif
        }
double VanillaOptionHandle_strikeSensitivity(VanillaOptionHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
            #else
            return Handle<VanillaOption>(*self)->strikeSensitivity();
            #endif
        }
double VanillaOptionHandle_impliedVolatility(VanillaOptionHandle *self,double targetValue,double accuracy,Size maxEvaluations,double minVol,double maxVol){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
            #else
            return Handle<VanillaOption>(*self)->impliedVolatility(
                targetValue,accuracy,maxEvaluations,minVol,maxVol);
            #endif
        }

swig_class cVanillaOption;
static void free_VanillaOptionHandle(VanillaOptionHandle *);

using QuantLib::AnalyticEuropeanEngine;
typedef Handle<PricingEngine> AnalyticEuropeanEngineHandle;

AnalyticEuropeanEngineHandle *new_AnalyticEuropeanEngineHandle(){
            return new AnalyticEuropeanEngineHandle(
                new AnalyticEuropeanEngine);
        }

swig_class cAnalyticEuropeanEngine;
static void free_AnalyticEuropeanEngineHandle(AnalyticEuropeanEngineHandle *);

using QuantLib::IntegralEngine;
typedef Handle<PricingEngine> IntegralEngineHandle;

IntegralEngineHandle *new_IntegralEngineHandle(){
            return new IntegralEngineHandle(new IntegralEngine);
        }

swig_class cIntegralEngine;
static void free_IntegralEngineHandle(IntegralEngineHandle *);

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
typedef Handle<PricingEngine> BinomialVanillaEngineHandle;

BinomialVanillaEngineHandle *new_BinomialVanillaEngineHandle(std::string const &type,Size steps){
            std::string s = StringFormatter::toLowercase(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEngineHandle(
                    new BinomialVanillaEngine<CoxRossRubinstein>(steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEngineHandle(
                    new BinomialVanillaEngine<JarrowRudd>(steps));
            else if (s == "eqp")
                return new BinomialVanillaEngineHandle(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEngineHandle(
                    new BinomialVanillaEngine<Trigeorgis>(steps));
            else if (s == "tian")
                return new BinomialVanillaEngineHandle(
                    new BinomialVanillaEngine<Tian>(steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEngineHandle(
                    new BinomialVanillaEngine<LeisenReimer>(steps));
            else
                throw Error("unknown binomial engine type: "+s);
        }

swig_class cBinomialEuropeanEngine;
static void free_BinomialVanillaEngineHandle(BinomialVanillaEngineHandle *);

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef Handle<PricingEngine> MCEuropeanEngineHandle;

MCEuropeanEngineHandle *new_MCEuropeanEngineHandle(std::string const &traits,Size timeSteps,bool antitheticVariate,bool controlVariate,intOrNull requiredSamples,doubleOrNull requiredTolerance,intOrNull maxSamples,long seed){
            std::string s = StringFormatter::toLowercase(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEngineHandle(
                         new MCEuropeanEngine<PseudoRandom>(timeSteps,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEngineHandle(
                       new MCEuropeanEngine<LowDiscrepancy>(timeSteps,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                throw Error("unknown Monte Carlo engine type: "+s);
        }

swig_class cMCEuropeanEngine;
static void free_MCEuropeanEngineHandle(MCEuropeanEngineHandle *);

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef Handle<PricingEngine> BaroneAdesiWhaleyApproximationEngineHandle;

BaroneAdesiWhaleyApproximationEngineHandle *new_BaroneAdesiWhaleyApproximationEngineHandle(){
            return new BaroneAdesiWhaleyApproximationEngineHandle(
                new BaroneAdesiWhaleyApproximationEngine);
        }

swig_class cBaroneAdesiWhaleyEngine;
static void free_BaroneAdesiWhaleyApproximationEngineHandle(BaroneAdesiWhaleyApproximationEngineHandle *);

using QuantLib::BjerksundStenslandApproximationEngine;
typedef Handle<PricingEngine> BjerksundStenslandApproximationEngineHandle;

BjerksundStenslandApproximationEngineHandle *new_BjerksundStenslandApproximationEngineHandle(){
            return new BjerksundStenslandApproximationEngineHandle(
                new BjerksundStenslandApproximationEngine);
        }

swig_class cBjerksundStenslandEngine;
static void free_BjerksundStenslandApproximationEngineHandle(BjerksundStenslandApproximationEngineHandle *);
int std_vectorlint_g_pop___(std::vector<int > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                int x = self->back();
                self->pop_back();
                return x;
            }
int std_vectorlint_g___getitem_____(std::vector<int > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlint_g___setitem_____(std::vector<int > *self,int i,int x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlint_g_each___(std::vector<int > *self){
                for (unsigned int i=0; i<self->size(); i++)
                    rb_yield(INT2NUM((*self)[i]));
            }

swig_class cIntVector;
static void free_std_vectorlint_g___(std::vector<int > *);
double std_vectorldouble_g_pop___(std::vector<double > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                double x = self->back();
                self->pop_back();
                return x;
            }
double std_vectorldouble_g___getitem_____(std::vector<double > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorldouble_g___setitem_____(std::vector<double > *self,int i,double x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorldouble_g_each___(std::vector<double > *self){
                for (unsigned int i=0; i<self->size(); i++)
                    rb_yield(rb_float_new((*self)[i]));
            }

swig_class cDoubleVector;
static void free_std_vectorldouble_g___(std::vector<double > *);

using QuantLib::History;
typedef History::Entry HistoryEntry;


swig_class cHistoryEntry;
static void free_HistoryEntry(HistoryEntry *);
Size History___len__(History *self){
            return self->size();
        }
doubleOrNull History___getitem__(History *self,Date const &d){
            return (*self)[d];
        }
void History_each(History *self){
            History::const_iterator i=self->begin(), end=self->end();
            for ( ; i!=end; ++i) {
                Date* d = new Date(i->date());
                double v = i->value();
                VALUE entry = rb_ary_new2(2);
                VALUE date = SWIG_NewPointerObj(d, SWIGTYPE_p_Date, 1);
                VALUE value = (v == Null<double>() ? Qnil : rb_float_new(v));
                rb_ary_store(entry,0,date);
                rb_ary_store(entry,1,value);
                rb_yield(entry);
            }
        }
void History_each_valid(History *self){
            History::const_valid_iterator i=self->vbegin(), end=self->vend();
            for ( ; i!=end; ++i) {
                Date* d = new Date(i->date());
                double v = i->value();
                VALUE entry = rb_ary_new2(2);
                VALUE date = SWIG_NewPointerObj(d, SWIGTYPE_p_Date, 1);
                VALUE value = rb_float_new(v);
                rb_ary_store(entry,0,date);
                rb_ary_store(entry,1,value);
                rb_yield(entry);
            }
        }

swig_class cHistory;
static void free_History(History *);

using QuantLib::XiborManager;


swig_class cXiborManager;
static void free_XiborManager(XiborManager *);

using QuantLib::Index;

bool HandlelIndex_g_isNull___(Handle<Index > *self){
            return IsNull(*self);
        }
std::string HandlelIndex_g___str_____(Handle<Index > *self){
        if (!IsNull(*self))
            return (*self)->name()+" index";
        else
            return "Null index";
    }

swig_class cIndex;
static void free_HandlelIndex_g___(Handle<Index > *);

using QuantLib::Xibor;
using QuantLib::Euribor;
using QuantLib::AUDLibor;
using QuantLib::GBPLibor;
using QuantLib::USDLibor;
using QuantLib::JPYLibor;
using QuantLib::CADLibor;
using QuantLib::CHFLibor;
using QuantLib::ZARLibor;
typedef Handle<Index> XiborHandle;

XiborHandle *new_XiborHandle(std::string const &name,int n,TimeUnit units,RelinkableHandle<TermStructure > const &h){
            std::string s = StringFormatter::toLowercase(name);
            if (s == "euribor")
                return new XiborHandle(new Euribor(n,units,h));
            else if (s == "audlibor")
                return new XiborHandle(new AUDLibor(n,units,h));
            else if (s == "gbplibor")
                return new XiborHandle(new GBPLibor(n,units,h));
            else if (s == "usdlibor")
                return new XiborHandle(new USDLibor(n,units,h));
            else if (s == "jpylibor")
                return new XiborHandle(new JPYLibor(n,units,h));
            else if (s == "cadlibor")
                return new XiborHandle(new CADLibor(n,units,h));
            else if (s == "chflibor")
                return new XiborHandle(new CHFLibor(n,units,h));
            else if (s == "zarlibor")
                return new XiborHandle(new ZARLibor(n,units,h));
            else
                throw Error("unknown index: " + name);
            QL_DUMMY_RETURN(new XiborHandle);
        }
Period XiborHandle_tenor(XiborHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Xibor>(*self)->tenor();
            #else
            return Handle<Xibor>(*self)->tenor();
            #endif
        }
Currency XiborHandle_currency(XiborHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Xibor>(*self)->currency();
            #else
            return Handle<Xibor>(*self)->currency();
            #endif
        }
Calendar XiborHandle_calendar(XiborHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Xibor>(*self)->calendar();
            #else
            return Handle<Xibor>(*self)->calendar();
            #endif
        }
bool XiborHandle_isAdjusted(XiborHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Xibor>(*self)->isAdjusted();
            #else
            return Handle<Xibor>(*self)->isAdjusted();
            #endif
        }
RollingConvention XiborHandle_rollingConvention(XiborHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Xibor>(*self)
                 ->rollingConvention();
            #else
            return Handle<Xibor>(*self)->rollingConvention();
            #endif
        }
DayCounter XiborHandle_dayCounter(XiborHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Xibor>(*self)->dayCounter();
            #else
            return Handle<Xibor>(*self)->dayCounter();
            #endif
        }

swig_class cXibor;
static void free_XiborHandle(XiborHandle *);

using QuantLib::Schedule;

Date Schedule___getitem__(Schedule *self,int i){
            int size_ = static_cast<int>(self->size());
            if (i>=0 && i<size_) {
                return self->date(i);
            } else if (i<0 && -i<=size_) {
                return self->date(size_+i);
            } else {
                throw IndexError("Schedule index out of range");
            }
            QL_DUMMY_RETURN(Date())
        }
void Schedule_each(Schedule *self){
            for (Size i=0; i<self->size(); i++) {
                Date* d = new Date(self->date(i));
                rb_yield(SWIG_NewPointerObj((void *) d, 
                                            SWIGTYPE_p_Date, 1));
            }
        }

swig_class cSchedule;
static void free_Schedule(Schedule *);

using QuantLib::CashFlow;

bool HandlelCashFlow_g_isNull___(Handle<CashFlow > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelCashFlow_g_asObservable___(Handle<CashFlow > *self){
        return Handle<Observable>(*self);
    }

swig_class cCashFlow;
static void free_HandlelCashFlow_g___(Handle<CashFlow > *);

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::ParCoupon;
typedef Handle<CashFlow> SimpleCashFlowHandle;
typedef Handle<CashFlow> FixedRateCouponHandle;
typedef Handle<CashFlow> ParCouponHandle;

SimpleCashFlowHandle *new_SimpleCashFlowHandle(double amount,Date const &date){
            return new SimpleCashFlowHandle(
                new SimpleCashFlow(amount,date));
        }

swig_class cSimpleCashFlow;
static void free_SimpleCashFlowHandle(SimpleCashFlowHandle *);
FixedRateCouponHandle *new_FixedRateCouponHandle(double nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart,Date const &refPeriodEnd){
            return new FixedRateCouponHandle(
                new FixedRateCoupon(nominal, paymentDate, rate, 
                                    dayCounter, startDate, endDate, 
                                    refPeriodStart, refPeriodEnd));
        }

swig_class cFixedRateCoupon;
static void free_FixedRateCouponHandle(FixedRateCouponHandle *);
ParCouponHandle *new_ParCouponHandle(double nominal,Date const &paymentDate,XiborHandle const &index,Date const &startDate,Date const &endDate,int fixingDays,Spread spread,Date const &refPeriodStart,Date const &refPeriodEnd){
            #if defined(HAVE_BOOST)
            Handle<Xibor> libor = boost::dynamic_pointer_cast<Xibor>(index);
            #else
            Handle<Xibor> libor = index;
            #endif
            return new ParCouponHandle(
                new ParCoupon(nominal, paymentDate, libor,
                              startDate, endDate, fixingDays, spread,
                              refPeriodStart, refPeriodEnd));
        }
Date ParCouponHandle_accrualStartDate(ParCouponHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualStartDate();
            #else
            return Handle<ParCoupon>(*self)->accrualStartDate();
            #endif
        }
Date ParCouponHandle_accrualEndDate(ParCouponHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualEndDate();
            #else
            return Handle<ParCoupon>(*self)->accrualEndDate();
            #endif
        }
double ParCouponHandle_fixing(ParCouponHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->fixing();
            #else
            return Handle<ParCoupon>(*self)->fixing();
            #endif
        }
double ParCouponHandle_nominal(ParCouponHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->nominal();
            #else
            return Handle<ParCoupon>(*self)->nominal();
            #endif
        }
double ParCouponHandle_amount(ParCouponHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->amount();
            #else
            return Handle<ParCoupon>(*self)->amount();
            #endif
        }

swig_class cParCoupon;
static void free_ParCouponHandle(ParCouponHandle *);
Handle<CashFlow > std_vectorlHandlelCashFlow_g_g_pop___(std::vector<Handle<CashFlow > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Handle<CashFlow > x = self->back();
                self->pop_back();
                return x;
            }
Handle<CashFlow > &std_vectorlHandlelCashFlow_g_g___getitem_____(std::vector<Handle<CashFlow > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelCashFlow_g_g___setitem_____(std::vector<Handle<CashFlow > > *self,int i,Handle<CashFlow > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelCashFlow_g_g_each___(std::vector<Handle<CashFlow > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Handle<CashFlow >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_HandleTCashFlow_t, 0));
                }
            }

swig_class cCashFlowVector;
static void free_std_vectorlHandlelCashFlow_g_g___(std::vector<Handle<CashFlow > > *);

using QuantLib::FixedRateCouponVector;


std::vector<Handle<CashFlow> > 
FloatingRateCouponVector(const Schedule& schedule,
                         const std::vector<double>& nominals,
                         const XiborHandle& index, int fixingDays,
                         const std::vector<Spread>& spreads = 
                             std::vector<Spread>()) {
    #if defined(HAVE_BOOST)
    Handle<Xibor> libor = boost::dynamic_pointer_cast<Xibor>(index);
    #else
    Handle<Xibor> libor = index;
    #endif
    return QuantLib::FloatingRateCouponVector(schedule,nominals,libor,
                                              fixingDays,spreads);
}


using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;
typedef Handle<Instrument> CapHandle;
typedef Handle<Instrument> FloorHandle;
typedef Handle<Instrument> CollarHandle;

CapHandle *new_CapHandle(std::vector<Handle<CashFlow > > const &leg,std::vector<double > const &capRates,RelinkableHandle<TermStructure > const &h,Handle<PricingEngine > const &engine){
            return new CapHandle(
                new Cap(leg,capRates,h,engine));
        }

swig_class cCap;
static void free_CapHandle(CapHandle *);
FloorHandle *new_FloorHandle(std::vector<Handle<CashFlow > > const &leg,std::vector<double > const &floorRates,RelinkableHandle<TermStructure > const &h,Handle<PricingEngine > const &engine){
            return new FloorHandle(
                new Floor(leg,floorRates,h,engine));
        }

swig_class cFloor;
static void free_FloorHandle(FloorHandle *);
CollarHandle *new_CollarHandle(std::vector<Handle<CashFlow > > const &leg,std::vector<double > const &capRates,std::vector<double > const &floorRates,RelinkableHandle<TermStructure > const &h,Handle<PricingEngine > const &engine){
            return new CollarHandle(
                new Collar(leg,capRates,floorRates, h,engine));
        }

swig_class cCollar;
static void free_CollarHandle(CollarHandle *);

using QuantLib::BlackCapFloor;
typedef Handle<PricingEngine> BlackCapFloorEngineHandle;

BlackCapFloorEngineHandle *new_BlackCapFloorEngineHandle(Handle<BlackModel > const &model){
            return new BlackCapFloorEngineHandle(new BlackCapFloor(model));
        }

swig_class cBlackCapFloorEngine;
static void free_BlackCapFloorEngineHandle(BlackCapFloorEngineHandle *);

using QuantLib::CompoundForward;
typedef Handle<TermStructure> CompoundForwardHandle;

CompoundForwardHandle *new_CompoundForwardHandle(Date const &todaysDate,Date const &settlementDate,std::vector<Date > const &dates,std::vector<double > const &rates,Calendar calendar,RollingConvention roll,int compounding,DayCounter const &dayCounter){
	        return new CompoundForwardHandle(
                new CompoundForward(todaysDate, settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
std::vector<Date > const &CompoundForwardHandle_dates(CompoundForwardHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
            #else
            return Handle<CompoundForward>(*self)->dates();
            #endif
        }

swig_class cCompoundForward;
static void free_CompoundForwardHandle(CompoundForwardHandle *);

using QuantLib::DiscountCurve;
using QuantLib::ExtendedDiscountCurve;
typedef Handle<TermStructure> DiscountCurveHandle;
typedef Handle<TermStructure> ExtendedDiscountCurveHandle;

DiscountCurveHandle *new_DiscountCurveHandle(Date const &todaysDate,std::vector<Date > const &dates,std::vector<double > const &discounts,DayCounter const &dayCounter){
            return new DiscountCurveHandle(
                new DiscountCurve(todaysDate, dates, discounts, dayCounter));
        }
std::vector<Date > const &DiscountCurveHandle_dates(DiscountCurveHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
            #else
            return Handle<DiscountCurve>(*self)->dates();
            #endif
        }

swig_class cDiscountCurve;
static void free_DiscountCurveHandle(DiscountCurveHandle *);
ExtendedDiscountCurveHandle *new_ExtendedDiscountCurveHandle(Date const &todaysDate,std::vector<Date > const &dates,std::vector<double > const &discounts,Calendar const &calendar,RollingConvention roll,DayCounter const &dayCounter){
            return new ExtendedDiscountCurveHandle(
                new ExtendedDiscountCurve(todaysDate, dates, discounts, 
                                          calendar, roll, dayCounter));
        }

swig_class cExtendedDiscountCurve;
static void free_ExtendedDiscountCurveHandle(ExtendedDiscountCurveHandle *);

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;


swig_class cNormalDistribution;
static void free_NormalDistribution(NormalDistribution *);

swig_class cCumulativeNormalDistribution;
static void free_CumulativeNormalDistribution(CumulativeNormalDistribution *);

swig_class cInverseCumulativeNormal;
static void free_InverseCumulativeNormal(InverseCumulativeNormal *);

swig_class cMoroInverseCumulativeNormal;
static void free_MoroInverseCumulativeNormal(MoroInverseCumulativeNormal *);

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::SimpsonIntegral;
using QuantLib::KronrodIntegral;

double SegmentIntegral___call__(SegmentIntegral *self,double a,double b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cSegmentIntegral;
static void free_SegmentIntegral(SegmentIntegral *);
double TrapezoidIntegral___call__(TrapezoidIntegral *self,double a,double b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cTrapezoidIntegral;
static void free_TrapezoidIntegral(TrapezoidIntegral *);
double SimpsonIntegral___call__(SimpsonIntegral *self,double a,double b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cSimpsonIntegral;
static void free_SimpsonIntegral(SimpsonIntegral *);
double KronrodIntegral___call__(KronrodIntegral *self,double a,double b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cKronrodIntegral;
static void free_KronrodIntegral(KronrodIntegral *);

// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    double operator()(double x, bool allowExtrapolation=false) { 
        return f_(x, allowExtrapolation); 
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


swig_class cLinearInterpolation;
static void free_SafeLinearInterpolation(SafeLinearInterpolation *);

typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

double SafeNaturalCubicSpline_derivative(SafeNaturalCubicSpline *self,double x,bool extrapolate){
        return self->f_.derivative(x,extrapolate);
    }
double SafeNaturalCubicSpline_secondDerivative(SafeNaturalCubicSpline *self,double x,bool extrapolate){
        return self->f_.secondDerivative(x,extrapolate);
    }

swig_class cCubicSpline;
static void free_SafeNaturalCubicSpline(SafeNaturalCubicSpline *);

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

double SafeNaturalMonotonicCubicSpline_derivative(SafeNaturalMonotonicCubicSpline *self,double x,bool extrapolate){
        return self->f_.derivative(x,extrapolate);
    }
double SafeNaturalMonotonicCubicSpline_secondDerivative(SafeNaturalMonotonicCubicSpline *self,double x,bool extrapolate){
        return self->f_.secondDerivative(x,extrapolate);
    }

swig_class cMonotonicCubicSpline;
static void free_SafeNaturalMonotonicCubicSpline(SafeNaturalMonotonicCubicSpline *);

typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


swig_class cLogLinearInterpolation;
static void free_SafeLogLinearInterpolation(SafeLogLinearInterpolation *);

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    double operator()(double x, double y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


swig_class cBilinearInterpolation;
static void free_SafeBilinearInterpolation(SafeBilinearInterpolation *);

typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


swig_class cBicubicSpline;
static void free_SafeBicubicSpline(SafeBicubicSpline *);

using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;
using QuantLib::UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::ICGaussianRng;
using QuantLib::GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

using QuantLib::UniformRandomSequenceGenerator;
using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;
using QuantLib::UniformLowDiscrepancySequenceGenerator;

using QuantLib::ICGaussianRsg;
using QuantLib::GaussianRandomSequenceGenerator;
using QuantLib::GaussianLowDiscrepancySequenceGenerator;

double Sampleldouble_g_value___(Sample<double > *self){ return self->value; }
double Sampleldouble_g_weight___(Sample<double > *self){ return self->weight; }

swig_class cSampleNumber;
static void free_Sampleldouble_g___(Sample<double > *);
Array SamplelArray_g_value___(Sample<Array > *self){ return self->value; }
double SamplelArray_g_weight___(Sample<Array > *self){ return self->weight; }

swig_class cSampleArray;
static void free_SamplelArray_g___(Sample<Array > *);

swig_class cLecuyerUniformRng;
static void free_LecuyerUniformRng(LecuyerUniformRng *);

swig_class cKnuthUniformRng;
static void free_KnuthUniformRng(KnuthUniformRng *);

swig_class cMersenneTwisterUniformRng;
static void free_MersenneTwisterUniformRng(MersenneTwisterUniformRng *);

swig_class cUniformRandomGenerator;
static void free_UniformRandomGenerator(UniformRandomGenerator *);

swig_class cCentralLimitLecuyerGaussianRng;
static void free_CLGaussianRnglLecuyerUniformRng_g___(CLGaussianRng<LecuyerUniformRng > *);

swig_class cCentralLimitKnuthGaussianRng;
static void free_CLGaussianRnglKnuthUniformRng_g___(CLGaussianRng<KnuthUniformRng > *);

swig_class cCentralLimitMersenneTwisterGaussianRng;
static void free_CLGaussianRnglMersenneTwisterUniformRng_g___(CLGaussianRng<MersenneTwisterUniformRng > *);

swig_class cBoxMullerLecuyerGaussianRng;
static void free_BoxMullerGaussianRnglLecuyerUniformRng_g___(BoxMullerGaussianRng<LecuyerUniformRng > *);

swig_class cBoxMullerKnuthGaussianRng;
static void free_BoxMullerGaussianRnglKnuthUniformRng_g___(BoxMullerGaussianRng<KnuthUniformRng > *);

swig_class cBoxMullerMersenneTwisterGaussianRng;
static void free_BoxMullerGaussianRnglMersenneTwisterUniformRng_g___(BoxMullerGaussianRng<MersenneTwisterUniformRng > *);

swig_class cMoroInvCumulativeLecuyerGaussianRng;
static void free_ICGaussianRnglLecuyerUniformRngcMoroInverseCumulativeNormal_g___(ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeKnuthGaussianRng;
static void free_ICGaussianRnglKnuthUniformRngcMoroInverseCumulativeNormal_g___(ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeMersenneTwisterGaussianRng;
static void free_ICGaussianRnglMersenneTwisterUniformRngcMoroInverseCumulativeNormal_g___(ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *);

swig_class cInvCumulativeLecuyerGaussianRng;
static void free_ICGaussianRnglLecuyerUniformRngcInverseCumulativeNormal_g___(ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *);

swig_class cInvCumulativeKnuthGaussianRng;
static void free_ICGaussianRnglKnuthUniformRngcInverseCumulativeNormal_g___(ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *);

swig_class cInvCumulativeMersenneTwisterGaussianRng;
static void free_ICGaussianRnglMersenneTwisterUniformRngcInverseCumulativeNormal_g___(ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *);

swig_class cGaussianRandomGenerator;
static void free_GaussianRandomGenerator(GaussianRandomGenerator *);

swig_class cHaltonRsg;
static void free_HaltonRsg(HaltonRsg *);

swig_class cSobolRsg;
static void free_SobolRsg(SobolRsg *);

swig_class cLecuyerUniformRsg;
static void free_RandomSequenceGeneratorlLecuyerUniformRng_g___(RandomSequenceGenerator<LecuyerUniformRng > *);

swig_class cKnuthUniformRsg;
static void free_RandomSequenceGeneratorlKnuthUniformRng_g___(RandomSequenceGenerator<KnuthUniformRng > *);

swig_class cMersenneTwisterUniformRsg;
static void free_RandomSequenceGeneratorlMersenneTwisterUniformRng_g___(RandomSequenceGenerator<MersenneTwisterUniformRng > *);

swig_class cUniformRandomSequenceGenerator;
static void free_UniformRandomSequenceGenerator(UniformRandomSequenceGenerator *);

swig_class cUniformLowDiscrepancySequenceGenerator;
static void free_UniformLowDiscrepancySequenceGenerator(UniformLowDiscrepancySequenceGenerator *);

swig_class cMoroInvCumulativeLecuyerGaussianRsg;
static void free_ICGaussianRsglRandomSequenceGeneratorlLecuyerUniformRng_gcMoroInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeKnuthGaussianRsg;
static void free_ICGaussianRsglRandomSequenceGeneratorlKnuthUniformRng_gcMoroInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeMersenneTwisterGaussianRsg;
static void free_ICGaussianRsglRandomSequenceGeneratorlMersenneTwisterUniformRng_gcMoroInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeHaltonGaussianRsg;
static void free_ICGaussianRsglHaltonRsgcMoroInverseCumulativeNormal_g___(ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *);

swig_class cInvCumulativeLecuyerGaussianRsg;
static void free_ICGaussianRsglRandomSequenceGeneratorlLecuyerUniformRng_gcInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *);

swig_class cInvCumulativeKnuthGaussianRsg;
static void free_ICGaussianRsglRandomSequenceGeneratorlKnuthUniformRng_gcInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *);

swig_class cInvCumulativeMersenneTwisterGaussianRsg;
static void free_ICGaussianRsglRandomSequenceGeneratorlMersenneTwisterUniformRng_gcInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *);

swig_class cInvCumulativeHaltonGaussianRsg;
static void free_ICGaussianRsglHaltonRsgcInverseCumulativeNormal_g___(ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *);

swig_class cGaussianRandomSequenceGenerator;
static void free_GaussianRandomSequenceGenerator(GaussianRandomSequenceGenerator *);

swig_class cGaussianLowDiscrepancySequenceGenerator;
static void free_GaussianLowDiscrepancySequenceGenerator(GaussianLowDiscrepancySequenceGenerator *);

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;

double Path___getitem__(Path *self,int i){
            int size_ = int(self->size());
            if (i>=0 && i<size_) {
                return (*self)[i];
            } else if (i<0 && -i<=size_) {
                return (*self)[size_+i];
            } else {
                throw IndexError("Path index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }
void Path_each(Path *self){
            for (Size i=0; i<self->size(); i++)
                rb_yield(rb_float_new((*self)[i]));
        }

swig_class cPath;
static void free_Path(Path *);

using QuantLib::GaussianPathGenerator_old;

Path SamplelPath_g_value___(Sample<Path > *self){ return self->value; }
double SamplelPath_g_weight___(Sample<Path > *self){ return self->weight; }

swig_class cSamplePath;
static void free_SamplelPath_g___(Sample<Path > *);

swig_class cGaussianPathGenerator;
static void free_GaussianPathGenerator_old(GaussianPathGenerator_old *);

using QuantLib::MultiPath;

Path const &MultiPath___getitem__(MultiPath *self,int i){
            int assets_ = int(self->assetNumber());
            if (i>=0 && i<assets_) {
                return (*self)[i];
            } else if (i<0 && -i<=assets_) {
                return (*self)[assets_+i];
            } else {
                throw IndexError("MultiPath index out of range");
            }
            QL_DUMMY_RETURN((*self)[0])
        }
void MultiPath_each_path(MultiPath *self){
            swig_type_info* type = SWIG_TypeQuery("Path *");
            for (Size i=0; i<self->assetNumber(); i++)
                rb_yield(SWIG_NewPointerObj((void *) &((*self)[i]), type, 0));
        }
void MultiPath_each_step(MultiPath *self){
            for (Size j=0; j<self->pathSize(); j++) {
                VALUE v = rb_ary_new2(self->assetNumber());
                for (Size i=0; i<self->assetNumber(); i++)
                    rb_ary_store(v,i,rb_float_new((*self)[i][j]));
                rb_yield(v);
            }
        }

swig_class cMultiPath;
static void free_MultiPath(MultiPath *);

using QuantLib::GaussianMultiPathGenerator;

MultiPath SamplelMultiPath_g_value___(Sample<MultiPath > *self){ return self->value; }
double SamplelMultiPath_g_weight___(Sample<MultiPath > *self){ return self->weight; }

swig_class cSampleMultiPath;
static void free_SamplelMultiPath_g___(Sample<MultiPath > *);
GaussianMultiPathGenerator *new_GaussianMultiPathGenerator(Array const &drifts,Matrix const &covariance,std::vector<double > const &timeDelays,long seed){
          return new GaussianMultiPathGenerator(drifts,
                                                covariance,
                                                QL::TimeGrid(
                                                    timeDelays.begin(),
                                                    timeDelays.end()),
                                                seed);
      }

swig_class cGaussianMultiPathGenerator;
static void free_GaussianMultiPathGenerator(GaussianMultiPathGenerator *);

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
		BoundaryCondition;
typedef BoundaryCondition::Side BoundaryConditionSide;

BoundaryCondition::Side BCSideFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "" || s == "none")
        return BoundaryCondition::None;
    else if (s == "upper")
        return BoundaryCondition::Upper;
    else if (s == "lower")
        return BoundaryCondition::Lower;
    else
        throw Error("unknown boundary condition side: "+s);
}

std::string BCSideToString(BoundaryCondition::Side type) {
    switch (type) {
      case BoundaryCondition::None:
        return "None";
      case BoundaryCondition::Upper:
        return "upper";
      case BoundaryCondition::Lower:
        return "lower";
      default:
        throw Error("unknown boundary condition side");
    }
}

bool HandlelBoundaryCondition_g_isNull___(Handle<BoundaryCondition > *self){
            return IsNull(*self);
        }

swig_class cBoundaryCondition;
static void free_HandlelBoundaryCondition_g___(Handle<BoundaryCondition > *);

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef Handle<BoundaryCondition> NeumannBCHandle;
typedef Handle<BoundaryCondition> DirichletBCHandle;

NeumannBCHandle *new_NeumannBCHandle(double value,BoundaryConditionSide side){
            return new NeumannBCHandle(new NeumannBC(value, side));
        }

swig_class cNeumannBC;
static void free_NeumannBCHandle(NeumannBCHandle *);
DirichletBCHandle *new_DirichletBCHandle(double value,BoundaryConditionSide side){
            return new DirichletBCHandle(new DirichletBC(value, side));
        }

swig_class cDirichletBC;
static void free_DirichletBCHandle(DirichletBCHandle *);

using QuantLib::TridiagonalOperator;

TridiagonalOperator TridiagonalOperator___add__(TridiagonalOperator *self,TridiagonalOperator const &O){
            return *self+O;
        }
TridiagonalOperator TridiagonalOperator___sub__(TridiagonalOperator *self,TridiagonalOperator const &O){
            return *self-O;
        }
TridiagonalOperator TridiagonalOperator___mul__(TridiagonalOperator *self,double a){
            return *self*a;
        }
TridiagonalOperator TridiagonalOperator___div__(TridiagonalOperator *self,double a){
            return *self/a;
        }

swig_class cTridiagonalOperator;
static void free_TridiagonalOperator(TridiagonalOperator *);

using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


swig_class cDPlus;
static void free_DPlus(DPlus *);

swig_class cDMinus;
static void free_DMinus(DMinus *);

swig_class cDZero;
static void free_DZero(DZero *);

swig_class cDPlusDMinus;
static void free_DPlusDMinus(DPlusDMinus *);

using QuantLib::valueAtCenter;
using QuantLib::firstDerivativeAtCenter;
using QuantLib::secondDerivativeAtCenter;


using QuantLib::SymmetricEigenvalues;
using QuantLib::SymmetricEigenvectors;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;

double Brent_solve__SWIG_0(Brent *self,double xAccuracy,double guess,double step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
double Brent_solve__SWIG_1(Brent *self,double xAccuracy,double guess,double xMin,double xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cBrent;
static void free_Brent(Brent *);
double Bisection_solve__SWIG_0(Bisection *self,double xAccuracy,double guess,double step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
double Bisection_solve__SWIG_1(Bisection *self,double xAccuracy,double guess,double xMin,double xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cBisection;
static void free_Bisection(Bisection *);
double FalsePosition_solve__SWIG_0(FalsePosition *self,double xAccuracy,double guess,double step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
double FalsePosition_solve__SWIG_1(FalsePosition *self,double xAccuracy,double guess,double xMin,double xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cFalsePosition;
static void free_FalsePosition(FalsePosition *);
double Ridder_solve__SWIG_0(Ridder *self,double xAccuracy,double guess,double step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
double Ridder_solve__SWIG_1(Ridder *self,double xAccuracy,double guess,double xMin,double xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cRidder;
static void free_Ridder(Ridder *);
double Secant_solve__SWIG_0(Secant *self,double xAccuracy,double guess,double step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
double Secant_solve__SWIG_1(Secant *self,double xAccuracy,double guess,double xMin,double xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cSecant;
static void free_Secant(Secant *);

using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;


swig_class cConstraint;
static void free_Constraint(Constraint *);

swig_class cBoundaryConstraint;
static void free_BoundaryConstraint(BoundaryConstraint *);

swig_class cNoConstraint;
static void free_NoConstraint(NoConstraint *);

swig_class cPositiveConstraint;
static void free_PositiveConstraint(PositiveConstraint *);

using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;


swig_class cOptimizationMethod;
static void free_OptimizationMethod(OptimizationMethod *);

swig_class cConjugateGradient;
static void free_ConjugateGradient(ConjugateGradient *);

swig_class cSimplex;
static void free_Simplex(Simplex *);

swig_class cSteepestDescent;
static void free_SteepestDescent(SteepestDescent *);

using QuantLib::Problem;


    class Optimizer {};

Array Optimizer_solve(Optimizer *self,Constraint &c,OptimizationMethod &m){
        RubyCostFunction f;
        Problem p(f,c,m);
        p.minimize();
        return p.minimumValue();
    }

swig_class cOptimizer;
static void free_Optimizer(Optimizer *);

using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
typedef Handle<Payoff> PlainVanillaPayoffHandle;
typedef Handle<Payoff> PercentageStrikePayoffHandle;
typedef Handle<Payoff> CashOrNothingPayoffHandle;
typedef Handle<Payoff> AssetOrNothingPayoffHandle;
typedef Handle<Payoff> SuperSharePayoffHandle;

PlainVanillaPayoffHandle *new_PlainVanillaPayoffHandle(OptionType type,double strike){
            return new PlainVanillaPayoffHandle(
                                        new PlainVanillaPayoff(type, strike));
        }

swig_class cPlainVanillaPayoff;
static void free_PlainVanillaPayoffHandle(PlainVanillaPayoffHandle *);
PercentageStrikePayoffHandle *new_PercentageStrikePayoffHandle(OptionType type,double moneyness){
            return new PercentageStrikePayoffHandle(
                                 new PercentageStrikePayoff(type, moneyness));
        }

swig_class cPercentageStrikePayoff;
static void free_PercentageStrikePayoffHandle(PercentageStrikePayoffHandle *);
CashOrNothingPayoffHandle *new_CashOrNothingPayoffHandle(OptionType type,double strike,double payoff){
            return new CashOrNothingPayoffHandle(
                               new CashOrNothingPayoff(type, strike, payoff));
        }

swig_class cCashOrNothingPayoff;
static void free_CashOrNothingPayoffHandle(CashOrNothingPayoffHandle *);
AssetOrNothingPayoffHandle *new_AssetOrNothingPayoffHandle(OptionType type,double strike){
            return new AssetOrNothingPayoffHandle(
                                      new AssetOrNothingPayoff(type, strike));
        }

swig_class cAssetOrNothingPayoff;
static void free_AssetOrNothingPayoffHandle(AssetOrNothingPayoffHandle *);
SuperSharePayoffHandle *new_SuperSharePayoffHandle(OptionType type,double strike,double increment){
            return new SuperSharePayoffHandle(
                               new SuperSharePayoff(type, strike, increment));
        }

swig_class cSuperSharePayoff;
static void free_SuperSharePayoffHandle(SuperSharePayoffHandle *);

using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
typedef Handle<RateHelper> DepositRateHelperHandle;
typedef Handle<RateHelper> FraRateHelperHandle;
typedef Handle<RateHelper> FuturesRateHelperHandle;
typedef Handle<RateHelper> SwapRateHelperHandle;

bool HandlelRateHelper_g_isNull___(Handle<RateHelper > *self){
            return IsNull(*self);
        }

swig_class cRateHelper;
static void free_HandlelRateHelper_g___(Handle<RateHelper > *);
DepositRateHelperHandle *new_DepositRateHelperHandle__SWIG_0(RelinkableHandle<Quote > const &rate,int n,TimeUnit units,int settlementDays,Calendar const &calendar,RollingConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperHandle(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
DepositRateHelperHandle *new_DepositRateHelperHandle__SWIG_1(double rate,int n,TimeUnit units,int settlementDays,Calendar const &calendar,RollingConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperHandle(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }

swig_class cDepositRateHelper;
static void free_DepositRateHelperHandle(DepositRateHelperHandle *);
FraRateHelperHandle *new_FraRateHelperHandle__SWIG_0(RelinkableHandle<Quote > const &rate,int monthsToStart,int monthsToEnd,int settlementDays,Calendar const &calendar,RollingConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperHandle(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
FraRateHelperHandle *new_FraRateHelperHandle__SWIG_1(double rate,int monthsToStart,int monthsToEnd,int settlementDays,Calendar const &calendar,RollingConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperHandle(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }

swig_class cFraRateHelper;
static void free_FraRateHelperHandle(FraRateHelperHandle *);
FuturesRateHelperHandle *new_FuturesRateHelperHandle__SWIG_0(RelinkableHandle<Quote > const &price,Date const &immDate,int nMonths,Calendar const &calendar,RollingConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperHandle(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
FuturesRateHelperHandle *new_FuturesRateHelperHandle__SWIG_1(double price,Date const &immDate,int nMonths,Calendar const &calendar,RollingConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperHandle(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
FuturesRateHelperHandle *new_FuturesRateHelperHandle__SWIG_2(RelinkableHandle<Quote > const &price,Date const &immDate,Date const &matDate,Calendar const &calendar,RollingConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperHandle(
                new FuturesRateHelper(price,immDate,matDate,
                                      calendar,convention,dayCounter));
        }

swig_class cFuturesRateHelper;
static void free_FuturesRateHelperHandle(FuturesRateHelperHandle *);
SwapRateHelperHandle *new_SwapRateHelperHandle__SWIG_0(RelinkableHandle<Quote > const &rate,int n,TimeUnit units,int settlementDays,Calendar const &calendar,RollingConvention rollingConvention,int fixedFrequency,bool fixedIsAdjusted,DayCounter const &fixedDayCount,int floatingFrequency){
            return new SwapRateHelperHandle(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, rollingConvention, 
                                   fixedFrequency, fixedIsAdjusted, 
                                   fixedDayCount, floatingFrequency));
        }
SwapRateHelperHandle *new_SwapRateHelperHandle__SWIG_1(double rate,int n,TimeUnit units,int settlementDays,Calendar const &calendar,RollingConvention rollingConvention,int fixedFrequency,bool fixedIsAdjusted,DayCounter const &fixedDayCount,int floatingFrequency){
            return new SwapRateHelperHandle(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, rollingConvention, 
                                   fixedFrequency, fixedIsAdjusted, 
                                   fixedDayCount, floatingFrequency));
        }

swig_class cSwapRateHelper;
static void free_SwapRateHelperHandle(SwapRateHelperHandle *);
Handle<RateHelper > std_vectorlHandlelRateHelper_g_g_pop___(std::vector<Handle<RateHelper > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Handle<RateHelper > x = self->back();
                self->pop_back();
                return x;
            }
Handle<RateHelper > &std_vectorlHandlelRateHelper_g_g___getitem_____(std::vector<Handle<RateHelper > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelRateHelper_g_g___setitem_____(std::vector<Handle<RateHelper > > *self,int i,Handle<RateHelper > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelRateHelper_g_g_each___(std::vector<Handle<RateHelper > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Handle<RateHelper >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_HandleTRateHelper_t, 0));
                }
            }

swig_class cRateHelperVector;
static void free_std_vectorlHandlelRateHelper_g_g___(std::vector<Handle<RateHelper > > *);

using QuantLib::PiecewiseFlatForward;
typedef Handle<TermStructure> PiecewiseFlatForwardHandle;

PiecewiseFlatForwardHandle *new_PiecewiseFlatForwardHandle__SWIG_0(Date const &todaysDate,Date const &referenceDate,std::vector<Handle<RateHelper > > const &instruments,DayCounter const &dayCounter,double accuracy){
	        return new PiecewiseFlatForwardHandle(
	            new PiecewiseFlatForward(todaysDate, referenceDate, 
                                         instruments, dayCounter, accuracy));
        }
PiecewiseFlatForwardHandle *new_PiecewiseFlatForwardHandle__SWIG_1(Date const &todaysDate,std::vector<Date > const &dates,std::vector<double > const &forwards,DayCounter const &dayCounter){
	        return new PiecewiseFlatForwardHandle(
                new PiecewiseFlatForward(todaysDate,
                                         dates, forwards, dayCounter));
        }
std::vector<Date > const &PiecewiseFlatForwardHandle_dates(PiecewiseFlatForwardHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->dates();
            #else
            return Handle<PiecewiseFlatForward>(*self)->dates();
            #endif
        }
std::vector<double > const &PiecewiseFlatForwardHandle_times(PiecewiseFlatForwardHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->times();
            #else
            return Handle<PiecewiseFlatForward>(*self)->times();
            #endif
        }

swig_class cPiecewiseFlatForward;
static void free_PiecewiseFlatForwardHandle(PiecewiseFlatForwardHandle *);

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef Handle<CalibrationHelper> SwaptionHelperHandle;
typedef Handle<CalibrationHelper> CapHelperHandle;

bool HandlelCalibrationHelper_g_isNull___(Handle<CalibrationHelper > *self){
            return IsNull(*self);
        }

swig_class cCalibrationHelper;
static void free_HandlelCalibrationHelper_g___(Handle<CalibrationHelper > *);
SwaptionHelperHandle *new_SwaptionHelperHandle(Period const &maturity,Period const &length,RelinkableHandle<Quote > const &volatility,XiborHandle const &index,RelinkableHandle<TermStructure > const &termStructure){
            #if defined(HAVE_BOOST)
            Handle<Xibor> libor = boost::dynamic_pointer_cast<Xibor>(index);
            #else
            Handle<Xibor> libor = index;
            #endif
            return new SwaptionHelperHandle(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,termStructure));
        }

swig_class cSwaptionHelper;
static void free_SwaptionHelperHandle(SwaptionHelperHandle *);
CapHelperHandle *new_CapHelperHandle(Period const &length,RelinkableHandle<Quote > const &volatility,XiborHandle const &index,RelinkableHandle<TermStructure > const &termStructure){
            #if defined(HAVE_BOOST)
            Handle<Xibor> libor = boost::dynamic_pointer_cast<Xibor>(index);
            #else
            Handle<Xibor> libor = index;
            #endif
            return new CapHelperHandle(
                new CapHelper(length,volatility,libor,termStructure));
        }

swig_class cCapHelper;
static void free_CapHelperHandle(CapHelperHandle *);
Handle<CalibrationHelper > std_vectorlHandlelCalibrationHelper_g_g_pop___(std::vector<Handle<CalibrationHelper > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Handle<CalibrationHelper > x = self->back();
                self->pop_back();
                return x;
            }
Handle<CalibrationHelper > &std_vectorlHandlelCalibrationHelper_g_g___getitem_____(std::vector<Handle<CalibrationHelper > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelCalibrationHelper_g_g___setitem_____(std::vector<Handle<CalibrationHelper > > *self,int i,Handle<CalibrationHelper > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelCalibrationHelper_g_g_each___(std::vector<Handle<CalibrationHelper > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Handle<CalibrationHelper >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_HandleTCalibrationHelper_t, 0));
                }
            }

swig_class cCalibrationHelperVector;
static void free_std_vectorlHandlelCalibrationHelper_g_g___(std::vector<Handle<CalibrationHelper > > *);

using QuantLib::ShortRateModel;

bool HandlelShortRateModel_g_isNull___(Handle<ShortRateModel > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelShortRateModel_g_asObservable___(Handle<ShortRateModel > *self){
        return Handle<Observable>(*self);
    }

swig_class cShortRateModel;
static void free_HandlelShortRateModel_g___(Handle<ShortRateModel > *);

using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
typedef Handle<ShortRateModel> HullWhiteHandle;
typedef Handle<ShortRateModel> BlackKarasinskiHandle;

HullWhiteHandle *new_HullWhiteHandle(RelinkableHandle<TermStructure > const &termStructure,double a,double sigma){
	        return new HullWhiteHandle(
	            new HullWhite(termStructure, a, sigma));
        }

swig_class cHullWhite;
static void free_HullWhiteHandle(HullWhiteHandle *);
BlackKarasinskiHandle *new_BlackKarasinskiHandle(RelinkableHandle<TermStructure > const &termStructure,double a,double sigma){
	        return new BlackKarasinskiHandle(
	            new BlackKarasinski(termStructure, a, sigma));
        }

swig_class cBlackKarasinski;
static void free_BlackKarasinskiHandle(BlackKarasinskiHandle *);

using QuantLib::JamshidianSwaption;
using QuantLib::TreeSwaption;
using QuantLib::TreeCapFloor;
typedef Handle<PricingEngine> JamshidianSwaptionHandle;
typedef Handle<PricingEngine> TreeSwaptionHandle;
typedef Handle<PricingEngine> TreeCapFloorHandle;

JamshidianSwaptionHandle *new_JamshidianSwaptionHandle(Handle<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            #if defined(HAVE_BOOST)
            Handle<OneFactorAffineModel> m = 
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            #else
            Handle<OneFactorAffineModel> m = model;
            #endif
            QL_REQUIRE(!IsNull(model),
                       "JamshidianSwaption: affine model required");
            return new JamshidianSwaptionHandle(new JamshidianSwaption(m));
        }

swig_class cJamshidianSwaption;
static void free_JamshidianSwaptionHandle(JamshidianSwaptionHandle *);
TreeSwaptionHandle *new_TreeSwaptionHandle(Handle<ShortRateModel > const &model,Size timeSteps){
            return new TreeSwaptionHandle(
                new TreeSwaption(model,timeSteps));
        }

swig_class cTreeSwaption;
static void free_TreeSwaptionHandle(TreeSwaptionHandle *);
TreeCapFloorHandle *new_TreeCapFloorHandle(Handle<ShortRateModel > const &model,Size timeSteps){
            return new TreeCapFloorHandle(
                new TreeCapFloor(model,timeSteps));
        }

swig_class cTreeCapFloor;
static void free_TreeCapFloorHandle(TreeCapFloorHandle *);

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::SequenceStatistics;

void Statistics_add__SWIG_1(Statistics *self,std::vector<double > const &values){
            self->addSequence(values.begin(), values.end());
        }
void Statistics_add__SWIG_2(Statistics *self,std::vector<double > const &values,std::vector<double > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

swig_class cStatistics;
static void free_Statistics(Statistics *);

swig_class cRiskStatistics;
static void free_RiskStatistics(RiskStatistics *);

swig_class cMultipleStatistics;
static void free_SequenceStatisticslStatistics_g___(SequenceStatistics<Statistics > *);

using QuantLib::TimeBasket;

double TimeBasket___getitem__(TimeBasket *self,Date const &d){
            return (*self)[d];
        }
void TimeBasket___setitem__(TimeBasket *self,Date const &d,double value){
            (*self)[d] = value;
        }
void TimeBasket_each(TimeBasket *self){
            TimeBasket::iterator i;
            for (i=self->begin(); i!=self->end(); ++i) {
                    Date* d = new Date(i->first);
                    VALUE entry = rb_ary_new2(2);
                    VALUE k = SWIG_NewPointerObj((void *) d,
                                                 SWIGTYPE_p_Date,1);
                    VALUE x = rb_float_new(i->second);
                    rb_ary_store(entry,0,k);
                    rb_ary_store(entry,1,x);
                    rb_yield(entry);
            }
        }

swig_class cTimeBasket;
static void free_TimeBasket(TimeBasket *);

using QuantLib::Swap;
using QuantLib::SimpleSwap;
typedef Handle<Instrument> SwapHandle;
typedef Handle<Instrument> SimpleSwapHandle;

SwapHandle *new_SwapHandle(std::vector<Handle<CashFlow > > const &firstLeg,std::vector<Handle<CashFlow > > const &secondLeg,RelinkableHandle<TermStructure > const &termStructure){
            return new SwapHandle(new Swap(firstLeg, secondLeg, 
                                           termStructure));
        }
Date SwapHandle_startDate(SwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
            #else
            return Handle<Swap>(*self)->startDate();
            #endif
        }
Date SwapHandle_maturity(SwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Swap>(*self)->maturity();
            #else
            return Handle<Swap>(*self)->maturity();
            #endif
        }
double SwapHandle_firstLegBPS(SwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Swap>(*self)->firstLegBPS();
            #else
            return Handle<Swap>(*self)->firstLegBPS();
            #endif
        }
double SwapHandle_secondLegBPS(SwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Swap>(*self)->secondLegBPS();
            #else
            return Handle<Swap>(*self)->secondLegBPS();
            #endif
        }
TimeBasket SwapHandle_sensitivity(SwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<Swap>(*self)->sensitivity();
            #else
            return Handle<Swap>(*self)->sensitivity();
            #endif
        }

swig_class cSwap;
static void free_SwapHandle(SwapHandle *);

class FixedSwapLeg {
  public:
    FixedSwapLeg(int fixedFrequency, Rate fixedRate,
                 bool fixedIsAdjusted, const DayCounter& fixedDayCount)
    : fixedFrequency(fixedFrequency), fixedRate(fixedRate),
      fixedIsAdjusted(fixedIsAdjusted), fixedDayCount(fixedDayCount) {}
    int fixedFrequency;
    Rate fixedRate;
    bool fixedIsAdjusted;
    DayCounter fixedDayCount;
};
class FloatingSwapLeg {
  public:
    FloatingSwapLeg(int floatingFrequency, XiborHandle index, 
                    int indexFixingDays, Spread spread)
    : floatingFrequency(floatingFrequency), index(index),
      indexFixingDays(indexFixingDays), spread(spread) {}
    int floatingFrequency;
    XiborHandle index;
    int indexFixingDays;
    Spread spread;
};


swig_class cFixedSwapLeg;
static void free_FixedSwapLeg(FixedSwapLeg *);

swig_class cFloatingSwapLeg;
static void free_FloatingSwapLeg(FloatingSwapLeg *);
SimpleSwapHandle *new_SimpleSwapHandle(bool payFixedRate,Date const &startDate,int n,TimeUnit unit,Calendar const &calendar,RollingConvention rollingConvention,double nominal,FixedSwapLeg const &fixedLeg,FloatingSwapLeg const &floatingLeg,RelinkableHandle<TermStructure > const &termStructure){
            #if defined(HAVE_BOOST)
            Handle<Xibor> libor = 
                 boost::dynamic_pointer_cast<Xibor>(floatingLeg.index);
            #else
            Handle<Xibor> libor = floatingLeg.index;
            #endif
            return new SimpleSwapHandle(
                new SimpleSwap(
                    payFixedRate, startDate, n, unit, calendar,
                    rollingConvention, nominal, 
                    fixedLeg.fixedFrequency, fixedLeg.fixedRate, 
                    fixedLeg.fixedIsAdjusted, fixedLeg.fixedDayCount, 
                    floatingLeg.floatingFrequency, libor, 
                    floatingLeg.indexFixingDays, floatingLeg.spread, 
                    termStructure));
        }
Rate SimpleSwapHandle_fairRate(SimpleSwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)->fairRate();
            #else
            return Handle<SimpleSwap>(*self)->fairRate();
            #endif
        }
Spread SimpleSwapHandle_fairSpread(SimpleSwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fairSpread();
            #else
            return Handle<SimpleSwap>(*self)->fairSpread();
            #endif
        }
double SimpleSwapHandle_fixedLegBPS(SimpleSwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fixedLegBPS();
            #else
            return Handle<SimpleSwap>(*self)->fixedLegBPS();
            #endif
        }
double SimpleSwapHandle_floatingLegBPS(SimpleSwapHandle *self){
            #if defined(HAVE_BOOST)
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->floatingLegBPS();
            #else
            return Handle<SimpleSwap>(*self)->floatingLegBPS();
            #endif
        }

swig_class cSimpleSwap;
static void free_SimpleSwapHandle(SimpleSwapHandle *);

using QuantLib::Swaption;
typedef Handle<Instrument> SwaptionHandle;

SwaptionHandle *new_SwaptionHandle(Handle<Instrument > const &simpleSwap,Handle<Exercise > const &exercise,RelinkableHandle<TermStructure > const &termStructure,Handle<PricingEngine > const &engine){
            #if defined(HAVE_BOOST)
            Handle<SimpleSwap> swap = 
                 boost::dynamic_pointer_cast<SimpleSwap>(simpleSwap);
            #else
            Handle<SimpleSwap> swap = simpleSwap;
            #endif
            QL_REQUIRE(!IsNull(swap),
                       "Swaption: simple swap required");
            return new SwaptionHandle(new Swaption(swap,exercise,
                                                   termStructure,engine));
        }

swig_class cSwaption;
static void free_SwaptionHandle(SwaptionHandle *);

using QuantLib::BlackSwaption;
typedef Handle<PricingEngine> BlackSwaptionEngineHandle;

BlackSwaptionEngineHandle *new_BlackSwaptionEngineHandle(Handle<BlackModel > const &model){
            return new BlackSwaptionEngineHandle(new BlackSwaption(model));
        }

swig_class cBlackSwaptionEngine;
static void free_BlackSwaptionEngineHandle(BlackSwaptionEngineHandle *);

using QuantLib::EuropeanOption;


swig_class cEuropeanOption;
static void free_EuropeanOption(EuropeanOption *);

using QuantLib::Barrier;
typedef Barrier::Type BarrierType;

BarrierType barrierTypeFromString(std::string s) {
    s = StringFormatter::toLowercase(s);
    if (s == "downin")
        return Barrier::DownIn;
    else if (s == "downout")
        return Barrier::DownOut;
    else if (s == "upin")
        return Barrier::UpIn;
    else if (s == "upout")
        return Barrier::UpOut;
    else
        throw Error("unknown barrier type: "+s);
}

std::string barrierTypeToString(BarrierType t) {
    switch (t) {
      case Barrier::DownIn:
        return "DownIn";
      case Barrier::DownOut:
        return "DownOut";
      case Barrier::UpIn:
        return "UpIn";
      case Barrier::UpOut:
        return "UpOut";
      default:
        throw Error("unknown barrier type");
    }
}


using QuantLib::CliquetOptionPricer;


swig_class cCliquetOption;
static void free_CliquetOptionPricer(CliquetOptionPricer *);

using QuantLib::ContinuousGeometricAPO;
using QuantLib::DiscreteGeometricAPO;
using QuantLib::DiscreteGeometricASO;


swig_class cContinuousGeometricAPO;
static void free_ContinuousGeometricAPO(ContinuousGeometricAPO *);

swig_class cDiscreteGeometricAPO;
static void free_DiscreteGeometricAPO(DiscreteGeometricAPO *);

swig_class cDiscreteGeometricASO;
static void free_DiscreteGeometricASO(DiscreteGeometricASO *);

using QuantLib::FdEuropean;
using QuantLib::FdDividendEuropeanOption;


swig_class cFdEuropean;
static void free_FdEuropean(FdEuropean *);

swig_class cFdDividendEuropeanOption;
static void free_FdDividendEuropeanOption(FdDividendEuropeanOption *);

using QuantLib::FdAmericanOption;
using QuantLib::FdDividendAmericanOption;


swig_class cFdAmericanOption;
static void free_FdAmericanOption(FdAmericanOption *);

swig_class cFdDividendAmericanOption;
static void free_FdDividendAmericanOption(FdDividendAmericanOption *);

using QuantLib::FdShoutOption;
using QuantLib::FdDividendShoutOption;


swig_class cFdShoutOption;
static void free_FdShoutOption(FdShoutOption *);

swig_class cFdDividendShoutOption;
static void free_FdDividendShoutOption(FdDividendShoutOption *);

using QuantLib::FdBermudanOption;


swig_class cFdBermudanOption;
static void free_FdBermudanOption(FdBermudanOption *);

// single asset
using QuantLib::McDiscreteArithmeticAPO;
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McBasket;
using QuantLib::McMaxBasket;
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;


swig_class cMcDiscreteArithmeticAPO;
static void free_McDiscreteArithmeticAPO(McDiscreteArithmeticAPO *);

swig_class cMcDiscreteArithmeticASO;
static void free_McDiscreteArithmeticASO(McDiscreteArithmeticASO *);

swig_class cMcBasket;
static void free_McBasket(McBasket *);

swig_class cMcMaxBasket;
static void free_McMaxBasket(McMaxBasket *);

swig_class cMcHimalaya;
static void free_McHimalaya(McHimalaya *);

swig_class cMcEverest;
static void free_McEverest(McEverest *);

swig_class cMcPagoda;
static void free_McPagoda(McPagoda *);

using QuantLib::SwaptionVolatilityStructure;

bool HandlelSwaptionVolatilityStructure_g_isNull___(Handle<SwaptionVolatilityStructure > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelSwaptionVolatilityStructure_g_asObservable___(Handle<SwaptionVolatilityStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cSwaptionVolatilityStructure;
static void free_HandlelSwaptionVolatilityStructure_g___(Handle<SwaptionVolatilityStructure > *);
Handle<Observable > RelinkableHandlelSwaptionVolatilityStructure_g_asObservable___(RelinkableHandle<SwaptionVolatilityStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cSwaptionVolatilityStructureHandle;
static void free_RelinkableHandlelSwaptionVolatilityStructure_g___(RelinkableHandle<SwaptionVolatilityStructure > *);

using QuantLib::SwaptionVolatilityMatrix;
typedef Handle<SwaptionVolatilityStructure> SwaptionVolatilityMatrixHandle;

SwaptionVolatilityMatrixHandle *new_SwaptionVolatilityMatrixHandle(Date const &today,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixHandle(
                new SwaptionVolatilityMatrix(today,dates,lengths,
                                             vols,dayCounter));
        }

swig_class cSwaptionVolatilityMatrix;
static void free_SwaptionVolatilityMatrixHandle(SwaptionVolatilityMatrixHandle *);

using QuantLib::CapFlatVolatilityStructure;

bool HandlelCapFlatVolatilityStructure_g_isNull___(Handle<CapFlatVolatilityStructure > *self){
            return IsNull(*self);
        }
Handle<Observable > HandlelCapFlatVolatilityStructure_g_asObservable___(Handle<CapFlatVolatilityStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cCapFlatVolatilityStructure;
static void free_HandlelCapFlatVolatilityStructure_g___(Handle<CapFlatVolatilityStructure > *);
Handle<Observable > RelinkableHandlelCapFlatVolatilityStructure_g_asObservable___(RelinkableHandle<CapFlatVolatilityStructure > *self){
        return Handle<Observable>(*self);
    }

swig_class cCapFlatVolatilityStructureHandle;
static void free_RelinkableHandlelCapFlatVolatilityStructure_g___(RelinkableHandle<CapFlatVolatilityStructure > *);

using QuantLib::CapFlatVolatilityVector;
typedef Handle<CapFlatVolatilityStructure> CapFlatVolatilityVectorHandle;

CapFlatVolatilityVectorHandle *new_CapFlatVolatilityVectorHandle(Date const &today,Calendar const &calendar,int settlementDays,std::vector<Period > const &lengths,std::vector<double > const &vols,DayCounter const &dayCounter){
            return new CapFlatVolatilityVectorHandle(
                new CapFlatVolatilityVector(today,calendar,settlementDays,
                                            lengths,vols,dayCounter));
        }

swig_class cCapFlatVolatilityVector;
static void free_CapFlatVolatilityVectorHandle(CapFlatVolatilityVectorHandle *);
static VALUE
_wrap_Observable___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<Observable > *arg1 = (Handle<Observable > *) 0 ;
    Observable *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTObservable_t, 1);
    {
        try {
            result = (Observable *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Observable,0);
    return vresult;
}


static VALUE
_wrap_Observable_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<Observable > *arg1 = (Handle<Observable > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTObservable_t, 1);
    {
        try {
            result = (bool)HandlelObservable_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Observable_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Observable_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTObservable_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Observable(int argc, VALUE *argv, VALUE self) {
    Handle<Observable > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<Observable > *)new Handle<Observable >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelObservable_g___(Handle<Observable > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Observer_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Observer_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RubyObserver);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Observer(int argc, VALUE *argv, VALUE self) {
    VALUE arg1 ;
    RubyObserver *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = argv[0];
    {
        try {
            result = (RubyObserver *)new RubyObserver(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Observer__registerWith(int argc, VALUE *argv, VALUE self) {
    RubyObserver *arg1 = (RubyObserver *) 0 ;
    Handle<Observable > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RubyObserver, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTObservable_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->registerWith((Handle<Observable > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Observer__unregisterWith(int argc, VALUE *argv, VALUE self) {
    RubyObserver *arg1 = (RubyObserver *) 0 ;
    Handle<Observable > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RubyObserver, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTObservable_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->unregisterWith((Handle<Observable > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_RubyObserver(RubyObserver *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Array__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Array *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Array *)new Array();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Array__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    double arg2 = (double) 0.0 ;
    Array *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    if (argc > 1) {
        arg2 = (double) NUM2DBL(argv[1]);
    }
    {
        try {
            result = (Array *)new Array(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Array_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Array_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Array);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Array__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *result;
    Array temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (Array *)new Array((Array const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Array(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_Array__SWIG_0(nargs, args, self);
    }
    if ((argc >= 1) && (argc <= 2)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            if (argc <= 1) {
                return _wrap_new_Array__SWIG_1(nargs, args, self);
            }
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Array__SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                _v = 1;
                /* wrapped Array? */
            } else {
                Array* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_Array,0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_Array__SWIG_2(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Array'");
    return Qnil;
}


static VALUE
_wrap_Array___len__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Size result;
    Array temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(self,(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = ((Array const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Array___str__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        try {
            result = Array___str__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Array___add__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = Array___add__(arg1,(Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array___sub__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = Array___sub__(arg1,(Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array___mul____SWIG_0(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    double arg2 ;
    Array result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = Array___mul____SWIG_0(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array___mul____SWIG_1(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Array *arg2 = 0 ;
    double result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (double)Array___mul____SWIG_1(arg1,(Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Array___mul____SWIG_2(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Matrix *arg2 = 0 ;
    Array result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Array___mul____SWIG_2(arg1,(Matrix const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE _wrap_Array___mul__(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Array, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Array___mul____SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Array, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Array? */
                } else {
                    Array* v;
                    if (SWIG_ConvertPtr(argv[1],(void **) &v, 
                    SWIGTYPE_p_Array,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Array___mul____SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Array, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Matrix? */
                } else {
                    Matrix* m;
                    if (SWIG_ConvertPtr(argv[1],(void **) &m, 
                    SWIGTYPE_p_Matrix,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Array___mul____SWIG_2(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Array___mul__'");
    return Qnil;
}


static VALUE
_wrap_Array___div__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    double arg2 ;
    Array result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = Array___div__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array_each(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        try {
            Array_each(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Array___getitem__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    int arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (double)Array___getitem__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Array___setitem__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    int arg2 ;
    double arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            Array___setitem__(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_Array(Array *arg1) {
    delete arg1;
}
static VALUE
_wrap_LexicographicalViewColumn___getitem__(int argc, VALUE *argv, VALUE self) {
    LexicographicalViewColumn *arg1 = (LexicographicalViewColumn *) 0 ;
    int arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalViewColumn, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (double)LexicographicalViewColumn___getitem__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LexicographicalViewColumn___setitem__(int argc, VALUE *argv, VALUE self) {
    LexicographicalViewColumn *arg1 = (LexicographicalViewColumn *) 0 ;
    int arg2 ;
    double arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalViewColumn, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            LexicographicalViewColumn___setitem__(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_LexicographicalViewColumn(LexicographicalViewColumn *arg1) {
    delete arg1;
}
static VALUE
_wrap_LexicographicalView_xSize(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        try {
            result = ((LexicographicalView const *)arg1)->xSize();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_LexicographicalView_ySize(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        try {
            result = ((LexicographicalView const *)arg1)->ySize();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LexicographicalView_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LexicographicalView_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LexicographicalView);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LexicographicalView(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Size arg2 ;
    LexicographicalView *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Array, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Size(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = (LexicographicalView *)new_LexicographicalView(*arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LexicographicalView___str__(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        try {
            result = LexicographicalView___str__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_LexicographicalView___getitem__(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size arg2 ;
    SwigValueWrapper< LexicographicalViewColumn > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = LexicographicalView___getitem__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        LexicographicalViewColumn * resultptr;
        resultptr = new LexicographicalViewColumn((LexicographicalViewColumn &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_LexicographicalViewColumn, 1);
    }
    return vresult;
}


static void
free_LexicographicalView(LexicographicalView *arg1) {
    delete arg1;
}
static VALUE
_wrap_MatrixRow___getitem__(int argc, VALUE *argv, VALUE self) {
    MatrixRow *arg1 = (MatrixRow *) 0 ;
    int arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MatrixRow, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (double)MatrixRow___getitem__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_MatrixRow___setitem__(int argc, VALUE *argv, VALUE self) {
    MatrixRow *arg1 = (MatrixRow *) 0 ;
    int arg2 ;
    double arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MatrixRow, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            MatrixRow___setitem__(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_MatrixRow(MatrixRow *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Matrix__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Matrix *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Matrix *)new Matrix();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Matrix__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    Size arg2 ;
    double arg3 = (double) 0.0 ;
    Matrix *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Size(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    if (argc > 2) {
        arg3 = (double) NUM2DBL(argv[2]);
    }
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2,arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Matrix_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Matrix_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Matrix);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Matrix__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    Matrix *result;
    Matrix temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (Matrix *)new Matrix((Matrix const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Matrix(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_Matrix__SWIG_0(nargs, args, self);
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                _v = 1;
                /* wrapped Matrix? */
            } else {
                Matrix* m;
                if (SWIG_ConvertPtr(argv[0],(void **) &m, 
                SWIGTYPE_p_Matrix,0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_Matrix__SWIG_2(nargs, args, self);
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_Matrix__SWIG_1(nargs, args, self);
                }
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_Matrix__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Matrix'");
    return Qnil;
}


static VALUE
_wrap_Matrix_rows(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(self)->len;
            if (rows > 0) {
                VALUE o = RARRAY(self)->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(self,(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = ((Matrix const *)arg1)->rows();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Matrix_columns(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(self)->len;
            if (rows > 0) {
                VALUE o = RARRAY(self)->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(self,(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = ((Matrix const *)arg1)->columns();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Matrix___str__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        try {
            result = Matrix___str__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Matrix___add__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Matrix___add__(arg1,(Matrix const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___sub__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Matrix___sub__(arg1,(Matrix const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___mul____SWIG_0(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    double arg2 ;
    Matrix result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = Matrix___mul____SWIG_0(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___mul____SWIG_1(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = Matrix___mul____SWIG_1(arg1,(Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___mul____SWIG_2(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Matrix___mul____SWIG_2(arg1,(Matrix const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE _wrap_Matrix___mul__(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Matrix, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Matrix___mul____SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Matrix, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Array? */
                } else {
                    Array* v;
                    if (SWIG_ConvertPtr(argv[1],(void **) &v, 
                    SWIGTYPE_p_Array,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Matrix___mul____SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Matrix, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Matrix? */
                } else {
                    Matrix* m;
                    if (SWIG_ConvertPtr(argv[1],(void **) &m, 
                    SWIGTYPE_p_Matrix,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Matrix___mul____SWIG_2(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Matrix___mul__'");
    return Qnil;
}


static VALUE
_wrap_Matrix___div__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    double arg2 ;
    Matrix result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = Matrix___div__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___getitem__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Size arg2 ;
    SwigValueWrapper< MatrixRow > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = Matrix___getitem__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        MatrixRow * resultptr;
        resultptr = new MatrixRow((MatrixRow &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_MatrixRow, 1);
    }
    return vresult;
}


static void
free_Matrix(Matrix *arg1) {
    delete arg1;
}
static VALUE
_wrap_transpose(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    Matrix result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = transpose((Matrix const &)*arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_outerProduct(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix result;
    Array temp1 ;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_matrixSqrt(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    Matrix result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = matrixSqrt((Matrix const &)*arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SVD_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SVD_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SVD);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SVD(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    SVD *result;
    Matrix temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (SVD *)new SVD((Matrix const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_SVD_U(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->U();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Matrix,0);
    return vresult;
}


static VALUE
_wrap_SVD_V(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->V();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Matrix,0);
    return vresult;
}


static VALUE
_wrap_SVD_S(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Matrix result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            result = ((SVD const *)arg1)->S();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_SVD_singularValues(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Array *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            {
                Array const &_result_ref = ((SVD const *)arg1)->singularValues();
                result = (Array *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Array,0);
    return vresult;
}


static void
free_SVD(SVD *arg1) {
    delete arg1;
}
static VALUE
_wrap_Quote___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    Quote *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = (Quote *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Quote,0);
    return vresult;
}


static VALUE
_wrap_Quote_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = (bool)HandlelQuote_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Quote_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = HandlelQuote_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_Quote_value(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = (double)(*arg1)->value();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Quote_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Quote_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTQuote_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Quote(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelQuote_g___(Handle<Quote > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_QuoteHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_QuoteHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RelinkableHandleTQuote_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_QuoteHandle(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > const &arg1_defvalue = Handle<Quote >() ;
    Handle<Quote > *arg1 = (Handle<Quote > *) &arg1_defvalue ;
    RelinkableHandle<Quote > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (RelinkableHandle<Quote > *)new RelinkableHandle<Quote >((Handle<Quote > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_QuoteHandle___deref__(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
    Handle<Quote > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Quote > * resultptr;
        resultptr = new Handle<Quote >((Handle<Quote > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTQuote_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((Handle<Quote > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandle_nullq___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
    {
        try {
            result = (bool)(arg1)->isNull();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_QuoteHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
    {
        try {
            result = RelinkableHandlelQuote_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteHandle_value(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
    {
        try {
            result = (double)(*arg1)->value();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_RelinkableHandlelQuote_g___(RelinkableHandle<Quote > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SimpleQuote_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SimpleQuote_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SimpleQuoteHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SimpleQuote(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    SimpleQuoteHandle *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (SimpleQuoteHandle *)new_SimpleQuoteHandle(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_SimpleQuote_valuee___(int argc, VALUE *argv, VALUE self) {
    SimpleQuoteHandle *arg1 = (SimpleQuoteHandle *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SimpleQuoteHandle, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            SimpleQuoteHandle_setValue(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_SimpleQuoteHandle(SimpleQuoteHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_QuoteVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<Handle<Quote > > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_QuoteVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    Handle<Quote > *arg2 = 0 ;
    std::vector<Handle<Quote > > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1,(Handle<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_QuoteVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_QuoteVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_QuoteVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = 0 ;
    std::vector<Handle<Quote > > *result;
    std::vector<Handle<Quote > > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Handle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >((std::vector<Handle<Quote > > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_QuoteVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_QuoteVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_QuoteVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Handle<Quote >* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_HandleTQuote_t,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Handle<Quote > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTHandleTQuote_t_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_QuoteVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_QuoteVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_QuoteVector'");
    return Qnil;
}


static VALUE
_wrap_QuoteVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    unsigned int result;
    std::vector<Handle<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Handle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Handle<Quote > > const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_QuoteVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    bool result;
    std::vector<Handle<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Handle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<Handle<Quote > > const *)arg1)->empty();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_QuoteVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((Handle<Quote > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    {
        try {
            result = std_vectorlHandlelQuote_g_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        Handle<Quote > * resultptr;
        resultptr = new Handle<Quote >((Handle<Quote > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTQuote_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Handle<Quote > &_result_ref = std_vectorlHandlelQuote_g_g___getitem_____(arg1,arg2);
                result = (Handle<Quote > *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_HandleTQuote_t,0);
    return vresult;
}


static VALUE
_wrap_QuoteVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_HandleTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlHandlelQuote_g_g___setitem_____(arg1,arg2,(Handle<Quote > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    {
        try {
            std_vectorlHandlelQuote_g_g_each___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlHandlelQuote_g_g___(std::vector<Handle<Quote > > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_QuoteHandleVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<RelinkableHandle<Quote > > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_QuoteHandleVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    RelinkableHandle<Quote > *arg2 = 0 ;
    std::vector<RelinkableHandle<Quote > > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >(arg1,(RelinkableHandle<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_QuoteHandleVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_QuoteHandleVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_QuoteHandleVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = 0 ;
    std::vector<RelinkableHandle<Quote > > *result;
    std::vector<RelinkableHandle<Quote > > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<RelinkableHandle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                RelinkableHandle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >((std::vector<RelinkableHandle<Quote > > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_QuoteHandleVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_QuoteHandleVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_QuoteHandleVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    RelinkableHandle<Quote >* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_RelinkableHandleTQuote_t,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<RelinkableHandle<Quote > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_QuoteHandleVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_RelinkableHandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_QuoteHandleVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_QuoteHandleVector'");
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    unsigned int result;
    std::vector<RelinkableHandle<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<RelinkableHandle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                RelinkableHandle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<RelinkableHandle<Quote > > const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    bool result;
    std::vector<RelinkableHandle<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<RelinkableHandle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                RelinkableHandle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<RelinkableHandle<Quote > > const *)arg1)->empty();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    RelinkableHandle<Quote > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((RelinkableHandle<Quote > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    RelinkableHandle<Quote > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
    {
        try {
            result = std_vectorlRelinkableHandlelQuote_g_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        RelinkableHandle<Quote > * resultptr;
        resultptr = new RelinkableHandle<Quote >((RelinkableHandle<Quote > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_RelinkableHandleTQuote_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    int arg2 ;
    RelinkableHandle<Quote > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                RelinkableHandle<Quote > &_result_ref = std_vectorlRelinkableHandlelQuote_g_g___getitem_____(arg1,arg2);
                result = (RelinkableHandle<Quote > *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RelinkableHandleTQuote_t,0);
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    int arg2 ;
    RelinkableHandle<Quote > *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlRelinkableHandlelQuote_g_g___setitem_____(arg1,arg2,(RelinkableHandle<Quote > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t, 1);
    {
        try {
            std_vectorlRelinkableHandlelQuote_g_g_each___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlRelinkableHandlelQuote_g_g___(std::vector<RelinkableHandle<Quote > > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Period__SWIG_0(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    TimeUnit arg2 ;
    Period *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    {
        try {
            result = (Period *)new Period(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Period_length(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = (int)((Period const *)arg1)->length();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Period_units(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    TimeUnit result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = ((Period const *)arg1)->units();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(stringFromTimeunit(result).c_str());
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Period_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Period_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Period);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Period__SWIG_1(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    Period *result;
    std::string temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (Period *)new_Period__SWIG_1((std::string const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Period(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 1) {
        int _v;
        {
            _v = (TYPE(argv[0]) == T_STRING) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Period__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Period__SWIG_0(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Period'");
    return Qnil;
}


static VALUE
_wrap_Period___str__(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = Period___str__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Period___repr__(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = Period___repr__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Period___cmp__(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    Period *arg2 = 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (int)Period___cmp__(arg1,(Period const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static void
free_Period(Period *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_PeriodVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<Period > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_PeriodVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    Period *arg2 = 0 ;
    std::vector<Period > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >(arg1,(Period const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_PeriodVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_PeriodVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTPeriod_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_PeriodVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = 0 ;
    std::vector<Period > *result;
    std::vector<Period > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Period* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Period, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
        }
    }
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >((std::vector<Period > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_PeriodVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_PeriodVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_PeriodVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Period* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_Period,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Period >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTPeriod_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_PeriodVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Period, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_PeriodVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_PeriodVector'");
    return Qnil;
}


static VALUE
_wrap_PeriodVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    unsigned int result;
    std::vector<Period > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Period* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Period, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Period > const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PeriodVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    bool result;
    std::vector<Period > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Period* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Period, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<Period > const *)arg1)->empty();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PeriodVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_PeriodVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    Period *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((Period const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_PeriodVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    SwigValueWrapper< Period > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    {
        try {
            result = std_vectorlPeriod_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        Period * resultptr;
        resultptr = new Period((Period &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Period, 1);
    }
    return vresult;
}


static VALUE
_wrap_PeriodVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Period &_result_ref = std_vectorlPeriod_g___getitem_____(arg1,arg2);
                result = (Period *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Period,0);
    return vresult;
}


static VALUE
_wrap_PeriodVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Period, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlPeriod_g___setitem_____(arg1,arg2,(Period const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_PeriodVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    {
        try {
            std_vectorlPeriod_g_each___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlPeriod_g___(std::vector<Period > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Date__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Date *)new Date();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Date__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Day arg1 ;
    Month arg2 ;
    Year arg3 ;
    Date *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Month(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg3 = NUM2INT(argv[2]);
    {
        try {
            result = (Date *)new Date(arg1,arg2,arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Date__SWIG_2(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    Date *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2LONG(argv[0]);
    {
        try {
            result = (Date *)new Date(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Date_weekday(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Weekday result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = ((Date const *)arg1)->weekday();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(stringFromWeekday(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date_dayOfMonth(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Day result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfMonth();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_dayOfYear(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Day result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfYear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_isEndOfMonth(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (bool)((Date const *)arg1)->isEndOfMonth();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Date_lastDayOfMonth(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Day result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Day)((Date const *)arg1)->lastDayOfMonth();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_month(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Month result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = ((Date const *)arg1)->month();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Date_year(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Year result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Year)((Date const *)arg1)->year();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_serialNumber(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (long)((Date const *)arg1)->serialNumber();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_plusDays(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->plusDays(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_plusWeeks(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->plusWeeks(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_plusMonths(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->plusMonths(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_plusYears(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->plusYears(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_plus(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int arg2 ;
    TimeUnit arg3 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg3 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    {
        try {
            result = ((Date const *)arg1)->plus(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_isLeap(int argc, VALUE *argv, VALUE self) {
    Year arg1 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        try {
            result = (bool)Date::isLeap(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Date_minDate(int argc, VALUE *argv, VALUE self) {
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = Date::minDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_maxDate(int argc, VALUE *argv, VALUE self) {
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = Date::maxDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_todaysDate(int argc, VALUE *argv, VALUE self) {
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = Date::todaysDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date___add__(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->operator +(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date___sub____SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->operator -(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Date_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Date_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Date);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Date__SWIG_3(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    Date *result;
    std::string temp1 ;
    std::string temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        if (TYPE(argv[1]) == T_STRING) {
            temp2 = std::string(StringValuePtr(argv[1]));
            arg2 = &temp2;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (Date *)new_Date__SWIG_3((std::string const &)*arg1,(std::string const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Date(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_Date__SWIG_0(nargs, args, self);
    }
    if (argc == 1) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Date__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (TYPE(argv[0]) == T_STRING) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Date__SWIG_3(nargs, args, self);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_Date__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Date'");
    return Qnil;
}


static VALUE
_wrap_Date_weekdayNumber(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (int)Date_weekdayNumber(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date___str__(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date___str__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date___repr__(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date___repr__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date_ISO(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date_ISO(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date___sub____SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Date *arg2 = 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (long)Date_operator_s_____SWIG_1(arg1,(Date const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE _wrap_Date___sub__(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Date___sub____SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Date___sub____SWIG_0(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Date___sub__'");
    return Qnil;
}


static VALUE
_wrap_Date___cmp__(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Date *arg2 = 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (int)Date___cmp__(arg1,(Date const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_succ(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date_succ(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static void
free_Date(Date *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_DateVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<Date > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_DateVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    Date *arg2 = 0 ;
    std::vector<Date > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >(arg1,(Date const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DateVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DateVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTDate_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DateVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = 0 ;
    std::vector<Date > *result;
    std::vector<Date > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >((std::vector<Date > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_DateVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_DateVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_DateVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Date* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_Date,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Date >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTDate_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_DateVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_DateVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_DateVector'");
    return Qnil;
}


static VALUE
_wrap_DateVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    unsigned int result;
    std::vector<Date > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Date > const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DateVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    bool result;
    std::vector<Date > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<Date > const *)arg1)->empty();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_DateVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DateVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((Date const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DateVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    {
        try {
            result = std_vectorlDate_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_DateVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Date &_result_ref = std_vectorlDate_g___getitem_____(arg1,arg2);
                result = (Date *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Date,0);
    return vresult;
}


static VALUE
_wrap_DateVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlDate_g___setitem_____(arg1,arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_DateVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    {
        try {
            std_vectorlDate_g_each___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlDate_g___(std::vector<Date > *arg1) {
    delete arg1;
}
static VALUE
_wrap_nullInt(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (int)nullInt();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_nullDouble(int argc, VALUE *argv, VALUE self) {
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (double)nullDouble();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DayCounter_dayCount(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (int)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DayCounter_yearFraction(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date const &arg4_defvalue = Date() ;
    Date *arg4 = (Date *) &arg4_defvalue ;
    Date const &arg5_defvalue = Date() ;
    Date *arg5 = (Date *) &arg5_defvalue ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_Date, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_Date, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DayCounter_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DayCounter_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DayCounter);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DayCounter(int argc, VALUE *argv, VALUE self) {
    std::string arg1 ;
    DayCounter *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            arg1 = std::string(StringValuePtr(argv[0]));
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (DayCounter *)new_DayCounter(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_DayCounter___str__(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    {
        try {
            result = DayCounter___str__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_DayCounter___eq__(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    DayCounter *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_DayCounter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)DayCounter___eq__(arg1,(DayCounter const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_DayCounter(DayCounter *arg1) {
    delete arg1;
}
static VALUE
_wrap_TermStructure___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    TermStructure *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = (TermStructure *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_TermStructure,0);
    return vresult;
}


static VALUE
_wrap_TermStructure_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = (bool)HandlelTermStructure_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TermStructure_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = HandlelTermStructure_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructure_dayCounter(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructure_todaysDate(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->todaysDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructure_referenceDate(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructure_maxDate(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructure_maxTime(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructure_discount__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructure_discount__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructure_discount(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructure_discount__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructure_discount__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructure_discount__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructure_discount__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructure_discount'");
    return Qnil;
}


static VALUE
_wrap_TermStructure_zeroYield__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroYield((Date const &)*arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructure_zeroYield__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroYield(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructure_zeroYield(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructure_zeroYield__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructure_zeroYield__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructure_zeroYield__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructure_zeroYield__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructure_zeroYield'");
    return Qnil;
}


static VALUE
_wrap_TermStructure_forward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->forward((Date const &)*arg2,(Date const &)*arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructure_forward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->forward(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructure_forward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructure_forward__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructure_forward__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructure_forward__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructure_forward__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructure_forward'");
    return Qnil;
}


static VALUE
_wrap_TermStructure_instantaneousForward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->instantaneousForward((Date const &)*arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructure_instantaneousForward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->instantaneousForward(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructure_instantaneousForward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructure_instantaneousForward__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructure_instantaneousForward__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructure_instantaneousForward__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructure_instantaneousForward__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructure_instantaneousForward'");
    return Qnil;
}


static VALUE
_wrap_TermStructure_compoundForward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->compoundForward((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructure_compoundForward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Time arg2 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->compoundForward(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructure_compoundForward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructure_compoundForward__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructure_compoundForward__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructure_compoundForward__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructure_compoundForward__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructure_compoundForward'");
    return Qnil;
}


static VALUE
_wrap_TermStructure_zeroCoupon__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroCoupon((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructure_zeroCoupon__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) 0 ;
    Time arg2 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroCoupon(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructure_zeroCoupon(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructure_zeroCoupon__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructure_zeroCoupon__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructure_zeroCoupon__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructure_zeroCoupon__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructure_zeroCoupon'");
    return Qnil;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TermStructure(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<TermStructure > *)new Handle<TermStructure >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelTermStructure_g___(Handle<TermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TermStructureHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TermStructureHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RelinkableHandleTTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TermStructureHandle(int argc, VALUE *argv, VALUE self) {
    Handle<TermStructure > const &arg1_defvalue = Handle<TermStructure >() ;
    Handle<TermStructure > *arg1 = (Handle<TermStructure > *) &arg1_defvalue ;
    RelinkableHandle<TermStructure > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (RelinkableHandle<TermStructure > *)new RelinkableHandle<TermStructure >((Handle<TermStructure > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_TermStructureHandle___deref__(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Handle<TermStructure > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<TermStructure > * resultptr;
        resultptr = new Handle<TermStructure >((Handle<TermStructure > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTTermStructure_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Handle<TermStructure > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((Handle<TermStructure > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_TermStructureHandle_nullq___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = (bool)(arg1)->isNull();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = RelinkableHandlelTermStructure_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_dayCounter(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_todaysDate(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->todaysDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_referenceDate(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_maxDate(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_maxTime(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_discount__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_discount__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructureHandle_discount(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructureHandle_discount__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructureHandle_discount__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructureHandle_discount__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructureHandle_discount__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructureHandle_discount'");
    return Qnil;
}


static VALUE
_wrap_TermStructureHandle_zeroYield__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroYield((Date const &)*arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_zeroYield__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroYield(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructureHandle_zeroYield(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructureHandle_zeroYield__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructureHandle_zeroYield__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructureHandle_zeroYield__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructureHandle_zeroYield__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructureHandle_zeroYield'");
    return Qnil;
}


static VALUE
_wrap_TermStructureHandle_forward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->forward((Date const &)*arg2,(Date const &)*arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_forward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->forward(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructureHandle_forward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructureHandle_forward__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructureHandle_forward__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructureHandle_forward__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructureHandle_forward__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructureHandle_forward'");
    return Qnil;
}


static VALUE
_wrap_TermStructureHandle_instantaneousForward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->instantaneousForward((Date const &)*arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_instantaneousForward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Rate)(*arg1)->instantaneousForward(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructureHandle_instantaneousForward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructureHandle_instantaneousForward__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructureHandle_instantaneousForward__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_TermStructureHandle_instantaneousForward__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_TermStructureHandle_instantaneousForward__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructureHandle_instantaneousForward'");
    return Qnil;
}


static VALUE
_wrap_TermStructureHandle_compoundForward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->compoundForward((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_compoundForward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Time arg2 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->compoundForward(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructureHandle_compoundForward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructureHandle_compoundForward__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructureHandle_compoundForward__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructureHandle_compoundForward__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructureHandle_compoundForward__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructureHandle_compoundForward'");
    return Qnil;
}


static VALUE
_wrap_TermStructureHandle_zeroCoupon__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Date *arg2 = 0 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroCoupon((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TermStructureHandle_zeroCoupon__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = (RelinkableHandle<TermStructure > *) 0 ;
    Time arg2 ;
    int arg3 ;
    bool arg4 = (bool) false ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = NUM2INT(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Rate)(*arg1)->zeroCoupon(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_TermStructureHandle_zeroCoupon(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructureHandle_zeroCoupon__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructureHandle_zeroCoupon__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_TermStructureHandle_zeroCoupon__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_TermStructureHandle_zeroCoupon__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'TermStructureHandle_zeroCoupon'");
    return Qnil;
}


static void
free_RelinkableHandlelTermStructure_g___(RelinkableHandle<TermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ImpliedTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ImpliedTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ImpliedTermStructureHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ImpliedTermStructure(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    ImpliedTermStructureHandle *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ImpliedTermStructureHandle *)new_ImpliedTermStructureHandle((RelinkableHandle<TermStructure > const &)*arg1,(Date const &)*arg2,(Date const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ImpliedTermStructureHandle(ImpliedTermStructureHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ZeroSpreadedTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ZeroSpreadedTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ZeroSpreadedTermStructureHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ZeroSpreadedTermStructure(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = 0 ;
    RelinkableHandle<Quote > *arg2 = 0 ;
    ZeroSpreadedTermStructureHandle *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ZeroSpreadedTermStructureHandle *)new_ZeroSpreadedTermStructureHandle((RelinkableHandle<TermStructure > const &)*arg1,(RelinkableHandle<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ZeroSpreadedTermStructureHandle(ZeroSpreadedTermStructureHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ForwardSpreadedTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ForwardSpreadedTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ForwardSpreadedTermStructureHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ForwardSpreadedTermStructure(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<TermStructure > *arg1 = 0 ;
    RelinkableHandle<Quote > *arg2 = 0 ;
    ForwardSpreadedTermStructureHandle *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ForwardSpreadedTermStructureHandle *)new_ForwardSpreadedTermStructureHandle((RelinkableHandle<TermStructure > const &)*arg1,(RelinkableHandle<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ForwardSpreadedTermStructureHandle(ForwardSpreadedTermStructureHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_FlatForward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    RelinkableHandle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    FlatForwardHandle *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (FlatForwardHandle *)new_FlatForwardHandle__SWIG_0((Date const &)*arg1,(Date const &)*arg2,(RelinkableHandle<Quote > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FlatForward_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FlatForward_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FlatForwardHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FlatForward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    double arg3 ;
    DayCounter *arg4 = 0 ;
    FlatForwardHandle *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (double) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (FlatForwardHandle *)new_FlatForwardHandle__SWIG_1((Date const &)*arg1,(Date const &)*arg2,arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_FlatForward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_RelinkableHandleTQuote_t, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_FlatForward__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_FlatForward__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FlatForward'");
    return Qnil;
}


static void
free_FlatForwardHandle(FlatForwardHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_BlackModel___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<BlackModel > *arg1 = (Handle<BlackModel > *) 0 ;
    BlackModel *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackModel_t, 1);
    {
        try {
            result = (BlackModel *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BlackModel,0);
    return vresult;
}


static VALUE
_wrap_BlackModel_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<BlackModel > *arg1 = (Handle<BlackModel > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackModel_t, 1);
    {
        try {
            result = (bool)HandlelBlackModel_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackModel_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackModel_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTBlackModel_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackModel(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = 0 ;
    RelinkableHandle<TermStructure > *arg2 = 0 ;
    Handle<BlackModel > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (Handle<BlackModel > *)new_HandlelBlackModel_g___((RelinkableHandle<Quote > const &)*arg1,(RelinkableHandle<TermStructure > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelBlackModel_g___(Handle<BlackModel > *arg1) {
    delete arg1;
}
static VALUE
_wrap_Calendar_isBusinessDayq___(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Calendar_isHolidayq___(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)(arg1)->isHoliday((Date const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Calendar_roll(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    RollingConvention arg3 = (RollingConvention) QuantLib::Following ;
    Date const &arg4_defvalue = Date() ;
    Date *arg4 = (Date *) &arg4_defvalue ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        {
            if (TYPE(argv[1]) == T_STRING) {
                std::string s(STR2CSTR(argv[1]));
                try {
                    arg3 = rollconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
            }
        }
    }
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_Date, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (arg1)->roll((Date const &)*arg2,arg3,(Date const &)*arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Calendar_advance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    int arg3 ;
    TimeUnit arg4 ;
    RollingConvention arg5 = (RollingConvention) QuantLib::Following ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]);
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg4 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    if (argc > 3) {
        {
            if (TYPE(argv[3]) == T_STRING) {
                std::string s(STR2CSTR(argv[3]));
                try {
                    arg5 = rollconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
            }
        }
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Calendar_advance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    RollingConvention arg4 = (RollingConvention) QuantLib::Following ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Period, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        {
            if (TYPE(argv[2]) == T_STRING) {
                std::string s(STR2CSTR(argv[2]));
                try {
                    arg4 = rollconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
            }
        }
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE _wrap_Calendar_advance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Period, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_Calendar_advance__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_Calendar_advance__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_Calendar_advance__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_Calendar_advance__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Calendar_advance'");
    return Qnil;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Calendar_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Calendar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Calendar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Calendar(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    Calendar *result;
    std::string temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (Calendar *)new_Calendar((std::string const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Calendar___str__(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    {
        try {
            result = Calendar___str__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Calendar___eq__(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Calendar *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)Calendar___eq__(arg1,(Calendar const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_Calendar(Calendar *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_JointCalendar__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    JointCalendarRule arg3 = (JointCalendarRule) QuantLib::JoinHolidays ;
    JointCalendar *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Calendar, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        {
            if (TYPE(argv[2]) == T_STRING) {
                std::string s(STR2CSTR(argv[2]));
                try {
                    arg3 = joinRuleFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
            }
        }
    }
    {
        try {
            result = (JointCalendar *)new JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_JointCalendar__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    JointCalendarRule arg4 = (JointCalendarRule) QuantLib::JoinHolidays ;
    JointCalendar *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Calendar, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Calendar, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        {
            if (TYPE(argv[3]) == T_STRING) {
                std::string s(STR2CSTR(argv[3]));
                try {
                    arg4 = joinRuleFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
            }
        }
    }
    {
        try {
            result = (JointCalendar *)new JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_JointCalendar_allocate(VALUE self) {
#else
    static VALUE
    _wrap_JointCalendar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_JointCalendar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_JointCalendar__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    JointCalendarRule arg5 = (JointCalendarRule) QuantLib::JoinHolidays ;
    JointCalendar *result;
    
    if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Calendar, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Calendar, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_Calendar, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 4) {
        {
            if (TYPE(argv[4]) == T_STRING) {
                std::string s(STR2CSTR(argv[4]));
                try {
                    arg5 = joinRuleFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
            }
        }
    }
    {
        try {
            result = (JointCalendar *)new JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_JointCalendar(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_JointCalendar__SWIG_0(nargs, args, self);
                }
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_JointCalendar__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_new_JointCalendar__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_JointCalendar__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_new_JointCalendar__SWIG_2(nargs, args, self);
                        }
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_new_JointCalendar__SWIG_2(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_JointCalendar'");
    return Qnil;
}


static void
free_JointCalendar(JointCalendar *arg1) {
    delete arg1;
}
static VALUE
_wrap_Exercise___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<Exercise > *arg1 = (Handle<Exercise > *) 0 ;
    Exercise *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTExercise_t, 1);
    {
        try {
            result = (Exercise *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Exercise,0);
    return vresult;
}


static VALUE
_wrap_Exercise_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<Exercise > *arg1 = (Handle<Exercise > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTExercise_t, 1);
    {
        try {
            result = (bool)HandlelExercise_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Exercise_type(int argc, VALUE *argv, VALUE self) {
    Handle<Exercise > *arg1 = (Handle<Exercise > *) 0 ;
    ExerciseType result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTExercise_t, 1);
    {
        try {
            result = (*arg1)->type();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(exerciseTypeToString(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_Exercise_dates(int argc, VALUE *argv, VALUE self) {
    Handle<Exercise > *arg1 = (Handle<Exercise > *) 0 ;
    std::vector<Date > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTExercise_t, 1);
    {
        try {
            result = (*arg1)->dates();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_ary_new2((&result)->size());
        for (unsigned int i=0; i<(&result)->size(); i++) {
            Date* x = new Date(((std::vector<Date > &)result)[i]);
            rb_ary_store(vresult,i,
            SWIG_NewPointerObj((void *) x, 
            SWIGTYPE_p_Date, 1));
        }
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Exercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Exercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTExercise_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Exercise(int argc, VALUE *argv, VALUE self) {
    Handle<Exercise > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<Exercise > *)new Handle<Exercise >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelExercise_g___(Handle<Exercise > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_EuropeanExercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_EuropeanExercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_EuropeanExerciseHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_EuropeanExercise(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    EuropeanExerciseHandle *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (EuropeanExerciseHandle *)new_EuropeanExerciseHandle((Date const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_EuropeanExerciseHandle(EuropeanExerciseHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_AmericanExercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_AmericanExercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_AmericanExerciseHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_AmericanExercise(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    AmericanExerciseHandle *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        arg3 = RTEST(argv[2]);
    }
    {
        try {
            result = (AmericanExerciseHandle *)new_AmericanExerciseHandle((Date const &)*arg1,(Date const &)*arg2,arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_AmericanExerciseHandle(AmericanExerciseHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BermudanExercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BermudanExercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BermudanExerciseHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BermudanExercise(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = 0 ;
    bool arg2 = (bool) false ;
    BermudanExerciseHandle *result;
    std::vector<Date > temp1 ;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    if (argc > 1) {
        arg2 = RTEST(argv[1]);
    }
    {
        try {
            result = (BermudanExerciseHandle *)new_BermudanExerciseHandle((std::vector<Date > const &)*arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BermudanExerciseHandle(BermudanExerciseHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_BlackVolTermStructure___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    BlackVolTermStructure *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (BlackVolTermStructure *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BlackVolTermStructure,0);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (bool)HandlelBlackVolTermStructure_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = HandlelBlackVolTermStructure_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_referenceDate(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_dayCounter(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_maxDate(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_maxTime(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVol(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_blackVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVariance(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackVariance'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackForwardVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackForwardVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackForwardVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackForwardVariance'");
    return Qnil;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackVolTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackVolTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTBlackVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackVolTermStructure(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<BlackVolTermStructure > *)new Handle<BlackVolTermStructure >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelBlackVolTermStructure_g___(Handle<BlackVolTermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackVolTermStructureHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackVolTermStructureHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackVolTermStructureHandle(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > const &arg1_defvalue = Handle<BlackVolTermStructure >() ;
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) &arg1_defvalue ;
    RelinkableHandle<BlackVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (RelinkableHandle<BlackVolTermStructure > *)new RelinkableHandle<BlackVolTermStructure >((Handle<BlackVolTermStructure > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_BlackVolTermStructureHandle___deref__(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Handle<BlackVolTermStructure > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<BlackVolTermStructure > * resultptr;
        resultptr = new Handle<BlackVolTermStructure >((Handle<BlackVolTermStructure > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Handle<BlackVolTermStructure > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((Handle<BlackVolTermStructure > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_nullq___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (bool)(arg1)->isNull();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = RelinkableHandlelBlackVolTermStructure_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_referenceDate(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_dayCounter(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_maxDate(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_maxTime(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVol(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->blackVariance(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackVariance'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackForwardVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackForwardVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    double arg4 ;
    bool arg5 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (double)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackForwardVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackForwardVariance'");
    return Qnil;
}


static void
free_RelinkableHandlelBlackVolTermStructure_g___(RelinkableHandle<BlackVolTermStructure > *arg1) {
    delete arg1;
}
static VALUE
_wrap_LocalVolTermStructure___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    LocalVolTermStructure *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (LocalVolTermStructure *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_LocalVolTermStructure,0);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (bool)HandlelLocalVolTermStructure_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = HandlelLocalVolTermStructure_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_referenceDate(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_dayCounter(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_maxDate(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_maxTime(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_localVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_localVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Time arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->localVol(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_LocalVolTermStructure_localVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'LocalVolTermStructure_localVol'");
    return Qnil;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LocalVolTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LocalVolTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTLocalVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LocalVolTermStructure(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<LocalVolTermStructure > *)new Handle<LocalVolTermStructure >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelLocalVolTermStructure_g___(Handle<LocalVolTermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LocalVolTermStructureHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LocalVolTermStructureHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LocalVolTermStructureHandle(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > const &arg1_defvalue = Handle<LocalVolTermStructure >() ;
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) &arg1_defvalue ;
    RelinkableHandle<LocalVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (RelinkableHandle<LocalVolTermStructure > *)new RelinkableHandle<LocalVolTermStructure >((Handle<LocalVolTermStructure > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LocalVolTermStructureHandle___deref__(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Handle<LocalVolTermStructure > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<LocalVolTermStructure > * resultptr;
        resultptr = new Handle<LocalVolTermStructure >((Handle<LocalVolTermStructure > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Handle<LocalVolTermStructure > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((Handle<LocalVolTermStructure > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructureHandle_nullq___(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (bool)(arg1)->isNull();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = RelinkableHandlelLocalVolTermStructure_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_referenceDate(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_dayCounter(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_maxDate(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_maxTime(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_localVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_localVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
    Time arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(*arg1)->localVol(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_LocalVolTermStructureHandle_localVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'LocalVolTermStructureHandle_localVol'");
    return Qnil;
}


static void
free_RelinkableHandlelLocalVolTermStructure_g___(RelinkableHandle<LocalVolTermStructure > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_BlackConstantVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    double arg2 ;
    DayCounter const &arg3_defvalue = Actual365() ;
    DayCounter *arg3 = (DayCounter *) &arg3_defvalue ;
    BlackConstantVolHandle *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg2 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (BlackConstantVolHandle *)new_BlackConstantVolHandle__SWIG_0((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackConstantVol_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackConstantVol_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BlackConstantVolHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackConstantVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    RelinkableHandle<Quote > *arg2 = 0 ;
    DayCounter const &arg3_defvalue = Actual365() ;
    DayCounter *arg3 = (DayCounter *) &arg3_defvalue ;
    BlackConstantVolHandle *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (BlackConstantVolHandle *)new_BlackConstantVolHandle__SWIG_1((Date const &)*arg1,(RelinkableHandle<Quote > const &)*arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_BlackConstantVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_RelinkableHandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_BlackConstantVol__SWIG_1(nargs, args, self);
                }
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_BlackConstantVol__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_BlackConstantVol__SWIG_0(nargs, args, self);
                }
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_BlackConstantVol__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_BlackConstantVol'");
    return Qnil;
}


static void
free_BlackConstantVolHandle(BlackConstantVolHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackVarianceSurface_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackVarianceSurface_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BlackVarianceSurfaceHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackVarianceSurface(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    std::vector<Date > *arg2 = 0 ;
    std::vector<double > *arg3 = 0 ;
    Matrix *arg4 = 0 ;
    VolExtrapolationType arg5 = (VolExtrapolationType) BlackVarianceSurface::InterpolatorDefaultExtrapolation ;
    VolExtrapolationType arg6 = (VolExtrapolationType) BlackVarianceSurface::InterpolatorDefaultExtrapolation ;
    DayCounter const &arg7_defvalue = Actual365() ;
    DayCounter *arg7 = (DayCounter *) &arg7_defvalue ;
    BlackVarianceSurfaceHandle *result;
    std::vector<Date > temp2 ;
    Matrix temp4 ;
    
    if ((argc < 4) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<Date >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp2[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTdouble_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[3],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[3])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[3])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp4 = Matrix(rows,cols);
            arg4 = &temp4;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[3])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp4[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[3],(void **) &arg4,SWIGTYPE_p_Matrix,1);
        }
    }
    if (argc > 4) {
        {
            if (TYPE(argv[4]) == T_STRING) {
                std::string s(STR2CSTR(argv[4]));
                try {
                    arg5 = volExTypeFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
            }
        }
    }
    if (argc > 5) {
        {
            if (TYPE(argv[5]) == T_STRING) {
                std::string s(STR2CSTR(argv[5]));
                try {
                    arg6 = volExTypeFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
            }
        }
    }
    if (argc > 6) {
        SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_DayCounter, 1); if (arg7 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (BlackVarianceSurfaceHandle *)new_BlackVarianceSurfaceHandle((Date const &)*arg1,(std::vector<Date > const &)*arg2,(std::vector<double > const &)*arg3,(Matrix const &)*arg4,arg5,arg6,(DayCounter const &)*arg7);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BlackVarianceSurfaceHandle(BlackVarianceSurfaceHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_LocalConstantVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    double arg2 ;
    DayCounter const &arg3_defvalue = Actual365() ;
    DayCounter *arg3 = (DayCounter *) &arg3_defvalue ;
    LocalConstantVolHandle *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg2 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (LocalConstantVolHandle *)new_LocalConstantVolHandle__SWIG_0((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LocalConstantVol_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LocalConstantVol_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LocalConstantVolHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LocalConstantVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    RelinkableHandle<Quote > *arg2 = 0 ;
    DayCounter const &arg3_defvalue = Actual365() ;
    DayCounter *arg3 = (DayCounter *) &arg3_defvalue ;
    LocalConstantVolHandle *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (LocalConstantVolHandle *)new_LocalConstantVolHandle__SWIG_1((Date const &)*arg1,(RelinkableHandle<Quote > const &)*arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_LocalConstantVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_RelinkableHandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_LocalConstantVol__SWIG_1(nargs, args, self);
                }
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_LocalConstantVol__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_LocalConstantVol__SWIG_0(nargs, args, self);
                }
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_LocalConstantVol__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_LocalConstantVol'");
    return Qnil;
}


static void
free_LocalConstantVolHandle(LocalConstantVolHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_StochasticProcess___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<StochasticProcess > *arg1 = (Handle<StochasticProcess > *) 0 ;
    StochasticProcess *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTStochasticProcess_t, 1);
    {
        try {
            result = (StochasticProcess *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_StochasticProcess,0);
    return vresult;
}


static VALUE
_wrap_StochasticProcess_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<StochasticProcess > *arg1 = (Handle<StochasticProcess > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTStochasticProcess_t, 1);
    {
        try {
            result = (bool)HandlelStochasticProcess_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_StochasticProcess_allocate(VALUE self) {
#else
    static VALUE
    _wrap_StochasticProcess_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTStochasticProcess_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_StochasticProcess(int argc, VALUE *argv, VALUE self) {
    Handle<StochasticProcess > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<StochasticProcess > *)new Handle<StochasticProcess >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelStochasticProcess_g___(Handle<StochasticProcess > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackScholesStochasticProcess_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackScholesStochasticProcess_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BlackScholesStochasticProcessHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackScholesStochasticProcess(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = 0 ;
    RelinkableHandle<TermStructure > *arg2 = 0 ;
    RelinkableHandle<TermStructure > *arg3 = 0 ;
    RelinkableHandle<BlackVolTermStructure > *arg4 = 0 ;
    BlackScholesStochasticProcessHandle *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BlackScholesStochasticProcessHandle *)new_BlackScholesStochasticProcessHandle((RelinkableHandle<Quote > const &)*arg1,(RelinkableHandle<TermStructure > const &)*arg2,(RelinkableHandle<TermStructure > const &)*arg3,(RelinkableHandle<BlackVolTermStructure > const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BlackScholesStochasticProcessHandle(BlackScholesStochasticProcessHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Merton76StochasticProcess_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Merton76StochasticProcess_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Merton76StochasticProcessHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Merton76StochasticProcess(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = 0 ;
    RelinkableHandle<TermStructure > *arg2 = 0 ;
    RelinkableHandle<TermStructure > *arg3 = 0 ;
    RelinkableHandle<BlackVolTermStructure > *arg4 = 0 ;
    RelinkableHandle<Quote > *arg5 = 0 ;
    RelinkableHandle<Quote > *arg6 = 0 ;
    RelinkableHandle<Quote > *arg7 = 0 ;
    Merton76StochasticProcessHandle *result;
    
    if ((argc < 7) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg7 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (Merton76StochasticProcessHandle *)new_Merton76StochasticProcessHandle((RelinkableHandle<Quote > const &)*arg1,(RelinkableHandle<TermStructure > const &)*arg2,(RelinkableHandle<TermStructure > const &)*arg3,(RelinkableHandle<BlackVolTermStructure > const &)*arg4,(RelinkableHandle<Quote > const &)*arg5,(RelinkableHandle<Quote > const &)*arg6,(RelinkableHandle<Quote > const &)*arg7);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_Merton76StochasticProcessHandle(Merton76StochasticProcessHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_PricingEngine___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<PricingEngine > *arg1 = (Handle<PricingEngine > *) 0 ;
    PricingEngine *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTPricingEngine_t, 1);
    {
        try {
            result = (PricingEngine *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PricingEngine,0);
    return vresult;
}


static VALUE
_wrap_PricingEngine_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<PricingEngine > *arg1 = (Handle<PricingEngine > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTPricingEngine_t, 1);
    {
        try {
            result = (bool)HandlelPricingEngine_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_PricingEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_PricingEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTPricingEngine_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_PricingEngine(int argc, VALUE *argv, VALUE self) {
    Handle<PricingEngine > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<PricingEngine > *)new Handle<PricingEngine >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelPricingEngine_g___(Handle<PricingEngine > *arg1) {
    delete arg1;
}
static VALUE
_wrap_Instrument___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    Instrument *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            result = (Instrument *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Instrument,0);
    return vresult;
}


static VALUE
_wrap_Instrument_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            result = (bool)HandlelInstrument_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Instrument_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            result = HandlelInstrument_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_Instrument_NPV(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            result = (double)(*arg1)->NPV();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Instrument_isExpiredq___(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            result = (bool)(*arg1)->isExpired();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Instrument_setPricingEngine(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    Handle<PricingEngine > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTPricingEngine_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (*arg1)->setPricingEngine((Handle<PricingEngine > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Instrument_recalculateN___(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            (*arg1)->recalculate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Instrument_freezeN___(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            (*arg1)->freeze();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Instrument_unfreezeN___(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *arg1 = (Handle<Instrument > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTInstrument_t, 1);
    {
        try {
            (*arg1)->unfreeze();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Instrument_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Instrument_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTInstrument_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Instrument(int argc, VALUE *argv, VALUE self) {
    Handle<Instrument > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<Instrument > *)new Handle<Instrument >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelInstrument_g___(Handle<Instrument > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Stock_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Stock_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_StockHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Stock(int argc, VALUE *argv, VALUE self) {
    RelinkableHandle<Quote > *arg1 = 0 ;
    StockHandle *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RelinkableHandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (StockHandle *)new_StockHandle((RelinkableHandle<Quote > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_StockHandle(StockHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_Payoff___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<Payoff > *arg1 = (Handle<Payoff > *) 0 ;
    Payoff *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTPayoff_t, 1);
    {
        try {
            result = (Payoff *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Payoff,0);
    return vresult;
}


static VALUE
_wrap_Payoff_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<Payoff > *arg1 = (Handle<Payoff > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTPayoff_t, 1);
    {
        try {
            result = (bool)HandlelPayoff_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Payoff___call__(int argc, VALUE *argv, VALUE self) {
    Handle<Payoff > *arg1 = (Handle<Payoff > *) 0 ;
    double arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTPayoff_t, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (double)(*arg1)->operator ()(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Payoff_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Payoff_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTPayoff_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Payoff(int argc, VALUE *argv, VALUE self) {
    Handle<Payoff > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<Payoff > *)new Handle<Payoff >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelPayoff_g___(Handle<Payoff > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_VanillaOption_allocate(VALUE self) {
#else
    static VALUE
    _wrap_VanillaOption_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_VanillaOptionHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_VanillaOption(int argc, VALUE *argv, VALUE self) {
    Handle<StochasticProcess > *arg1 = 0 ;
    Handle<Payoff > *arg2 = 0 ;
    Handle<Exercise > *arg3 = 0 ;
    Handle<PricingEngine > const &arg4_defvalue = Handle<PricingEngine >() ;
    Handle<PricingEngine > *arg4 = (Handle<PricingEngine > *) &arg4_defvalue ;
    VanillaOptionHandle *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTStochasticProcess_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTPayoff_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTExercise_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_HandleTPricingEngine_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (VanillaOptionHandle *)new_VanillaOptionHandle((Handle<StochasticProcess > const &)*arg1,(Handle<Payoff > const &)*arg2,(Handle<Exercise > const &)*arg3,(Handle<PricingEngine > const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_VanillaOption_errorEstimate(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_errorEstimate(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_delta(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_delta(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_gamma(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_gamma(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_theta(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_theta(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_vega(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_vega(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_rho(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_rho(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_dividendRho(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_dividendRho(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_strikeSensitivity(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    {
        try {
            result = (double)VanillaOptionHandle_strikeSensitivity(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_VanillaOption_impliedVolatility(int argc, VALUE *argv, VALUE self) {
    VanillaOptionHandle *arg1 = (VanillaOptionHandle *) 0 ;
    double arg2 ;
    double arg3 = (double) 1.0e-4 ;
    Size arg4 = (Size) 100 ;
    double arg5 = (double) 1.0e-4 ;
    double arg6 = (double) 4.0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_VanillaOptionHandle, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = (double) NUM2DBL(argv[1]);
    }
    if (argc > 2) {
        {
            if (FIXNUM_P(argv[2]))
            arg4 = Size(FIX2INT(argv[2]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 3) {
        arg5 = (double) NUM2DBL(argv[3]);
    }
    if (argc > 4) {
        arg6 = (double) NUM2DBL(argv[4]);
    }
    {
        try {
            result = (double)VanillaOptionHandle_impliedVolatility(arg1,arg2,arg3,arg4,arg5,arg6);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_VanillaOptionHandle(VanillaOptionHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_AnalyticEuropeanEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_AnalyticEuropeanEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_AnalyticEuropeanEngineHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_AnalyticEuropeanEngine(int argc, VALUE *argv, VALUE self) {
    AnalyticEuropeanEngineHandle *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (AnalyticEuropeanEngineHandle *)new_AnalyticEuropeanEngineHandle();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_AnalyticEuropeanEngineHandle(AnalyticEuropeanEngineHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_IntegralEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_IntegralEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_IntegralEngineHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_IntegralEngine(int argc, VALUE *argv, VALUE self) {
    IntegralEngineHandle *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (IntegralEngineHandle *)new_IntegralEngineHandle();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_IntegralEngineHandle(IntegralEngineHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BinomialEuropeanEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BinomialEuropeanEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BinomialVanillaEngineHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BinomialEuropeanEngine(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    Size arg2 ;
    BinomialVanillaEngineHandle *result;
    std::string temp1 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Size(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = (BinomialVanillaEngineHandle *)new_BinomialVanillaEngineHandle((std::string const &)*arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BinomialVanillaEngineHandle(BinomialVanillaEngineHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MCEuropeanEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MCEuropeanEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_MCEuropeanEngineHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MCEuropeanEngine(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    Size arg2 ;
    bool arg3 = (bool) false ;
    bool arg4 = (bool) false ;
    intOrNull arg5 = (intOrNull) Null<int >() ;
    doubleOrNull arg6 = (doubleOrNull) Null<double >() ;
    intOrNull arg7 = (intOrNull) Null<int >() ;
    long arg8 = (long) 0 ;
    MCEuropeanEngineHandle *result;
    std::string temp1 ;
    char *kwnames[] = {
        "traits","timeSteps","antitheticVariate","controlVariate","requiredSamples","requiredTolerance","maxSamples","seed", NULL 
    };
    
    if ((argc < 2) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Size(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    if (argc > 2) {
        arg3 = RTEST(argv[2]);
    }
    if (argc > 3) {
        arg4 = RTEST(argv[3]);
    }
    if (argc > 4) {
        {
            if (argv[4] == Qnil)
            arg5 = Null<int>();
            else if (FIXNUM_P(argv[4]))
            arg5 = int(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 5) {
        {
            if (argv[5] == Qnil)
            arg6 = Null<double>();
            else if (TYPE(argv[5]) == T_FLOAT)
            arg6 = NUM2DBL(argv[5]);
            else if (FIXNUM_P(argv[5]))
            arg6 = double(FIX2INT(argv[5]));
            else
            SWIG_exception(SWIG_TypeError,"not a double");
        }
    }
    if (argc > 6) {
        {
            if (argv[6] == Qnil)
            arg7 = Null<int>();
            else if (FIXNUM_P(argv[6]))
            arg7 = int(FIX2INT(argv[6]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 7) {
        arg8 = NUM2LONG(argv[7]);
    }
    {
        try {
            result = (MCEuropeanEngineHandle *)new_MCEuropeanEngineHandle((std::string const &)*arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_MCEuropeanEngineHandle(MCEuropeanEngineHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BaroneAdesiWhaleyEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BaroneAdesiWhaleyEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BaroneAdesiWhaleyApproximationEngineHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BaroneAdesiWhaleyEngine(int argc, VALUE *argv, VALUE self) {
    BaroneAdesiWhaleyApproximationEngineHandle *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (BaroneAdesiWhaleyApproximationEngineHandle *)new_BaroneAdesiWhaleyApproximationEngineHandle();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BaroneAdesiWhaleyApproximationEngineHandle(BaroneAdesiWhaleyApproximationEngineHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BjerksundStenslandEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BjerksundStenslandEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BjerksundStenslandApproximationEngineHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BjerksundStenslandEngine(int argc, VALUE *argv, VALUE self) {
    BjerksundStenslandApproximationEngineHandle *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (BjerksundStenslandApproximationEngineHandle *)new_BjerksundStenslandApproximationEngineHandle();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BjerksundStenslandApproximationEngineHandle(BjerksundStenslandApproximationEngineHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_IntVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<int > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<int > *)new std::vector<int >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_IntVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    int *arg2 = 0 ;
    std::vector<int > *result;
    int temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    temp2 = (int) NUM2INT(argv[1]);
    arg2 = &temp2;
    {
        try {
            result = (std::vector<int > *)new std::vector<int >(arg1,(int const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_IntVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_IntVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTint_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_IntVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = 0 ;
    std::vector<int > *result;
    std::vector<int > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<int >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (FIXNUM_P(o))
                temp1[i] = (int)(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""int" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
        }
    }
    {
        try {
            result = (std::vector<int > *)new std::vector<int >((std::vector<int > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_IntVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_IntVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_IntVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if (FIXNUM_P(o))
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<int >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTint_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_IntVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_IntVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_IntVector'");
    return Qnil;
}


static VALUE
_wrap_IntVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    unsigned int result;
    std::vector<int > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<int >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (FIXNUM_P(o))
                temp1[i] = (int)(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""int" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<int > const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_IntVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    bool result;
    std::vector<int > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<int >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (FIXNUM_P(o))
                temp1[i] = (int)(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""int" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<int > const *)arg1)->empty();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_IntVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_IntVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_IntVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    {
        try {
            result = (int)std_vectorlint_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_IntVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (int)std_vectorlint_g___getitem_____(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_IntVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    {
        try {
            std_vectorlint_g___setitem_____(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_IntVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    {
        try {
            std_vectorlint_g_each___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlint_g___(std::vector<int > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_DoubleVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<double > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<double > *)new std::vector<double >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_DoubleVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    double *arg2 = 0 ;
    std::vector<double > *result;
    double temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    temp2 = (double) NUM2DBL(argv[1]);
    arg2 = &temp2;
    {
        try {
            result = (std::vector<double > *)new std::vector<double >(arg1,(double const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DoubleVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DoubleVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTdouble_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DoubleVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = 0 ;
    std::vector<double > *result;
    std::vector<double > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<double >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp1[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (std::vector<double > *)new std::vector<double >((std::vector<double > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_DoubleVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_DoubleVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_DoubleVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if (SWIG_FLOAT_P(o))
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<double >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTdouble_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_DoubleVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_DoubleVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_DoubleVector'");
    return Qnil;
}


static VALUE
_wrap_DoubleVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    unsigned int result;
    std::vector<double > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<double >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp1[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<double > const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DoubleVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    bool result;
    std::vector<double > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<double >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp1[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<double > const *)arg1)->empty();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_DoubleVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DoubleVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DoubleVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    {
        try {
            result = (double)std_vectorldouble_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DoubleVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (double)std_vectorldouble_g___getitem_____(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DoubleVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            std_vectorldouble_g___setitem_____(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_DoubleVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    {
        try {
            std_vectorldouble_g_each___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorldouble_g___(std::vector<double > *arg1) {
    delete arg1;
}
static void
free_HistoryEntry(HistoryEntry *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_History_allocate(VALUE self) {
#else
    static VALUE
    _wrap_History_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_History);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_History(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = 0 ;
    std::vector<double > *arg2 = 0 ;
    History *result;
    std::vector<Date > temp1 ;
    std::vector<double > temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<double >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp2[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (History *)new History((std::vector<Date > const &)*arg1,(std::vector<double > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_History_firstDate(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            result = ((History const *)arg1)->firstDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_History_lastDate(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            result = ((History const *)arg1)->lastDate();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_History___len__(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            result = History___len__(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_History___getitem__(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Date *arg2 = 0 ;
    doubleOrNull result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = History___getitem__(arg1,(Date const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        if (result == Null<double>())
        vresult = Qnil;
        else
        vresult = rb_float_new(result);
    }
    return vresult;
}


static VALUE
_wrap_History_each(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            History_each(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_History_each_valid(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            History_each_valid(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_History(History *arg1) {
    delete arg1;
}
static VALUE
_wrap_XiborManager_setHistory(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    History *arg2 = 0 ;
    std::string temp1 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_History, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            XiborManager::setHistory((std::string const &)*arg1,(History const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_XiborManager_getHistory(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    History *result;
    std::string temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            {
                History const &_result_ref = XiborManager::getHistory((std::string const &)*arg1);
                result = (History *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_History,0);
    return vresult;
}


static VALUE
_wrap_XiborManager_hasHistoryq___(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    bool result;
    std::string temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (bool)XiborManager::hasHistory((std::string const &)*arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_XiborManager(XiborManager *arg1) {
    delete arg1;
}
static VALUE
_wrap_Index___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<Index > *arg1 = (Handle<Index > *) 0 ;
    Index *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTIndex_t, 1);
    {
        try {
            result = (Index *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Index,0);
    return vresult;
}


static VALUE
_wrap_Index_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<Index > *arg1 = (Handle<Index > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTIndex_t, 1);
    {
        try {
            result = (bool)HandlelIndex_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Index___str__(int argc, VALUE *argv, VALUE self) {
    Handle<Index > *arg1 = (Handle<Index > *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTIndex_t, 1);
    {
        try {
            result = HandlelIndex_g___str_____(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Index_fixing(int argc, VALUE *argv, VALUE self) {
    Handle<Index > *arg1 = (Handle<Index > *) 0 ;
    Date *arg2 = 0 ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTIndex_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (Rate)(*arg1)->fixing((Date const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Index_name(int argc, VALUE *argv, VALUE self) {
    Handle<Index > *arg1 = (Handle<Index > *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTIndex_t, 1);
    {
        try {
            result = (*arg1)->name();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Index_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Index_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTIndex_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Index(int argc, VALUE *argv, VALUE self) {
    Handle<Index > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<Index > *)new Handle<Index >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelIndex_g___(Handle<Index > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Xibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Xibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_XiborHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Xibor(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    int arg2 ;
    TimeUnit arg3 ;
    RelinkableHandle<TermStructure > *arg4 = 0 ;
    XiborHandle *result;
    std::string temp1 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    arg2 = NUM2INT(argv[1]);
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg3 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (XiborHandle *)new_XiborHandle((std::string const &)*arg1,arg2,arg3,(RelinkableHandle<TermStructure > const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Xibor_tenor(int argc, VALUE *argv, VALUE self) {
    XiborHandle *arg1 = (XiborHandle *) 0 ;
    SwigValueWrapper< Period > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborHandle, 1);
    {
        try {
            result = XiborHandle_tenor(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Period * resultptr;
        resultptr = new Period((Period &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Period, 1);
    }
    return vresult;
}


static VALUE
_wrap_Xibor_currency(int argc, VALUE *argv, VALUE self) {
    XiborHandle *arg1 = (XiborHandle *) 0 ;
    Currency result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborHandle, 1);
    {
        try {
            result = XiborHandle_currency(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(currencyToString(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_Xibor_calendar(int argc, VALUE *argv, VALUE self) {
    XiborHandle *arg1 = (XiborHandle *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborHandle, 1);
    {
        try {
            result = XiborHandle_calendar(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_Xibor_isAdjustedq___(int argc, VALUE *argv, VALUE self) {
    XiborHandle *arg1 = (XiborHandle *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborHandle, 1);
    {
        try {
            result = (bool)XiborHandle_isAdjusted(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Xibor_rollingConvention(int argc, VALUE *argv, VALUE self) {
    XiborHandle *arg1 = (XiborHandle *) 0 ;
    RollingConvention result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborHandle, 1);
    {
        try {
            result = XiborHandle_rollingConvention(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(rollconvToString(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_Xibor_dayCounter(int argc, VALUE *argv, VALUE self) {
    XiborHandle *arg1 = (XiborHandle *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborHandle, 1);
    {
        try {
            result = XiborHandle_dayCounter(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static void
free_XiborHandle(XiborHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Schedule__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    int arg4 ;
    RollingConvention arg5 ;
    bool arg6 ;
    Date const &arg7_defvalue = Date() ;
    Date *arg7 = (Date *) &arg7_defvalue ;
    bool arg8 = (bool) false ;
    bool arg9 = (bool) false ;
    Schedule *result;
    
    if ((argc < 6) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Calendar, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[3]);
    {
        if (TYPE(argv[4]) == T_STRING) {
            std::string s(STR2CSTR(argv[4]));
            try {
                arg5 = rollconvFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
        }
    }
    arg6 = RTEST(argv[5]);
    if (argc > 6) {
        SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_Date, 1); if (arg7 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 7) {
        arg8 = RTEST(argv[7]);
    }
    if (argc > 8) {
        arg9 = RTEST(argv[8]);
    }
    {
        try {
            result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5,arg6,(Date const &)*arg7,arg8,arg9);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Schedule_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Schedule_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Schedule);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Schedule__SWIG_1(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    RollingConvention arg3 ;
    bool arg4 ;
    Schedule *result;
    std::vector<Date > temp1 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg3 = rollconvFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
        }
    }
    arg4 = RTEST(argv[3]);
    {
        try {
            result = (Schedule *)new Schedule((std::vector<Date > const &)*arg1,(Calendar const &)*arg2,arg3,arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Schedule(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[9];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 9); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 4) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Date* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_Date,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Date >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTDate_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_Schedule__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 6) && (argc <= 9)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0;
                            }
                            if (_v) {
                                if (argc <= 6) {
                                    return _wrap_new_Schedule__SWIG_0(nargs, args, self);
                                }
                                {
                                    void *ptr;
                                    _v = (NIL_P(argv[6]) || (TYPE(argv[6]) == T_DATA && SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                                }
                                if (_v) {
                                    if (argc <= 7) {
                                        return _wrap_new_Schedule__SWIG_0(nargs, args, self);
                                    }
                                    {
                                        _v = (argv[7] == Qtrue || argv[7] == Qfalse) ? 1 : 0;
                                    }
                                    if (_v) {
                                        if (argc <= 8) {
                                            return _wrap_new_Schedule__SWIG_0(nargs, args, self);
                                        }
                                        {
                                            _v = (argv[8] == Qtrue || argv[8] == Qfalse) ? 1 : 0;
                                        }
                                        if (_v) {
                                            return _wrap_new_Schedule__SWIG_0(nargs, args, self);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Schedule'");
    return Qnil;
}


static VALUE
_wrap_Schedule___len__(int argc, VALUE *argv, VALUE self) {
    Schedule *arg1 = (Schedule *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Schedule, 1);
    {
        try {
            result = ((Schedule const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Schedule_isRegularq___(int argc, VALUE *argv, VALUE self) {
    Schedule *arg1 = (Schedule *) 0 ;
    Size arg2 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Schedule, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = (bool)((Schedule const *)arg1)->isRegular(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Schedule___getitem__(int argc, VALUE *argv, VALUE self) {
    Schedule *arg1 = (Schedule *) 0 ;
    int arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Schedule, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = Schedule___getitem__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Schedule_each(int argc, VALUE *argv, VALUE self) {
    Schedule *arg1 = (Schedule *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Schedule, 1);
    {
        try {
            Schedule_each(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_Schedule(Schedule *arg1) {
    delete arg1;
}
static VALUE
_wrap_CashFlow___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<CashFlow > *arg1 = (Handle<CashFlow > *) 0 ;
    CashFlow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTCashFlow_t, 1);
    {
        try {
            result = (CashFlow *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CashFlow,0);
    return vresult;
}


static VALUE
_wrap_CashFlow_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<CashFlow > *arg1 = (Handle<CashFlow > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTCashFlow_t, 1);
    {
        try {
            result = (bool)HandlelCashFlow_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_CashFlow_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<CashFlow > *arg1 = (Handle<CashFlow > *) 0 ;
    Handle<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTCashFlow_t, 1);
    {
        try {
            result = HandlelCashFlow_g_asObservable___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Observable > * resultptr;
        resultptr = new Handle<Observable >((Handle<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_CashFlow_amount(int argc, VALUE *argv, VALUE self) {
    Handle<CashFlow > *arg1 = (Handle<CashFlow > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTCashFlow_t, 1);
    {
        try {
            result = (double)(*arg1)->amount();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CashFlow_date(int argc, VALUE *argv, VALUE self) {
    Handle<CashFlow > *arg1 = (Handle<CashFlow > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTCashFlow_t, 1);
    {
        try {
            result = (*arg1)->date();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CashFlow_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CashFlow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTCashFlow_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CashFlow(int argc, VALUE *argv, VALUE self) {
    Handle<CashFlow > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<CashFlow > *)new Handle<CashFlow >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelCashFlow_g___(Handle<CashFlow > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SimpleCashFlow_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SimpleCashFlow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SimpleCashFlowHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SimpleCashFlow(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    Date *arg2 = 0 ;
    SimpleCashFlowHandle *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (SimpleCashFlowHandle *)new_SimpleCashFlowHandle(arg1,(Date const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_SimpleCashFlowHandle(SimpleCashFlowHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FixedRateCoupon_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FixedRateCoupon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FixedRateCouponHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FixedRateCoupon(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    Date *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    Date *arg5 = 0 ;
    Date *arg6 = 0 ;
    Date const &arg7_defvalue = Date() ;
    Date *arg7 = (Date *) &arg7_defvalue ;
    Date const &arg8_defvalue = Date() ;
    Date *arg8 = (Date *) &arg8_defvalue ;
    FixedRateCouponHandle *result;
    
    if ((argc < 6) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Rate) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_Date, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_Date, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 6) {
        SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_Date, 1); if (arg7 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 7) {
        SWIG_ConvertPtr(argv[7], (void **) &arg8, SWIGTYPE_p_Date, 1); if (arg8 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (FixedRateCouponHandle *)new_FixedRateCouponHandle(arg1,(Date const &)*arg2,arg3,(DayCounter const &)*arg4,(Date const &)*arg5,(Date const &)*arg6,(Date const &)*arg7,(Date const &)*arg8);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_FixedRateCouponHandle(FixedRateCouponHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ParCoupon_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ParCoupon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ParCouponHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ParCoupon(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    Date *arg2 = 0 ;
    XiborHandle *arg3 = 0 ;
    Date *arg4 = 0 ;
    Date *arg5 = 0 ;
    int arg6 ;
    Spread arg7 = (Spread) 0.0 ;
    Date const &arg8_defvalue = Date() ;
    Date *arg8 = (Date *) &arg8_defvalue ;
    Date const &arg9_defvalue = Date() ;
    Date *arg9 = (Date *) &arg9_defvalue ;
    ParCouponHandle *result;
    
    if ((argc < 6) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_XiborHandle, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_Date, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_Date, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg6 = NUM2INT(argv[5]);
    if (argc > 6) {
        arg7 = (Spread) NUM2DBL(argv[6]);
    }
    if (argc > 7) {
        SWIG_ConvertPtr(argv[7], (void **) &arg8, SWIGTYPE_p_Date, 1); if (arg8 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 8) {
        SWIG_ConvertPtr(argv[8], (void **) &arg9, SWIGTYPE_p_Date, 1); if (arg9 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (ParCouponHandle *)new_ParCouponHandle(arg1,(Date const &)*arg2,(XiborHandle const &)*arg3,(Date const &)*arg4,(Date const &)*arg5,arg6,arg7,(Date const &)*arg8,(Date const &)*arg9);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_ParCoupon_accrualStartDate(int argc, VALUE *argv, VALUE self) {
    ParCouponHandle *arg1 = (ParCouponHandle *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ParCouponHandle, 1);
    {
        try {
            result = ParCouponHandle_accrualStartDate(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_ParCoupon_accrualEndDate(int argc, VALUE *argv, VALUE self) {
    ParCouponHandle *arg1 = (ParCouponHandle *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ParCouponHandle, 1);
    {
        try {
            result = ParCouponHandle_accrualEndDate(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_ParCoupon_fixing(int argc, VALUE *argv, VALUE self) {
    ParCouponHandle *arg1 = (ParCouponHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ParCouponHandle, 1);
    {
        try {
            result = (double)ParCouponHandle_fixing(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_ParCoupon_nominal(int argc, VALUE *argv, VALUE self) {
    ParCouponHandle *arg1 = (ParCouponHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ParCouponHandle, 1);
    {
        try {
            result = (double)ParCouponHandle_nominal(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_ParCoupon_amount(int argc, VALUE *argv, VALUE self) {
    ParCouponHandle *arg1 = (ParCouponHandle *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ParCouponHandle, 1);
    {
        try {
            result = (double)ParCouponHandle_amount(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_ParCouponHandle(ParCouponHandle *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_CashFlowVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<Handle<CashFlow > > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<Handle<CashFlow > > *)new std::vector<Handle<CashFlow > >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_CashFlowVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    Handle<CashFlow > *arg2 = 0 ;
    std::vector<Handle<CashFlow > > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTCashFlow_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<Handle<CashFlow > > *)new std::vector<Handle<CashFlow > >(arg1,(Handle<CashFlow > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CashFlowVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CashFlowVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CashFlowVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = 0 ;
    std::vector<Handle<CashFlow > > *result;
    std::vector<Handle<CashFlow > > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Handle<CashFlow > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Handle<CashFlow >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTCashFlow_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
        }
    }
    {
        try {
            result = (std::vector<Handle<CashFlow > > *)new std::vector<Handle<CashFlow > >((std::vector<Handle<CashFlow > > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_CashFlowVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_CashFlowVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CashFlowVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Handle<CashFlow >* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_HandleTCashFlow_t,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Handle<CashFlow > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_CashFlowVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_HandleTCashFlow_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_CashFlowVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_CashFlowVector'");
    return Qnil;
}


static VALUE
_wrap_CashFlowVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    unsigned int result;
    std::vector<Handle<CashFlow > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Handle<CashFlow > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Handle<CashFlow >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTCashFlow_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Handle<CashFlow > > const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_CashFlowVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    bool result;
    std::vector<Handle<CashFlow > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Handle<CashFlow > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Handle<CashFlow >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTCashFlow_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<Handle<CashFlow > > const *)arg1)->empty();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_CashFlowVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_CashFlowVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    Handle<CashFlow > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTCashFlow_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((Handle<CashFlow > const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_CashFlowVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    Handle<CashFlow > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
    {
        try {
            result = std_vectorlHandlelCashFlow_g_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        Handle<CashFlow > * resultptr;
        resultptr = new Handle<CashFlow >((Handle<CashFlow > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTCashFlow_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_CashFlowVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    int arg2 ;
    Handle<CashFlow > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Handle<CashFlow > &_result_ref = std_vectorlHandlelCashFlow_g_g___getitem_____(arg1,arg2);
                result = (Handle<CashFlow > *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_HandleTCashFlow_t,0);
    return vresult;
}


static VALUE
_wrap_CashFlowVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    int arg2 ;
    Handle<CashFlow > *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_HandleTCashFlow_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlHandlelCashFlow_g_g___setitem_____(arg1,arg2,(Handle<CashFlow > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_CashFlowVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = (std::vector<Handle<CashFlow > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
    {
        try {
            std_vectorlHandlelCashFlow_g_g_each___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlHandlelCashFlow_g_g___(std::vector<Handle<CashFlow > > *arg1) {
    delete arg1;
}
static VALUE
_wrap_FixedRateCouponVector(int argc, VALUE *argv, VALUE self) {
    Schedule *arg1 = 0 ;
    std::vector<double > *arg2 = 0 ;
    std::vector<Rate > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    DayCounter const &arg5_defvalue = DayCounter() ;
    DayCounter *arg5 = (DayCounter *) &arg5_defvalue ;
    std::vector<Handle<CashFlow > > result;
    std::vector<double > temp2 ;
    std::vector<double > temp3 ;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Schedule, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<double >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp2[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = std::vector<double >(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp3[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_DayCounter, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = FixedRateCouponVector((Schedule const &)*arg1,(std::vector<double > const &)*arg2,(std::vector<Rate > const &)*arg3,(DayCounter const &)*arg4,(DayCounter const &)*arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_ary_new2((&result)->size());
        for (unsigned int i=0; i<(&result)->size(); i++) {
            Handle<CashFlow >* x = new Handle<CashFlow >(((std::vector<Handle<CashFlow > > &)result)[i]);
            rb_ary_store(vresult,i,
            SWIG_NewPointerObj((void *) x, 
            SWIGTYPE_p_HandleTCashFlow_t, 1));
        }
    }
    return vresult;
}


static VALUE
_wrap_FloatingRateCouponVector(int argc, VALUE *argv, VALUE self) {
    Schedule *arg1 = 0 ;
    std::vector<double > *arg2 = 0 ;
    XiborHandle *arg3 = 0 ;
    int arg4 ;
    std::vector<Spread > const &arg5_defvalue = std::vector<Spread >() ;
    std::vector<Spread > *arg5 = (std::vector<Spread > *) &arg5_defvalue ;
    std::vector<Handle<CashFlow > > result;
    std::vector<double > temp2 ;
    std::vector<double > temp5 ;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Schedule, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<double >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp2[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_XiborHandle, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[3]);
    if (argc > 4) {
        {
            if (rb_obj_is_kind_of(argv[4],rb_cArray)) {
                unsigned int size = RARRAY(argv[4])->len;
                temp5 = std::vector<double >(size);
                arg5 = &temp5;
                for (unsigned int i=0; i<size; i++) {
                    VALUE o = RARRAY(argv[4])->ptr[i];
                    if (SWIG_FLOAT_P(o))
                    temp5[i] = (double)(SWIG_NUM2DBL(o));
                    else
                    rb_raise(rb_eTypeError,
                    "wrong argument type"
                    " (expected vector<""double" ">)");
                }
            } else {
                SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_std__vectorTdouble_t, 1);
            }
        }
    }
    {
        try {
            result = FloatingRateCouponVector((Schedule const &)*arg1,(std::vector<double > const &)*arg2,(XiborHandle const &)*arg3,arg4,(std::vector<Spread > const &)*arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_ary_new2((&result)->size());
        for (unsigned int i=0; i<(&result)->size(); i++) {
            Handle<CashFlow >* x = new Handle<CashFlow >(((std::vector<Handle<CashFlow > > &)result)[i]);
            rb_ary_store(vresult,i,
            SWIG_NewPointerObj((void *) x, 
            SWIGTYPE_p_HandleTCashFlow_t, 1));
        }
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Cap_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Cap_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CapHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Cap(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = 0 ;
    std::vector<double > *arg2 = 0 ;
    RelinkableHandle<TermStructure > *arg3 = 0 ;
    Handle<PricingEngine > *arg4 = 0 ;
    CapHandle *result;
    std::vector<Handle<CashFlow > > temp1 ;
    std::vector<double > temp2 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Handle<CashFlow > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Handle<CashFlow >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTCashFlow_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<double >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp2[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_HandleTPricingEngine_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (CapHandle *)new_CapHandle((std::vector<Handle<CashFlow > > const &)*arg1,(std::vector<double > const &)*arg2,(RelinkableHandle<TermStructure > const &)*arg3,(Handle<PricingEngine > const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_CapHandle(CapHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Floor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Floor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FloorHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Floor(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = 0 ;
    std::vector<double > *arg2 = 0 ;
    RelinkableHandle<TermStructure > *arg3 = 0 ;
    Handle<PricingEngine > *arg4 = 0 ;
    FloorHandle *result;
    std::vector<Handle<CashFlow > > temp1 ;
    std::vector<double > temp2 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Handle<CashFlow > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Handle<CashFlow >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTCashFlow_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<double >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp2[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_HandleTPricingEngine_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (FloorHandle *)new_FloorHandle((std::vector<Handle<CashFlow > > const &)*arg1,(std::vector<double > const &)*arg2,(RelinkableHandle<TermStructure > const &)*arg3,(Handle<PricingEngine > const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_FloorHandle(FloorHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Collar_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Collar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CollarHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Collar(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<CashFlow > > *arg1 = 0 ;
    std::vector<double > *arg2 = 0 ;
    std::vector<double > *arg3 = 0 ;
    RelinkableHandle<TermStructure > *arg4 = 0 ;
    Handle<PricingEngine > *arg5 = 0 ;
    CollarHandle *result;
    std::vector<Handle<CashFlow > > temp1 ;
    std::vector<double > temp2 ;
    std::vector<double > temp3 ;
    
    if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Handle<CashFlow > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Handle<CashFlow >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTCashFlow_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTCashFlow_t_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<double >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp2[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = std::vector<double >(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp3[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_RelinkableHandleTTermStructure_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_HandleTPricingEngine_t, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (CollarHandle *)new_CollarHandle((std::vector<Handle<CashFlow > > const &)*arg1,(std::vector<double > const &)*arg2,(std::vector<double > const &)*arg3,(RelinkableHandle<TermStructure > const &)*arg4,(Handle<PricingEngine > const &)*arg5);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_CollarHandle(CollarHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackCapFloorEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackCapFloorEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BlackCapFloorEngineHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackCapFloorEngine(int argc, VALUE *argv, VALUE self) {
    Handle<BlackModel > *arg1 = 0 ;
    BlackCapFloorEngineHandle *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTBlackModel_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BlackCapFloorEngineHandle *)new_BlackCapFloorEngineHandle((Handle<BlackModel > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BlackCapFloorEngineHandle(BlackCapFloorEngineHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CompoundForward_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CompoundForward_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CompoundForwardHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CompoundForward(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    std::vector<Date > *arg3 = 0 ;
    std::vector<double > *arg4 = 0 ;
    SwigValueWrapper< Calendar > arg5 ;
    RollingConvention arg6 ;
    int arg7 ;
    DayCounter const &arg8_defvalue = Actual365() ;
    DayCounter *arg8 = (DayCounter *) &arg8_defvalue ;
    CompoundForwardHandle *result;
    std::vector<Date > temp3 ;
    std::vector<double > temp4 ;
    
    if ((argc < 7) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = std::vector<Date >(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp3[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[3],rb_cArray)) {
            unsigned int size = RARRAY(argv[3])->len;
            temp4 = std::vector<double >(size);
            arg4 = &temp4;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[3])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp4[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        Calendar * ptr;
        SWIG_ConvertPtr(argv[4], (void **) &ptr, SWIGTYPE_p_Calendar, 1);
        if (ptr) arg5 = *ptr;
    }
    {
        if (TYPE(argv[5]) == T_STRING) {
            std::string s(STR2CSTR(argv[5]));
            try {
                arg6 = rollconvFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
        }
    }
    arg7 = NUM2INT(argv[6]);
    if (argc > 7) {
        SWIG_ConvertPtr(argv[7], (void **) &arg8, SWIGTYPE_p_DayCounter, 1); if (arg8 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (CompoundForwardHandle *)new_CompoundForwardHandle((Date const &)*arg1,(Date const &)*arg2,(std::vector<Date > const &)*arg3,(std::vector<double > const &)*arg4,arg5,arg6,arg7,(DayCounter const &)*arg8);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_CompoundForward_dates(int argc, VALUE *argv, VALUE self) {
    CompoundForwardHandle *arg1 = (CompoundForwardHandle *) 0 ;
    std::vector<Date > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CompoundForwardHandle, 1);
    {
        try {
            {
                std::vector<Date > const &_result_ref = CompoundForwardHandle_dates(arg1);
                result = (std::vector<Date > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_std__vectorTDate_t,0);
    return vresult;
}


static void
free_CompoundForwardHandle(CompoundForwardHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DiscountCurve_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DiscountCurve_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DiscountCurveHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DiscountCurve(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    std::vector<Date > *arg2 = 0 ;
    std::vector<double > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = Actual365() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    DiscountCurveHandle *result;
    std::vector<Date > temp2 ;
    std::vector<double > temp3 ;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<Date >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp2[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = std::vector<double >(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp3[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (DiscountCurveHandle *)new_DiscountCurveHandle((Date const &)*arg1,(std::vector<Date > const &)*arg2,(std::vector<double > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_DiscountCurve_dates(int argc, VALUE *argv, VALUE self) {
    DiscountCurveHandle *arg1 = (DiscountCurveHandle *) 0 ;
    std::vector<Date > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DiscountCurveHandle, 1);
    {
        try {
            {
                std::vector<Date > const &_result_ref = DiscountCurveHandle_dates(arg1);
                result = (std::vector<Date > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_std__vectorTDate_t,0);
    return vresult;
}


static void
free_DiscountCurveHandle(DiscountCurveHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ExtendedDiscountCurve_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ExtendedDiscountCurve_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ExtendedDiscountCurveHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ExtendedDiscountCurve(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    std::vector<Date > *arg2 = 0 ;
    std::vector<double > *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    RollingConvention arg5 ;
    DayCounter const &arg6_defvalue = Actual365() ;
    DayCounter *arg6 = (DayCounter *) &arg6_defvalue ;
    ExtendedDiscountCurveHandle *result;
    std::vector<Date > temp2 ;
    std::vector<double > temp3 ;
    
    if ((argc < 5) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<Date >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp2[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = std::vector<double >(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp3[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_Calendar, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[4]) == T_STRING) {
            std::string s(STR2CSTR(argv[4]));
            try {
                arg5 = rollconvFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "RollingConvention");
        }
    }
    if (argc > 5) {
        SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_DayCounter, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (ExtendedDiscountCurveHandle *)new_ExtendedDiscountCurveHandle((Date const &)*arg1,(std::vector<Date > const &)*arg2,(std::vector<double > const &)*arg3,(Calendar const &)*arg4,arg5,(DayCounter const &)*arg6);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ExtendedDiscountCurveHandle(ExtendedDiscountCurveHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_NormalDistribution_allocate(VALUE self) {
#else
    static VALUE
    _wrap_NormalDistribution_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_NormalDistribution);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_NormalDistribution(int argc, VALUE *argv, VALUE self) {
    double arg1 = (double) 0.0 ;
    double arg2 = (double) 1.0 ;
    NormalDistribution *result;
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (double) NUM2DBL(argv[0]);
    }
    if (argc > 1) {
        arg2 = (double) NUM2DBL(argv[1]);
    }
    {
        try {
            result = (NormalDistribution *)new NormalDistribution(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_NormalDistribution___call__(int argc, VALUE *argv, VALUE self) {
    NormalDistribution *arg1 = (NormalDistribution *) 0 ;
    double arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_NormalDistribution, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (double)(arg1)->operator ()(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_NormalDistribution_derivative(int argc, VALUE *argv, VALUE self) {
    NormalDistribution *arg1 = (NormalDistribution *) 0 ;
    double arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_NormalDistribution, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (double)(arg1)->derivative(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_NormalDistribution(NormalDistribution *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CumulativeNormalDistribution_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CumulativeNormalDistribution_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CumulativeNormalDistribution);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CumulativeNormalDistribution(int argc, VALUE *argv, VALUE self) {
    double arg1 = (double) 0.0 ;
    double arg2 = (double) 1.0 ;
    CumulativeNormalDistribution *result;
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (double) NUM2DBL(argv[0]);
    }
    if (argc > 1) {
        arg2 = (double) NUM2DBL(argv[1]);
    }
    {
        try {
            result = (CumulativeNormalDistribution *)new CumulativeNormalDistribution(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_CumulativeNormalDistribution___call__(int argc, VALUE *argv, VALUE self) {
    CumulativeNormalDistribution *arg1 = (CumulativeNormalDistribution *) 0 ;
    double arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CumulativeNormalDistribution, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (double)(arg1)->operator ()(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CumulativeNormalDistribution_derivative(int argc, VALUE *argv, VALUE self) {
    CumulativeNormalDistribution *arg1 = (CumulativeNormalDistribution *) 0 ;
    double arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CumulativeNormalDistribution, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (double)(arg1)->derivative(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_CumulativeNormalDistribution(CumulativeNormalDistribution *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InverseCumulativeNormal_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InverseCumulativeNormal_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_InverseCumulativeNormal);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InverseCumulativeNormal(int argc, VALUE *argv, VALUE self) {
    double arg1 = (double) 0.0 ;
    double arg2 = (double) 1.0 ;
    InverseCumulativeNormal *result;
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (double) NUM2DBL(argv[0]);
    }
    if (argc > 1) {
        arg2 = (double) NUM2DBL(argv[1]);
    }
    {
        try {
            result = (InverseCumulativeNormal *)new InverseCumulativeNormal(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_InverseCumulativeNormal___call__(int argc, VALUE *argv, VALUE self) {
    InverseCumulativeNormal *arg1 = (InverseCumulativeNormal *) 0 ;
    double arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InverseCumulativeNormal, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (double)(arg1)->operator ()(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_InverseCumulativeNormal(InverseCumulativeNormal *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInverseCumulativeNormal_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInverseCumulativeNormal_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_MoroInverseCumulativeNormal);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInverseCumulativeNormal(int argc, VALUE *argv, VALUE self) {
    double arg1 = (double) 0.0 ;
    double arg2 = (double) 1.0 ;
    MoroInverseCumulativeNormal *result;
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (double) NUM2DBL(argv[0]);
    }
    if (argc > 1) {
        arg2 = (double) NUM2DBL(argv[1]);
    }
    {
        try {
            result = (MoroInverseCumulativeNormal *)new MoroInverseCumulativeNormal(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MoroInverseCumulativeNormal___call__(int argc, VALUE *argv, VALUE self) {
    MoroInverseCumulativeNormal *arg1 = (MoroInverseCumulativeNormal *) 0 ;
    double arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MoroInverseCumulativeNormal, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (double)(arg1)->operator ()(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_MoroInverseCumulativeNormal(MoroInverseCumulativeNormal *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SegmentIntegral_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SegmentIntegral_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SegmentIntegral);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SegmentIntegral(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    SegmentIntegral *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = (SegmentIntegral *)new SegmentIntegral(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_SegmentIntegral___call__(int argc, VALUE *argv, VALUE self) {
    SegmentIntegral *arg1 = (SegmentIntegral *) 0 ;
    double arg2 ;
    double arg3 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SegmentIntegral, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (double)SegmentIntegral___call__(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SegmentIntegral(SegmentIntegral *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TrapezoidIntegral_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TrapezoidIntegral_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_TrapezoidIntegral);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TrapezoidIntegral(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    TrapezoidIntegral *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (TrapezoidIntegral *)new TrapezoidIntegral(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_TrapezoidIntegral___call__(int argc, VALUE *argv, VALUE self) {
    TrapezoidIntegral *arg1 = (TrapezoidIntegral *) 0 ;
    double arg2 ;
    double arg3 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TrapezoidIntegral, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (double)TrapezoidIntegral___call__(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_TrapezoidIntegral(TrapezoidIntegral *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SimpsonIntegral_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SimpsonIntegral_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SimpsonIntegral);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SimpsonIntegral(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    SimpsonIntegral *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (SimpsonIntegral *)new SimpsonIntegral(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_SimpsonIntegral___call__(int argc, VALUE *argv, VALUE self) {
    SimpsonIntegral *arg1 = (SimpsonIntegral *) 0 ;
    double arg2 ;
    double arg3 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SimpsonIntegral, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (double)SimpsonIntegral___call__(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SimpsonIntegral(SimpsonIntegral *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_KronrodIntegral_allocate(VALUE self) {
#else
    static VALUE
    _wrap_KronrodIntegral_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_KronrodIntegral);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_KronrodIntegral(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    KronrodIntegral *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = (KronrodIntegral *)new KronrodIntegral(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_KronrodIntegral___call__(int argc, VALUE *argv, VALUE self) {
    KronrodIntegral *arg1 = (KronrodIntegral *) 0 ;
    double arg2 ;
    double arg3 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_KronrodIntegral, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (double)KronrodIntegral___call__(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_KronrodIntegral(KronrodIntegral *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LinearInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LinearInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeLinearInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LinearInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeLinearInterpolation *)new SafeLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LinearInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeLinearInterpolation, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)(arg1)->operator ()(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeLinearInterpolation(SafeLinearInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CubicSpline_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CubicSpline_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeNaturalCubicSpline);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CubicSpline(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalCubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeNaturalCubicSpline *)new SafeNaturalCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_CubicSpline___call__(int argc, VALUE *argv, VALUE self) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalCubicSpline, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)(arg1)->operator ()(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CubicSpline_derivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalCubicSpline, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)SafeNaturalCubicSpline_derivative(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CubicSpline_secondDerivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalCubicSpline, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)SafeNaturalCubicSpline_secondDerivative(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeNaturalCubicSpline(SafeNaturalCubicSpline *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MonotonicCubicSpline_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MonotonicCubicSpline_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MonotonicCubicSpline(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalMonotonicCubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeNaturalMonotonicCubicSpline *)new SafeNaturalMonotonicCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MonotonicCubicSpline___call__(int argc, VALUE *argv, VALUE self) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)(arg1)->operator ()(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_MonotonicCubicSpline_derivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)SafeNaturalMonotonicCubicSpline_derivative(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_MonotonicCubicSpline_secondDerivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)SafeNaturalMonotonicCubicSpline_secondDerivative(arg1,arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeNaturalMonotonicCubicSpline(SafeNaturalMonotonicCubicSpline *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LogLinearInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LogLinearInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeLogLinearInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LogLinearInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLogLinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeLogLinearInterpolation *)new SafeLogLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LogLinearInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    double arg2 ;
    bool arg3 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeLogLinearInterpolation, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (double)(arg1)->operator ()(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeLogLinearInterpolation(SafeLogLinearInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BilinearInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BilinearInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeBilinearInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BilinearInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBilinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    Matrix temp3 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[2])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[2])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp3 = Matrix(rows,cols);
            arg3 = &temp3;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp3[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[2],(void **) &arg3,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (SafeBilinearInterpolation *)new SafeBilinearInterpolation((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_BilinearInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    double arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeBilinearInterpolation, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeBilinearInterpolation(SafeBilinearInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BicubicSpline_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BicubicSpline_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeBicubicSpline);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BicubicSpline(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBicubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    Matrix temp3 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[2])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[2])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp3 = Matrix(rows,cols);
            arg3 = &temp3;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp3[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[2],(void **) &arg3,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (SafeBicubicSpline *)new SafeBicubicSpline((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_BicubicSpline___call__(int argc, VALUE *argv, VALUE self) {
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    double arg2 ;
    double arg3 ;
    bool arg4 = (bool) false ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeBicubicSpline, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (double)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeBicubicSpline(SafeBicubicSpline *arg1) {
    delete arg1;
}
static VALUE
_wrap_SampleNumber_value(int argc, VALUE *argv, VALUE self) {
    Sample<double > *arg1 = (Sample<double > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTdouble_t, 1);
    {
        try {
            result = (double)Sampleldouble_g_value___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_SampleNumber_weight(int argc, VALUE *argv, VALUE self) {
    Sample<double > *arg1 = (Sample<double > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTdouble_t, 1);
    {
        try {
            result = (double)Sampleldouble_g_weight___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_Sampleldouble_g___(Sample<double > *arg1) {
    delete arg1;
}
static VALUE
_wrap_SampleArray_value(int argc, VALUE *argv, VALUE self) {
    Sample<Array > *arg1 = (Sample<Array > *) 0 ;
    Array result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTArray_t, 1);
    {
        try {
            result = SamplelArray_g_value___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_SampleArray_weight(int argc, VALUE *argv, VALUE self) {
    Sample<Array > *arg1 = (Sample<Array > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTArray_t, 1);
    {
        try {
            result = (double)SamplelArray_g_weight___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SamplelArray_g___(Sample<Array > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LecuyerUniformRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LecuyerUniformRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LecuyerUniformRng);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LecuyerUniformRng(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    LecuyerUniformRng *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (LecuyerUniformRng *)new LecuyerUniformRng(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LecuyerUniformRng_next(int argc, VALUE *argv, VALUE self) {
    LecuyerUniformRng *arg1 = (LecuyerUniformRng *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LecuyerUniformRng, 1);
    {
        try {
            result = ((LecuyerUniformRng const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_LecuyerUniformRng(LecuyerUniformRng *arg1) {
    delete arg1;
}
static void
free_KnuthUniformRng(KnuthUniformRng *arg1) {
    delete arg1;
}
static void
free_MersenneTwisterUniformRng(MersenneTwisterUniformRng *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_UniformRandomGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_UniformRandomGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_UniformRandomGenerator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_UniformRandomGenerator(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    UniformRandomGenerator *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (UniformRandomGenerator *)new UniformRandomGenerator(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_UniformRandomGenerator_next(int argc, VALUE *argv, VALUE self) {
    UniformRandomGenerator *arg1 = (UniformRandomGenerator *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_UniformRandomGenerator, 1);
    {
        try {
            result = ((UniformRandomGenerator const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_UniformRandomGenerator(UniformRandomGenerator *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_CentralLimitLecuyerGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    LecuyerUniformRng *arg1 = 0 ;
    CLGaussianRng<LecuyerUniformRng > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_LecuyerUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (CLGaussianRng<LecuyerUniformRng > *)new CLGaussianRng<LecuyerUniformRng >((LecuyerUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CentralLimitLecuyerGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CentralLimitLecuyerGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CLGaussianRngTLecuyerUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CentralLimitLecuyerGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    CLGaussianRng<LecuyerUniformRng > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (CLGaussianRng<LecuyerUniformRng > *)new CLGaussianRng<LecuyerUniformRng >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_CentralLimitLecuyerGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_CentralLimitLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CentralLimitLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_LecuyerUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CentralLimitLecuyerGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_CentralLimitLecuyerGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_CentralLimitLecuyerGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    CLGaussianRng<LecuyerUniformRng > *arg1 = (CLGaussianRng<LecuyerUniformRng > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CLGaussianRngTLecuyerUniformRng_t, 1);
    {
        try {
            result = ((CLGaussianRng<LecuyerUniformRng > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_CLGaussianRnglLecuyerUniformRng_g___(CLGaussianRng<LecuyerUniformRng > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_CentralLimitKnuthGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    KnuthUniformRng *arg1 = 0 ;
    CLGaussianRng<KnuthUniformRng > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_KnuthUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (CLGaussianRng<KnuthUniformRng > *)new CLGaussianRng<KnuthUniformRng >((KnuthUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CentralLimitKnuthGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CentralLimitKnuthGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CLGaussianRngTKnuthUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CentralLimitKnuthGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    CLGaussianRng<KnuthUniformRng > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (CLGaussianRng<KnuthUniformRng > *)new CLGaussianRng<KnuthUniformRng >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_CentralLimitKnuthGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_CentralLimitKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CentralLimitKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_KnuthUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CentralLimitKnuthGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_CentralLimitKnuthGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_CentralLimitKnuthGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    CLGaussianRng<KnuthUniformRng > *arg1 = (CLGaussianRng<KnuthUniformRng > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CLGaussianRngTKnuthUniformRng_t, 1);
    {
        try {
            result = ((CLGaussianRng<KnuthUniformRng > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_CLGaussianRnglKnuthUniformRng_g___(CLGaussianRng<KnuthUniformRng > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_CentralLimitMersenneTwisterGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    MersenneTwisterUniformRng *arg1 = 0 ;
    CLGaussianRng<MersenneTwisterUniformRng > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_MersenneTwisterUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (CLGaussianRng<MersenneTwisterUniformRng > *)new CLGaussianRng<MersenneTwisterUniformRng >((MersenneTwisterUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CentralLimitMersenneTwisterGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CentralLimitMersenneTwisterGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CLGaussianRngTMersenneTwisterUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CentralLimitMersenneTwisterGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    CLGaussianRng<MersenneTwisterUniformRng > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (CLGaussianRng<MersenneTwisterUniformRng > *)new CLGaussianRng<MersenneTwisterUniformRng >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_CentralLimitMersenneTwisterGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_CentralLimitMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CentralLimitMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_MersenneTwisterUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CentralLimitMersenneTwisterGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_CentralLimitMersenneTwisterGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_CentralLimitMersenneTwisterGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    CLGaussianRng<MersenneTwisterUniformRng > *arg1 = (CLGaussianRng<MersenneTwisterUniformRng > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CLGaussianRngTMersenneTwisterUniformRng_t, 1);
    {
        try {
            result = ((CLGaussianRng<MersenneTwisterUniformRng > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_CLGaussianRnglMersenneTwisterUniformRng_g___(CLGaussianRng<MersenneTwisterUniformRng > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_BoxMullerLecuyerGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    LecuyerUniformRng *arg1 = 0 ;
    BoxMullerGaussianRng<LecuyerUniformRng > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_LecuyerUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BoxMullerGaussianRng<LecuyerUniformRng > *)new BoxMullerGaussianRng<LecuyerUniformRng >((LecuyerUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BoxMullerLecuyerGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BoxMullerLecuyerGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BoxMullerGaussianRngTLecuyerUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BoxMullerLecuyerGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    BoxMullerGaussianRng<LecuyerUniformRng > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (BoxMullerGaussianRng<LecuyerUniformRng > *)new BoxMullerGaussianRng<LecuyerUniformRng >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_BoxMullerLecuyerGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_BoxMullerLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_BoxMullerLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_LecuyerUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_BoxMullerLecuyerGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_BoxMullerLecuyerGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_BoxMullerLecuyerGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    BoxMullerGaussianRng<LecuyerUniformRng > *arg1 = (BoxMullerGaussianRng<LecuyerUniformRng > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BoxMullerGaussianRngTLecuyerUniformRng_t, 1);
    {
        try {
            result = ((BoxMullerGaussianRng<LecuyerUniformRng > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_BoxMullerGaussianRnglLecuyerUniformRng_g___(BoxMullerGaussianRng<LecuyerUniformRng > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_BoxMullerKnuthGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    KnuthUniformRng *arg1 = 0 ;
    BoxMullerGaussianRng<KnuthUniformRng > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_KnuthUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BoxMullerGaussianRng<KnuthUniformRng > *)new BoxMullerGaussianRng<KnuthUniformRng >((KnuthUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BoxMullerKnuthGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BoxMullerKnuthGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BoxMullerGaussianRngTKnuthUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BoxMullerKnuthGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    BoxMullerGaussianRng<KnuthUniformRng > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (BoxMullerGaussianRng<KnuthUniformRng > *)new BoxMullerGaussianRng<KnuthUniformRng >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_BoxMullerKnuthGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_BoxMullerKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_BoxMullerKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_KnuthUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_BoxMullerKnuthGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_BoxMullerKnuthGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_BoxMullerKnuthGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    BoxMullerGaussianRng<KnuthUniformRng > *arg1 = (BoxMullerGaussianRng<KnuthUniformRng > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BoxMullerGaussianRngTKnuthUniformRng_t, 1);
    {
        try {
            result = ((BoxMullerGaussianRng<KnuthUniformRng > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_BoxMullerGaussianRnglKnuthUniformRng_g___(BoxMullerGaussianRng<KnuthUniformRng > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_BoxMullerMersenneTwisterGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    MersenneTwisterUniformRng *arg1 = 0 ;
    BoxMullerGaussianRng<MersenneTwisterUniformRng > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_MersenneTwisterUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BoxMullerGaussianRng<MersenneTwisterUniformRng > *)new BoxMullerGaussianRng<MersenneTwisterUniformRng >((MersenneTwisterUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BoxMullerMersenneTwisterGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BoxMullerMersenneTwisterGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BoxMullerGaussianRngTMersenneTwisterUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BoxMullerMersenneTwisterGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    BoxMullerGaussianRng<MersenneTwisterUniformRng > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (BoxMullerGaussianRng<MersenneTwisterUniformRng > *)new BoxMullerGaussianRng<MersenneTwisterUniformRng >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_BoxMullerMersenneTwisterGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_BoxMullerMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_BoxMullerMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_MersenneTwisterUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_BoxMullerMersenneTwisterGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_BoxMullerMersenneTwisterGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_BoxMullerMersenneTwisterGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    BoxMullerGaussianRng<MersenneTwisterUniformRng > *arg1 = (BoxMullerGaussianRng<MersenneTwisterUniformRng > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BoxMullerGaussianRngTMersenneTwisterUniformRng_t, 1);
    {
        try {
            result = ((BoxMullerGaussianRng<MersenneTwisterUniformRng > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_BoxMullerGaussianRnglMersenneTwisterUniformRng_g___(BoxMullerGaussianRng<MersenneTwisterUniformRng > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_MoroInvCumulativeLecuyerGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    LecuyerUniformRng *arg1 = 0 ;
    ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_LecuyerUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *)new ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal >((LecuyerUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInvCumulativeLecuyerGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInvCumulativeLecuyerGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInvCumulativeLecuyerGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *)new ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_MoroInvCumulativeLecuyerGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_MoroInvCumulativeLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_MoroInvCumulativeLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_LecuyerUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_MoroInvCumulativeLecuyerGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_MoroInvCumulativeLecuyerGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_MoroInvCumulativeLecuyerGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_ICGaussianRnglLecuyerUniformRngcMoroInverseCumulativeNormal_g___(ICGaussianRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_MoroInvCumulativeKnuthGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    KnuthUniformRng *arg1 = 0 ;
    ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_KnuthUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *)new ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal >((KnuthUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInvCumulativeKnuthGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInvCumulativeKnuthGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRngTKnuthUniformRng_MoroInverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInvCumulativeKnuthGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *)new ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_MoroInvCumulativeKnuthGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_MoroInvCumulativeKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_MoroInvCumulativeKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_KnuthUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_MoroInvCumulativeKnuthGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_MoroInvCumulativeKnuthGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_MoroInvCumulativeKnuthGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRngTKnuthUniformRng_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_ICGaussianRnglKnuthUniformRngcMoroInverseCumulativeNormal_g___(ICGaussianRng<KnuthUniformRng,MoroInverseCumulativeNormal > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_MoroInvCumulativeMersenneTwisterGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    MersenneTwisterUniformRng *arg1 = 0 ;
    ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_MersenneTwisterUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *)new ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal >((MersenneTwisterUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInvCumulativeMersenneTwisterGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInvCumulativeMersenneTwisterGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInvCumulativeMersenneTwisterGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *)new ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_MoroInvCumulativeMersenneTwisterGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_MoroInvCumulativeMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_MoroInvCumulativeMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_MersenneTwisterUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_MoroInvCumulativeMersenneTwisterGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_MoroInvCumulativeMersenneTwisterGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_MoroInvCumulativeMersenneTwisterGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_ICGaussianRnglMersenneTwisterUniformRngcMoroInverseCumulativeNormal_g___(ICGaussianRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_InvCumulativeLecuyerGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    LecuyerUniformRng *arg1 = 0 ;
    ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_LecuyerUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *)new ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal >((LecuyerUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InvCumulativeLecuyerGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InvCumulativeLecuyerGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRngTLecuyerUniformRng_InverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InvCumulativeLecuyerGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *)new ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_InvCumulativeLecuyerGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_InvCumulativeLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_InvCumulativeLecuyerGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_LecuyerUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_InvCumulativeLecuyerGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_InvCumulativeLecuyerGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_InvCumulativeLecuyerGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *arg1 = (ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRngTLecuyerUniformRng_InverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_ICGaussianRnglLecuyerUniformRngcInverseCumulativeNormal_g___(ICGaussianRng<LecuyerUniformRng,InverseCumulativeNormal > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_InvCumulativeKnuthGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    KnuthUniformRng *arg1 = 0 ;
    ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_KnuthUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *)new ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal >((KnuthUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InvCumulativeKnuthGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InvCumulativeKnuthGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRngTKnuthUniformRng_InverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InvCumulativeKnuthGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *)new ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_InvCumulativeKnuthGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_InvCumulativeKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_InvCumulativeKnuthGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_KnuthUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_InvCumulativeKnuthGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_InvCumulativeKnuthGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_InvCumulativeKnuthGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *arg1 = (ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRngTKnuthUniformRng_InverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_ICGaussianRnglKnuthUniformRngcInverseCumulativeNormal_g___(ICGaussianRng<KnuthUniformRng,InverseCumulativeNormal > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_InvCumulativeMersenneTwisterGaussianRng__SWIG_0(int argc, VALUE *argv, VALUE self) {
    MersenneTwisterUniformRng *arg1 = 0 ;
    ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_MersenneTwisterUniformRng, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *)new ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal >((MersenneTwisterUniformRng const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InvCumulativeMersenneTwisterGaussianRng_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InvCumulativeMersenneTwisterGaussianRng_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InvCumulativeMersenneTwisterGaussianRng__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *)new ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal >(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_InvCumulativeMersenneTwisterGaussianRng(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_InvCumulativeMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_InvCumulativeMersenneTwisterGaussianRng__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_MersenneTwisterUniformRng, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_InvCumulativeMersenneTwisterGaussianRng__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_InvCumulativeMersenneTwisterGaussianRng'");
    return Qnil;
}


static VALUE
_wrap_InvCumulativeMersenneTwisterGaussianRng_next(int argc, VALUE *argv, VALUE self) {
    ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *arg1 = (ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_ICGaussianRnglMersenneTwisterUniformRngcInverseCumulativeNormal_g___(ICGaussianRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_GaussianRandomGenerator__SWIG_0(int argc, VALUE *argv, VALUE self) {
    UniformRandomGenerator *arg1 = 0 ;
    GaussianRandomGenerator *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_UniformRandomGenerator, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (GaussianRandomGenerator *)new GaussianRandomGenerator((UniformRandomGenerator const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GaussianRandomGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GaussianRandomGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GaussianRandomGenerator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GaussianRandomGenerator__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    GaussianRandomGenerator *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    {
        try {
            result = (GaussianRandomGenerator *)new GaussianRandomGenerator(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_GaussianRandomGenerator(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_GaussianRandomGenerator__SWIG_1(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_GaussianRandomGenerator__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_UniformRandomGenerator, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_GaussianRandomGenerator__SWIG_0(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_GaussianRandomGenerator'");
    return Qnil;
}


static VALUE
_wrap_GaussianRandomGenerator_next(int argc, VALUE *argv, VALUE self) {
    GaussianRandomGenerator *arg1 = (GaussianRandomGenerator *) 0 ;
    SwigValueWrapper< Sample<double > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GaussianRandomGenerator, 1);
    {
        try {
            result = ((GaussianRandomGenerator const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<double > * resultptr;
        resultptr = new Sample<double >((Sample<double > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTdouble_t, 1);
    }
    return vresult;
}


static void
free_GaussianRandomGenerator(GaussianRandomGenerator *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_HaltonRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_HaltonRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HaltonRsg);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_HaltonRsg(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    HaltonRsg *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2LONG(argv[0]);
    {
        try {
            result = (HaltonRsg *)new HaltonRsg(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_HaltonRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    HaltonRsg *arg1 = (HaltonRsg *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HaltonRsg, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((HaltonRsg const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_HaltonRsg_dimension(int argc, VALUE *argv, VALUE self) {
    HaltonRsg *arg1 = (HaltonRsg *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HaltonRsg, 1);
    {
        try {
            result = ((HaltonRsg const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_HaltonRsg(HaltonRsg *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SobolRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SobolRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SobolRsg);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SobolRsg(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    long arg2 = (long) 0 ;
    SobolRsg *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2LONG(argv[0]);
    if (argc > 1) {
        arg2 = NUM2LONG(argv[1]);
    }
    {
        try {
            result = (SobolRsg *)new SobolRsg(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_SobolRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    SobolRsg *arg1 = (SobolRsg *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SobolRsg, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((SobolRsg const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_SobolRsg_dimension(int argc, VALUE *argv, VALUE self) {
    SobolRsg *arg1 = (SobolRsg *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SobolRsg, 1);
    {
        try {
            result = ((SobolRsg const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_SobolRsg(SobolRsg *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LecuyerUniformRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LecuyerUniformRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LecuyerUniformRsg(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    LecuyerUniformRng *arg2 = 0 ;
    RandomSequenceGenerator<LecuyerUniformRng > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2LONG(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_LecuyerUniformRng, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (RandomSequenceGenerator<LecuyerUniformRng > *)new RandomSequenceGenerator<LecuyerUniformRng >(arg1,(LecuyerUniformRng const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LecuyerUniformRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<LecuyerUniformRng > *arg1 = (RandomSequenceGenerator<LecuyerUniformRng > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((RandomSequenceGenerator<LecuyerUniformRng > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_LecuyerUniformRsg_dimension(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<LecuyerUniformRng > *arg1 = (RandomSequenceGenerator<LecuyerUniformRng > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t, 1);
    {
        try {
            result = ((RandomSequenceGenerator<LecuyerUniformRng > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_RandomSequenceGeneratorlLecuyerUniformRng_g___(RandomSequenceGenerator<LecuyerUniformRng > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_KnuthUniformRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_KnuthUniformRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_KnuthUniformRsg(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    KnuthUniformRng *arg2 = 0 ;
    RandomSequenceGenerator<KnuthUniformRng > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2LONG(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_KnuthUniformRng, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (RandomSequenceGenerator<KnuthUniformRng > *)new RandomSequenceGenerator<KnuthUniformRng >(arg1,(KnuthUniformRng const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_KnuthUniformRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<KnuthUniformRng > *arg1 = (RandomSequenceGenerator<KnuthUniformRng > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((RandomSequenceGenerator<KnuthUniformRng > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_KnuthUniformRsg_dimension(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<KnuthUniformRng > *arg1 = (RandomSequenceGenerator<KnuthUniformRng > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t, 1);
    {
        try {
            result = ((RandomSequenceGenerator<KnuthUniformRng > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_RandomSequenceGeneratorlKnuthUniformRng_g___(RandomSequenceGenerator<KnuthUniformRng > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MersenneTwisterUniformRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MersenneTwisterUniformRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MersenneTwisterUniformRsg(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    MersenneTwisterUniformRng *arg2 = 0 ;
    RandomSequenceGenerator<MersenneTwisterUniformRng > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2LONG(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_MersenneTwisterUniformRng, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (RandomSequenceGenerator<MersenneTwisterUniformRng > *)new RandomSequenceGenerator<MersenneTwisterUniformRng >(arg1,(MersenneTwisterUniformRng const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MersenneTwisterUniformRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<MersenneTwisterUniformRng > *arg1 = (RandomSequenceGenerator<MersenneTwisterUniformRng > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((RandomSequenceGenerator<MersenneTwisterUniformRng > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_MersenneTwisterUniformRsg_dimension(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<MersenneTwisterUniformRng > *arg1 = (RandomSequenceGenerator<MersenneTwisterUniformRng > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t, 1);
    {
        try {
            result = ((RandomSequenceGenerator<MersenneTwisterUniformRng > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_RandomSequenceGeneratorlMersenneTwisterUniformRng_g___(RandomSequenceGenerator<MersenneTwisterUniformRng > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_UniformRandomSequenceGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_UniformRandomSequenceGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_UniformRandomSequenceGenerator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_UniformRandomSequenceGenerator(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    UniformRandomGenerator *arg2 = 0 ;
    UniformRandomSequenceGenerator *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2LONG(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_UniformRandomGenerator, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (UniformRandomSequenceGenerator *)new UniformRandomSequenceGenerator(arg1,(UniformRandomGenerator const &)*arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_UniformRandomSequenceGenerator_nextSequence(int argc, VALUE *argv, VALUE self) {
    UniformRandomSequenceGenerator *arg1 = (UniformRandomSequenceGenerator *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_UniformRandomSequenceGenerator, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((UniformRandomSequenceGenerator const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_UniformRandomSequenceGenerator_dimension(int argc, VALUE *argv, VALUE self) {
    UniformRandomSequenceGenerator *arg1 = (UniformRandomSequenceGenerator *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_UniformRandomSequenceGenerator, 1);
    {
        try {
            result = ((UniformRandomSequenceGenerator const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_UniformRandomSequenceGenerator(UniformRandomSequenceGenerator *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_UniformLowDiscrepancySequenceGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_UniformLowDiscrepancySequenceGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_UniformLowDiscrepancySequenceGenerator(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    UniformLowDiscrepancySequenceGenerator *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2LONG(argv[0]);
    {
        try {
            result = (UniformLowDiscrepancySequenceGenerator *)new UniformLowDiscrepancySequenceGenerator(arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_UniformLowDiscrepancySequenceGenerator_nextSequence(int argc, VALUE *argv, VALUE self) {
    UniformLowDiscrepancySequenceGenerator *arg1 = (UniformLowDiscrepancySequenceGenerator *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((UniformLowDiscrepancySequenceGenerator const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_UniformLowDiscrepancySequenceGenerator_dimension(int argc, VALUE *argv, VALUE self) {
    UniformLowDiscrepancySequenceGenerator *arg1 = (UniformLowDiscrepancySequenceGenerator *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator, 1);
    {
        try {
            result = ((UniformLowDiscrepancySequenceGenerator const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_UniformLowDiscrepancySequenceGenerator(UniformLowDiscrepancySequenceGenerator *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInvCumulativeLecuyerGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInvCumulativeLecuyerGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInvCumulativeLecuyerGaussianRsg(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<LecuyerUniformRng > *arg1 = 0 ;
    ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *)new ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal >((RandomSequenceGenerator<LecuyerUniformRng > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MoroInvCumulativeLecuyerGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_MoroInvCumulativeLecuyerGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglRandomSequenceGeneratorlLecuyerUniformRng_gcMoroInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInvCumulativeKnuthGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInvCumulativeKnuthGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInvCumulativeKnuthGaussianRsg(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<KnuthUniformRng > *arg1 = 0 ;
    ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *)new ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal >((RandomSequenceGenerator<KnuthUniformRng > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MoroInvCumulativeKnuthGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_MoroInvCumulativeKnuthGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglRandomSequenceGeneratorlKnuthUniformRng_gcMoroInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInvCumulativeMersenneTwisterGaussianRsg(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<MersenneTwisterUniformRng > *arg1 = 0 ;
    ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *)new ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal >((RandomSequenceGenerator<MersenneTwisterUniformRng > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglRandomSequenceGeneratorlMersenneTwisterUniformRng_gcMoroInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MoroInvCumulativeHaltonGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MoroInvCumulativeHaltonGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTHaltonRsg_MoroInverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MoroInvCumulativeHaltonGaussianRsg(int argc, VALUE *argv, VALUE self) {
    HaltonRsg *arg1 = 0 ;
    ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HaltonRsg, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *)new ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal >((HaltonRsg const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MoroInvCumulativeHaltonGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTHaltonRsg_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_MoroInvCumulativeHaltonGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *arg1 = (ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTHaltonRsg_MoroInverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglHaltonRsgcMoroInverseCumulativeNormal_g___(ICGaussianRsg<HaltonRsg,MoroInverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InvCumulativeLecuyerGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InvCumulativeLecuyerGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InvCumulativeLecuyerGaussianRsg(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<LecuyerUniformRng > *arg1 = 0 ;
    ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *)new ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal >((RandomSequenceGenerator<LecuyerUniformRng > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_InvCumulativeLecuyerGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_InvCumulativeLecuyerGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglRandomSequenceGeneratorlLecuyerUniformRng_gcInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InvCumulativeKnuthGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InvCumulativeKnuthGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InvCumulativeKnuthGaussianRsg(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<KnuthUniformRng > *arg1 = 0 ;
    ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *)new ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal >((RandomSequenceGenerator<KnuthUniformRng > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_InvCumulativeKnuthGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_InvCumulativeKnuthGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglRandomSequenceGeneratorlKnuthUniformRng_gcInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InvCumulativeMersenneTwisterGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InvCumulativeMersenneTwisterGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InvCumulativeMersenneTwisterGaussianRsg(int argc, VALUE *argv, VALUE self) {
    RandomSequenceGenerator<MersenneTwisterUniformRng > *arg1 = 0 ;
    ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *)new ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal >((RandomSequenceGenerator<MersenneTwisterUniformRng > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_InvCumulativeMersenneTwisterGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_InvCumulativeMersenneTwisterGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglRandomSequenceGeneratorlMersenneTwisterUniformRng_gcInverseCumulativeNormal_g___(ICGaussianRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InvCumulativeHaltonGaussianRsg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InvCumulativeHaltonGaussianRsg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ICGaussianRsgTHaltonRsg_InverseCumulativeNormal_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InvCumulativeHaltonGaussianRsg(int argc, VALUE *argv, VALUE self) {
    HaltonRsg *arg1 = 0 ;
    ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HaltonRsg, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *)new ICGaussianRsg<HaltonRsg,InverseCumulativeNormal >((HaltonRsg const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_InvCumulativeHaltonGaussianRsg_nextSequence(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTHaltonRsg_InverseCumulativeNormal_t, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_InvCumulativeHaltonGaussianRsg_dimension(int argc, VALUE *argv, VALUE self) {
    ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *arg1 = (ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_ICGaussianRsgTHaltonRsg_InverseCumulativeNormal_t, 1);
    {
        try {
            result = ((ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_ICGaussianRsglHaltonRsgcInverseCumulativeNormal_g___(ICGaussianRsg<HaltonRsg,InverseCumulativeNormal > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GaussianRandomSequenceGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GaussianRandomSequenceGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GaussianRandomSequenceGenerator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GaussianRandomSequenceGenerator(int argc, VALUE *argv, VALUE self) {
    UniformRandomSequenceGenerator *arg1 = 0 ;
    GaussianRandomSequenceGenerator *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_UniformRandomSequenceGenerator, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (GaussianRandomSequenceGenerator *)new GaussianRandomSequenceGenerator((UniformRandomSequenceGenerator const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_GaussianRandomSequenceGenerator_nextSequence(int argc, VALUE *argv, VALUE self) {
    GaussianRandomSequenceGenerator *arg1 = (GaussianRandomSequenceGenerator *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GaussianRandomSequenceGenerator, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((GaussianRandomSequenceGenerator const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_GaussianRandomSequenceGenerator_dimension(int argc, VALUE *argv, VALUE self) {
    GaussianRandomSequenceGenerator *arg1 = (GaussianRandomSequenceGenerator *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GaussianRandomSequenceGenerator, 1);
    {
        try {
            result = ((GaussianRandomSequenceGenerator const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_GaussianRandomSequenceGenerator(GaussianRandomSequenceGenerator *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GaussianLowDiscrepancySequenceGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GaussianLowDiscrepancySequenceGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GaussianLowDiscrepancySequenceGenerator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GaussianLowDiscrepancySequenceGenerator(int argc, VALUE *argv, VALUE self) {
    UniformLowDiscrepancySequenceGenerator *arg1 = 0 ;
    GaussianLowDiscrepancySequenceGenerator *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (GaussianLowDiscrepancySequenceGenerator *)new GaussianLowDiscrepancySequenceGenerator((UniformLowDiscrepancySequenceGenerator const &)*arg1);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_GaussianLowDiscrepancySequenceGenerator_nextSequence(int argc, VALUE *argv, VALUE self) {
    GaussianLowDiscrepancySequenceGenerator *arg1 = (GaussianLowDiscrepancySequenceGenerator *) 0 ;
    Sample<Array > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GaussianLowDiscrepancySequenceGenerator, 1);
    {
        try {
            {
                Sample<Array > const &_result_ref = ((GaussianLowDiscrepancySequenceGenerator const *)arg1)->nextSequence();
                result = (Sample<Array > *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SampleTArray_t,0);
    return vresult;
}


static VALUE
_wrap_GaussianLowDiscrepancySequenceGenerator_dimension(int argc, VALUE *argv, VALUE self) {
    GaussianLowDiscrepancySequenceGenerator *arg1 = (GaussianLowDiscrepancySequenceGenerator *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GaussianLowDiscrepancySequenceGenerator, 1);
    {
        try {
            result = ((GaussianLowDiscrepancySequenceGenerator const *)arg1)->dimension();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static void
free_GaussianLowDiscrepancySequenceGenerator(GaussianLowDiscrepancySequenceGenerator *arg1) {
    delete arg1;
}
static VALUE
_wrap_getCovariance(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Array temp1 ;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[1])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[1])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = getCovariance((Array const &)*arg1,(Matrix const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Path___len__(int argc, VALUE *argv, VALUE self) {
    Path *arg1 = (Path *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Path, 1);
    {
        try {
            result = ((Path const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Path_drift(int argc, VALUE *argv, VALUE self) {
    Path *arg1 = (Path *) 0 ;
    Array *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Path, 1);
    {
        try {
            {
                Array const &_result_ref = ((Path const *)arg1)->drift();
                result = (Array *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Array,0);
    return vresult;
}


static VALUE
_wrap_Path_diffusion(int argc, VALUE *argv, VALUE self) {
    Path *arg1 = (Path *) 0 ;
    Array *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Path, 1);
    {
        try {
            {
                Array const &_result_ref = ((Path const *)arg1)->diffusion();
                result = (Array *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Array,0);
    return vresult;
}


static VALUE
_wrap_Path___getitem__(int argc, VALUE *argv, VALUE self) {
    Path *arg1 = (Path *) 0 ;
    int arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Path, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (double)Path___getitem__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Path_each(int argc, VALUE *argv, VALUE self) {
    Path *arg1 = (Path *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Path, 1);
    {
        try {
            Path_each(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_Path(Path *arg1) {
    delete arg1;
}
static VALUE
_wrap_SamplePath_value(int argc, VALUE *argv, VALUE self) {
    Sample<Path > *arg1 = (Sample<Path > *) 0 ;
    SwigValueWrapper< Path > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTPath_t, 1);
    {
        try {
            result = SamplelPath_g_value___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Path * resultptr;
        resultptr = new Path((Path &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Path, 1);
    }
    return vresult;
}


static VALUE
_wrap_SamplePath_weight(int argc, VALUE *argv, VALUE self) {
    Sample<Path > *arg1 = (Sample<Path > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTPath_t, 1);
    {
        try {
            result = (double)SamplelPath_g_weight___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SamplelPath_g___(Sample<Path > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GaussianPathGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GaussianPathGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GaussianPathGenerator_old);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GaussianPathGenerator(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    double arg2 ;
    Time arg3 ;
    Size arg4 ;
    long arg5 = (long) 0 ;
    GaussianPathGenerator_old *result;
    
    if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    arg2 = (double) NUM2DBL(argv[1]);
    arg3 = (Time) NUM2DBL(argv[2]);
    {
        if (FIXNUM_P(argv[3]))
        arg4 = Size(FIX2INT(argv[3]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    if (argc > 4) {
        arg5 = NUM2LONG(argv[4]);
    }
    {
        try {
            result = (GaussianPathGenerator_old *)new GaussianPathGenerator_old(arg1,arg2,arg3,arg4,arg5);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_GaussianPathGenerator_next(int argc, VALUE *argv, VALUE self) {
    GaussianPathGenerator_old *arg1 = (GaussianPathGenerator_old *) 0 ;
    SwigValueWrapper< Sample<Path > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GaussianPathGenerator_old, 1);
    {
        try {
            result = ((GaussianPathGenerator_old const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<Path > * resultptr;
        resultptr = new Sample<Path >((Sample<Path > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTPath_t, 1);
    }
    return vresult;
}


static void
free_GaussianPathGenerator_old(GaussianPathGenerator_old *arg1) {
    delete arg1;
}
static VALUE
_wrap_MultiPath___len__(int argc, VALUE *argv, VALUE self) {
    MultiPath *arg1 = (MultiPath *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MultiPath, 1);
    {
        try {
            result = ((MultiPath const *)arg1)->pathSize();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_MultiPath_assetNumber(int argc, VALUE *argv, VALUE self) {
    MultiPath *arg1 = (MultiPath *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MultiPath, 1);
    {
        try {
            result = ((MultiPath const *)arg1)->assetNumber();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_MultiPath___getitem__(int argc, VALUE *argv, VALUE self) {
    MultiPath *arg1 = (MultiPath *) 0 ;
    int arg2 ;
    Path *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MultiPath, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Path const &_result_ref = MultiPath___getitem__(arg1,arg2);
                result = (Path *) &_result_ref;
            }
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Path,0);
    return vresult;
}


static VALUE
_wrap_MultiPath_each_path(int argc, VALUE *argv, VALUE self) {
    MultiPath *arg1 = (MultiPath *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MultiPath, 1);
    {
        try {
            MultiPath_each_path(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_MultiPath_each_step(int argc, VALUE *argv, VALUE self) {
    MultiPath *arg1 = (MultiPath *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MultiPath, 1);
    {
        try {
            MultiPath_each_step(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_MultiPath(MultiPath *arg1) {
    delete arg1;
}
static VALUE
_wrap_SampleMultiPath_value(int argc, VALUE *argv, VALUE self) {
    Sample<MultiPath > *arg1 = (Sample<MultiPath > *) 0 ;
    SwigValueWrapper< MultiPath > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTMultiPath_t, 1);
    {
        try {
            result = SamplelMultiPath_g_value___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        MultiPath * resultptr;
        resultptr = new MultiPath((MultiPath &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_MultiPath, 1);
    }
    return vresult;
}


static VALUE
_wrap_SampleMultiPath_weight(int argc, VALUE *argv, VALUE self) {
    Sample<MultiPath > *arg1 = (Sample<MultiPath > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SampleTMultiPath_t, 1);
    {
        try {
            result = (double)SamplelMultiPath_g_weight___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SamplelMultiPath_g___(Sample<MultiPath > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GaussianMultiPathGenerator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GaussianMultiPathGenerator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GaussianMultiPathGenerator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GaussianMultiPathGenerator(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Matrix *arg2 = 0 ;
    std::vector<double > *arg3 = 0 ;
    long arg4 = (long) 0 ;
    GaussianMultiPathGenerator *result;
    Array temp1 ;
    Matrix temp2 ;
    std::vector<double > temp3 ;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[1])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[1])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = std::vector<double >(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp3[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    if (argc > 3) {
        arg4 = NUM2LONG(argv[3]);
    }
    {
        try {
            result = (GaussianMultiPathGenerator *)new_GaussianMultiPathGenerator((Array const &)*arg1,(Matrix const &)*arg2,(std::vector<double > const &)*arg3,arg4);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_GaussianMultiPathGenerator_next(int argc, VALUE *argv, VALUE self) {
    GaussianMultiPathGenerator *arg1 = (GaussianMultiPathGenerator *) 0 ;
    SwigValueWrapper< Sample<MultiPath > > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GaussianMultiPathGenerator, 1);
    {
        try {
            result = ((GaussianMultiPathGenerator const *)arg1)->next();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Sample<MultiPath > * resultptr;
        resultptr = new Sample<MultiPath >((Sample<MultiPath > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SampleTMultiPath_t, 1);
    }
    return vresult;
}


static void
free_GaussianMultiPathGenerator(GaussianMultiPathGenerator *arg1) {
    delete arg1;
}
static VALUE
_wrap_BoundaryCondition___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<BoundaryCondition > *arg1 = (Handle<BoundaryCondition > *) 0 ;
    BoundaryCondition *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBoundaryCondition_t, 1);
    {
        try {
            result = (BoundaryCondition *)(arg1)->operator ->();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BoundaryCondition,0);
    return vresult;
}


static VALUE
_wrap_BoundaryCondition_nullq___(int argc, VALUE *argv, VALUE self) {
    Handle<BoundaryCondition > *arg1 = (Handle<BoundaryCondition > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBoundaryCondition_t, 1);
    {
        try {
            result = (bool)HandlelBoundaryCondition_g_isNull___(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BoundaryCondition_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BoundaryCondition_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTBoundaryCondition_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BoundaryCondition(int argc, VALUE *argv, VALUE self) {
    Handle<BoundaryCondition > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Handle<BoundaryCondition > *)new Handle<BoundaryCondition >();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_HandlelBoundaryCondition_g___(Handle<BoundaryCondition > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_NeumannBC_allocate(VALUE self) {
#else
    static VALUE
    _wrap_NeumannBC_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_NeumannBCHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_NeumannBC(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    BoundaryConditionSide arg2 ;
    NeumannBCHandle *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = BCSideFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "BoundaryConditionSide");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "BoundaryConditionSide");
        }
    }
    {
        try {
            result = (NeumannBCHandle *)new_NeumannBCHandle(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_NeumannBCHandle(NeumannBCHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DirichletBC_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DirichletBC_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DirichletBCHandle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DirichletBC(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    BoundaryConditionSide arg2 ;
    DirichletBCHandle *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = BCSideFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "BoundaryConditionSide");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "BoundaryConditionSide");
        }
    }
    {
        try {
            result = (DirichletBCHandle *)new_DirichletBCHandle(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_DirichletBCHandle(DirichletBCHandle *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TridiagonalOperator_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TridiagonalOperator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_TridiagonalOperator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TridiagonalOperator(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Array *arg3 = 0 ;
    TridiagonalOperator *result;
    Array temp1 ;
    Array temp2 ;
    Array temp3 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = Array(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp3[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp3[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[2],(void **) &arg3,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (TridiagonalOperator *)new TridiagonalOperator((Array const &)*arg1,(Array const &)*arg2,(Array const &)*arg3);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_TridiagonalOperator_solveFor(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = ((TridiagonalOperator const *)arg1)->solveFor((Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_TridiagonalOperator_applyTo(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = ((TridiagonalOperator const *)arg1)->applyTo((Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_TridiagonalOperator_size(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    {
        try {
            result = ((TridiagonalOperator const *)arg1)->size();
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_TridiagonalOperator_firstRowe___(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    double arg2 ;
    double arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            (arg1)->setFirstRow(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_TridiagonalOperator_midRowe___(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    Size arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg3 = (double) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    arg5 = (double) NUM2DBL(argv[3]);
    {
        try {
            (arg1)->setMidRow(arg2,arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_TridiagonalOperator_midRowse___(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    {
        try {
            (arg1)->setMidRows(arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_TridiagonalOperator_lastRowe___(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    double arg2 ;
    double arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            (arg1)->setLastRow(arg2,arg3);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_TridiagonalOperator_identity(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    SwigValueWrapper< TridiagonalOperator > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = TridiagonalOperator::identity(arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        TridiagonalOperator * resultptr;
        resultptr = new TridiagonalOperator((TridiagonalOperator &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_TridiagonalOperator, 1);
    }
    return vresult;
}


static VALUE
_wrap_TridiagonalOperator___add__(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    TridiagonalOperator *arg2 = 0 ;
    SwigValueWrapper< TridiagonalOperator > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_TridiagonalOperator, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = TridiagonalOperator___add__(arg1,(TridiagonalOperator const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        TridiagonalOperator * resultptr;
        resultptr = new TridiagonalOperator((TridiagonalOperator &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_TridiagonalOperator, 1);
    }
    return vresult;
}


static VALUE
_wrap_TridiagonalOperator___sub__(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    TridiagonalOperator *arg2 = 0 ;
    SwigValueWrapper< TridiagonalOperator > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_TridiagonalOperator, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = TridiagonalOperator___sub__(arg1,(TridiagonalOperator const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        TridiagonalOperator * resultptr;
        resultptr = new TridiagonalOperator((TridiagonalOperator &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_TridiagonalOperator, 1);
    }
    return vresult;
}


static VALUE
_wrap_TridiagonalOperator___mul__(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    double arg2 ;
    SwigValueWrapper< TridiagonalOperator > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = TridiagonalOperator___mul__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        TridiagonalOperator * resultptr;
        resultptr = new TridiagonalOperator((TridiagonalOperator &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_TridiagonalOperator, 1);
    }
    return vresult;
}


static VALUE
_wrap_TridiagonalOperator___div__(int argc, VALUE *argv, VALUE self) {
    TridiagonalOperator *arg1 = (TridiagonalOperator *) 0 ;
    double arg2 ;
    SwigValueWrapper< TridiagonalOperator > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TridiagonalOperator, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            result = TridiagonalOperator___div__(arg1,arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        TridiagonalOperator * resultptr;
        resultptr = new TridiagonalOperator((TridiagonalOperator &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_TridiagonalOperator, 1);
    }
    return vresult;
}


static void
free_TridiagonalOperator(TridiagonalOperator *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DPlus_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DPlus_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DPlus);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DPlus(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    double arg2 ;
    DPlus *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg2 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (DPlus *)new DPlus(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_DPlus(DPlus *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DMinus_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DMinus_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DMinus);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DMinus(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    double arg2 ;
    DMinus *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg2 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (DMinus *)new DMinus(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_DMinus(DMinus *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DZero_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DZero_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DZero);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DZero(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    double arg2 ;
    DZero *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg2 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (DZero *)new DZero(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_DZero(DZero *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DPlusDMinus_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DPlusDMinus_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DPlusDMinus);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DPlusDMinus(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    double arg2 ;
    DPlusDMinus *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg2 = (double) NUM2DBL(argv[1]);
    {
        try {
            result = (DPlusDMinus *)new DPlusDMinus(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_DPlusDMinus(DPlusDMinus *arg1) {
    delete arg1;
}
static VALUE
_wrap_valueAtCenter(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    double result;
    Array temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (double)valueAtCenter((Array const &)*arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_firstDerivativeAtCenter(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    double result;
    Array temp1 ;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (double)firstDerivativeAtCenter((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_secondDerivativeAtCenter(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    double result;
    Array temp1 ;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = double(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (double)secondDerivativeAtCenter((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_SymmetricEigenvalues(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    Array result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Matrix, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = SymmetricEigenvalues(*arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_SymmetricEigenvectors(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    Matrix result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Matrix, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = SymmetricEigenvectors(*arg1);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Brent_maxEvaluationse___(int argc, VALUE *argv, VALUE self) {
    Brent *arg1 = (Brent *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Brent, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            (arg1)->setMaxEvaluations(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Brent_lowerBounde___(int argc, VALUE *argv, VALUE self) {
    Brent *arg1 = (Brent *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Brent, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            (arg1)->setLowerBound(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Brent_upperBounde___(int argc, VALUE *argv, VALUE self) {
    Brent *arg1 = (Brent *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Brent, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            (arg1)->setUpperBound(arg2);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Brent_solve__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Brent *arg1 = (Brent *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Brent, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    {
        try {
            result = (double)Brent_solve__SWIG_0(arg1,arg2,arg3,arg4);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Brent_solve__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Brent *arg1 = (Brent *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Brent, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    arg5 = (double) NUM2DBL(argv[3]);
    {
        try {
            result = (double)Brent_solve__SWIG_1(arg1,arg2,arg3,arg4,arg5);
            
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_Brent_solve(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Brent, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_Brent_solve__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Brent, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_Brent_solve__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Brent_solve'");
    return Qnil;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Brent_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Brent_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Brent);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Brent(int argc, VALUE *argv, VALUE self) {
    Brent *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Brent *)new Brent();
            DATA_PTR(self) = result;
        } catch (IndexError& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
         