open Swig
type c_enum_type = [ 
  `unknown
| `Weekday
| `Month
| `TimeUnit
| `Frequency
| `Month
| `Type
| `Convention
| `Convention
| `Compounding
| `BusinessDayConvention
| `JointCalendarRule
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Type
| `Type
| `Type
| `Type
| `Type
| `ConversionType
| `Type
| `Type
]
type c_enum_value = [ 
  `Int of int
| `Sunday
| `Monday
| `Tuesday
| `Wednesday
| `Thursday
| `Friday
| `Saturday
| `January
| `February
| `March
| `April
| `May
| `June
| `July
| `August
| `September
| `October
| `November
| `December
| `Days
| `Weeks
| `Months
| `Years
| `NoFrequency
| `Once
| `Annual
| `Semiannual
| `EveryFourthMonth
| `Quarterly
| `Bimonthly
| `Monthly
| `Biweekly
| `Weekly
| `Daily
| `F
| `G
| `H
| `J
| `K
| `M
| `N
| `Q
| `U
| `V
| `X
| `Z
| `None
| `Spectral
| `USA
| `BondBasis
| `European
| `EurobondBasis
| `Italian
| `ISMA
| `Bond
| `ISDA
| `Historical
| `Actual365
| `AFB
| `Euro
| `Simple
| `Compounded
| `Continuous
| `SimpleThenCompounded
| `Following
| `ModifiedFollowing
| `Preceding
| `ModifiedPreceding
| `Unadjusted
| `JoinHolidays
| `JoinBusinessDays
| `Merval
| `Settlement
| `PSE
| `FrankfurtStockExchange
| `Xetra
| `Eurex
| `HKEx
| `ICEX
| `NSE
| `BEJ
| `JSX
| `Exchange
| `BMV
| `Tadawul
| `SGX
| `BSSE
| `KRX
| `TSEC
| `USE
| `Metals
| `NYSE
| `GovernmentBond
| `NERC
| `Put
| `Call
| `DownIn
| `UpIn
| `DownOut
| `UpOut
| `Open
| `Close
| `High
| `Low
| `Macaulay
| `Modified
| `Dirty
| `Clean
| `NoConversion
| `BaseCurrencyConversion
| `AutomatedConversion
| `Direct
| `Derived
| `MaxIterations
| `StationaryPoint
| `StationaryFunctionValue
| `StationaryFunctionAccuracy
| `ZeroGradientNorm
| `Unknown
]

type c_obj = c_enum_value c_obj_t
let module_name = "QuantLib"

exception BadArgs of string
exception BadMethodName of c_obj * string * string
exception NotObject of c_obj
exception NotEnumType of c_obj
exception LabelNotFromThisEnum of c_obj
exception InvalidDirectorCall of c_obj


  
  let array_to_vector v argcons array = 
    for i = 0 to (Array.length array) - 1 do
	(invoke v) "set" (C_list [ C_int i ; (argcons array.(i)) ])
    done ;
    v
    
  let vector_to_array v argcons array =
    for i = 0; to (get_int ((invoke v) "size" C_void)) - 1 do
	array.(i) <- argcons ((invoke v) "[]" (C_int i))
    done ; 
    v
      

external _new_string_f : c_obj list -> c_obj list = "_wrap_new_string__SWIG_0QuantLib" ;;
let _new_string arg = match _new_string_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_string_f : c_obj list -> c_obj list = "_wrap_new_stringQuantLib" ;;
let _new_string arg = match _new_string_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_size_f : c_obj list -> c_obj list = "_wrap_string_sizeQuantLib" ;;
let _string_size arg = match _string_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_string_operator_bB___QuantLib" ;;
let _string_operator_xx_xx_lbrace_xx_rbrace arg = match _string_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_c_str_f : c_obj list -> c_obj list = "_wrap_string_c_strQuantLib" ;;
let _string_c_str arg = match _string_c_str_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_string_operator_e_____SWIG_0QuantLib" ;;
let _string_operator_xx_xx_equals arg = match _string_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_string_operator_e___QuantLib" ;;
let _string_operator_xx_xx_equals arg = match _string_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_append_f : c_obj list -> c_obj list = "_wrap_string_append__SWIG_0QuantLib" ;;
let _string_append arg = match _string_append_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_append_f : c_obj list -> c_obj list = "_wrap_string_appendQuantLib" ;;
let _string_append arg = match _string_append_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_push_back_f : c_obj list -> c_obj list = "_wrap_string_push_backQuantLib" ;;
let _string_push_back arg = match _string_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_clear_f : c_obj list -> c_obj list = "_wrap_string_clearQuantLib" ;;
let _string_clear arg = match _string_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_reserve_f : c_obj list -> c_obj list = "_wrap_string_reserveQuantLib" ;;
let _string_reserve arg = match _string_reserve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_resize_f : c_obj list -> c_obj list = "_wrap_string_resize__SWIG_0QuantLib" ;;
let _string_resize arg = match _string_resize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_resize_f : c_obj list -> c_obj list = "_wrap_string_resizeQuantLib" ;;
let _string_resize arg = match _string_resize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_compare_f : c_obj list -> c_obj list = "_wrap_string_compare__SWIG_0QuantLib" ;;
let _string_compare arg = match _string_compare_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_compare_f : c_obj list -> c_obj list = "_wrap_string_compareQuantLib" ;;
let _string_compare arg = match _string_compare_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_insert_f : c_obj list -> c_obj list = "_wrap_string_insertQuantLib" ;;
let _string_insert arg = match _string_insert_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_find_f : c_obj list -> c_obj list = "_wrap_string_find__SWIG_0QuantLib" ;;
let _string_find arg = match _string_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_find_f : c_obj list -> c_obj list = "_wrap_string_find__SWIG_1QuantLib" ;;
let _string_find arg = match _string_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_find_f : c_obj list -> c_obj list = "_wrap_string_find__SWIG_2QuantLib" ;;
let _string_find arg = match _string_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_find_f : c_obj list -> c_obj list = "_wrap_string_findQuantLib" ;;
let _string_find arg = match _string_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_equals_xx_equals_f : c_obj list -> c_obj list = "_wrap_string_operator_ee___QuantLib" ;;
let _string_operator_xx_xx_equals_xx_equals arg = match _string_operator_xx_xx_equals_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_not_xx_equals_f : c_obj list -> c_obj list = "_wrap_string_operator_Ne___QuantLib" ;;
let _string_operator_xx_xx_not_xx_equals arg = match _string_operator_xx_xx_not_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_ldbrace_f : c_obj list -> c_obj list = "_wrap_string_operator_l___QuantLib" ;;
let _string_operator_xx_xx_ldbrace arg = match _string_operator_xx_xx_ldbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_rdbrace_f : c_obj list -> c_obj list = "_wrap_string_operator_g___QuantLib" ;;
let _string_operator_xx_xx_rdbrace arg = match _string_operator_xx_xx_rdbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_ldbrace_xx_equals_f : c_obj list -> c_obj list = "_wrap_string_operator_le___QuantLib" ;;
let _string_operator_xx_xx_ldbrace_xx_equals arg = match _string_operator_xx_xx_ldbrace_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _string_operator_xx_xx_rdbrace_xx_equals_f : c_obj list -> c_obj list = "_wrap_string_operator_ge___QuantLib" ;;
let _string_operator_xx_xx_rdbrace_xx_equals arg = match _string_operator_xx_xx_rdbrace_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_string_f : c_obj list -> c_obj list = "_wrap_delete_stringQuantLib" ;;
let _delete_string arg = match _delete_string_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_wstring_f : c_obj list -> c_obj list = "_wrap_new_wstring__SWIG_0QuantLib" ;;
let _new_wstring arg = match _new_wstring_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_wstring_f : c_obj list -> c_obj list = "_wrap_new_wstringQuantLib" ;;
let _new_wstring arg = match _new_wstring_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_size_f : c_obj list -> c_obj list = "_wrap_wstring_sizeQuantLib" ;;
let _wstring_size arg = match _wstring_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_wstring_operator_bB___QuantLib" ;;
let _wstring_operator_xx_xx_lbrace_xx_rbrace arg = match _wstring_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_c_str_f : c_obj list -> c_obj list = "_wrap_wstring_c_strQuantLib" ;;
let _wstring_c_str arg = match _wstring_c_str_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_wstring_operator_e_____SWIG_0QuantLib" ;;
let _wstring_operator_xx_xx_equals arg = match _wstring_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_wstring_operator_e___QuantLib" ;;
let _wstring_operator_xx_xx_equals arg = match _wstring_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_append_f : c_obj list -> c_obj list = "_wrap_wstring_append__SWIG_0QuantLib" ;;
let _wstring_append arg = match _wstring_append_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_append_f : c_obj list -> c_obj list = "_wrap_wstring_appendQuantLib" ;;
let _wstring_append arg = match _wstring_append_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_push_back_f : c_obj list -> c_obj list = "_wrap_wstring_push_backQuantLib" ;;
let _wstring_push_back arg = match _wstring_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_clear_f : c_obj list -> c_obj list = "_wrap_wstring_clearQuantLib" ;;
let _wstring_clear arg = match _wstring_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_reserve_f : c_obj list -> c_obj list = "_wrap_wstring_reserveQuantLib" ;;
let _wstring_reserve arg = match _wstring_reserve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_resize_f : c_obj list -> c_obj list = "_wrap_wstring_resize__SWIG_0QuantLib" ;;
let _wstring_resize arg = match _wstring_resize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_resize_f : c_obj list -> c_obj list = "_wrap_wstring_resizeQuantLib" ;;
let _wstring_resize arg = match _wstring_resize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_compare_f : c_obj list -> c_obj list = "_wrap_wstring_compare__SWIG_0QuantLib" ;;
let _wstring_compare arg = match _wstring_compare_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_compare_f : c_obj list -> c_obj list = "_wrap_wstring_compareQuantLib" ;;
let _wstring_compare arg = match _wstring_compare_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_insert_f : c_obj list -> c_obj list = "_wrap_wstring_insertQuantLib" ;;
let _wstring_insert arg = match _wstring_insert_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_find_f : c_obj list -> c_obj list = "_wrap_wstring_find__SWIG_0QuantLib" ;;
let _wstring_find arg = match _wstring_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_find_f : c_obj list -> c_obj list = "_wrap_wstring_find__SWIG_1QuantLib" ;;
let _wstring_find arg = match _wstring_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_find_f : c_obj list -> c_obj list = "_wrap_wstring_find__SWIG_2QuantLib" ;;
let _wstring_find arg = match _wstring_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_find_f : c_obj list -> c_obj list = "_wrap_wstring_findQuantLib" ;;
let _wstring_find arg = match _wstring_find_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_equals_xx_equals_f : c_obj list -> c_obj list = "_wrap_wstring_operator_ee___QuantLib" ;;
let _wstring_operator_xx_xx_equals_xx_equals arg = match _wstring_operator_xx_xx_equals_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_not_xx_equals_f : c_obj list -> c_obj list = "_wrap_wstring_operator_Ne___QuantLib" ;;
let _wstring_operator_xx_xx_not_xx_equals arg = match _wstring_operator_xx_xx_not_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_ldbrace_f : c_obj list -> c_obj list = "_wrap_wstring_operator_l___QuantLib" ;;
let _wstring_operator_xx_xx_ldbrace arg = match _wstring_operator_xx_xx_ldbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_rdbrace_f : c_obj list -> c_obj list = "_wrap_wstring_operator_g___QuantLib" ;;
let _wstring_operator_xx_xx_rdbrace arg = match _wstring_operator_xx_xx_rdbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_ldbrace_xx_equals_f : c_obj list -> c_obj list = "_wrap_wstring_operator_le___QuantLib" ;;
let _wstring_operator_xx_xx_ldbrace_xx_equals arg = match _wstring_operator_xx_xx_ldbrace_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _wstring_operator_xx_xx_rdbrace_xx_equals_f : c_obj list -> c_obj list = "_wrap_wstring_operator_ge___QuantLib" ;;
let _wstring_operator_xx_xx_rdbrace_xx_equals arg = match _wstring_operator_xx_xx_rdbrace_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_wstring_f : c_obj list -> c_obj list = "_wrap_delete_wstringQuantLib" ;;
let _delete_wstring arg = match _delete_wstring_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Weekday_marker" (`Weekday)
external _Sunday : c_obj -> Swig.c_obj = "_wrap_Sunday" 
external _Monday : c_obj -> Swig.c_obj = "_wrap_Monday" 
external _Tuesday : c_obj -> Swig.c_obj = "_wrap_Tuesday" 
external _Wednesday : c_obj -> Swig.c_obj = "_wrap_Wednesday" 
external _Thursday : c_obj -> Swig.c_obj = "_wrap_Thursday" 
external _Friday : c_obj -> Swig.c_obj = "_wrap_Friday" 
external _Saturday : c_obj -> Swig.c_obj = "_wrap_Saturday" 
let _ = Callback.register "Month_marker" (`Month)
external _January : c_obj -> Swig.c_obj = "_wrap_January" 
external _February : c_obj -> Swig.c_obj = "_wrap_February" 
external _March : c_obj -> Swig.c_obj = "_wrap_March" 
external _April : c_obj -> Swig.c_obj = "_wrap_April" 
external _May : c_obj -> Swig.c_obj = "_wrap_May" 
external _June : c_obj -> Swig.c_obj = "_wrap_June" 
external _July : c_obj -> Swig.c_obj = "_wrap_July" 
external _August : c_obj -> Swig.c_obj = "_wrap_August" 
external _September : c_obj -> Swig.c_obj = "_wrap_September" 
external _October : c_obj -> Swig.c_obj = "_wrap_October" 
external _November : c_obj -> Swig.c_obj = "_wrap_November" 
external _December : c_obj -> Swig.c_obj = "_wrap_December" 
let _ = Callback.register "TimeUnit_marker" (`TimeUnit)
external _Days : c_obj -> Swig.c_obj = "_wrap_Days" 
external _Weeks : c_obj -> Swig.c_obj = "_wrap_Weeks" 
external _Months : c_obj -> Swig.c_obj = "_wrap_Months" 
external _Years : c_obj -> Swig.c_obj = "_wrap_Years" 
let _ = Callback.register "Frequency_marker" (`Frequency)
external _NoFrequency : c_obj -> Swig.c_obj = "_wrap_NoFrequency" 
external _Once : c_obj -> Swig.c_obj = "_wrap_Once" 
external _Annual : c_obj -> Swig.c_obj = "_wrap_Annual" 
external _Semiannual : c_obj -> Swig.c_obj = "_wrap_Semiannual" 
external _EveryFourthMonth : c_obj -> Swig.c_obj = "_wrap_EveryFourthMonth" 
external _Quarterly : c_obj -> Swig.c_obj = "_wrap_Quarterly" 
external _Bimonthly : c_obj -> Swig.c_obj = "_wrap_Bimonthly" 
external _Monthly : c_obj -> Swig.c_obj = "_wrap_Monthly" 
external _Biweekly : c_obj -> Swig.c_obj = "_wrap_Biweekly" 
external _Weekly : c_obj -> Swig.c_obj = "_wrap_Weekly" 
external _Daily : c_obj -> Swig.c_obj = "_wrap_Daily" 
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_Period__SWIG_0QuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_Period__SWIG_1QuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_Period__SWIG_2QuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period_length_f : c_obj list -> c_obj list = "_wrap_Period_lengthQuantLib" ;;
let _Period_length arg = match _Period_length_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period_units_f : c_obj list -> c_obj list = "_wrap_Period_unitsQuantLib" ;;
let _Period_units arg = match _Period_units_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_PeriodQuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period___str___f : c_obj list -> c_obj list = "_wrap_Period___str__QuantLib" ;;
let _Period___str__ arg = match _Period___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period___repr___f : c_obj list -> c_obj list = "_wrap_Period___repr__QuantLib" ;;
let _Period___repr__ arg = match _Period___repr___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Period_f : c_obj list -> c_obj list = "_wrap_delete_PeriodQuantLib" ;;
let _delete_Period arg = match _delete_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVector__SWIG_0QuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVector__SWIG_1QuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVector__SWIG_2QuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVectorQuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_size_f : c_obj list -> c_obj list = "_wrap_PeriodVector_sizeQuantLib" ;;
let _PeriodVector_size arg = match _PeriodVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_empty_f : c_obj list -> c_obj list = "_wrap_PeriodVector_emptyQuantLib" ;;
let _PeriodVector_empty arg = match _PeriodVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_clear_f : c_obj list -> c_obj list = "_wrap_PeriodVector_clearQuantLib" ;;
let _PeriodVector_clear arg = match _PeriodVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_push_back_f : c_obj list -> c_obj list = "_wrap_PeriodVector_push_backQuantLib" ;;
let _PeriodVector_push_back arg = match _PeriodVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_PeriodVector_operator_bB___QuantLib" ;;
let _PeriodVector_operator_xx_xx_lbrace_xx_rbrace arg = match _PeriodVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_PeriodVector_operator_e___QuantLib" ;;
let _PeriodVector_operator_xx_xx_equals arg = match _PeriodVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_set_f : c_obj list -> c_obj list = "_wrap_PeriodVector_setQuantLib" ;;
let _PeriodVector_set arg = match _PeriodVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_to_array_f : c_obj list -> c_obj list = "_wrap_PeriodVector_to_arrayQuantLib" ;;
let _PeriodVector_to_array arg = match _PeriodVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PeriodVector_f : c_obj list -> c_obj list = "_wrap_delete_PeriodVectorQuantLib" ;;
let _delete_PeriodVector arg = match _delete_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_Date__SWIG_0QuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_Date__SWIG_1QuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_Date__SWIG_2QuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_weekday_f : c_obj list -> c_obj list = "_wrap_Date_weekdayQuantLib" ;;
let _Date_weekday arg = match _Date_weekday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_dayOfMonth_f : c_obj list -> c_obj list = "_wrap_Date_dayOfMonthQuantLib" ;;
let _Date_dayOfMonth arg = match _Date_dayOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_dayOfYear_f : c_obj list -> c_obj list = "_wrap_Date_dayOfYearQuantLib" ;;
let _Date_dayOfYear arg = match _Date_dayOfYear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_month_f : c_obj list -> c_obj list = "_wrap_Date_monthQuantLib" ;;
let _Date_month arg = match _Date_month_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_year_f : c_obj list -> c_obj list = "_wrap_Date_yearQuantLib" ;;
let _Date_year arg = match _Date_year_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_serialNumber_f : c_obj list -> c_obj list = "_wrap_Date_serialNumberQuantLib" ;;
let _Date_serialNumber arg = match _Date_serialNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_isLeap_f : c_obj list -> c_obj list = "_wrap_Date_isLeapQuantLib" ;;
let _Date_isLeap arg = match _Date_isLeap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_minDate_f : c_obj list -> c_obj list = "_wrap_Date_minDateQuantLib" ;;
let _Date_minDate arg = match _Date_minDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_maxDate_f : c_obj list -> c_obj list = "_wrap_Date_maxDateQuantLib" ;;
let _Date_maxDate arg = match _Date_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_todaysDate_f : c_obj list -> c_obj list = "_wrap_Date_todaysDateQuantLib" ;;
let _Date_todaysDate arg = match _Date_todaysDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_endOfMonth_f : c_obj list -> c_obj list = "_wrap_Date_endOfMonthQuantLib" ;;
let _Date_endOfMonth arg = match _Date_endOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_isEndOfMonth_f : c_obj list -> c_obj list = "_wrap_Date_isEndOfMonthQuantLib" ;;
let _Date_isEndOfMonth arg = match _Date_isEndOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_nextWeekday_f : c_obj list -> c_obj list = "_wrap_Date_nextWeekdayQuantLib" ;;
let _Date_nextWeekday arg = match _Date_nextWeekday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_nthWeekday_f : c_obj list -> c_obj list = "_wrap_Date_nthWeekdayQuantLib" ;;
let _Date_nthWeekday arg = match _Date_nthWeekday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_DateQuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_weekdayNumber_f : c_obj list -> c_obj list = "_wrap_Date_weekdayNumberQuantLib" ;;
let _Date_weekdayNumber arg = match _Date_weekdayNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date___str___f : c_obj list -> c_obj list = "_wrap_Date___str__QuantLib" ;;
let _Date___str__ arg = match _Date___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date___repr___f : c_obj list -> c_obj list = "_wrap_Date___repr__QuantLib" ;;
let _Date___repr__ arg = match _Date___repr___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_ISO_f : c_obj list -> c_obj list = "_wrap_Date_ISOQuantLib" ;;
let _Date_ISO arg = match _Date_ISO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Date_f : c_obj list -> c_obj list = "_wrap_delete_DateQuantLib" ;;
let _delete_Date arg = match _delete_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateParser_parse_f : c_obj list -> c_obj list = "_wrap_DateParser_parseQuantLib" ;;
let _DateParser_parse arg = match _DateParser_parse_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateParser_parseISO_f : c_obj list -> c_obj list = "_wrap_DateParser_parseISOQuantLib" ;;
let _DateParser_parseISO arg = match _DateParser_parseISO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateParser_f : c_obj list -> c_obj list = "_wrap_new_DateParserQuantLib" ;;
let _new_DateParser arg = match _new_DateParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DateParser_f : c_obj list -> c_obj list = "_wrap_delete_DateParserQuantLib" ;;
let _delete_DateParser arg = match _delete_DateParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodParser_parse_f : c_obj list -> c_obj list = "_wrap_PeriodParser_parseQuantLib" ;;
let _PeriodParser_parse arg = match _PeriodParser_parse_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodParser_f : c_obj list -> c_obj list = "_wrap_new_PeriodParserQuantLib" ;;
let _new_PeriodParser arg = match _new_PeriodParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PeriodParser_f : c_obj list -> c_obj list = "_wrap_delete_PeriodParserQuantLib" ;;
let _delete_PeriodParser arg = match _delete_PeriodParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVector__SWIG_0QuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVector__SWIG_1QuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVector__SWIG_2QuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVectorQuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_size_f : c_obj list -> c_obj list = "_wrap_DateVector_sizeQuantLib" ;;
let _DateVector_size arg = match _DateVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_empty_f : c_obj list -> c_obj list = "_wrap_DateVector_emptyQuantLib" ;;
let _DateVector_empty arg = match _DateVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_clear_f : c_obj list -> c_obj list = "_wrap_DateVector_clearQuantLib" ;;
let _DateVector_clear arg = match _DateVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_push_back_f : c_obj list -> c_obj list = "_wrap_DateVector_push_backQuantLib" ;;
let _DateVector_push_back arg = match _DateVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_DateVector_operator_bB___QuantLib" ;;
let _DateVector_operator_xx_xx_lbrace_xx_rbrace arg = match _DateVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_DateVector_operator_e___QuantLib" ;;
let _DateVector_operator_xx_xx_equals arg = match _DateVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_set_f : c_obj list -> c_obj list = "_wrap_DateVector_setQuantLib" ;;
let _DateVector_set arg = match _DateVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_to_array_f : c_obj list -> c_obj list = "_wrap_DateVector_to_arrayQuantLib" ;;
let _DateVector_to_array arg = match _DateVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DateVector_f : c_obj list -> c_obj list = "_wrap_delete_DateVectorQuantLib" ;;
let _delete_DateVector arg = match _delete_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "IMM::Month_marker" (`Month)
external _F : c_obj -> Swig.c_obj = "_wrap_F" 
external _G : c_obj -> Swig.c_obj = "_wrap_G" 
external _H : c_obj -> Swig.c_obj = "_wrap_H" 
external _J : c_obj -> Swig.c_obj = "_wrap_J" 
external _K : c_obj -> Swig.c_obj = "_wrap_K" 
external _M : c_obj -> Swig.c_obj = "_wrap_M" 
external _N : c_obj -> Swig.c_obj = "_wrap_N" 
external _Q : c_obj -> Swig.c_obj = "_wrap_Q" 
external _U : c_obj -> Swig.c_obj = "_wrap_U" 
external _V : c_obj -> Swig.c_obj = "_wrap_V" 
external _X : c_obj -> Swig.c_obj = "_wrap_X" 
external _Z : c_obj -> Swig.c_obj = "_wrap_Z" 
external _IMM_isIMMdate_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMdate__SWIG_0QuantLib" ;;
let _IMM_isIMMdate arg = match _IMM_isIMMdate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_isIMMdate_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMdateQuantLib" ;;
let _IMM_isIMMdate arg = match _IMM_isIMMdate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_isIMMcode_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMcode__SWIG_0QuantLib" ;;
let _IMM_isIMMcode arg = match _IMM_isIMMcode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_isIMMcode_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMcodeQuantLib" ;;
let _IMM_isIMMcode arg = match _IMM_isIMMcode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_code_f : c_obj list -> c_obj list = "_wrap_IMM_codeQuantLib" ;;
let _IMM_code arg = match _IMM_code_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_date_f : c_obj list -> c_obj list = "_wrap_IMM_date__SWIG_0QuantLib" ;;
let _IMM_date arg = match _IMM_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_date_f : c_obj list -> c_obj list = "_wrap_IMM_dateQuantLib" ;;
let _IMM_date arg = match _IMM_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_0QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_1QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_2QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_3QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_4QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDateQuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_0QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_1QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_2QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_3QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_4QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCodeQuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IMM_f : c_obj list -> c_obj list = "_wrap_new_IMMQuantLib" ;;
let _new_IMM arg = match _new_IMM_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IMM_f : c_obj list -> c_obj list = "_wrap_delete_IMMQuantLib" ;;
let _delete_IMM arg = match _delete_IMM_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise___deref___f : c_obj list -> c_obj list = "_wrap_Exercise___deref__QuantLib" ;;
let _Exercise___deref__ arg = match _Exercise___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_isNull_f : c_obj list -> c_obj list = "_wrap_Exercise_isNullQuantLib" ;;
let _Exercise_isNull arg = match _Exercise_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_American : c_obj -> Swig.c_obj = "_wrap_Exercise_American" 
external _Exercise_Bermudan : c_obj -> Swig.c_obj = "_wrap_Exercise_Bermudan" 
external _Exercise_European : c_obj -> Swig.c_obj = "_wrap_Exercise_European" 
external _new_Exercise_f : c_obj list -> c_obj list = "_wrap_new_ExerciseQuantLib" ;;
let _new_Exercise arg = match _new_Exercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Exercise_f : c_obj list -> c_obj list = "_wrap_delete_ExerciseQuantLib" ;;
let _delete_Exercise arg = match _delete_Exercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_type_f : c_obj list -> c_obj list = "_wrap_Exercise_typeQuantLib" ;;
let _Exercise_type arg = match _Exercise_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_dates_f : c_obj list -> c_obj list = "_wrap_Exercise_datesQuantLib" ;;
let _Exercise_dates arg = match _Exercise_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuropeanExercise_f : c_obj list -> c_obj list = "_wrap_new_EuropeanExerciseQuantLib" ;;
let _new_EuropeanExercise arg = match _new_EuropeanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuropeanExercise_f : c_obj list -> c_obj list = "_wrap_delete_EuropeanExerciseQuantLib" ;;
let _delete_EuropeanExercise arg = match _delete_EuropeanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AmericanExercise_f : c_obj list -> c_obj list = "_wrap_new_AmericanExercise__SWIG_0QuantLib" ;;
let _new_AmericanExercise arg = match _new_AmericanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AmericanExercise_f : c_obj list -> c_obj list = "_wrap_new_AmericanExerciseQuantLib" ;;
let _new_AmericanExercise arg = match _new_AmericanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AmericanExercise_f : c_obj list -> c_obj list = "_wrap_delete_AmericanExerciseQuantLib" ;;
let _delete_AmericanExercise arg = match _delete_AmericanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BermudanExercise_f : c_obj list -> c_obj list = "_wrap_new_BermudanExercise__SWIG_0QuantLib" ;;
let _new_BermudanExercise arg = match _new_BermudanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BermudanExercise_f : c_obj list -> c_obj list = "_wrap_new_BermudanExerciseQuantLib" ;;
let _new_BermudanExercise arg = match _new_BermudanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BermudanExercise_f : c_obj list -> c_obj list = "_wrap_delete_BermudanExerciseQuantLib" ;;
let _delete_BermudanExercise arg = match _delete_BermudanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Observable___deref___f : c_obj list -> c_obj list = "_wrap_Observable___deref__QuantLib" ;;
let _Observable___deref__ arg = match _Observable___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Observable_isNull_f : c_obj list -> c_obj list = "_wrap_Observable_isNullQuantLib" ;;
let _Observable_isNull arg = match _Observable_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Observable_f : c_obj list -> c_obj list = "_wrap_new_ObservableQuantLib" ;;
let _new_Observable arg = match _new_Observable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Observable_f : c_obj list -> c_obj list = "_wrap_delete_ObservableQuantLib" ;;
let _delete_Observable arg = match _delete_Observable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_Array__SWIG_0QuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_Array__SWIG_1QuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_Array__SWIG_2QuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_ArrayQuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Array_size_f : c_obj list -> c_obj list = "_wrap_Array_sizeQuantLib" ;;
let _Array_size arg = match _Array_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Array___str___f : c_obj list -> c_obj list = "_wrap_Array___str__QuantLib" ;;
let _Array___str__ arg = match _Array___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Array_f : c_obj list -> c_obj list = "_wrap_delete_ArrayQuantLib" ;;
let _delete_Array arg = match _delete_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LexicographicalView_xSize_f : c_obj list -> c_obj list = "_wrap_LexicographicalView_xSizeQuantLib" ;;
let _LexicographicalView_xSize arg = match _LexicographicalView_xSize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LexicographicalView_ySize_f : c_obj list -> c_obj list = "_wrap_LexicographicalView_ySizeQuantLib" ;;
let _LexicographicalView_ySize arg = match _LexicographicalView_ySize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LexicographicalView_f : c_obj list -> c_obj list = "_wrap_new_LexicographicalViewQuantLib" ;;
let _new_LexicographicalView arg = match _new_LexicographicalView_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LexicographicalView___str___f : c_obj list -> c_obj list = "_wrap_LexicographicalView___str__QuantLib" ;;
let _LexicographicalView___str__ arg = match _LexicographicalView___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LexicographicalView_f : c_obj list -> c_obj list = "_wrap_delete_LexicographicalViewQuantLib" ;;
let _delete_LexicographicalView arg = match _delete_LexicographicalView_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_Matrix__SWIG_0QuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_Matrix__SWIG_1QuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_Matrix__SWIG_2QuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_MatrixQuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Matrix_rows_f : c_obj list -> c_obj list = "_wrap_Matrix_rowsQuantLib" ;;
let _Matrix_rows arg = match _Matrix_rows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Matrix_columns_f : c_obj list -> c_obj list = "_wrap_Matrix_columnsQuantLib" ;;
let _Matrix_columns arg = match _Matrix_columns_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Matrix___str___f : c_obj list -> c_obj list = "_wrap_Matrix___str__QuantLib" ;;
let _Matrix___str__ arg = match _Matrix___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Matrix_f : c_obj list -> c_obj list = "_wrap_delete_MatrixQuantLib" ;;
let _delete_Matrix arg = match _delete_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "SalvagingAlgorithm::Type_marker" (`Type)
external _None : c_obj -> Swig.c_obj = "_wrap_None" 
external _Spectral : c_obj -> Swig.c_obj = "_wrap_Spectral" 
external _new_SalvagingAlgorithm_f : c_obj list -> c_obj list = "_wrap_new_SalvagingAlgorithmQuantLib" ;;
let _new_SalvagingAlgorithm arg = match _new_SalvagingAlgorithm_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SalvagingAlgorithm_f : c_obj list -> c_obj list = "_wrap_delete_SalvagingAlgorithmQuantLib" ;;
let _delete_SalvagingAlgorithm arg = match _delete_SalvagingAlgorithm_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _transpose_f : c_obj list -> c_obj list = "_wrap_transposeQuantLib" ;;
let _transpose arg = match _transpose_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _outerProduct_f : c_obj list -> c_obj list = "_wrap_outerProductQuantLib" ;;
let _outerProduct arg = match _outerProduct_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _pseudoSqrt_f : c_obj list -> c_obj list = "_wrap_pseudoSqrtQuantLib" ;;
let _pseudoSqrt arg = match _pseudoSqrt_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SVD_f : c_obj list -> c_obj list = "_wrap_new_SVDQuantLib" ;;
let _new_SVD arg = match _new_SVD_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_U_f : c_obj list -> c_obj list = "_wrap_SVD_UQuantLib" ;;
let _SVD_U arg = match _SVD_U_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_V_f : c_obj list -> c_obj list = "_wrap_SVD_VQuantLib" ;;
let _SVD_V arg = match _SVD_V_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_S_f : c_obj list -> c_obj list = "_wrap_SVD_SQuantLib" ;;
let _SVD_S arg = match _SVD_S_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_singularValues_f : c_obj list -> c_obj list = "_wrap_SVD_singularValuesQuantLib" ;;
let _SVD_singularValues arg = match _SVD_singularValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SVD_f : c_obj list -> c_obj list = "_wrap_delete_SVDQuantLib" ;;
let _delete_SVD arg = match _delete_SVD_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DisposableArray_f : c_obj list -> c_obj list = "_wrap_new_DisposableArrayQuantLib" ;;
let _new_DisposableArray arg = match _new_DisposableArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DisposableArray_f : c_obj list -> c_obj list = "_wrap_delete_DisposableArrayQuantLib" ;;
let _delete_DisposableArray arg = match _delete_DisposableArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote___deref___f : c_obj list -> c_obj list = "_wrap_Quote___deref__QuantLib" ;;
let _Quote___deref__ arg = match _Quote___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote_isNull_f : c_obj list -> c_obj list = "_wrap_Quote_isNullQuantLib" ;;
let _Quote_isNull arg = match _Quote_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote_asObservable_f : c_obj list -> c_obj list = "_wrap_Quote_asObservableQuantLib" ;;
let _Quote_asObservable arg = match _Quote_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Quote_f : c_obj list -> c_obj list = "_wrap_new_QuoteQuantLib" ;;
let _new_Quote arg = match _new_Quote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Quote_f : c_obj list -> c_obj list = "_wrap_delete_QuoteQuantLib" ;;
let _delete_Quote arg = match _delete_Quote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote_value_f : c_obj list -> c_obj list = "_wrap_Quote_valueQuantLib" ;;
let _Quote_value arg = match _Quote_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandle__SWIG_0QuantLib" ;;
let _new_QuoteHandle arg = match _new_QuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleQuantLib" ;;
let _new_QuoteHandle arg = match _new_QuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle___deref___f : c_obj list -> c_obj list = "_wrap_QuoteHandle___deref__QuantLib" ;;
let _QuoteHandle___deref__ arg = match _QuoteHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle_empty_f : c_obj list -> c_obj list = "_wrap_QuoteHandle_emptyQuantLib" ;;
let _QuoteHandle_empty arg = match _QuoteHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_QuoteHandle_asObservableQuantLib" ;;
let _QuoteHandle_asObservable arg = match _QuoteHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteHandle_f : c_obj list -> c_obj list = "_wrap_delete_QuoteHandleQuantLib" ;;
let _delete_QuoteHandle arg = match _delete_QuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle_value_f : c_obj list -> c_obj list = "_wrap_QuoteHandle_valueQuantLib" ;;
let _QuoteHandle_value arg = match _QuoteHandle_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandle__SWIG_0QuantLib" ;;
let _new_RelinkableQuoteHandle arg = match _new_RelinkableQuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleQuantLib" ;;
let _new_RelinkableQuoteHandle arg = match _new_RelinkableQuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandle_linkToQuantLib" ;;
let _RelinkableQuoteHandle_linkTo arg = match _RelinkableQuoteHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableQuoteHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableQuoteHandleQuantLib" ;;
let _delete_RelinkableQuoteHandle arg = match _delete_RelinkableQuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpleQuote_f : c_obj list -> c_obj list = "_wrap_new_SimpleQuoteQuantLib" ;;
let _new_SimpleQuote arg = match _new_SimpleQuote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SimpleQuote_setValue_f : c_obj list -> c_obj list = "_wrap_SimpleQuote_setValueQuantLib" ;;
let _SimpleQuote_setValue arg = match _SimpleQuote_setValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpleQuote_f : c_obj list -> c_obj list = "_wrap_delete_SimpleQuoteQuantLib" ;;
let _delete_SimpleQuote arg = match _delete_SimpleQuote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVector__SWIG_0QuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVector__SWIG_1QuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVector__SWIG_2QuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVectorQuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_size_f : c_obj list -> c_obj list = "_wrap_QuoteVector_sizeQuantLib" ;;
let _QuoteVector_size arg = match _QuoteVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_empty_f : c_obj list -> c_obj list = "_wrap_QuoteVector_emptyQuantLib" ;;
let _QuoteVector_empty arg = match _QuoteVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_clear_f : c_obj list -> c_obj list = "_wrap_QuoteVector_clearQuantLib" ;;
let _QuoteVector_clear arg = match _QuoteVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_push_back_f : c_obj list -> c_obj list = "_wrap_QuoteVector_push_backQuantLib" ;;
let _QuoteVector_push_back arg = match _QuoteVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_QuoteVector_operator_bB___QuantLib" ;;
let _QuoteVector_operator_xx_xx_lbrace_xx_rbrace arg = match _QuoteVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_QuoteVector_operator_e___QuantLib" ;;
let _QuoteVector_operator_xx_xx_equals arg = match _QuoteVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_set_f : c_obj list -> c_obj list = "_wrap_QuoteVector_setQuantLib" ;;
let _QuoteVector_set arg = match _QuoteVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_to_array_f : c_obj list -> c_obj list = "_wrap_QuoteVector_to_arrayQuantLib" ;;
let _QuoteVector_to_array arg = match _QuoteVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteVector_f : c_obj list -> c_obj list = "_wrap_delete_QuoteVectorQuantLib" ;;
let _delete_QuoteVector arg = match _delete_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVector__SWIG_0QuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVector__SWIG_1QuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVector__SWIG_2QuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVectorQuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_size_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_sizeQuantLib" ;;
let _QuoteHandleVector_size arg = match _QuoteHandleVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_empty_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_emptyQuantLib" ;;
let _QuoteHandleVector_empty arg = match _QuoteHandleVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_clear_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_clearQuantLib" ;;
let _QuoteHandleVector_clear arg = match _QuoteHandleVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_push_back_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_push_backQuantLib" ;;
let _QuoteHandleVector_push_back arg = match _QuoteHandleVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_operator_bB___QuantLib" ;;
let _QuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace arg = match _QuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_operator_e___QuantLib" ;;
let _QuoteHandleVector_operator_xx_xx_equals arg = match _QuoteHandleVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_set_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_setQuantLib" ;;
let _QuoteHandleVector_set arg = match _QuoteHandleVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_to_array_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_to_arrayQuantLib" ;;
let _QuoteHandleVector_to_array arg = match _QuoteHandleVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_delete_QuoteHandleVectorQuantLib" ;;
let _delete_QuoteHandleVector arg = match _delete_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVector__SWIG_0QuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVector__SWIG_1QuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVector__SWIG_2QuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVectorQuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_size_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_sizeQuantLib" ;;
let _RelinkableQuoteHandleVector_size arg = match _RelinkableQuoteHandleVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_empty_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_emptyQuantLib" ;;
let _RelinkableQuoteHandleVector_empty arg = match _RelinkableQuoteHandleVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_clear_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_clearQuantLib" ;;
let _RelinkableQuoteHandleVector_clear arg = match _RelinkableQuoteHandleVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_push_back_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_push_backQuantLib" ;;
let _RelinkableQuoteHandleVector_push_back arg = match _RelinkableQuoteHandleVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_operator_bB___QuantLib" ;;
let _RelinkableQuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace arg = match _RelinkableQuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_operator_e___QuantLib" ;;
let _RelinkableQuoteHandleVector_operator_xx_xx_equals arg = match _RelinkableQuoteHandleVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_set_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_setQuantLib" ;;
let _RelinkableQuoteHandleVector_set arg = match _RelinkableQuoteHandleVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_to_array_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_to_arrayQuantLib" ;;
let _RelinkableQuoteHandleVector_to_array arg = match _RelinkableQuoteHandleVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableQuoteHandleVectorQuantLib" ;;
let _delete_RelinkableQuoteHandleVector arg = match _delete_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _nullInt_f : c_obj list -> c_obj list = "_wrap_nullIntQuantLib" ;;
let _nullInt arg = match _nullInt_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _nullDouble_f : c_obj list -> c_obj list = "_wrap_nullDoubleQuantLib" ;;
let _nullDouble arg = match _nullDouble_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_dayCount_f : c_obj list -> c_obj list = "_wrap_DayCounter_dayCountQuantLib" ;;
let _DayCounter_dayCount arg = match _DayCounter_dayCount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_yearFraction_f : c_obj list -> c_obj list = "_wrap_DayCounter_yearFraction__SWIG_0QuantLib" ;;
let _DayCounter_yearFraction arg = match _DayCounter_yearFraction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_yearFraction_f : c_obj list -> c_obj list = "_wrap_DayCounter_yearFraction__SWIG_1QuantLib" ;;
let _DayCounter_yearFraction arg = match _DayCounter_yearFraction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_yearFraction_f : c_obj list -> c_obj list = "_wrap_DayCounter_yearFractionQuantLib" ;;
let _DayCounter_yearFraction arg = match _DayCounter_yearFraction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter___str___f : c_obj list -> c_obj list = "_wrap_DayCounter___str__QuantLib" ;;
let _DayCounter___str__ arg = match _DayCounter___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DayCounter_f : c_obj list -> c_obj list = "_wrap_delete_DayCounterQuantLib" ;;
let _delete_DayCounter arg = match _delete_DayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Actual360_f : c_obj list -> c_obj list = "_wrap_new_Actual360QuantLib" ;;
let _new_Actual360 arg = match _new_Actual360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Actual360_f : c_obj list -> c_obj list = "_wrap_delete_Actual360QuantLib" ;;
let _delete_Actual360 arg = match _delete_Actual360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Actual365Fixed_f : c_obj list -> c_obj list = "_wrap_new_Actual365FixedQuantLib" ;;
let _new_Actual365Fixed arg = match _new_Actual365Fixed_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Actual365Fixed_f : c_obj list -> c_obj list = "_wrap_delete_Actual365FixedQuantLib" ;;
let _delete_Actual365Fixed arg = match _delete_Actual365Fixed_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Thirty360::Convention_marker" (`Convention)
external _USA : c_obj -> Swig.c_obj = "_wrap_USA" 
external _BondBasis : c_obj -> Swig.c_obj = "_wrap_BondBasis" 
external _European : c_obj -> Swig.c_obj = "_wrap_European" 
external _EurobondBasis : c_obj -> Swig.c_obj = "_wrap_EurobondBasis" 
external _Italian : c_obj -> Swig.c_obj = "_wrap_Italian" 
external _new_Thirty360_f : c_obj list -> c_obj list = "_wrap_new_Thirty360__SWIG_0QuantLib" ;;
let _new_Thirty360 arg = match _new_Thirty360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Thirty360_f : c_obj list -> c_obj list = "_wrap_new_Thirty360QuantLib" ;;
let _new_Thirty360 arg = match _new_Thirty360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Thirty360_f : c_obj list -> c_obj list = "_wrap_delete_Thirty360QuantLib" ;;
let _delete_Thirty360 arg = match _delete_Thirty360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::ActualActual::Convention_marker" (`Convention)
external _ISMA : c_obj -> Swig.c_obj = "_wrap_ISMA" 
external _Bond : c_obj -> Swig.c_obj = "_wrap_Bond" 
external _ISDA : c_obj -> Swig.c_obj = "_wrap_ISDA" 
external _Historical : c_obj -> Swig.c_obj = "_wrap_Historical" 
external _Actual365 : c_obj -> Swig.c_obj = "_wrap_Actual365" 
external _AFB : c_obj -> Swig.c_obj = "_wrap_AFB" 
external _Euro : c_obj -> Swig.c_obj = "_wrap_Euro" 
external _new_ActualActual_f : c_obj list -> c_obj list = "_wrap_new_ActualActual__SWIG_0QuantLib" ;;
let _new_ActualActual arg = match _new_ActualActual_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ActualActual_f : c_obj list -> c_obj list = "_wrap_new_ActualActualQuantLib" ;;
let _new_ActualActual arg = match _new_ActualActual_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ActualActual_f : c_obj list -> c_obj list = "_wrap_delete_ActualActualQuantLib" ;;
let _delete_ActualActual arg = match _delete_ActualActual_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OneDayCounter_f : c_obj list -> c_obj list = "_wrap_new_OneDayCounterQuantLib" ;;
let _new_OneDayCounter arg = match _new_OneDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_OneDayCounter_f : c_obj list -> c_obj list = "_wrap_delete_OneDayCounterQuantLib" ;;
let _delete_OneDayCounter arg = match _delete_OneDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpleDayCounter_f : c_obj list -> c_obj list = "_wrap_new_SimpleDayCounterQuantLib" ;;
let _new_SimpleDayCounter arg = match _new_SimpleDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpleDayCounter_f : c_obj list -> c_obj list = "_wrap_delete_SimpleDayCounterQuantLib" ;;
let _delete_SimpleDayCounter arg = match _delete_SimpleDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Compounding_marker" (`Compounding)
external _Simple : c_obj -> Swig.c_obj = "_wrap_Simple" 
external _Compounded : c_obj -> Swig.c_obj = "_wrap_Compounded" 
external _Continuous : c_obj -> Swig.c_obj = "_wrap_Continuous" 
external _SimpleThenCompounded : c_obj -> Swig.c_obj = "_wrap_SimpleThenCompounded" 
external _new_InterestRate_f : c_obj list -> c_obj list = "_wrap_new_InterestRate__SWIG_0QuantLib" ;;
let _new_InterestRate arg = match _new_InterestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InterestRate_f : c_obj list -> c_obj list = "_wrap_new_InterestRate__SWIG_1QuantLib" ;;
let _new_InterestRate arg = match _new_InterestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InterestRate_f : c_obj list -> c_obj list = "_wrap_new_InterestRateQuantLib" ;;
let _new_InterestRate arg = match _new_InterestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_rate_f : c_obj list -> c_obj list = "_wrap_InterestRate_rateQuantLib" ;;
let _InterestRate_rate arg = match _InterestRate_rate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_dayCounter_f : c_obj list -> c_obj list = "_wrap_InterestRate_dayCounterQuantLib" ;;
let _InterestRate_dayCounter arg = match _InterestRate_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compounding_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundingQuantLib" ;;
let _InterestRate_compounding arg = match _InterestRate_compounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_frequency_f : c_obj list -> c_obj list = "_wrap_InterestRate_frequencyQuantLib" ;;
let _InterestRate_frequency arg = match _InterestRate_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_discountFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_discountFactor__SWIG_0QuantLib" ;;
let _InterestRate_discountFactor arg = match _InterestRate_discountFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_discountFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_discountFactorQuantLib" ;;
let _InterestRate_discountFactor arg = match _InterestRate_discountFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compoundFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundFactor__SWIG_0QuantLib" ;;
let _InterestRate_compoundFactor arg = match _InterestRate_compoundFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compoundFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundFactorQuantLib" ;;
let _InterestRate_compoundFactor arg = match _InterestRate_compoundFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRate__SWIG_0QuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRate__SWIG_1QuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRate__SWIG_2QuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRateQuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRate__SWIG_0QuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRate__SWIG_1QuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRate__SWIG_2QuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRateQuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate___str___f : c_obj list -> c_obj list = "_wrap_InterestRate___str__QuantLib" ;;
let _InterestRate___str__ arg = match _InterestRate___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InterestRate_f : c_obj list -> c_obj list = "_wrap_delete_InterestRateQuantLib" ;;
let _delete_InterestRate arg = match _delete_InterestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "BusinessDayConvention_marker" (`BusinessDayConvention)
external _Following : c_obj -> Swig.c_obj = "_wrap_Following" 
external _ModifiedFollowing : c_obj -> Swig.c_obj = "_wrap_ModifiedFollowing" 
external _Preceding : c_obj -> Swig.c_obj = "_wrap_Preceding" 
external _ModifiedPreceding : c_obj -> Swig.c_obj = "_wrap_ModifiedPreceding" 
external _Unadjusted : c_obj -> Swig.c_obj = "_wrap_Unadjusted" 
let _ = Callback.register "JointCalendarRule_marker" (`JointCalendarRule)
external _JoinHolidays : c_obj -> Swig.c_obj = "_wrap_JoinHolidays" 
external _JoinBusinessDays : c_obj -> Swig.c_obj = "_wrap_JoinBusinessDays" 
external _Calendar_isBusinessDay_f : c_obj list -> c_obj list = "_wrap_Calendar_isBusinessDayQuantLib" ;;
let _Calendar_isBusinessDay arg = match _Calendar_isBusinessDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_isHoliday_f : c_obj list -> c_obj list = "_wrap_Calendar_isHolidayQuantLib" ;;
let _Calendar_isHoliday arg = match _Calendar_isHoliday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_isEndOfMonth_f : c_obj list -> c_obj list = "_wrap_Calendar_isEndOfMonthQuantLib" ;;
let _Calendar_isEndOfMonth arg = match _Calendar_isEndOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_addHoliday_f : c_obj list -> c_obj list = "_wrap_Calendar_addHolidayQuantLib" ;;
let _Calendar_addHoliday arg = match _Calendar_addHoliday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_removeHoliday_f : c_obj list -> c_obj list = "_wrap_Calendar_removeHolidayQuantLib" ;;
let _Calendar_removeHoliday arg = match _Calendar_removeHoliday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_adjust_f : c_obj list -> c_obj list = "_wrap_Calendar_adjust__SWIG_0QuantLib" ;;
let _Calendar_adjust arg = match _Calendar_adjust_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_adjust_f : c_obj list -> c_obj list = "_wrap_Calendar_adjustQuantLib" ;;
let _Calendar_adjust arg = match _Calendar_adjust_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_0QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_1QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_2QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_3QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_4QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advanceQuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_businessDaysBetween_f : c_obj list -> c_obj list = "_wrap_Calendar_businessDaysBetween__SWIG_0QuantLib" ;;
let _Calendar_businessDaysBetween arg = match _Calendar_businessDaysBetween_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_businessDaysBetween_f : c_obj list -> c_obj list = "_wrap_Calendar_businessDaysBetween__SWIG_1QuantLib" ;;
let _Calendar_businessDaysBetween arg = match _Calendar_businessDaysBetween_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_businessDaysBetween_f : c_obj list -> c_obj list = "_wrap_Calendar_businessDaysBetweenQuantLib" ;;
let _Calendar_businessDaysBetween arg = match _Calendar_businessDaysBetween_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar___str___f : c_obj list -> c_obj list = "_wrap_Calendar___str__QuantLib" ;;
let _Calendar___str__ arg = match _Calendar___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Calendar_f : c_obj list -> c_obj list = "_wrap_delete_CalendarQuantLib" ;;
let _delete_Calendar arg = match _delete_Calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Argentina::Market_marker" (`Market)
external _Merval : c_obj -> Swig.c_obj = "_wrap_Merval" 
external _new_Argentina_f : c_obj list -> c_obj list = "_wrap_new_Argentina__SWIG_0QuantLib" ;;
let _new_Argentina arg = match _new_Argentina_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Argentina_f : c_obj list -> c_obj list = "_wrap_new_ArgentinaQuantLib" ;;
let _new_Argentina arg = match _new_Argentina_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Argentina_f : c_obj list -> c_obj list = "_wrap_delete_ArgentinaQuantLib" ;;
let _delete_Argentina arg = match _delete_Argentina_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Australia_f : c_obj list -> c_obj list = "_wrap_new_AustraliaQuantLib" ;;
let _new_Australia arg = match _new_Australia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Australia_f : c_obj list -> c_obj list = "_wrap_delete_AustraliaQuantLib" ;;
let _delete_Australia arg = match _delete_Australia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Brazil::Market_marker" (`Market)
external _Settlement : c_obj -> Swig.c_obj = "_wrap_Settlement" 
external _new_Brazil_f : c_obj list -> c_obj list = "_wrap_new_Brazil__SWIG_0QuantLib" ;;
let _new_Brazil arg = match _new_Brazil_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Brazil_f : c_obj list -> c_obj list = "_wrap_new_BrazilQuantLib" ;;
let _new_Brazil arg = match _new_Brazil_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Brazil_f : c_obj list -> c_obj list = "_wrap_delete_BrazilQuantLib" ;;
let _delete_Brazil arg = match _delete_Brazil_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Canada_f : c_obj list -> c_obj list = "_wrap_new_CanadaQuantLib" ;;
let _new_Canada arg = match _new_Canada_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Canada_f : c_obj list -> c_obj list = "_wrap_delete_CanadaQuantLib" ;;
let _delete_Canada arg = match _delete_Canada_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_China_f : c_obj list -> c_obj list = "_wrap_new_ChinaQuantLib" ;;
let _new_China arg = match _new_China_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_China_f : c_obj list -> c_obj list = "_wrap_delete_ChinaQuantLib" ;;
let _delete_China arg = match _delete_China_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::CzechRepublic::Market_marker" (`Market)
external _PSE : c_obj -> Swig.c_obj = "_wrap_PSE" 
external _new_CzechRepublic_f : c_obj list -> c_obj list = "_wrap_new_CzechRepublic__SWIG_0QuantLib" ;;
let _new_CzechRepublic arg = match _new_CzechRepublic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CzechRepublic_f : c_obj list -> c_obj list = "_wrap_new_CzechRepublicQuantLib" ;;
let _new_CzechRepublic arg = match _new_CzechRepublic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CzechRepublic_f : c_obj list -> c_obj list = "_wrap_delete_CzechRepublicQuantLib" ;;
let _delete_CzechRepublic arg = match _delete_CzechRepublic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Denmark_f : c_obj list -> c_obj list = "_wrap_new_DenmarkQuantLib" ;;
let _new_Denmark arg = match _new_Denmark_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Denmark_f : c_obj list -> c_obj list = "_wrap_delete_DenmarkQuantLib" ;;
let _delete_Denmark arg = match _delete_Denmark_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Finland_f : c_obj list -> c_obj list = "_wrap_new_FinlandQuantLib" ;;
let _new_Finland arg = match _new_Finland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Finland_f : c_obj list -> c_obj list = "_wrap_delete_FinlandQuantLib" ;;
let _delete_Finland arg = match _delete_Finland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Germany::Market_marker" (`Market)
external _FrankfurtStockExchange : c_obj -> Swig.c_obj = "_wrap_FrankfurtStockExchange" 
external _Xetra : c_obj -> Swig.c_obj = "_wrap_Xetra" 
external _Eurex : c_obj -> Swig.c_obj = "_wrap_Eurex" 
external _new_Germany_f : c_obj list -> c_obj list = "_wrap_new_Germany__SWIG_0QuantLib" ;;
let _new_Germany arg = match _new_Germany_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Germany_f : c_obj list -> c_obj list = "_wrap_new_GermanyQuantLib" ;;
let _new_Germany arg = match _new_Germany_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Germany_f : c_obj list -> c_obj list = "_wrap_delete_GermanyQuantLib" ;;
let _delete_Germany arg = match _delete_Germany_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::HongKong::Market_marker" (`Market)
external _HKEx : c_obj -> Swig.c_obj = "_wrap_HKEx" 
external _new_HongKong_f : c_obj list -> c_obj list = "_wrap_new_HongKong__SWIG_0QuantLib" ;;
let _new_HongKong arg = match _new_HongKong_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HongKong_f : c_obj list -> c_obj list = "_wrap_new_HongKongQuantLib" ;;
let _new_HongKong arg = match _new_HongKong_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HongKong_f : c_obj list -> c_obj list = "_wrap_delete_HongKongQuantLib" ;;
let _delete_HongKong arg = match _delete_HongKong_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Hungary_f : c_obj list -> c_obj list = "_wrap_new_HungaryQuantLib" ;;
let _new_Hungary arg = match _new_Hungary_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Hungary_f : c_obj list -> c_obj list = "_wrap_delete_HungaryQuantLib" ;;
let _delete_Hungary arg = match _delete_Hungary_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Iceland::Market_marker" (`Market)
external _ICEX : c_obj -> Swig.c_obj = "_wrap_ICEX" 
external _new_Iceland_f : c_obj list -> c_obj list = "_wrap_new_Iceland__SWIG_0QuantLib" ;;
let _new_Iceland arg = match _new_Iceland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Iceland_f : c_obj list -> c_obj list = "_wrap_new_IcelandQuantLib" ;;
let _new_Iceland arg = match _new_Iceland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Iceland_f : c_obj list -> c_obj list = "_wrap_delete_IcelandQuantLib" ;;
let _delete_Iceland arg = match _delete_Iceland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::India::Market_marker" (`Market)
external _NSE : c_obj -> Swig.c_obj = "_wrap_NSE" 
external _new_India_f : c_obj list -> c_obj list = "_wrap_new_India__SWIG_0QuantLib" ;;
let _new_India arg = match _new_India_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_India_f : c_obj list -> c_obj list = "_wrap_new_IndiaQuantLib" ;;
let _new_India arg = match _new_India_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_India_f : c_obj list -> c_obj list = "_wrap_delete_IndiaQuantLib" ;;
let _delete_India arg = match _delete_India_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Indonesia::Market_marker" (`Market)
external _BEJ : c_obj -> Swig.c_obj = "_wrap_BEJ" 
external _JSX : c_obj -> Swig.c_obj = "_wrap_JSX" 
external _new_Indonesia_f : c_obj list -> c_obj list = "_wrap_new_Indonesia__SWIG_0QuantLib" ;;
let _new_Indonesia arg = match _new_Indonesia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Indonesia_f : c_obj list -> c_obj list = "_wrap_new_IndonesiaQuantLib" ;;
let _new_Indonesia arg = match _new_Indonesia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Indonesia_f : c_obj list -> c_obj list = "_wrap_delete_IndonesiaQuantLib" ;;
let _delete_Indonesia arg = match _delete_Indonesia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Italy::Market_marker" (`Market)
external _Exchange : c_obj -> Swig.c_obj = "_wrap_Exchange" 
external _new_Italy_f : c_obj list -> c_obj list = "_wrap_new_Italy__SWIG_0QuantLib" ;;
let _new_Italy arg = match _new_Italy_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Italy_f : c_obj list -> c_obj list = "_wrap_new_ItalyQuantLib" ;;
let _new_Italy arg = match _new_Italy_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Italy_f : c_obj list -> c_obj list = "_wrap_delete_ItalyQuantLib" ;;
let _delete_Italy arg = match _delete_Italy_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Japan_f : c_obj list -> c_obj list = "_wrap_new_JapanQuantLib" ;;
let _new_Japan arg = match _new_Japan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Japan_f : c_obj list -> c_obj list = "_wrap_delete_JapanQuantLib" ;;
let _delete_Japan arg = match _delete_Japan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Mexico::Market_marker" (`Market)
external _BMV : c_obj -> Swig.c_obj = "_wrap_BMV" 
external _new_Mexico_f : c_obj list -> c_obj list = "_wrap_new_Mexico__SWIG_0QuantLib" ;;
let _new_Mexico arg = match _new_Mexico_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Mexico_f : c_obj list -> c_obj list = "_wrap_new_MexicoQuantLib" ;;
let _new_Mexico arg = match _new_Mexico_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Mexico_f : c_obj list -> c_obj list = "_wrap_delete_MexicoQuantLib" ;;
let _delete_Mexico arg = match _delete_Mexico_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NewZealand_f : c_obj list -> c_obj list = "_wrap_new_NewZealandQuantLib" ;;
let _new_NewZealand arg = match _new_NewZealand_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NewZealand_f : c_obj list -> c_obj list = "_wrap_delete_NewZealandQuantLib" ;;
let _delete_NewZealand arg = match _delete_NewZealand_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Norway_f : c_obj list -> c_obj list = "_wrap_new_NorwayQuantLib" ;;
let _new_Norway arg = match _new_Norway_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Norway_f : c_obj list -> c_obj list = "_wrap_delete_NorwayQuantLib" ;;
let _delete_Norway arg = match _delete_Norway_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Poland_f : c_obj list -> c_obj list = "_wrap_new_PolandQuantLib" ;;
let _new_Poland arg = match _new_Poland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Poland_f : c_obj list -> c_obj list = "_wrap_delete_PolandQuantLib" ;;
let _delete_Poland arg = match _delete_Poland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::SaudiArabia::Market_marker" (`Market)
external _Tadawul : c_obj -> Swig.c_obj = "_wrap_Tadawul" 
external _new_SaudiArabia_f : c_obj list -> c_obj list = "_wrap_new_SaudiArabia__SWIG_0QuantLib" ;;
let _new_SaudiArabia arg = match _new_SaudiArabia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SaudiArabia_f : c_obj list -> c_obj list = "_wrap_new_SaudiArabiaQuantLib" ;;
let _new_SaudiArabia arg = match _new_SaudiArabia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SaudiArabia_f : c_obj list -> c_obj list = "_wrap_delete_SaudiArabiaQuantLib" ;;
let _delete_SaudiArabia arg = match _delete_SaudiArabia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Singapore::Market_marker" (`Market)
external _SGX : c_obj -> Swig.c_obj = "_wrap_SGX" 
external _new_Singapore_f : c_obj list -> c_obj list = "_wrap_new_Singapore__SWIG_0QuantLib" ;;
let _new_Singapore arg = match _new_Singapore_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Singapore_f : c_obj list -> c_obj list = "_wrap_new_SingaporeQuantLib" ;;
let _new_Singapore arg = match _new_Singapore_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Singapore_f : c_obj list -> c_obj list = "_wrap_delete_SingaporeQuantLib" ;;
let _delete_Singapore arg = match _delete_Singapore_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Slovakia::Market_marker" (`Market)
external _BSSE : c_obj -> Swig.c_obj = "_wrap_BSSE" 
external _new_Slovakia_f : c_obj list -> c_obj list = "_wrap_new_Slovakia__SWIG_0QuantLib" ;;
let _new_Slovakia arg = match _new_Slovakia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Slovakia_f : c_obj list -> c_obj list = "_wrap_new_SlovakiaQuantLib" ;;
let _new_Slovakia arg = match _new_Slovakia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Slovakia_f : c_obj list -> c_obj list = "_wrap_delete_SlovakiaQuantLib" ;;
let _delete_Slovakia arg = match _delete_Slovakia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SouthAfrica_f : c_obj list -> c_obj list = "_wrap_new_SouthAfricaQuantLib" ;;
let _new_SouthAfrica arg = match _new_SouthAfrica_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SouthAfrica_f : c_obj list -> c_obj list = "_wrap_delete_SouthAfricaQuantLib" ;;
let _delete_SouthAfrica arg = match _delete_SouthAfrica_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::SouthKorea::Market_marker" (`Market)
external _KRX : c_obj -> Swig.c_obj = "_wrap_KRX" 
external _new_SouthKorea_f : c_obj list -> c_obj list = "_wrap_new_SouthKorea__SWIG_0QuantLib" ;;
let _new_SouthKorea arg = match _new_SouthKorea_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SouthKorea_f : c_obj list -> c_obj list = "_wrap_new_SouthKoreaQuantLib" ;;
let _new_SouthKorea arg = match _new_SouthKorea_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SouthKorea_f : c_obj list -> c_obj list = "_wrap_delete_SouthKoreaQuantLib" ;;
let _delete_SouthKorea arg = match _delete_SouthKorea_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Sweden_f : c_obj list -> c_obj list = "_wrap_new_SwedenQuantLib" ;;
let _new_Sweden arg = match _new_Sweden_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Sweden_f : c_obj list -> c_obj list = "_wrap_delete_SwedenQuantLib" ;;
let _delete_Sweden arg = match _delete_Sweden_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Switzerland_f : c_obj list -> c_obj list = "_wrap_new_SwitzerlandQuantLib" ;;
let _new_Switzerland arg = match _new_Switzerland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Switzerland_f : c_obj list -> c_obj list = "_wrap_delete_SwitzerlandQuantLib" ;;
let _delete_Switzerland arg = match _delete_Switzerland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Taiwan::Market_marker" (`Market)
external _TSEC : c_obj -> Swig.c_obj = "_wrap_TSEC" 
external _new_Taiwan_f : c_obj list -> c_obj list = "_wrap_new_Taiwan__SWIG_0QuantLib" ;;
let _new_Taiwan arg = match _new_Taiwan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Taiwan_f : c_obj list -> c_obj list = "_wrap_new_TaiwanQuantLib" ;;
let _new_Taiwan arg = match _new_Taiwan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Taiwan_f : c_obj list -> c_obj list = "_wrap_delete_TaiwanQuantLib" ;;
let _delete_Taiwan arg = match _delete_Taiwan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TARGET_f : c_obj list -> c_obj list = "_wrap_new_TARGETQuantLib" ;;
let _new_TARGET arg = match _new_TARGET_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TARGET_f : c_obj list -> c_obj list = "_wrap_delete_TARGETQuantLib" ;;
let _delete_TARGET arg = match _delete_TARGET_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Turkey_f : c_obj list -> c_obj list = "_wrap_new_TurkeyQuantLib" ;;
let _new_Turkey arg = match _new_Turkey_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Turkey_f : c_obj list -> c_obj list = "_wrap_delete_TurkeyQuantLib" ;;
let _delete_Turkey arg = match _delete_Turkey_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Ukraine::Market_marker" (`Market)
external _USE : c_obj -> Swig.c_obj = "_wrap_USE" 
external _new_Ukraine_f : c_obj list -> c_obj list = "_wrap_new_Ukraine__SWIG_0QuantLib" ;;
let _new_Ukraine arg = match _new_Ukraine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Ukraine_f : c_obj list -> c_obj list = "_wrap_new_UkraineQuantLib" ;;
let _new_Ukraine arg = match _new_Ukraine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Ukraine_f : c_obj list -> c_obj list = "_wrap_delete_UkraineQuantLib" ;;
let _delete_Ukraine arg = match _delete_Ukraine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::UnitedKingdom::Market_marker" (`Market)
external _Metals : c_obj -> Swig.c_obj = "_wrap_Metals" 
external _new_UnitedKingdom_f : c_obj list -> c_obj list = "_wrap_new_UnitedKingdom__SWIG_0QuantLib" ;;
let _new_UnitedKingdom arg = match _new_UnitedKingdom_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnitedKingdom_f : c_obj list -> c_obj list = "_wrap_new_UnitedKingdomQuantLib" ;;
let _new_UnitedKingdom arg = match _new_UnitedKingdom_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UnitedKingdom_f : c_obj list -> c_obj list = "_wrap_delete_UnitedKingdomQuantLib" ;;
let _delete_UnitedKingdom arg = match _delete_UnitedKingdom_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::UnitedStates::Market_marker" (`Market)
external _NYSE : c_obj -> Swig.c_obj = "_wrap_NYSE" 
external _GovernmentBond : c_obj -> Swig.c_obj = "_wrap_GovernmentBond" 
external _NERC : c_obj -> Swig.c_obj = "_wrap_NERC" 
external _new_UnitedStates_f : c_obj list -> c_obj list = "_wrap_new_UnitedStates__SWIG_0QuantLib" ;;
let _new_UnitedStates arg = match _new_UnitedStates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnitedStates_f : c_obj list -> c_obj list = "_wrap_new_UnitedStatesQuantLib" ;;
let _new_UnitedStates arg = match _new_UnitedStates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UnitedStates_f : c_obj list -> c_obj list = "_wrap_delete_UnitedStatesQuantLib" ;;
let _delete_UnitedStates arg = match _delete_UnitedStates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NullCalendar_f : c_obj list -> c_obj list = "_wrap_new_NullCalendarQuantLib" ;;
let _new_NullCalendar arg = match _new_NullCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NullCalendar_f : c_obj list -> c_obj list = "_wrap_delete_NullCalendarQuantLib" ;;
let _delete_NullCalendar arg = match _delete_NullCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_0QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_1QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_2QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_3QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_4QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendarQuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_JointCalendar_f : c_obj list -> c_obj list = "_wrap_delete_JointCalendarQuantLib" ;;
let _delete_JointCalendar arg = match _delete_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Rounding_f : c_obj list -> c_obj list = "_wrap_new_RoundingQuantLib" ;;
let _new_Rounding arg = match _new_Rounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Rounding_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_Rounding_operator_pP___QuantLib" ;;
let _Rounding_operator_xx_xx_lparen_xx_rparen arg = match _Rounding_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Rounding_f : c_obj list -> c_obj list = "_wrap_delete_RoundingQuantLib" ;;
let _delete_Rounding arg = match _delete_Rounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpRounding_f : c_obj list -> c_obj list = "_wrap_new_UpRounding__SWIG_0QuantLib" ;;
let _new_UpRounding arg = match _new_UpRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpRounding_f : c_obj list -> c_obj list = "_wrap_new_UpRoundingQuantLib" ;;
let _new_UpRounding arg = match _new_UpRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UpRounding_f : c_obj list -> c_obj list = "_wrap_delete_UpRoundingQuantLib" ;;
let _delete_UpRounding arg = match _delete_UpRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DownRounding_f : c_obj list -> c_obj list = "_wrap_new_DownRounding__SWIG_0QuantLib" ;;
let _new_DownRounding arg = match _new_DownRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DownRounding_f : c_obj list -> c_obj list = "_wrap_new_DownRoundingQuantLib" ;;
let _new_DownRounding arg = match _new_DownRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DownRounding_f : c_obj list -> c_obj list = "_wrap_delete_DownRoundingQuantLib" ;;
let _delete_DownRounding arg = match _delete_DownRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ClosestRounding_f : c_obj list -> c_obj list = "_wrap_new_ClosestRounding__SWIG_0QuantLib" ;;
let _new_ClosestRounding arg = match _new_ClosestRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ClosestRounding_f : c_obj list -> c_obj list = "_wrap_new_ClosestRoundingQuantLib" ;;
let _new_ClosestRounding arg = match _new_ClosestRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ClosestRounding_f : c_obj list -> c_obj list = "_wrap_delete_ClosestRoundingQuantLib" ;;
let _delete_ClosestRounding arg = match _delete_ClosestRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CeilingTruncation_f : c_obj list -> c_obj list = "_wrap_new_CeilingTruncation__SWIG_0QuantLib" ;;
let _new_CeilingTruncation arg = match _new_CeilingTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CeilingTruncation_f : c_obj list -> c_obj list = "_wrap_new_CeilingTruncationQuantLib" ;;
let _new_CeilingTruncation arg = match _new_CeilingTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CeilingTruncation_f : c_obj list -> c_obj list = "_wrap_delete_CeilingTruncationQuantLib" ;;
let _delete_CeilingTruncation arg = match _delete_CeilingTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloorTruncation_f : c_obj list -> c_obj list = "_wrap_new_FloorTruncation__SWIG_0QuantLib" ;;
let _new_FloorTruncation arg = match _new_FloorTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloorTruncation_f : c_obj list -> c_obj list = "_wrap_new_FloorTruncationQuantLib" ;;
let _new_FloorTruncation arg = match _new_FloorTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FloorTruncation_f : c_obj list -> c_obj list = "_wrap_delete_FloorTruncationQuantLib" ;;
let _delete_FloorTruncation arg = match _delete_FloorTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_name_f : c_obj list -> c_obj list = "_wrap_Currency_nameQuantLib" ;;
let _Currency_name arg = match _Currency_name_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_code_f : c_obj list -> c_obj list = "_wrap_Currency_codeQuantLib" ;;
let _Currency_code arg = match _Currency_code_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_numericCode_f : c_obj list -> c_obj list = "_wrap_Currency_numericCodeQuantLib" ;;
let _Currency_numericCode arg = match _Currency_numericCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_symbol_f : c_obj list -> c_obj list = "_wrap_Currency_symbolQuantLib" ;;
let _Currency_symbol arg = match _Currency_symbol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_fractionSymbol_f : c_obj list -> c_obj list = "_wrap_Currency_fractionSymbolQuantLib" ;;
let _Currency_fractionSymbol arg = match _Currency_fractionSymbol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_fractionsPerUnit_f : c_obj list -> c_obj list = "_wrap_Currency_fractionsPerUnitQuantLib" ;;
let _Currency_fractionsPerUnit arg = match _Currency_fractionsPerUnit_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_rounding_f : c_obj list -> c_obj list = "_wrap_Currency_roundingQuantLib" ;;
let _Currency_rounding arg = match _Currency_rounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_format_f : c_obj list -> c_obj list = "_wrap_Currency_formatQuantLib" ;;
let _Currency_format arg = match _Currency_format_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_empty_f : c_obj list -> c_obj list = "_wrap_Currency_emptyQuantLib" ;;
let _Currency_empty arg = match _Currency_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_triangulationCurrency_f : c_obj list -> c_obj list = "_wrap_Currency_triangulationCurrencyQuantLib" ;;
let _Currency_triangulationCurrency arg = match _Currency_triangulationCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency___str___f : c_obj list -> c_obj list = "_wrap_Currency___str__QuantLib" ;;
let _Currency___str__ arg = match _Currency___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Currency_f : c_obj list -> c_obj list = "_wrap_new_CurrencyQuantLib" ;;
let _new_Currency arg = match _new_Currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Currency_f : c_obj list -> c_obj list = "_wrap_delete_CurrencyQuantLib" ;;
let _delete_Currency arg = match _delete_Currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ARSCurrency_f : c_obj list -> c_obj list = "_wrap_new_ARSCurrencyQuantLib" ;;
let _new_ARSCurrency arg = match _new_ARSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ARSCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ARSCurrencyQuantLib" ;;
let _delete_ARSCurrency arg = match _delete_ARSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ATSCurrency_f : c_obj list -> c_obj list = "_wrap_new_ATSCurrencyQuantLib" ;;
let _new_ATSCurrency arg = match _new_ATSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ATSCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ATSCurrencyQuantLib" ;;
let _delete_ATSCurrency arg = match _delete_ATSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AUDCurrency_f : c_obj list -> c_obj list = "_wrap_new_AUDCurrencyQuantLib" ;;
let _new_AUDCurrency arg = match _new_AUDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AUDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_AUDCurrencyQuantLib" ;;
let _delete_AUDCurrency arg = match _delete_AUDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BDTCurrency_f : c_obj list -> c_obj list = "_wrap_new_BDTCurrencyQuantLib" ;;
let _new_BDTCurrency arg = match _new_BDTCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BDTCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BDTCurrencyQuantLib" ;;
let _delete_BDTCurrency arg = match _delete_BDTCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BEFCurrency_f : c_obj list -> c_obj list = "_wrap_new_BEFCurrencyQuantLib" ;;
let _new_BEFCurrency arg = match _new_BEFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BEFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BEFCurrencyQuantLib" ;;
let _delete_BEFCurrency arg = match _delete_BEFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BGLCurrency_f : c_obj list -> c_obj list = "_wrap_new_BGLCurrencyQuantLib" ;;
let _new_BGLCurrency arg = match _new_BGLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BGLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BGLCurrencyQuantLib" ;;
let _delete_BGLCurrency arg = match _delete_BGLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BRLCurrency_f : c_obj list -> c_obj list = "_wrap_new_BRLCurrencyQuantLib" ;;
let _new_BRLCurrency arg = match _new_BRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BRLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BRLCurrencyQuantLib" ;;
let _delete_BRLCurrency arg = match _delete_BRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BYRCurrency_f : c_obj list -> c_obj list = "_wrap_new_BYRCurrencyQuantLib" ;;
let _new_BYRCurrency arg = match _new_BYRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BYRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BYRCurrencyQuantLib" ;;
let _delete_BYRCurrency arg = match _delete_BYRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CADCurrency_f : c_obj list -> c_obj list = "_wrap_new_CADCurrencyQuantLib" ;;
let _new_CADCurrency arg = match _new_CADCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CADCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CADCurrencyQuantLib" ;;
let _delete_CADCurrency arg = match _delete_CADCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CHFCurrency_f : c_obj list -> c_obj list = "_wrap_new_CHFCurrencyQuantLib" ;;
let _new_CHFCurrency arg = match _new_CHFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CHFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CHFCurrencyQuantLib" ;;
let _delete_CHFCurrency arg = match _delete_CHFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CLPCurrency_f : c_obj list -> c_obj list = "_wrap_new_CLPCurrencyQuantLib" ;;
let _new_CLPCurrency arg = match _new_CLPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CLPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CLPCurrencyQuantLib" ;;
let _delete_CLPCurrency arg = match _delete_CLPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CNYCurrency_f : c_obj list -> c_obj list = "_wrap_new_CNYCurrencyQuantLib" ;;
let _new_CNYCurrency arg = match _new_CNYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CNYCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CNYCurrencyQuantLib" ;;
let _delete_CNYCurrency arg = match _delete_CNYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_COPCurrency_f : c_obj list -> c_obj list = "_wrap_new_COPCurrencyQuantLib" ;;
let _new_COPCurrency arg = match _new_COPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_COPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_COPCurrencyQuantLib" ;;
let _delete_COPCurrency arg = match _delete_COPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CYPCurrency_f : c_obj list -> c_obj list = "_wrap_new_CYPCurrencyQuantLib" ;;
let _new_CYPCurrency arg = match _new_CYPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CYPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CYPCurrencyQuantLib" ;;
let _delete_CYPCurrency arg = match _delete_CYPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CZKCurrency_f : c_obj list -> c_obj list = "_wrap_new_CZKCurrencyQuantLib" ;;
let _new_CZKCurrency arg = match _new_CZKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CZKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CZKCurrencyQuantLib" ;;
let _delete_CZKCurrency arg = match _delete_CZKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DEMCurrency_f : c_obj list -> c_obj list = "_wrap_new_DEMCurrencyQuantLib" ;;
let _new_DEMCurrency arg = match _new_DEMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DEMCurrency_f : c_obj list -> c_obj list = "_wrap_delete_DEMCurrencyQuantLib" ;;
let _delete_DEMCurrency arg = match _delete_DEMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DKKCurrency_f : c_obj list -> c_obj list = "_wrap_new_DKKCurrencyQuantLib" ;;
let _new_DKKCurrency arg = match _new_DKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DKKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_DKKCurrencyQuantLib" ;;
let _delete_DKKCurrency arg = match _delete_DKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EEKCurrency_f : c_obj list -> c_obj list = "_wrap_new_EEKCurrencyQuantLib" ;;
let _new_EEKCurrency arg = match _new_EEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EEKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_EEKCurrencyQuantLib" ;;
let _delete_EEKCurrency arg = match _delete_EEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ESPCurrency_f : c_obj list -> c_obj list = "_wrap_new_ESPCurrencyQuantLib" ;;
let _new_ESPCurrency arg = match _new_ESPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ESPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ESPCurrencyQuantLib" ;;
let _delete_ESPCurrency arg = match _delete_ESPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURCurrency_f : c_obj list -> c_obj list = "_wrap_new_EURCurrencyQuantLib" ;;
let _new_EURCurrency arg = match _new_EURCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURCurrency_f : c_obj list -> c_obj list = "_wrap_delete_EURCurrencyQuantLib" ;;
let _delete_EURCurrency arg = match _delete_EURCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FIMCurrency_f : c_obj list -> c_obj list = "_wrap_new_FIMCurrencyQuantLib" ;;
let _new_FIMCurrency arg = match _new_FIMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FIMCurrency_f : c_obj list -> c_obj list = "_wrap_delete_FIMCurrencyQuantLib" ;;
let _delete_FIMCurrency arg = match _delete_FIMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FRFCurrency_f : c_obj list -> c_obj list = "_wrap_new_FRFCurrencyQuantLib" ;;
let _new_FRFCurrency arg = match _new_FRFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FRFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_FRFCurrencyQuantLib" ;;
let _delete_FRFCurrency arg = match _delete_FRFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GBPCurrency_f : c_obj list -> c_obj list = "_wrap_new_GBPCurrencyQuantLib" ;;
let _new_GBPCurrency arg = match _new_GBPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GBPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_GBPCurrencyQuantLib" ;;
let _delete_GBPCurrency arg = match _delete_GBPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GRDCurrency_f : c_obj list -> c_obj list = "_wrap_new_GRDCurrencyQuantLib" ;;
let _new_GRDCurrency arg = match _new_GRDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GRDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_GRDCurrencyQuantLib" ;;
let _delete_GRDCurrency arg = match _delete_GRDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HKDCurrency_f : c_obj list -> c_obj list = "_wrap_new_HKDCurrencyQuantLib" ;;
let _new_HKDCurrency arg = match _new_HKDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HKDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_HKDCurrencyQuantLib" ;;
let _delete_HKDCurrency arg = match _delete_HKDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HUFCurrency_f : c_obj list -> c_obj list = "_wrap_new_HUFCurrencyQuantLib" ;;
let _new_HUFCurrency arg = match _new_HUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HUFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_HUFCurrencyQuantLib" ;;
let _delete_HUFCurrency arg = match _delete_HUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IEPCurrency_f : c_obj list -> c_obj list = "_wrap_new_IEPCurrencyQuantLib" ;;
let _new_IEPCurrency arg = match _new_IEPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IEPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_IEPCurrencyQuantLib" ;;
let _delete_IEPCurrency arg = match _delete_IEPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ILSCurrency_f : c_obj list -> c_obj list = "_wrap_new_ILSCurrencyQuantLib" ;;
let _new_ILSCurrency arg = match _new_ILSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ILSCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ILSCurrencyQuantLib" ;;
let _delete_ILSCurrency arg = match _delete_ILSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_INRCurrency_f : c_obj list -> c_obj list = "_wrap_new_INRCurrencyQuantLib" ;;
let _new_INRCurrency arg = match _new_INRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_INRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_INRCurrencyQuantLib" ;;
let _delete_INRCurrency arg = match _delete_INRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IQDCurrency_f : c_obj list -> c_obj list = "_wrap_new_IQDCurrencyQuantLib" ;;
let _new_IQDCurrency arg = match _new_IQDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IQDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_IQDCurrencyQuantLib" ;;
let _delete_IQDCurrency arg = match _delete_IQDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IRRCurrency_f : c_obj list -> c_obj list = "_wrap_new_IRRCurrencyQuantLib" ;;
let _new_IRRCurrency arg = match _new_IRRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IRRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_IRRCurrencyQuantLib" ;;
let _delete_IRRCurrency arg = match _delete_IRRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ISKCurrency_f : c_obj list -> c_obj list = "_wrap_new_ISKCurrencyQuantLib" ;;
let _new_ISKCurrency arg = match _new_ISKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ISKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ISKCurrencyQuantLib" ;;
let _delete_ISKCurrency arg = match _delete_ISKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ITLCurrency_f : c_obj list -> c_obj list = "_wrap_new_ITLCurrencyQuantLib" ;;
let _new_ITLCurrency arg = match _new_ITLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ITLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ITLCurrencyQuantLib" ;;
let _delete_ITLCurrency arg = match _delete_ITLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JPYCurrency_f : c_obj list -> c_obj list = "_wrap_new_JPYCurrencyQuantLib" ;;
let _new_JPYCurrency arg = match _new_JPYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_JPYCurrency_f : c_obj list -> c_obj list = "_wrap_delete_JPYCurrencyQuantLib" ;;
let _delete_JPYCurrency arg = match _delete_JPYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KRWCurrency_f : c_obj list -> c_obj list = "_wrap_new_KRWCurrencyQuantLib" ;;
let _new_KRWCurrency arg = match _new_KRWCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KRWCurrency_f : c_obj list -> c_obj list = "_wrap_delete_KRWCurrencyQuantLib" ;;
let _delete_KRWCurrency arg = match _delete_KRWCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KWDCurrency_f : c_obj list -> c_obj list = "_wrap_new_KWDCurrencyQuantLib" ;;
let _new_KWDCurrency arg = match _new_KWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KWDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_KWDCurrencyQuantLib" ;;
let _delete_KWDCurrency arg = match _delete_KWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LTLCurrency_f : c_obj list -> c_obj list = "_wrap_new_LTLCurrencyQuantLib" ;;
let _new_LTLCurrency arg = match _new_LTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LTLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_LTLCurrencyQuantLib" ;;
let _delete_LTLCurrency arg = match _delete_LTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LUFCurrency_f : c_obj list -> c_obj list = "_wrap_new_LUFCurrencyQuantLib" ;;
let _new_LUFCurrency arg = match _new_LUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LUFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_LUFCurrencyQuantLib" ;;
let _delete_LUFCurrency arg = match _delete_LUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LVLCurrency_f : c_obj list -> c_obj list = "_wrap_new_LVLCurrencyQuantLib" ;;
let _new_LVLCurrency arg = match _new_LVLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LVLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_LVLCurrencyQuantLib" ;;
let _delete_LVLCurrency arg = match _delete_LVLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MTLCurrency_f : c_obj list -> c_obj list = "_wrap_new_MTLCurrencyQuantLib" ;;
let _new_MTLCurrency arg = match _new_MTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MTLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_MTLCurrencyQuantLib" ;;
let _delete_MTLCurrency arg = match _delete_MTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MXNCurrency_f : c_obj list -> c_obj list = "_wrap_new_MXNCurrencyQuantLib" ;;
let _new_MXNCurrency arg = match _new_MXNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MXNCurrency_f : c_obj list -> c_obj list = "_wrap_delete_MXNCurrencyQuantLib" ;;
let _delete_MXNCurrency arg = match _delete_MXNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NLGCurrency_f : c_obj list -> c_obj list = "_wrap_new_NLGCurrencyQuantLib" ;;
let _new_NLGCurrency arg = match _new_NLGCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NLGCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NLGCurrencyQuantLib" ;;
let _delete_NLGCurrency arg = match _delete_NLGCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NOKCurrency_f : c_obj list -> c_obj list = "_wrap_new_NOKCurrencyQuantLib" ;;
let _new_NOKCurrency arg = match _new_NOKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NOKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NOKCurrencyQuantLib" ;;
let _delete_NOKCurrency arg = match _delete_NOKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NPRCurrency_f : c_obj list -> c_obj list = "_wrap_new_NPRCurrencyQuantLib" ;;
let _new_NPRCurrency arg = match _new_NPRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NPRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NPRCurrencyQuantLib" ;;
let _delete_NPRCurrency arg = match _delete_NPRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NZDCurrency_f : c_obj list -> c_obj list = "_wrap_new_NZDCurrencyQuantLib" ;;
let _new_NZDCurrency arg = match _new_NZDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NZDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NZDCurrencyQuantLib" ;;
let _delete_NZDCurrency arg = match _delete_NZDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PKRCurrency_f : c_obj list -> c_obj list = "_wrap_new_PKRCurrencyQuantLib" ;;
let _new_PKRCurrency arg = match _new_PKRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PKRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_PKRCurrencyQuantLib" ;;
let _delete_PKRCurrency arg = match _delete_PKRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PLNCurrency_f : c_obj list -> c_obj list = "_wrap_new_PLNCurrencyQuantLib" ;;
let _new_PLNCurrency arg = match _new_PLNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PLNCurrency_f : c_obj list -> c_obj list = "_wrap_delete_PLNCurrencyQuantLib" ;;
let _delete_PLNCurrency arg = match _delete_PLNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PTECurrency_f : c_obj list -> c_obj list = "_wrap_new_PTECurrencyQuantLib" ;;
let _new_PTECurrency arg = match _new_PTECurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PTECurrency_f : c_obj list -> c_obj list = "_wrap_delete_PTECurrencyQuantLib" ;;
let _delete_PTECurrency arg = match _delete_PTECurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ROLCurrency_f : c_obj list -> c_obj list = "_wrap_new_ROLCurrencyQuantLib" ;;
let _new_ROLCurrency arg = match _new_ROLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ROLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ROLCurrencyQuantLib" ;;
let _delete_ROLCurrency arg = match _delete_ROLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RONCurrency_f : c_obj list -> c_obj list = "_wrap_new_RONCurrencyQuantLib" ;;
let _new_RONCurrency arg = match _new_RONCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RONCurrency_f : c_obj list -> c_obj list = "_wrap_delete_RONCurrencyQuantLib" ;;
let _delete_RONCurrency arg = match _delete_RONCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SARCurrency_f : c_obj list -> c_obj list = "_wrap_new_SARCurrencyQuantLib" ;;
let _new_SARCurrency arg = match _new_SARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SARCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SARCurrencyQuantLib" ;;
let _delete_SARCurrency arg = match _delete_SARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SEKCurrency_f : c_obj list -> c_obj list = "_wrap_new_SEKCurrencyQuantLib" ;;
let _new_SEKCurrency arg = match _new_SEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SEKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SEKCurrencyQuantLib" ;;
let _delete_SEKCurrency arg = match _delete_SEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SGDCurrency_f : c_obj list -> c_obj list = "_wrap_new_SGDCurrencyQuantLib" ;;
let _new_SGDCurrency arg = match _new_SGDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SGDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SGDCurrencyQuantLib" ;;
let _delete_SGDCurrency arg = match _delete_SGDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SITCurrency_f : c_obj list -> c_obj list = "_wrap_new_SITCurrencyQuantLib" ;;
let _new_SITCurrency arg = match _new_SITCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SITCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SITCurrencyQuantLib" ;;
let _delete_SITCurrency arg = match _delete_SITCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SKKCurrency_f : c_obj list -> c_obj list = "_wrap_new_SKKCurrencyQuantLib" ;;
let _new_SKKCurrency arg = match _new_SKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SKKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SKKCurrencyQuantLib" ;;
let _delete_SKKCurrency arg = match _delete_SKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_THBCurrency_f : c_obj list -> c_obj list = "_wrap_new_THBCurrencyQuantLib" ;;
let _new_THBCurrency arg = match _new_THBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_THBCurrency_f : c_obj list -> c_obj list = "_wrap_delete_THBCurrencyQuantLib" ;;
let _delete_THBCurrency arg = match _delete_THBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRLCurrency_f : c_obj list -> c_obj list = "_wrap_new_TRLCurrencyQuantLib" ;;
let _new_TRLCurrency arg = match _new_TRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TRLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TRLCurrencyQuantLib" ;;
let _delete_TRLCurrency arg = match _delete_TRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRYCurrency_f : c_obj list -> c_obj list = "_wrap_new_TRYCurrencyQuantLib" ;;
let _new_TRYCurrency arg = match _new_TRYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TRYCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TRYCurrencyQuantLib" ;;
let _delete_TRYCurrency arg = match _delete_TRYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TTDCurrency_f : c_obj list -> c_obj list = "_wrap_new_TTDCurrencyQuantLib" ;;
let _new_TTDCurrency arg = match _new_TTDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TTDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TTDCurrencyQuantLib" ;;
let _delete_TTDCurrency arg = match _delete_TTDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TWDCurrency_f : c_obj list -> c_obj list = "_wrap_new_TWDCurrencyQuantLib" ;;
let _new_TWDCurrency arg = match _new_TWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TWDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TWDCurrencyQuantLib" ;;
let _delete_TWDCurrency arg = match _delete_TWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USDCurrency_f : c_obj list -> c_obj list = "_wrap_new_USDCurrencyQuantLib" ;;
let _new_USDCurrency arg = match _new_USDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_USDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_USDCurrencyQuantLib" ;;
let _delete_USDCurrency arg = match _delete_USDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_VEBCurrency_f : c_obj list -> c_obj list = "_wrap_new_VEBCurrencyQuantLib" ;;
let _new_VEBCurrency arg = match _new_VEBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VEBCurrency_f : c_obj list -> c_obj list = "_wrap_delete_VEBCurrencyQuantLib" ;;
let _delete_VEBCurrency arg = match _delete_VEBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZARCurrency_f : c_obj list -> c_obj list = "_wrap_new_ZARCurrencyQuantLib" ;;
let _new_ZARCurrency arg = match _new_ZARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZARCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ZARCurrencyQuantLib" ;;
let _delete_ZARCurrency arg = match _delete_ZARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LinearInterpolation_f : c_obj list -> c_obj list = "_wrap_new_LinearInterpolationQuantLib" ;;
let _new_LinearInterpolation arg = match _new_LinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LinearInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _LinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LinearInterpolation_operator_pP___QuantLib" ;;
let _LinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LinearInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_LinearInterpolationQuantLib" ;;
let _delete_LinearInterpolation arg = match _delete_LinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LogLinearInterpolation_f : c_obj list -> c_obj list = "_wrap_new_LogLinearInterpolationQuantLib" ;;
let _new_LogLinearInterpolation arg = match _new_LogLinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogLinearInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogLinearInterpolation_operator_pP___QuantLib" ;;
let _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LogLinearInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_LogLinearInterpolationQuantLib" ;;
let _delete_LogLinearInterpolation arg = match _delete_LogLinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BackwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_new_BackwardFlatInterpolationQuantLib" ;;
let _new_BackwardFlatInterpolation arg = match _new_BackwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BackwardFlatInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BackwardFlatInterpolation_operator_pP___QuantLib" ;;
let _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BackwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_BackwardFlatInterpolationQuantLib" ;;
let _delete_BackwardFlatInterpolation arg = match _delete_BackwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_new_ForwardFlatInterpolationQuantLib" ;;
let _new_ForwardFlatInterpolation arg = match _new_ForwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_ForwardFlatInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_ForwardFlatInterpolation_operator_pP___QuantLib" ;;
let _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_ForwardFlatInterpolationQuantLib" ;;
let _delete_ForwardFlatInterpolation arg = match _delete_ForwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CubicSpline_f : c_obj list -> c_obj list = "_wrap_new_CubicSplineQuantLib" ;;
let _new_CubicSpline arg = match _new_CubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CubicSpline_operator_pP_____SWIG_0QuantLib" ;;
let _CubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _CubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CubicSpline_operator_pP___QuantLib" ;;
let _CubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _CubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicSpline_derivative_f : c_obj list -> c_obj list = "_wrap_CubicSpline_derivative__SWIG_0QuantLib" ;;
let _CubicSpline_derivative arg = match _CubicSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicSpline_derivative_f : c_obj list -> c_obj list = "_wrap_CubicSpline_derivativeQuantLib" ;;
let _CubicSpline_derivative arg = match _CubicSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_CubicSpline_secondDerivative__SWIG_0QuantLib" ;;
let _CubicSpline_secondDerivative arg = match _CubicSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_CubicSpline_secondDerivativeQuantLib" ;;
let _CubicSpline_secondDerivative arg = match _CubicSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CubicSpline_f : c_obj list -> c_obj list = "_wrap_delete_CubicSplineQuantLib" ;;
let _delete_CubicSpline arg = match _delete_CubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MonotonicCubicSpline_f : c_obj list -> c_obj list = "_wrap_new_MonotonicCubicSplineQuantLib" ;;
let _new_MonotonicCubicSpline arg = match _new_MonotonicCubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicSpline_operator_pP_____SWIG_0QuantLib" ;;
let _MonotonicCubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicCubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicSpline_operator_pP___QuantLib" ;;
let _MonotonicCubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicCubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicSpline_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicSpline_derivative__SWIG_0QuantLib" ;;
let _MonotonicCubicSpline_derivative arg = match _MonotonicCubicSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicSpline_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicSpline_derivativeQuantLib" ;;
let _MonotonicCubicSpline_derivative arg = match _MonotonicCubicSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicSpline_secondDerivative__SWIG_0QuantLib" ;;
let _MonotonicCubicSpline_secondDerivative arg = match _MonotonicCubicSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicSpline_secondDerivativeQuantLib" ;;
let _MonotonicCubicSpline_secondDerivative arg = match _MonotonicCubicSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MonotonicCubicSpline_f : c_obj list -> c_obj list = "_wrap_delete_MonotonicCubicSplineQuantLib" ;;
let _delete_MonotonicCubicSpline arg = match _delete_MonotonicCubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BilinearInterpolation_f : c_obj list -> c_obj list = "_wrap_new_BilinearInterpolationQuantLib" ;;
let _new_BilinearInterpolation arg = match _new_BilinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BilinearInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BilinearInterpolation_operator_pP___QuantLib" ;;
let _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BilinearInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_BilinearInterpolationQuantLib" ;;
let _delete_BilinearInterpolation arg = match _delete_BilinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BicubicSpline_f : c_obj list -> c_obj list = "_wrap_new_BicubicSplineQuantLib" ;;
let _new_BicubicSpline arg = match _new_BicubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BicubicSpline_operator_pP_____SWIG_0QuantLib" ;;
let _BicubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BicubicSpline_operator_pP___QuantLib" ;;
let _BicubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BicubicSpline_f : c_obj list -> c_obj list = "_wrap_delete_BicubicSplineQuantLib" ;;
let _delete_BicubicSpline arg = match _delete_BicubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BackwardFlat_f : c_obj list -> c_obj list = "_wrap_new_BackwardFlatQuantLib" ;;
let _new_BackwardFlat arg = match _new_BackwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BackwardFlat_f : c_obj list -> c_obj list = "_wrap_delete_BackwardFlatQuantLib" ;;
let _delete_BackwardFlat arg = match _delete_BackwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardFlat_f : c_obj list -> c_obj list = "_wrap_new_ForwardFlatQuantLib" ;;
let _new_ForwardFlat arg = match _new_ForwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardFlat_f : c_obj list -> c_obj list = "_wrap_delete_ForwardFlatQuantLib" ;;
let _delete_ForwardFlat arg = match _delete_ForwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Linear_f : c_obj list -> c_obj list = "_wrap_new_LinearQuantLib" ;;
let _new_Linear arg = match _new_Linear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Linear_f : c_obj list -> c_obj list = "_wrap_delete_LinearQuantLib" ;;
let _delete_Linear arg = match _delete_Linear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LogLinear_f : c_obj list -> c_obj list = "_wrap_new_LogLinearQuantLib" ;;
let _new_LogLinear arg = match _new_LogLinear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LogLinear_f : c_obj list -> c_obj list = "_wrap_delete_LogLinearQuantLib" ;;
let _delete_LogLinear arg = match _delete_LogLinear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cubic_f : c_obj list -> c_obj list = "_wrap_new_CubicQuantLib" ;;
let _new_Cubic arg = match _new_Cubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Cubic_f : c_obj list -> c_obj list = "_wrap_delete_CubicQuantLib" ;;
let _delete_Cubic arg = match _delete_Cubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_YieldTermStructure___deref__QuantLib" ;;
let _YieldTermStructure___deref__ arg = match _YieldTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_isNullQuantLib" ;;
let _YieldTermStructure_isNull arg = match _YieldTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_asObservableQuantLib" ;;
let _YieldTermStructure_asObservable arg = match _YieldTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructure_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureQuantLib" ;;
let _new_YieldTermStructure arg = match _new_YieldTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YieldTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_YieldTermStructureQuantLib" ;;
let _delete_YieldTermStructure arg = match _delete_YieldTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_dayCounterQuantLib" ;;
let _YieldTermStructure_dayCounter arg = match _YieldTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_calendarQuantLib" ;;
let _YieldTermStructure_calendar arg = match _YieldTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_referenceDateQuantLib" ;;
let _YieldTermStructure_referenceDate arg = match _YieldTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_maxDateQuantLib" ;;
let _YieldTermStructure_maxDate arg = match _YieldTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_maxTimeQuantLib" ;;
let _YieldTermStructure_maxTime arg = match _YieldTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discount__SWIG_0QuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discount__SWIG_1QuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discount__SWIG_2QuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discountQuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_0QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_1QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_2QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_3QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_4QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRateQuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_0QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_1QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_2QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_3QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_4QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRateQuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_enableExtrapolationQuantLib" ;;
let _YieldTermStructure_enableExtrapolation arg = match _YieldTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_disableExtrapolationQuantLib" ;;
let _YieldTermStructure_disableExtrapolation arg = match _YieldTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_allowsExtrapolationQuantLib" ;;
let _YieldTermStructure_allowsExtrapolation arg = match _YieldTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureHandle__SWIG_0QuantLib" ;;
let _new_YieldTermStructureHandle arg = match _new_YieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureHandleQuantLib" ;;
let _new_YieldTermStructureHandle arg = match _new_YieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle___deref__QuantLib" ;;
let _YieldTermStructureHandle___deref__ arg = match _YieldTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_emptyQuantLib" ;;
let _YieldTermStructureHandle_empty arg = match _YieldTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_asObservableQuantLib" ;;
let _YieldTermStructureHandle_asObservable arg = match _YieldTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_YieldTermStructureHandleQuantLib" ;;
let _delete_YieldTermStructureHandle arg = match _delete_YieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_dayCounterQuantLib" ;;
let _YieldTermStructureHandle_dayCounter arg = match _YieldTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_calendarQuantLib" ;;
let _YieldTermStructureHandle_calendar arg = match _YieldTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_referenceDateQuantLib" ;;
let _YieldTermStructureHandle_referenceDate arg = match _YieldTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_maxDateQuantLib" ;;
let _YieldTermStructureHandle_maxDate arg = match _YieldTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_maxTimeQuantLib" ;;
let _YieldTermStructureHandle_maxTime arg = match _YieldTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discount__SWIG_0QuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discount__SWIG_1QuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discount__SWIG_2QuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discountQuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_0QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_1QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_2QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_3QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_4QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRateQuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_0QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_1QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_2QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_3QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_4QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRateQuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_enableExtrapolationQuantLib" ;;
let _YieldTermStructureHandle_enableExtrapolation arg = match _YieldTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_disableExtrapolationQuantLib" ;;
let _YieldTermStructureHandle_disableExtrapolation arg = match _YieldTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _YieldTermStructureHandle_allowsExtrapolation arg = match _YieldTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableYieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableYieldTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableYieldTermStructureHandle arg = match _new_RelinkableYieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableYieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableYieldTermStructureHandleQuantLib" ;;
let _new_RelinkableYieldTermStructureHandle arg = match _new_RelinkableYieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableYieldTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableYieldTermStructureHandle_linkToQuantLib" ;;
let _RelinkableYieldTermStructureHandle_linkTo arg = match _RelinkableYieldTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableYieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableYieldTermStructureHandleQuantLib" ;;
let _delete_RelinkableYieldTermStructureHandle arg = match _delete_RelinkableYieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ImpliedTermStructure_f : c_obj list -> c_obj list = "_wrap_new_ImpliedTermStructureQuantLib" ;;
let _new_ImpliedTermStructure arg = match _new_ImpliedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ImpliedTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_ImpliedTermStructureQuantLib" ;;
let _delete_ImpliedTermStructure arg = match _delete_ImpliedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_new_ZeroSpreadedTermStructureQuantLib" ;;
let _new_ZeroSpreadedTermStructure arg = match _new_ZeroSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_ZeroSpreadedTermStructureQuantLib" ;;
let _delete_ZeroSpreadedTermStructure arg = match _delete_ZeroSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_new_ForwardSpreadedTermStructureQuantLib" ;;
let _new_ForwardSpreadedTermStructure arg = match _new_ForwardSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_ForwardSpreadedTermStructureQuantLib" ;;
let _delete_ForwardSpreadedTermStructure arg = match _delete_ForwardSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_0QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_1QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_2QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_3QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_4QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_5QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_6QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_7QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_8QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_9QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_10QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForwardQuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FlatForward_f : c_obj list -> c_obj list = "_wrap_delete_FlatForwardQuantLib" ;;
let _delete_FlatForward arg = match _delete_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure___deref__QuantLib" ;;
let _BlackVolTermStructure___deref__ arg = match _BlackVolTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_isNullQuantLib" ;;
let _BlackVolTermStructure_isNull arg = match _BlackVolTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_asObservableQuantLib" ;;
let _BlackVolTermStructure_asObservable arg = match _BlackVolTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructure_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureQuantLib" ;;
let _new_BlackVolTermStructure arg = match _new_BlackVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackVolTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_BlackVolTermStructureQuantLib" ;;
let _delete_BlackVolTermStructure arg = match _delete_BlackVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_referenceDateQuantLib" ;;
let _BlackVolTermStructure_referenceDate arg = match _BlackVolTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_dayCounterQuantLib" ;;
let _BlackVolTermStructure_dayCounter arg = match _BlackVolTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_calendarQuantLib" ;;
let _BlackVolTermStructure_calendar arg = match _BlackVolTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_maxDateQuantLib" ;;
let _BlackVolTermStructure_maxDate arg = match _BlackVolTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_maxTimeQuantLib" ;;
let _BlackVolTermStructure_maxTime arg = match _BlackVolTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_minStrikeQuantLib" ;;
let _BlackVolTermStructure_minStrike arg = match _BlackVolTermStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_maxStrikeQuantLib" ;;
let _BlackVolTermStructure_maxStrike arg = match _BlackVolTermStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVolQuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVarianceQuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVolQuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVarianceQuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_enableExtrapolationQuantLib" ;;
let _BlackVolTermStructure_enableExtrapolation arg = match _BlackVolTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_disableExtrapolationQuantLib" ;;
let _BlackVolTermStructure_disableExtrapolation arg = match _BlackVolTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_allowsExtrapolationQuantLib" ;;
let _BlackVolTermStructure_allowsExtrapolation arg = match _BlackVolTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_BlackVolTermStructureHandle arg = match _new_BlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureHandleQuantLib" ;;
let _new_BlackVolTermStructureHandle arg = match _new_BlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle___deref__QuantLib" ;;
let _BlackVolTermStructureHandle___deref__ arg = match _BlackVolTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_emptyQuantLib" ;;
let _BlackVolTermStructureHandle_empty arg = match _BlackVolTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_asObservableQuantLib" ;;
let _BlackVolTermStructureHandle_asObservable arg = match _BlackVolTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_BlackVolTermStructureHandleQuantLib" ;;
let _delete_BlackVolTermStructureHandle arg = match _delete_BlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_referenceDateQuantLib" ;;
let _BlackVolTermStructureHandle_referenceDate arg = match _BlackVolTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_dayCounterQuantLib" ;;
let _BlackVolTermStructureHandle_dayCounter arg = match _BlackVolTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_calendarQuantLib" ;;
let _BlackVolTermStructureHandle_calendar arg = match _BlackVolTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_maxDateQuantLib" ;;
let _BlackVolTermStructureHandle_maxDate arg = match _BlackVolTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_maxTimeQuantLib" ;;
let _BlackVolTermStructureHandle_maxTime arg = match _BlackVolTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_minStrikeQuantLib" ;;
let _BlackVolTermStructureHandle_minStrike arg = match _BlackVolTermStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_maxStrikeQuantLib" ;;
let _BlackVolTermStructureHandle_maxStrike arg = match _BlackVolTermStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVolQuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVarianceQuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVolQuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVarianceQuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_enableExtrapolationQuantLib" ;;
let _BlackVolTermStructureHandle_enableExtrapolation arg = match _BlackVolTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_disableExtrapolationQuantLib" ;;
let _BlackVolTermStructureHandle_disableExtrapolation arg = match _BlackVolTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _BlackVolTermStructureHandle_allowsExtrapolation arg = match _BlackVolTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableBlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableBlackVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableBlackVolTermStructureHandle arg = match _new_RelinkableBlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableBlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableBlackVolTermStructureHandleQuantLib" ;;
let _new_RelinkableBlackVolTermStructureHandle arg = match _new_RelinkableBlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableBlackVolTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableBlackVolTermStructureHandle_linkToQuantLib" ;;
let _RelinkableBlackVolTermStructureHandle_linkTo arg = match _RelinkableBlackVolTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableBlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableBlackVolTermStructureHandleQuantLib" ;;
let _delete_RelinkableBlackVolTermStructureHandle arg = match _delete_RelinkableBlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure___deref__QuantLib" ;;
let _LocalVolTermStructure___deref__ arg = match _LocalVolTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_isNullQuantLib" ;;
let _LocalVolTermStructure_isNull arg = match _LocalVolTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_asObservableQuantLib" ;;
let _LocalVolTermStructure_asObservable arg = match _LocalVolTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalVolTermStructure_f : c_obj list -> c_obj list = "_wrap_new_LocalVolTermStructureQuantLib" ;;
let _new_LocalVolTermStructure arg = match _new_LocalVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LocalVolTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_LocalVolTermStructureQuantLib" ;;
let _delete_LocalVolTermStructure arg = match _delete_LocalVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_referenceDateQuantLib" ;;
let _LocalVolTermStructure_referenceDate arg = match _LocalVolTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_dayCounterQuantLib" ;;
let _LocalVolTermStructure_dayCounter arg = match _LocalVolTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_calendarQuantLib" ;;
let _LocalVolTermStructure_calendar arg = match _LocalVolTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_maxDateQuantLib" ;;
let _LocalVolTermStructure_maxDate arg = match _LocalVolTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_maxTimeQuantLib" ;;
let _LocalVolTermStructure_maxTime arg = match _LocalVolTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_minStrikeQuantLib" ;;
let _LocalVolTermStructure_minStrike arg = match _LocalVolTermStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_maxStrikeQuantLib" ;;
let _LocalVolTermStructure_maxStrike arg = match _LocalVolTermStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVol__SWIG_0QuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVol__SWIG_1QuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVol__SWIG_2QuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVolQuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_enableExtrapolationQuantLib" ;;
let _LocalVolTermStructure_enableExtrapolation arg = match _LocalVolTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_disableExtrapolationQuantLib" ;;
let _LocalVolTermStructure_disableExtrapolation arg = match _LocalVolTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_allowsExtrapolationQuantLib" ;;
let _LocalVolTermStructure_allowsExtrapolation arg = match _LocalVolTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_LocalVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_LocalVolTermStructureHandle arg = match _new_LocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_LocalVolTermStructureHandleQuantLib" ;;
let _new_LocalVolTermStructureHandle arg = match _new_LocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle___deref__QuantLib" ;;
let _LocalVolTermStructureHandle___deref__ arg = match _LocalVolTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_emptyQuantLib" ;;
let _LocalVolTermStructureHandle_empty arg = match _LocalVolTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_asObservableQuantLib" ;;
let _LocalVolTermStructureHandle_asObservable arg = match _LocalVolTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_LocalVolTermStructureHandleQuantLib" ;;
let _delete_LocalVolTermStructureHandle arg = match _delete_LocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_referenceDateQuantLib" ;;
let _LocalVolTermStructureHandle_referenceDate arg = match _LocalVolTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_dayCounterQuantLib" ;;
let _LocalVolTermStructureHandle_dayCounter arg = match _LocalVolTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_calendarQuantLib" ;;
let _LocalVolTermStructureHandle_calendar arg = match _LocalVolTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_maxDateQuantLib" ;;
let _LocalVolTermStructureHandle_maxDate arg = match _LocalVolTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_maxTimeQuantLib" ;;
let _LocalVolTermStructureHandle_maxTime arg = match _LocalVolTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_minStrikeQuantLib" ;;
let _LocalVolTermStructureHandle_minStrike arg = match _LocalVolTermStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_maxStrikeQuantLib" ;;
let _LocalVolTermStructureHandle_maxStrike arg = match _LocalVolTermStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVol__SWIG_0QuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVol__SWIG_1QuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVol__SWIG_2QuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVolQuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_enableExtrapolationQuantLib" ;;
let _LocalVolTermStructureHandle_enableExtrapolation arg = match _LocalVolTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_disableExtrapolationQuantLib" ;;
let _LocalVolTermStructureHandle_disableExtrapolation arg = match _LocalVolTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _LocalVolTermStructureHandle_allowsExtrapolation arg = match _LocalVolTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableLocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableLocalVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableLocalVolTermStructureHandle arg = match _new_RelinkableLocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableLocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableLocalVolTermStructureHandleQuantLib" ;;
let _new_RelinkableLocalVolTermStructureHandle arg = match _new_RelinkableLocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableLocalVolTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableLocalVolTermStructureHandle_linkToQuantLib" ;;
let _RelinkableLocalVolTermStructureHandle_linkTo arg = match _RelinkableLocalVolTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableLocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableLocalVolTermStructureHandleQuantLib" ;;
let _delete_RelinkableLocalVolTermStructureHandle arg = match _delete_RelinkableLocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure___deref___f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure___deref__QuantLib" ;;
let _CapletVolatilityStructure___deref__ arg = match _CapletVolatilityStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_isNull_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_isNullQuantLib" ;;
let _CapletVolatilityStructure_isNull arg = match _CapletVolatilityStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_asObservableQuantLib" ;;
let _CapletVolatilityStructure_asObservable arg = match _CapletVolatilityStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapletVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_new_CapletVolatilityStructureQuantLib" ;;
let _new_CapletVolatilityStructure arg = match _new_CapletVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapletVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_delete_CapletVolatilityStructureQuantLib" ;;
let _delete_CapletVolatilityStructure arg = match _delete_CapletVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_referenceDateQuantLib" ;;
let _CapletVolatilityStructure_referenceDate arg = match _CapletVolatilityStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_dayCounterQuantLib" ;;
let _CapletVolatilityStructure_dayCounter arg = match _CapletVolatilityStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_calendar_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_calendarQuantLib" ;;
let _CapletVolatilityStructure_calendar arg = match _CapletVolatilityStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_maxDateQuantLib" ;;
let _CapletVolatilityStructure_maxDate arg = match _CapletVolatilityStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_maxTimeQuantLib" ;;
let _CapletVolatilityStructure_maxTime arg = match _CapletVolatilityStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_minStrikeQuantLib" ;;
let _CapletVolatilityStructure_minStrike arg = match _CapletVolatilityStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_maxStrikeQuantLib" ;;
let _CapletVolatilityStructure_maxStrike arg = match _CapletVolatilityStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_volatility__SWIG_0QuantLib" ;;
let _CapletVolatilityStructure_volatility arg = match _CapletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_volatility__SWIG_1QuantLib" ;;
let _CapletVolatilityStructure_volatility arg = match _CapletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_volatility__SWIG_2QuantLib" ;;
let _CapletVolatilityStructure_volatility arg = match _CapletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_volatilityQuantLib" ;;
let _CapletVolatilityStructure_volatility arg = match _CapletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_blackVariance__SWIG_0QuantLib" ;;
let _CapletVolatilityStructure_blackVariance arg = match _CapletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_blackVariance__SWIG_1QuantLib" ;;
let _CapletVolatilityStructure_blackVariance arg = match _CapletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_blackVariance__SWIG_2QuantLib" ;;
let _CapletVolatilityStructure_blackVariance arg = match _CapletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_blackVarianceQuantLib" ;;
let _CapletVolatilityStructure_blackVariance arg = match _CapletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_enableExtrapolationQuantLib" ;;
let _CapletVolatilityStructure_enableExtrapolation arg = match _CapletVolatilityStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_disableExtrapolationQuantLib" ;;
let _CapletVolatilityStructure_disableExtrapolation arg = match _CapletVolatilityStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructure_allowsExtrapolationQuantLib" ;;
let _CapletVolatilityStructure_allowsExtrapolation arg = match _CapletVolatilityStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_CapletVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_CapletVolatilityStructureHandle arg = match _new_CapletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_CapletVolatilityStructureHandleQuantLib" ;;
let _new_CapletVolatilityStructureHandle arg = match _new_CapletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle___deref__QuantLib" ;;
let _CapletVolatilityStructureHandle___deref__ arg = match _CapletVolatilityStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_emptyQuantLib" ;;
let _CapletVolatilityStructureHandle_empty arg = match _CapletVolatilityStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_asObservableQuantLib" ;;
let _CapletVolatilityStructureHandle_asObservable arg = match _CapletVolatilityStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_CapletVolatilityStructureHandleQuantLib" ;;
let _delete_CapletVolatilityStructureHandle arg = match _delete_CapletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_referenceDateQuantLib" ;;
let _CapletVolatilityStructureHandle_referenceDate arg = match _CapletVolatilityStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_dayCounterQuantLib" ;;
let _CapletVolatilityStructureHandle_dayCounter arg = match _CapletVolatilityStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_calendarQuantLib" ;;
let _CapletVolatilityStructureHandle_calendar arg = match _CapletVolatilityStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_maxDateQuantLib" ;;
let _CapletVolatilityStructureHandle_maxDate arg = match _CapletVolatilityStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_maxTimeQuantLib" ;;
let _CapletVolatilityStructureHandle_maxTime arg = match _CapletVolatilityStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_minStrikeQuantLib" ;;
let _CapletVolatilityStructureHandle_minStrike arg = match _CapletVolatilityStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_maxStrikeQuantLib" ;;
let _CapletVolatilityStructureHandle_maxStrike arg = match _CapletVolatilityStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_volatility__SWIG_0QuantLib" ;;
let _CapletVolatilityStructureHandle_volatility arg = match _CapletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_volatility__SWIG_1QuantLib" ;;
let _CapletVolatilityStructureHandle_volatility arg = match _CapletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_volatility__SWIG_2QuantLib" ;;
let _CapletVolatilityStructureHandle_volatility arg = match _CapletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_volatilityQuantLib" ;;
let _CapletVolatilityStructureHandle_volatility arg = match _CapletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_blackVariance__SWIG_0QuantLib" ;;
let _CapletVolatilityStructureHandle_blackVariance arg = match _CapletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_blackVariance__SWIG_1QuantLib" ;;
let _CapletVolatilityStructureHandle_blackVariance arg = match _CapletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_blackVariance__SWIG_2QuantLib" ;;
let _CapletVolatilityStructureHandle_blackVariance arg = match _CapletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_blackVarianceQuantLib" ;;
let _CapletVolatilityStructureHandle_blackVariance arg = match _CapletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_enableExtrapolationQuantLib" ;;
let _CapletVolatilityStructureHandle_enableExtrapolation arg = match _CapletVolatilityStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_disableExtrapolationQuantLib" ;;
let _CapletVolatilityStructureHandle_disableExtrapolation arg = match _CapletVolatilityStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapletVolatilityStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_CapletVolatilityStructureHandle_allowsExtrapolationQuantLib" ;;
let _CapletVolatilityStructureHandle_allowsExtrapolation arg = match _CapletVolatilityStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableCapletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableCapletVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableCapletVolatilityStructureHandle arg = match _new_RelinkableCapletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableCapletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableCapletVolatilityStructureHandleQuantLib" ;;
let _new_RelinkableCapletVolatilityStructureHandle arg = match _new_RelinkableCapletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableCapletVolatilityStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableCapletVolatilityStructureHandle_linkToQuantLib" ;;
let _RelinkableCapletVolatilityStructureHandle_linkTo arg = match _RelinkableCapletVolatilityStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableCapletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableCapletVolatilityStructureHandleQuantLib" ;;
let _delete_RelinkableCapletVolatilityStructureHandle arg = match _delete_RelinkableCapletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure___deref___f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure___deref__QuantLib" ;;
let _SwaptionVolatilityStructure___deref__ arg = match _SwaptionVolatilityStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_isNull_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_isNullQuantLib" ;;
let _SwaptionVolatilityStructure_isNull arg = match _SwaptionVolatilityStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_asObservableQuantLib" ;;
let _SwaptionVolatilityStructure_asObservable arg = match _SwaptionVolatilityStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityStructureQuantLib" ;;
let _new_SwaptionVolatilityStructure arg = match _new_SwaptionVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolatilityStructureQuantLib" ;;
let _delete_SwaptionVolatilityStructure arg = match _delete_SwaptionVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_referenceDateQuantLib" ;;
let _SwaptionVolatilityStructure_referenceDate arg = match _SwaptionVolatilityStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_dayCounterQuantLib" ;;
let _SwaptionVolatilityStructure_dayCounter arg = match _SwaptionVolatilityStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_calendar_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_calendarQuantLib" ;;
let _SwaptionVolatilityStructure_calendar arg = match _SwaptionVolatilityStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_maxSwapTenor_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_maxSwapTenorQuantLib" ;;
let _SwaptionVolatilityStructure_maxSwapTenor arg = match _SwaptionVolatilityStructure_maxSwapTenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_maxSwapLength_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_maxSwapLengthQuantLib" ;;
let _SwaptionVolatilityStructure_maxSwapLength arg = match _SwaptionVolatilityStructure_maxSwapLength_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_minStrikeQuantLib" ;;
let _SwaptionVolatilityStructure_minStrike arg = match _SwaptionVolatilityStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_maxStrikeQuantLib" ;;
let _SwaptionVolatilityStructure_maxStrike arg = match _SwaptionVolatilityStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatility__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatility__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatility__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatilityQuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVariance__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVariance__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVariance__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVarianceQuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_enableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructure_enableExtrapolation arg = match _SwaptionVolatilityStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_disableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructure_disableExtrapolation arg = match _SwaptionVolatilityStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_allowsExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructure_allowsExtrapolation arg = match _SwaptionVolatilityStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_SwaptionVolatilityStructureHandle arg = match _new_SwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityStructureHandleQuantLib" ;;
let _new_SwaptionVolatilityStructureHandle arg = match _new_SwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle___deref__QuantLib" ;;
let _SwaptionVolatilityStructureHandle___deref__ arg = match _SwaptionVolatilityStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_emptyQuantLib" ;;
let _SwaptionVolatilityStructureHandle_empty arg = match _SwaptionVolatilityStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_asObservableQuantLib" ;;
let _SwaptionVolatilityStructureHandle_asObservable arg = match _SwaptionVolatilityStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolatilityStructureHandleQuantLib" ;;
let _delete_SwaptionVolatilityStructureHandle arg = match _delete_SwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_referenceDateQuantLib" ;;
let _SwaptionVolatilityStructureHandle_referenceDate arg = match _SwaptionVolatilityStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_dayCounterQuantLib" ;;
let _SwaptionVolatilityStructureHandle_dayCounter arg = match _SwaptionVolatilityStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_calendarQuantLib" ;;
let _SwaptionVolatilityStructureHandle_calendar arg = match _SwaptionVolatilityStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_maxSwapTenor_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_maxSwapTenorQuantLib" ;;
let _SwaptionVolatilityStructureHandle_maxSwapTenor arg = match _SwaptionVolatilityStructureHandle_maxSwapTenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_maxSwapLength_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_maxSwapLengthQuantLib" ;;
let _SwaptionVolatilityStructureHandle_maxSwapLength arg = match _SwaptionVolatilityStructureHandle_maxSwapLength_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_minStrikeQuantLib" ;;
let _SwaptionVolatilityStructureHandle_minStrike arg = match _SwaptionVolatilityStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_maxStrikeQuantLib" ;;
let _SwaptionVolatilityStructureHandle_maxStrike arg = match _SwaptionVolatilityStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatility__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatility__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatility__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatilityQuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVariance__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVariance__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVariance__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVarianceQuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_enableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructureHandle_enableExtrapolation arg = match _SwaptionVolatilityStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_disableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructureHandle_disableExtrapolation arg = match _SwaptionVolatilityStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_allowsExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructureHandle_allowsExtrapolation arg = match _SwaptionVolatilityStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableSwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableSwaptionVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableSwaptionVolatilityStructureHandle arg = match _new_RelinkableSwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableSwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableSwaptionVolatilityStructureHandleQuantLib" ;;
let _new_RelinkableSwaptionVolatilityStructureHandle arg = match _new_RelinkableSwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableSwaptionVolatilityStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableSwaptionVolatilityStructureHandle_linkToQuantLib" ;;
let _RelinkableSwaptionVolatilityStructureHandle_linkTo arg = match _RelinkableSwaptionVolatilityStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableSwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableSwaptionVolatilityStructureHandleQuantLib" ;;
let _delete_RelinkableSwaptionVolatilityStructureHandle arg = match _delete_RelinkableSwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVol__SWIG_0QuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVol__SWIG_1QuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVol__SWIG_2QuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVolQuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_delete_BlackConstantVolQuantLib" ;;
let _delete_BlackConstantVol arg = match _delete_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceSurface__SWIG_0QuantLib" ;;
let _new_BlackVarianceSurface arg = match _new_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceSurface__SWIG_1QuantLib" ;;
let _new_BlackVarianceSurface arg = match _new_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceSurfaceQuantLib" ;;
let _new_BlackVarianceSurface arg = match _new_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVarianceSurface_ConstantExtrapolation : c_obj -> Swig.c_obj = "_wrap_BlackVarianceSurface_ConstantExtrapolation" 
external _BlackVarianceSurface_InterpolatorDefaultExtrapolation : c_obj -> Swig.c_obj = "_wrap_BlackVarianceSurface_InterpolatorDefaultExtrapolation" 
external _delete_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_delete_BlackVarianceSurfaceQuantLib" ;;
let _delete_BlackVarianceSurface arg = match _delete_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVol__SWIG_0QuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVol__SWIG_1QuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVol__SWIG_2QuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVolQuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_delete_LocalConstantVolQuantLib" ;;
let _delete_LocalConstantVol arg = match _delete_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapletConstantVolatility_f : c_obj list -> c_obj list = "_wrap_new_CapletConstantVolatility__SWIG_0QuantLib" ;;
let _new_CapletConstantVolatility arg = match _new_CapletConstantVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapletConstantVolatility_f : c_obj list -> c_obj list = "_wrap_new_CapletConstantVolatility__SWIG_1QuantLib" ;;
let _new_CapletConstantVolatility arg = match _new_CapletConstantVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapletConstantVolatility_f : c_obj list -> c_obj list = "_wrap_new_CapletConstantVolatility__SWIG_2QuantLib" ;;
let _new_CapletConstantVolatility arg = match _new_CapletConstantVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapletConstantVolatility_f : c_obj list -> c_obj list = "_wrap_new_CapletConstantVolatilityQuantLib" ;;
let _new_CapletConstantVolatility arg = match _new_CapletConstantVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapletConstantVolatility_f : c_obj list -> c_obj list = "_wrap_delete_CapletConstantVolatilityQuantLib" ;;
let _delete_CapletConstantVolatility arg = match _delete_CapletConstantVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityMatrix_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityMatrixQuantLib" ;;
let _new_SwaptionVolatilityMatrix arg = match _new_SwaptionVolatilityMatrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolatilityMatrix_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolatilityMatrixQuantLib" ;;
let _delete_SwaptionVolatilityMatrix arg = match _delete_SwaptionVolatilityMatrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcess___deref___f : c_obj list -> c_obj list = "_wrap_StochasticProcess___deref__QuantLib" ;;
let _StochasticProcess___deref__ arg = match _StochasticProcess___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcess_isNull_f : c_obj list -> c_obj list = "_wrap_StochasticProcess_isNullQuantLib" ;;
let _StochasticProcess_isNull arg = match _StochasticProcess_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcess_asObservable_f : c_obj list -> c_obj list = "_wrap_StochasticProcess_asObservableQuantLib" ;;
let _StochasticProcess_asObservable arg = match _StochasticProcess_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcess_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessQuantLib" ;;
let _new_StochasticProcess arg = match _new_StochasticProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcess_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcessQuantLib" ;;
let _delete_StochasticProcess arg = match _delete_StochasticProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcess1D_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcess1DQuantLib" ;;
let _delete_StochasticProcess1D arg = match _delete_StochasticProcess1D_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GeneralizedBlackScholesPress_f : c_obj list -> c_obj list = "_wrap_new_GeneralizedBlackScholesPressQuantLib" ;;
let _new_GeneralizedBlackScholesPress arg = match _new_GeneralizedBlackScholesPress_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GeneralizedBlackScholesPress_f : c_obj list -> c_obj list = "_wrap_delete_GeneralizedBlackScholesPressQuantLib" ;;
let _delete_GeneralizedBlackScholesPress arg = match _delete_GeneralizedBlackScholesPress_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackScholesProcess_f : c_obj list -> c_obj list = "_wrap_new_BlackScholesProcessQuantLib" ;;
let _new_BlackScholesProcess arg = match _new_BlackScholesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackScholesProcess_f : c_obj list -> c_obj list = "_wrap_delete_BlackScholesProcessQuantLib" ;;
let _delete_BlackScholesProcess arg = match _delete_BlackScholesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackScholesMertonProcess_f : c_obj list -> c_obj list = "_wrap_new_BlackScholesMertonProcessQuantLib" ;;
let _new_BlackScholesMertonProcess arg = match _new_BlackScholesMertonProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackScholesMertonProcess_f : c_obj list -> c_obj list = "_wrap_delete_BlackScholesMertonProcessQuantLib" ;;
let _delete_BlackScholesMertonProcess arg = match _delete_BlackScholesMertonProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackProcess_f : c_obj list -> c_obj list = "_wrap_new_BlackProcessQuantLib" ;;
let _new_BlackProcess arg = match _new_BlackProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackProcess_f : c_obj list -> c_obj list = "_wrap_delete_BlackProcessQuantLib" ;;
let _delete_BlackProcess arg = match _delete_BlackProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GarmanKohlagenProcess_f : c_obj list -> c_obj list = "_wrap_new_GarmanKohlagenProcessQuantLib" ;;
let _new_GarmanKohlagenProcess arg = match _new_GarmanKohlagenProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GarmanKohlagenProcess_f : c_obj list -> c_obj list = "_wrap_delete_GarmanKohlagenProcessQuantLib" ;;
let _delete_GarmanKohlagenProcess arg = match _delete_GarmanKohlagenProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Merton76Process_f : c_obj list -> c_obj list = "_wrap_new_Merton76ProcessQuantLib" ;;
let _new_Merton76Process arg = match _new_Merton76Process_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Merton76Process_f : c_obj list -> c_obj list = "_wrap_delete_Merton76ProcessQuantLib" ;;
let _delete_Merton76Process arg = match _delete_Merton76Process_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessArray_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessArrayQuantLib" ;;
let _new_StochasticProcessArray arg = match _new_StochasticProcessArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcessArray_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcessArrayQuantLib" ;;
let _delete_StochasticProcessArray arg = match _delete_StochasticProcessArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVector__SWIG_0QuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVector__SWIG_1QuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVector__SWIG_2QuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVectorQuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_size_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_sizeQuantLib" ;;
let _StochasticProcessVector_size arg = match _StochasticProcessVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_empty_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_emptyQuantLib" ;;
let _StochasticProcessVector_empty arg = match _StochasticProcessVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_clear_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_clearQuantLib" ;;
let _StochasticProcessVector_clear arg = match _StochasticProcessVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_push_back_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_push_backQuantLib" ;;
let _StochasticProcessVector_push_back arg = match _StochasticProcessVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_operator_bB___QuantLib" ;;
let _StochasticProcessVector_operator_xx_xx_lbrace_xx_rbrace arg = match _StochasticProcessVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_operator_e___QuantLib" ;;
let _StochasticProcessVector_operator_xx_xx_equals arg = match _StochasticProcessVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_set_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_setQuantLib" ;;
let _StochasticProcessVector_set arg = match _StochasticProcessVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_to_array_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_to_arrayQuantLib" ;;
let _StochasticProcessVector_to_array arg = match _StochasticProcessVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcessVectorQuantLib" ;;
let _delete_StochasticProcessVector arg = match _delete_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PricingEngine___deref___f : c_obj list -> c_obj list = "_wrap_PricingEngine___deref__QuantLib" ;;
let _PricingEngine___deref__ arg = match _PricingEngine___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PricingEngine_isNull_f : c_obj list -> c_obj list = "_wrap_PricingEngine_isNullQuantLib" ;;
let _PricingEngine_isNull arg = match _PricingEngine_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PricingEngine_f : c_obj list -> c_obj list = "_wrap_new_PricingEngineQuantLib" ;;
let _new_PricingEngine arg = match _new_PricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PricingEngine_f : c_obj list -> c_obj list = "_wrap_delete_PricingEngineQuantLib" ;;
let _delete_PricingEngine arg = match _delete_PricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument___deref___f : c_obj list -> c_obj list = "_wrap_Instrument___deref__QuantLib" ;;
let _Instrument___deref__ arg = match _Instrument___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_isNull_f : c_obj list -> c_obj list = "_wrap_Instrument_isNullQuantLib" ;;
let _Instrument_isNull arg = match _Instrument_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_asObservable_f : c_obj list -> c_obj list = "_wrap_Instrument_asObservableQuantLib" ;;
let _Instrument_asObservable arg = match _Instrument_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Instrument_f : c_obj list -> c_obj list = "_wrap_new_InstrumentQuantLib" ;;
let _new_Instrument arg = match _new_Instrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Instrument_f : c_obj list -> c_obj list = "_wrap_delete_InstrumentQuantLib" ;;
let _delete_Instrument arg = match _delete_Instrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_NPV_f : c_obj list -> c_obj list = "_wrap_Instrument_NPVQuantLib" ;;
let _Instrument_NPV arg = match _Instrument_NPV_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_errorEstimate_f : c_obj list -> c_obj list = "_wrap_Instrument_errorEstimateQuantLib" ;;
let _Instrument_errorEstimate arg = match _Instrument_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_isExpired_f : c_obj list -> c_obj list = "_wrap_Instrument_isExpiredQuantLib" ;;
let _Instrument_isExpired arg = match _Instrument_isExpired_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_setPricingEngine_f : c_obj list -> c_obj list = "_wrap_Instrument_setPricingEngineQuantLib" ;;
let _Instrument_setPricingEngine arg = match _Instrument_setPricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_recalculate_f : c_obj list -> c_obj list = "_wrap_Instrument_recalculateQuantLib" ;;
let _Instrument_recalculate arg = match _Instrument_recalculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_freeze_f : c_obj list -> c_obj list = "_wrap_Instrument_freezeQuantLib" ;;
let _Instrument_freeze arg = match _Instrument_freeze_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_unfreeze_f : c_obj list -> c_obj list = "_wrap_Instrument_unfreezeQuantLib" ;;
let _Instrument_unfreeze arg = match _Instrument_unfreeze_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Stock_f : c_obj list -> c_obj list = "_wrap_new_StockQuantLib" ;;
let _new_Stock arg = match _new_Stock_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Stock_f : c_obj list -> c_obj list = "_wrap_delete_StockQuantLib" ;;
let _delete_Stock arg = match _delete_Stock_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CompositeInstrument_f : c_obj list -> c_obj list = "_wrap_new_CompositeInstrumentQuantLib" ;;
let _new_CompositeInstrument arg = match _new_CompositeInstrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_add_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_add__SWIG_0QuantLib" ;;
let _CompositeInstrument_add arg = match _CompositeInstrument_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_add_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_addQuantLib" ;;
let _CompositeInstrument_add arg = match _CompositeInstrument_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_subtract_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_subtract__SWIG_0QuantLib" ;;
let _CompositeInstrument_subtract arg = match _CompositeInstrument_subtract_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_subtract_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_subtractQuantLib" ;;
let _CompositeInstrument_subtract arg = match _CompositeInstrument_subtract_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CompositeInstrument_f : c_obj list -> c_obj list = "_wrap_delete_CompositeInstrumentQuantLib" ;;
let _delete_CompositeInstrument arg = match _delete_CompositeInstrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Option::Type_marker" (`Type)
external _Put : c_obj -> Swig.c_obj = "_wrap_Put" 
external _Call : c_obj -> Swig.c_obj = "_wrap_Call" 
external _delete_Option_f : c_obj list -> c_obj list = "_wrap_delete_OptionQuantLib" ;;
let _delete_Option arg = match _delete_Option_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Barrier::Type_marker" (`Type)
external _DownIn : c_obj -> Swig.c_obj = "_wrap_DownIn" 
external _UpIn : c_obj -> Swig.c_obj = "_wrap_UpIn" 
external _DownOut : c_obj -> Swig.c_obj = "_wrap_DownOut" 
external _UpOut : c_obj -> Swig.c_obj = "_wrap_UpOut" 
external _new_Barrier_f : c_obj list -> c_obj list = "_wrap_new_BarrierQuantLib" ;;
let _new_Barrier arg = match _new_Barrier_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Barrier_f : c_obj list -> c_obj list = "_wrap_delete_BarrierQuantLib" ;;
let _delete_Barrier arg = match _delete_Barrier_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Payoff___deref___f : c_obj list -> c_obj list = "_wrap_Payoff___deref__QuantLib" ;;
let _Payoff___deref__ arg = match _Payoff___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Payoff_isNull_f : c_obj list -> c_obj list = "_wrap_Payoff_isNullQuantLib" ;;
let _Payoff_isNull arg = match _Payoff_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Payoff_f : c_obj list -> c_obj list = "_wrap_new_PayoffQuantLib" ;;
let _new_Payoff arg = match _new_Payoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Payoff_f : c_obj list -> c_obj list = "_wrap_delete_PayoffQuantLib" ;;
let _delete_Payoff arg = match _delete_Payoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Payoff_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_Payoff_operator_pP___QuantLib" ;;
let _Payoff_operator_xx_xx_lparen_xx_rparen arg = match _Payoff_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_VanillaOption_f : c_obj list -> c_obj list = "_wrap_new_VanillaOption__SWIG_0QuantLib" ;;
let _new_VanillaOption arg = match _new_VanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_VanillaOption_f : c_obj list -> c_obj list = "_wrap_new_VanillaOptionQuantLib" ;;
let _new_VanillaOption arg = match _new_VanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_delta_f : c_obj list -> c_obj list = "_wrap_VanillaOption_deltaQuantLib" ;;
let _VanillaOption_delta arg = match _VanillaOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_gamma_f : c_obj list -> c_obj list = "_wrap_VanillaOption_gammaQuantLib" ;;
let _VanillaOption_gamma arg = match _VanillaOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_theta_f : c_obj list -> c_obj list = "_wrap_VanillaOption_thetaQuantLib" ;;
let _VanillaOption_theta arg = match _VanillaOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_thetaPerDay_f : c_obj list -> c_obj list = "_wrap_VanillaOption_thetaPerDayQuantLib" ;;
let _VanillaOption_thetaPerDay arg = match _VanillaOption_thetaPerDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_vega_f : c_obj list -> c_obj list = "_wrap_VanillaOption_vegaQuantLib" ;;
let _VanillaOption_vega arg = match _VanillaOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_rho_f : c_obj list -> c_obj list = "_wrap_VanillaOption_rhoQuantLib" ;;
let _VanillaOption_rho arg = match _VanillaOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_VanillaOption_dividendRhoQuantLib" ;;
let _VanillaOption_dividendRho arg = match _VanillaOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_VanillaOption_strikeSensitivityQuantLib" ;;
let _VanillaOption_strikeSensitivity arg = match _VanillaOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_priceCurve_f : c_obj list -> c_obj list = "_wrap_VanillaOption_priceCurveQuantLib" ;;
let _VanillaOption_priceCurve arg = match _VanillaOption_priceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_0QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_1QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_2QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_3QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatilityQuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_VanillaOptionQuantLib" ;;
let _delete_VanillaOption arg = match _delete_VanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuropeanOption_f : c_obj list -> c_obj list = "_wrap_new_EuropeanOption__SWIG_0QuantLib" ;;
let _new_EuropeanOption arg = match _new_EuropeanOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuropeanOption_f : c_obj list -> c_obj list = "_wrap_new_EuropeanOptionQuantLib" ;;
let _new_EuropeanOption arg = match _new_EuropeanOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuropeanOption_f : c_obj list -> c_obj list = "_wrap_delete_EuropeanOptionQuantLib" ;;
let _delete_EuropeanOption arg = match _delete_EuropeanOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_ForwardVanillaOption__SWIG_0QuantLib" ;;
let _new_ForwardVanillaOption arg = match _new_ForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_ForwardVanillaOptionQuantLib" ;;
let _new_ForwardVanillaOption arg = match _new_ForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_ForwardVanillaOptionQuantLib" ;;
let _delete_ForwardVanillaOption arg = match _delete_ForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_QuantoVanillaOption__SWIG_0QuantLib" ;;
let _new_QuantoVanillaOption arg = match _new_QuantoVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_QuantoVanillaOptionQuantLib" ;;
let _new_QuantoVanillaOption arg = match _new_QuantoVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuantoVanillaOption_qvega_f : c_obj list -> c_obj list = "_wrap_QuantoVanillaOption_qvegaQuantLib" ;;
let _QuantoVanillaOption_qvega arg = match _QuantoVanillaOption_qvega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuantoVanillaOption_qrho_f : c_obj list -> c_obj list = "_wrap_QuantoVanillaOption_qrhoQuantLib" ;;
let _QuantoVanillaOption_qrho arg = match _QuantoVanillaOption_qrho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuantoVanillaOption_qlambda_f : c_obj list -> c_obj list = "_wrap_QuantoVanillaOption_qlambdaQuantLib" ;;
let _QuantoVanillaOption_qlambda arg = match _QuantoVanillaOption_qlambda_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_QuantoVanillaOptionQuantLib" ;;
let _delete_QuantoVanillaOption arg = match _delete_QuantoVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_QuantoForwardVanillaOption__SWIG_0QuantLib" ;;
let _new_QuantoForwardVanillaOption arg = match _new_QuantoForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_QuantoForwardVanillaOptionQuantLib" ;;
let _new_QuantoForwardVanillaOption arg = match _new_QuantoForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_QuantoForwardVanillaOptionQuantLib" ;;
let _delete_QuantoForwardVanillaOption arg = match _delete_QuantoForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_delta_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_deltaQuantLib" ;;
let _MultiAssetOption_delta arg = match _MultiAssetOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_gamma_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_gammaQuantLib" ;;
let _MultiAssetOption_gamma arg = match _MultiAssetOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_theta_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_thetaQuantLib" ;;
let _MultiAssetOption_theta arg = match _MultiAssetOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_vega_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_vegaQuantLib" ;;
let _MultiAssetOption_vega arg = match _MultiAssetOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_rho_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_rhoQuantLib" ;;
let _MultiAssetOption_rho arg = match _MultiAssetOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_dividendRhoQuantLib" ;;
let _MultiAssetOption_dividendRho arg = match _MultiAssetOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MultiAssetOption_f : c_obj list -> c_obj list = "_wrap_new_MultiAssetOptionQuantLib" ;;
let _new_MultiAssetOption arg = match _new_MultiAssetOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MultiAssetOption_f : c_obj list -> c_obj list = "_wrap_delete_MultiAssetOptionQuantLib" ;;
let _delete_MultiAssetOption arg = match _delete_MultiAssetOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticEuropeanEngineQuantLib" ;;
let _new_AnalyticEuropeanEngine arg = match _new_AnalyticEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticEuropeanEngineQuantLib" ;;
let _delete_AnalyticEuropeanEngine arg = match _delete_AnalyticEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntegralEngine_f : c_obj list -> c_obj list = "_wrap_new_IntegralEngineQuantLib" ;;
let _new_IntegralEngine arg = match _new_IntegralEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntegralEngine_f : c_obj list -> c_obj list = "_wrap_delete_IntegralEngineQuantLib" ;;
let _delete_IntegralEngine arg = match _delete_IntegralEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngine__SWIG_0QuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngine__SWIG_1QuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngine__SWIG_2QuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngineQuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDEuropeanEngineQuantLib" ;;
let _delete_FDEuropeanEngine arg = match _delete_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BinomialVanillaEngine_f : c_obj list -> c_obj list = "_wrap_new_BinomialVanillaEngineQuantLib" ;;
let _new_BinomialVanillaEngine arg = match _new_BinomialVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BinomialVanillaEngine_f : c_obj list -> c_obj list = "_wrap_delete_BinomialVanillaEngineQuantLib" ;;
let _delete_BinomialVanillaEngine arg = match _delete_BinomialVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_MCEuropeanEngineQuantLib" ;;
let _new_MCEuropeanEngine arg = match _new_MCEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCEuropeanEngineQuantLib" ;;
let _delete_MCEuropeanEngine arg = match _delete_MCEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngine__SWIG_0QuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngine__SWIG_1QuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngine__SWIG_2QuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngineQuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDAmericanEngineQuantLib" ;;
let _delete_FDAmericanEngine arg = match _delete_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngine__SWIG_0QuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngine__SWIG_1QuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngine__SWIG_2QuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngineQuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDShoutEngineQuantLib" ;;
let _delete_FDShoutEngine arg = match _delete_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BaroneAdesiWhaleyEngine_f : c_obj list -> c_obj list = "_wrap_new_BaroneAdesiWhaleyEngineQuantLib" ;;
let _new_BaroneAdesiWhaleyEngine arg = match _new_BaroneAdesiWhaleyEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BaroneAdesiWhaleyEngine_f : c_obj list -> c_obj list = "_wrap_delete_BaroneAdesiWhaleyEngineQuantLib" ;;
let _delete_BaroneAdesiWhaleyEngine arg = match _delete_BaroneAdesiWhaleyEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BjerksundStenslandEngine_f : c_obj list -> c_obj list = "_wrap_new_BjerksundStenslandEngineQuantLib" ;;
let _new_BjerksundStenslandEngine arg = match _new_BjerksundStenslandEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BjerksundStenslandEngine_f : c_obj list -> c_obj list = "_wrap_delete_BjerksundStenslandEngineQuantLib" ;;
let _delete_BjerksundStenslandEngine arg = match _delete_BjerksundStenslandEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticDigitalAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticDigitalAmericanEngineQuantLib" ;;
let _new_AnalyticDigitalAmericanEngine arg = match _new_AnalyticDigitalAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticDigitalAmericanEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticDigitalAmericanEngineQuantLib" ;;
let _delete_AnalyticDigitalAmericanEngine arg = match _delete_AnalyticDigitalAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DividendVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_DividendVanillaOption__SWIG_0QuantLib" ;;
let _new_DividendVanillaOption arg = match _new_DividendVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DividendVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_DividendVanillaOptionQuantLib" ;;
let _new_DividendVanillaOption arg = match _new_DividendVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_delta_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_deltaQuantLib" ;;
let _DividendVanillaOption_delta arg = match _DividendVanillaOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_gamma_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_gammaQuantLib" ;;
let _DividendVanillaOption_gamma arg = match _DividendVanillaOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_theta_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_thetaQuantLib" ;;
let _DividendVanillaOption_theta arg = match _DividendVanillaOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_vega_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_vegaQuantLib" ;;
let _DividendVanillaOption_vega arg = match _DividendVanillaOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_rho_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_rhoQuantLib" ;;
let _DividendVanillaOption_rho arg = match _DividendVanillaOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_dividendRhoQuantLib" ;;
let _DividendVanillaOption_dividendRho arg = match _DividendVanillaOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_strikeSensitivityQuantLib" ;;
let _DividendVanillaOption_strikeSensitivity arg = match _DividendVanillaOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_priceCurve_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_priceCurveQuantLib" ;;
let _DividendVanillaOption_priceCurve arg = match _DividendVanillaOption_priceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_0QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_1QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_2QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_3QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatilityQuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DividendVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_DividendVanillaOptionQuantLib" ;;
let _delete_DividendVanillaOption arg = match _delete_DividendVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticDividendEuropeanEngineQuantLib" ;;
let _new_AnalyticDividendEuropeanEngine arg = match _new_AnalyticDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticDividendEuropeanEngineQuantLib" ;;
let _delete_AnalyticDividendEuropeanEngine arg = match _delete_AnalyticDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngine__SWIG_0QuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngine__SWIG_1QuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngine__SWIG_2QuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngineQuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDDividendEuropeanEngineQuantLib" ;;
let _delete_FDDividendEuropeanEngine arg = match _delete_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngine__SWIG_0QuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngine__SWIG_1QuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngine__SWIG_2QuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngineQuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDDividendAmericanEngineQuantLib" ;;
let _delete_FDDividendAmericanEngine arg = match _delete_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BarrierOption_f : c_obj list -> c_obj list = "_wrap_new_BarrierOption__SWIG_0QuantLib" ;;
let _new_BarrierOption arg = match _new_BarrierOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BarrierOption_f : c_obj list -> c_obj list = "_wrap_new_BarrierOptionQuantLib" ;;
let _new_BarrierOption arg = match _new_BarrierOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_delta_f : c_obj list -> c_obj list = "_wrap_BarrierOption_deltaQuantLib" ;;
let _BarrierOption_delta arg = match _BarrierOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_gamma_f : c_obj list -> c_obj list = "_wrap_BarrierOption_gammaQuantLib" ;;
let _BarrierOption_gamma arg = match _BarrierOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_theta_f : c_obj list -> c_obj list = "_wrap_BarrierOption_thetaQuantLib" ;;
let _BarrierOption_theta arg = match _BarrierOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_vega_f : c_obj list -> c_obj list = "_wrap_BarrierOption_vegaQuantLib" ;;
let _BarrierOption_vega arg = match _BarrierOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_rho_f : c_obj list -> c_obj list = "_wrap_BarrierOption_rhoQuantLib" ;;
let _BarrierOption_rho arg = match _BarrierOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_BarrierOption_dividendRhoQuantLib" ;;
let _BarrierOption_dividendRho arg = match _BarrierOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_BarrierOption_strikeSensitivityQuantLib" ;;
let _BarrierOption_strikeSensitivity arg = match _BarrierOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_priceCurve_f : c_obj list -> c_obj list = "_wrap_BarrierOption_priceCurveQuantLib" ;;
let _BarrierOption_priceCurve arg = match _BarrierOption_priceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_0QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_1QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_2QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_3QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatilityQuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BarrierOption_f : c_obj list -> c_obj list = "_wrap_delete_BarrierOptionQuantLib" ;;
let _delete_BarrierOption arg = match _delete_BarrierOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticBarrierEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticBarrierEngineQuantLib" ;;
let _new_AnalyticBarrierEngine arg = match _new_AnalyticBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticBarrierEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticBarrierEngineQuantLib" ;;
let _delete_AnalyticBarrierEngine arg = match _delete_AnalyticBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCBarrierEngine_f : c_obj list -> c_obj list = "_wrap_new_MCBarrierEngineQuantLib" ;;
let _new_MCBarrierEngine arg = match _new_MCBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCBarrierEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCBarrierEngineQuantLib" ;;
let _delete_MCBarrierEngine arg = match _delete_MCBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardVanillaEngine_f : c_obj list -> c_obj list = "_wrap_new_ForwardVanillaEngineQuantLib" ;;
let _new_ForwardVanillaEngine arg = match _new_ForwardVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardVanillaEngine_f : c_obj list -> c_obj list = "_wrap_delete_ForwardVanillaEngineQuantLib" ;;
let _delete_ForwardVanillaEngine arg = match _delete_ForwardVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoVanillaEngine_f : c_obj list -> c_obj list = "_wrap_new_QuantoVanillaEngineQuantLib" ;;
let _new_QuantoVanillaEngine arg = match _new_QuantoVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoVanillaEngine_f : c_obj list -> c_obj list = "_wrap_delete_QuantoVanillaEngineQuantLib" ;;
let _delete_QuantoVanillaEngine arg = match _delete_QuantoVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoForwardVanillaEngine_f : c_obj list -> c_obj list = "_wrap_new_QuantoForwardVanillaEngineQuantLib" ;;
let _new_QuantoForwardVanillaEngine arg = match _new_QuantoForwardVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoForwardVanillaEngine_f : c_obj list -> c_obj list = "_wrap_delete_QuantoForwardVanillaEngineQuantLib" ;;
let _delete_QuantoForwardVanillaEngine arg = match _delete_QuantoForwardVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PlainVanillaPayoff_f : c_obj list -> c_obj list = "_wrap_new_PlainVanillaPayoffQuantLib" ;;
let _new_PlainVanillaPayoff arg = match _new_PlainVanillaPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PlainVanillaPayoff_f : c_obj list -> c_obj list = "_wrap_delete_PlainVanillaPayoffQuantLib" ;;
let _delete_PlainVanillaPayoff arg = match _delete_PlainVanillaPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PercentageStrikePayoff_f : c_obj list -> c_obj list = "_wrap_new_PercentageStrikePayoffQuantLib" ;;
let _new_PercentageStrikePayoff arg = match _new_PercentageStrikePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PercentageStrikePayoff_f : c_obj list -> c_obj list = "_wrap_delete_PercentageStrikePayoffQuantLib" ;;
let _delete_PercentageStrikePayoff arg = match _delete_PercentageStrikePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CashOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_new_CashOrNothingPayoffQuantLib" ;;
let _new_CashOrNothingPayoff arg = match _new_CashOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CashOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_delete_CashOrNothingPayoffQuantLib" ;;
let _delete_CashOrNothingPayoff arg = match _delete_CashOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AssetOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_new_AssetOrNothingPayoffQuantLib" ;;
let _new_AssetOrNothingPayoff arg = match _new_AssetOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AssetOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_delete_AssetOrNothingPayoffQuantLib" ;;
let _delete_AssetOrNothingPayoff arg = match _delete_AssetOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SuperSharePayoff_f : c_obj list -> c_obj list = "_wrap_new_SuperSharePayoffQuantLib" ;;
let _new_SuperSharePayoff arg = match _new_SuperSharePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SuperSharePayoff_f : c_obj list -> c_obj list = "_wrap_delete_SuperSharePayoffQuantLib" ;;
let _delete_SuperSharePayoff arg = match _delete_SuperSharePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GapPayoff_f : c_obj list -> c_obj list = "_wrap_new_GapPayoffQuantLib" ;;
let _new_GapPayoff arg = match _new_GapPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GapPayoff_f : c_obj list -> c_obj list = "_wrap_delete_GapPayoffQuantLib" ;;
let _delete_GapPayoff arg = match _delete_GapPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_BasketPayoffQuantLib" ;;
let _new_BasketPayoff arg = match _new_BasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_BasketPayoffQuantLib" ;;
let _delete_BasketPayoff arg = match _delete_BasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MinBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_MinBasketPayoffQuantLib" ;;
let _new_MinBasketPayoff arg = match _new_MinBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MinBasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_MinBasketPayoffQuantLib" ;;
let _delete_MinBasketPayoff arg = match _delete_MinBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MaxBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_MaxBasketPayoffQuantLib" ;;
let _new_MaxBasketPayoff arg = match _new_MaxBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MaxBasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_MaxBasketPayoffQuantLib" ;;
let _delete_MaxBasketPayoff arg = match _delete_MaxBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AverageBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_AverageBasketPayoff__SWIG_0QuantLib" ;;
let _new_AverageBasketPayoff arg = match _new_AverageBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AverageBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_AverageBasketPayoffQuantLib" ;;
let _new_AverageBasketPayoff arg = match _new_AverageBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AverageBasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_AverageBasketPayoffQuantLib" ;;
let _delete_AverageBasketPayoff arg = match _delete_AverageBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BasketOption_f : c_obj list -> c_obj list = "_wrap_new_BasketOption__SWIG_0QuantLib" ;;
let _new_BasketOption arg = match _new_BasketOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BasketOption_f : c_obj list -> c_obj list = "_wrap_new_BasketOptionQuantLib" ;;
let _new_BasketOption arg = match _new_BasketOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BasketOption_f : c_obj list -> c_obj list = "_wrap_delete_BasketOptionQuantLib" ;;
let _delete_BasketOption arg = match _delete_BasketOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCBasketEngine_f : c_obj list -> c_obj list = "_wrap_new_MCBasketEngineQuantLib" ;;
let _new_MCBasketEngine arg = match _new_MCBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCBasketEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCBasketEngineQuantLib" ;;
let _delete_MCBasketEngine arg = match _delete_MCBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCAmericanBasketEngine_f : c_obj list -> c_obj list = "_wrap_new_MCAmericanBasketEngineQuantLib" ;;
let _new_MCAmericanBasketEngine arg = match _new_MCAmericanBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCAmericanBasketEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCAmericanBasketEngineQuantLib" ;;
let _delete_MCAmericanBasketEngine arg = match _delete_MCAmericanBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StulzEngine_f : c_obj list -> c_obj list = "_wrap_new_StulzEngineQuantLib" ;;
let _new_StulzEngine arg = match _new_StulzEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StulzEngine_f : c_obj list -> c_obj list = "_wrap_delete_StulzEngineQuantLib" ;;
let _delete_StulzEngine arg = match _delete_StulzEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RealTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_RealTimeSeries__SWIG_0QuantLib" ;;
let _new_RealTimeSeries arg = match _new_RealTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RealTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_RealTimeSeriesQuantLib" ;;
let _new_RealTimeSeries arg = match _new_RealTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RealTimeSeries_dates_f : c_obj list -> c_obj list = "_wrap_RealTimeSeries_datesQuantLib" ;;
let _RealTimeSeries_dates arg = match _RealTimeSeries_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RealTimeSeries_values_f : c_obj list -> c_obj list = "_wrap_RealTimeSeries_valuesQuantLib" ;;
let _RealTimeSeries_values arg = match _RealTimeSeries_values_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RealTimeSeries_size_f : c_obj list -> c_obj list = "_wrap_RealTimeSeries_sizeQuantLib" ;;
let _RealTimeSeries_size arg = match _RealTimeSeries_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RealTimeSeries_f : c_obj list -> c_obj list = "_wrap_delete_RealTimeSeriesQuantLib" ;;
let _delete_RealTimeSeries arg = match _delete_RealTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceTimeSeries__SWIG_0QuantLib" ;;
let _new_IntervalPriceTimeSeries arg = match _new_IntervalPriceTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceTimeSeriesQuantLib" ;;
let _new_IntervalPriceTimeSeries arg = match _new_IntervalPriceTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceTimeSeries_dates_f : c_obj list -> c_obj list = "_wrap_IntervalPriceTimeSeries_datesQuantLib" ;;
let _IntervalPriceTimeSeries_dates arg = match _IntervalPriceTimeSeries_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceTimeSeries_values_f : c_obj list -> c_obj list = "_wrap_IntervalPriceTimeSeries_valuesQuantLib" ;;
let _IntervalPriceTimeSeries_values arg = match _IntervalPriceTimeSeries_values_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceTimeSeries_size_f : c_obj list -> c_obj list = "_wrap_IntervalPriceTimeSeries_sizeQuantLib" ;;
let _IntervalPriceTimeSeries_size arg = match _IntervalPriceTimeSeries_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntervalPriceTimeSeries_f : c_obj list -> c_obj list = "_wrap_delete_IntervalPriceTimeSeriesQuantLib" ;;
let _delete_IntervalPriceTimeSeries arg = match _delete_IntervalPriceTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVector__SWIG_0QuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVector__SWIG_1QuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVector__SWIG_2QuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVectorQuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_size_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_sizeQuantLib" ;;
let _IntervalPriceVector_size arg = match _IntervalPriceVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_empty_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_emptyQuantLib" ;;
let _IntervalPriceVector_empty arg = match _IntervalPriceVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_clear_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_clearQuantLib" ;;
let _IntervalPriceVector_clear arg = match _IntervalPriceVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_push_back_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_push_backQuantLib" ;;
let _IntervalPriceVector_push_back arg = match _IntervalPriceVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_operator_bB___QuantLib" ;;
let _IntervalPriceVector_operator_xx_xx_lbrace_xx_rbrace arg = match _IntervalPriceVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_operator_e___QuantLib" ;;
let _IntervalPriceVector_operator_xx_xx_equals arg = match _IntervalPriceVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_set_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_setQuantLib" ;;
let _IntervalPriceVector_set arg = match _IntervalPriceVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_to_array_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_to_arrayQuantLib" ;;
let _IntervalPriceVector_to_array arg = match _IntervalPriceVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_delete_IntervalPriceVectorQuantLib" ;;
let _delete_IntervalPriceVector arg = match _delete_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "IntervalPrice::Type_marker" (`Type)
external _Open : c_obj -> Swig.c_obj = "_wrap_Open" 
external _Close : c_obj -> Swig.c_obj = "_wrap_Close" 
external _High : c_obj -> Swig.c_obj = "_wrap_High" 
external _Low : c_obj -> Swig.c_obj = "_wrap_Low" 
external _new_IntervalPrice_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceQuantLib" ;;
let _new_IntervalPrice arg = match _new_IntervalPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_setValue_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_setValueQuantLib" ;;
let _IntervalPrice_setValue arg = match _IntervalPrice_setValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_setValues_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_setValuesQuantLib" ;;
let _IntervalPrice_setValues arg = match _IntervalPrice_setValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_value_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_valueQuantLib" ;;
let _IntervalPrice_value arg = match _IntervalPrice_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_open_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_openQuantLib" ;;
let _IntervalPrice_open arg = match _IntervalPrice_open_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_close_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_closeQuantLib" ;;
let _IntervalPrice_close arg = match _IntervalPrice_close_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_high_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_highQuantLib" ;;
let _IntervalPrice_high arg = match _IntervalPrice_high_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_low_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_lowQuantLib" ;;
let _IntervalPrice_low arg = match _IntervalPrice_low_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_makeSeries_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_makeSeriesQuantLib" ;;
let _IntervalPrice_makeSeries arg = match _IntervalPrice_makeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_extractValues_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_extractValuesQuantLib" ;;
let _IntervalPrice_extractValues arg = match _IntervalPrice_extractValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_extractComponent_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_extractComponentQuantLib" ;;
let _IntervalPrice_extractComponent arg = match _IntervalPrice_extractComponent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntervalPrice_f : c_obj list -> c_obj list = "_wrap_delete_IntervalPriceQuantLib" ;;
let _delete_IntervalPrice arg = match _delete_IntervalPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVector__SWIG_0QuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVector__SWIG_1QuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVector__SWIG_2QuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVectorQuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_size_f : c_obj list -> c_obj list = "_wrap_IntVector_sizeQuantLib" ;;
let _IntVector_size arg = match _IntVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_empty_f : c_obj list -> c_obj list = "_wrap_IntVector_emptyQuantLib" ;;
let _IntVector_empty arg = match _IntVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_clear_f : c_obj list -> c_obj list = "_wrap_IntVector_clearQuantLib" ;;
let _IntVector_clear arg = match _IntVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_push_back_f : c_obj list -> c_obj list = "_wrap_IntVector_push_backQuantLib" ;;
let _IntVector_push_back arg = match _IntVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_IntVector_operator_bB___QuantLib" ;;
let _IntVector_operator_xx_xx_lbrace_xx_rbrace arg = match _IntVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_IntVector_operator_e___QuantLib" ;;
let _IntVector_operator_xx_xx_equals arg = match _IntVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_set_f : c_obj list -> c_obj list = "_wrap_IntVector_setQuantLib" ;;
let _IntVector_set arg = match _IntVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_to_array_f : c_obj list -> c_obj list = "_wrap_IntVector_to_arrayQuantLib" ;;
let _IntVector_to_array arg = match _IntVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntVector_f : c_obj list -> c_obj list = "_wrap_delete_IntVectorQuantLib" ;;
let _delete_IntVector arg = match _delete_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVector__SWIG_0QuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVector__SWIG_1QuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVector__SWIG_2QuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVectorQuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_size_f : c_obj list -> c_obj list = "_wrap_DoubleVector_sizeQuantLib" ;;
let _DoubleVector_size arg = match _DoubleVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_empty_f : c_obj list -> c_obj list = "_wrap_DoubleVector_emptyQuantLib" ;;
let _DoubleVector_empty arg = match _DoubleVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_clear_f : c_obj list -> c_obj list = "_wrap_DoubleVector_clearQuantLib" ;;
let _DoubleVector_clear arg = match _DoubleVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_push_back_f : c_obj list -> c_obj list = "_wrap_DoubleVector_push_backQuantLib" ;;
let _DoubleVector_push_back arg = match _DoubleVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_DoubleVector_operator_bB___QuantLib" ;;
let _DoubleVector_operator_xx_xx_lbrace_xx_rbrace arg = match _DoubleVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_DoubleVector_operator_e___QuantLib" ;;
let _DoubleVector_operator_xx_xx_equals arg = match _DoubleVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_set_f : c_obj list -> c_obj list = "_wrap_DoubleVector_setQuantLib" ;;
let _DoubleVector_set arg = match _DoubleVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_to_array_f : c_obj list -> c_obj list = "_wrap_DoubleVector_to_arrayQuantLib" ;;
let _DoubleVector_to_array arg = match _DoubleVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DoubleVector_f : c_obj list -> c_obj list = "_wrap_delete_DoubleVectorQuantLib" ;;
let _delete_DoubleVector arg = match _delete_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVector__SWIG_0QuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVector__SWIG_1QuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVector__SWIG_2QuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVectorQuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_size_f : c_obj list -> c_obj list = "_wrap_StrVector_sizeQuantLib" ;;
let _StrVector_size arg = match _StrVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_empty_f : c_obj list -> c_obj list = "_wrap_StrVector_emptyQuantLib" ;;
let _StrVector_empty arg = match _StrVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_clear_f : c_obj list -> c_obj list = "_wrap_StrVector_clearQuantLib" ;;
let _StrVector_clear arg = match _StrVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_push_back_f : c_obj list -> c_obj list = "_wrap_StrVector_push_backQuantLib" ;;
let _StrVector_push_back arg = match _StrVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_StrVector_operator_bB___QuantLib" ;;
let _StrVector_operator_xx_xx_lbrace_xx_rbrace arg = match _StrVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_StrVector_operator_e___QuantLib" ;;
let _StrVector_operator_xx_xx_equals arg = match _StrVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_set_f : c_obj list -> c_obj list = "_wrap_StrVector_setQuantLib" ;;
let _StrVector_set arg = match _StrVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_to_array_f : c_obj list -> c_obj list = "_wrap_StrVector_to_arrayQuantLib" ;;
let _StrVector_to_array arg = match _StrVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StrVector_f : c_obj list -> c_obj list = "_wrap_delete_StrVectorQuantLib" ;;
let _delete_StrVector arg = match _delete_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodePair_f : c_obj list -> c_obj list = "_wrap_new_NodePair__SWIG_0QuantLib" ;;
let _new_NodePair arg = match _new_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodePair_f : c_obj list -> c_obj list = "_wrap_new_NodePair__SWIG_1QuantLib" ;;
let _new_NodePair arg = match _new_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodePair_f : c_obj list -> c_obj list = "_wrap_new_NodePairQuantLib" ;;
let _new_NodePair arg = match _new_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_first_set_f : c_obj list -> c_obj list = "_wrap_NodePair_first_setQuantLib" ;;
let _NodePair_first_set arg = match _NodePair_first_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_first_get_f : c_obj list -> c_obj list = "_wrap_NodePair_first_getQuantLib" ;;
let _NodePair_first_get arg = match _NodePair_first_get_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_second_set_f : c_obj list -> c_obj list = "_wrap_NodePair_second_setQuantLib" ;;
let _NodePair_second_set arg = match _NodePair_second_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_second_get_f : c_obj list -> c_obj list = "_wrap_NodePair_second_getQuantLib" ;;
let _NodePair_second_get arg = match _NodePair_second_get_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NodePair_f : c_obj list -> c_obj list = "_wrap_delete_NodePairQuantLib" ;;
let _delete_NodePair arg = match _delete_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVector__SWIG_0QuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVector__SWIG_1QuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVector__SWIG_2QuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVectorQuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_size_f : c_obj list -> c_obj list = "_wrap_NodeVector_sizeQuantLib" ;;
let _NodeVector_size arg = match _NodeVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_empty_f : c_obj list -> c_obj list = "_wrap_NodeVector_emptyQuantLib" ;;
let _NodeVector_empty arg = match _NodeVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_clear_f : c_obj list -> c_obj list = "_wrap_NodeVector_clearQuantLib" ;;
let _NodeVector_clear arg = match _NodeVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_push_back_f : c_obj list -> c_obj list = "_wrap_NodeVector_push_backQuantLib" ;;
let _NodeVector_push_back arg = match _NodeVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_NodeVector_operator_bB___QuantLib" ;;
let _NodeVector_operator_xx_xx_lbrace_xx_rbrace arg = match _NodeVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_NodeVector_operator_e___QuantLib" ;;
let _NodeVector_operator_xx_xx_equals arg = match _NodeVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_set_f : c_obj list -> c_obj list = "_wrap_NodeVector_setQuantLib" ;;
let _NodeVector_set arg = match _NodeVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_to_array_f : c_obj list -> c_obj list = "_wrap_NodeVector_to_arrayQuantLib" ;;
let _NodeVector_to_array arg = match _NodeVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NodeVector_f : c_obj list -> c_obj list = "_wrap_delete_NodeVectorQuantLib" ;;
let _delete_NodeVector arg = match _delete_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_instance_f : c_obj list -> c_obj list = "_wrap_IndexManager_instanceQuantLib" ;;
let _IndexManager_instance arg = match _IndexManager_instance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_setHistory_f : c_obj list -> c_obj list = "_wrap_IndexManager_setHistoryQuantLib" ;;
let _IndexManager_setHistory arg = match _IndexManager_setHistory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_getHistory_f : c_obj list -> c_obj list = "_wrap_IndexManager_getHistoryQuantLib" ;;
let _IndexManager_getHistory arg = match _IndexManager_getHistory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_hasHistory_f : c_obj list -> c_obj list = "_wrap_IndexManager_hasHistoryQuantLib" ;;
let _IndexManager_hasHistory arg = match _IndexManager_hasHistory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_histories_f : c_obj list -> c_obj list = "_wrap_IndexManager_historiesQuantLib" ;;
let _IndexManager_histories arg = match _IndexManager_histories_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IndexManager_f : c_obj list -> c_obj list = "_wrap_delete_IndexManagerQuantLib" ;;
let _delete_IndexManager arg = match _delete_IndexManager_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index___deref___f : c_obj list -> c_obj list = "_wrap_Index___deref__QuantLib" ;;
let _Index___deref__ arg = match _Index___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_isNull_f : c_obj list -> c_obj list = "_wrap_Index_isNullQuantLib" ;;
let _Index_isNull arg = match _Index_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_addFixings_f : c_obj list -> c_obj list = "_wrap_Index_addFixingsQuantLib" ;;
let _Index_addFixings arg = match _Index_addFixings_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index___str___f : c_obj list -> c_obj list = "_wrap_Index___str__QuantLib" ;;
let _Index___str__ arg = match _Index___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_asObservable_f : c_obj list -> c_obj list = "_wrap_Index_asObservableQuantLib" ;;
let _Index_asObservable arg = match _Index_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Index_f : c_obj list -> c_obj list = "_wrap_new_IndexQuantLib" ;;
let _new_Index arg = match _new_Index_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Index_f : c_obj list -> c_obj list = "_wrap_delete_IndexQuantLib" ;;
let _delete_Index arg = match _delete_Index_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_name_f : c_obj list -> c_obj list = "_wrap_Index_nameQuantLib" ;;
let _Index_name arg = match _Index_name_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_fixingCalendar_f : c_obj list -> c_obj list = "_wrap_Index_fixingCalendarQuantLib" ;;
let _Index_fixingCalendar arg = match _Index_fixingCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_isValidFixingDate_f : c_obj list -> c_obj list = "_wrap_Index_isValidFixingDateQuantLib" ;;
let _Index_isValidFixingDate arg = match _Index_isValidFixingDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_fixing_f : c_obj list -> c_obj list = "_wrap_Index_fixing__SWIG_0QuantLib" ;;
let _Index_fixing arg = match _Index_fixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_fixing_f : c_obj list -> c_obj list = "_wrap_Index_fixingQuantLib" ;;
let _Index_fixing arg = match _Index_fixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_addFixing_f : c_obj list -> c_obj list = "_wrap_Index_addFixingQuantLib" ;;
let _Index_addFixing arg = match _Index_addFixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_familyName_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_familyNameQuantLib" ;;
let _InterestRateIndex_familyName arg = match _InterestRateIndex_familyName_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_tenor_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_tenorQuantLib" ;;
let _InterestRateIndex_tenor arg = match _InterestRateIndex_tenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_fixingDays_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_fixingDaysQuantLib" ;;
let _InterestRateIndex_fixingDays arg = match _InterestRateIndex_fixingDays_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_fixingDate_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_fixingDateQuantLib" ;;
let _InterestRateIndex_fixingDate arg = match _InterestRateIndex_fixingDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_currency_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_currencyQuantLib" ;;
let _InterestRateIndex_currency arg = match _InterestRateIndex_currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_dayCounter_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_dayCounterQuantLib" ;;
let _InterestRateIndex_dayCounter arg = match _InterestRateIndex_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_forecastFixing_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_forecastFixingQuantLib" ;;
let _InterestRateIndex_forecastFixing arg = match _InterestRateIndex_forecastFixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_termStructure_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_termStructureQuantLib" ;;
let _InterestRateIndex_termStructure arg = match _InterestRateIndex_termStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_maturityDate_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_maturityDateQuantLib" ;;
let _InterestRateIndex_maturityDate arg = match _InterestRateIndex_maturityDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_valueDate_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_valueDateQuantLib" ;;
let _InterestRateIndex_valueDate arg = match _InterestRateIndex_valueDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InterestRateIndex_f : c_obj list -> c_obj list = "_wrap_delete_InterestRateIndexQuantLib" ;;
let _delete_InterestRateIndex arg = match _delete_InterestRateIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborIndex_f : c_obj list -> c_obj list = "_wrap_new_IborIndex__SWIG_0QuantLib" ;;
let _new_IborIndex arg = match _new_IborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborIndex_f : c_obj list -> c_obj list = "_wrap_new_IborIndexQuantLib" ;;
let _new_IborIndex arg = match _new_IborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborIndex_businessDayConvention_f : c_obj list -> c_obj list = "_wrap_IborIndex_businessDayConventionQuantLib" ;;
let _IborIndex_businessDayConvention arg = match _IborIndex_businessDayConvention_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborIndex_endOfMonth_f : c_obj list -> c_obj list = "_wrap_IborIndex_endOfMonthQuantLib" ;;
let _IborIndex_endOfMonth arg = match _IborIndex_endOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IborIndex_f : c_obj list -> c_obj list = "_wrap_delete_IborIndexQuantLib" ;;
let _delete_IborIndex arg = match _delete_IborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapIndex_f : c_obj list -> c_obj list = "_wrap_new_SwapIndexQuantLib" ;;
let _new_SwapIndex arg = match _new_SwapIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapIndex_fixedLegTenor_f : c_obj list -> c_obj list = "_wrap_SwapIndex_fixedLegTenorQuantLib" ;;
let _SwapIndex_fixedLegTenor arg = match _SwapIndex_fixedLegTenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapIndex_fixedLegConvention_f : c_obj list -> c_obj list = "_wrap_SwapIndex_fixedLegConventionQuantLib" ;;
let _SwapIndex_fixedLegConvention arg = match _SwapIndex_fixedLegConvention_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapIndex_iborIndex_f : c_obj list -> c_obj list = "_wrap_SwapIndex_iborIndexQuantLib" ;;
let _SwapIndex_iborIndex arg = match _SwapIndex_iborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwapIndex_f : c_obj list -> c_obj list = "_wrap_delete_SwapIndexQuantLib" ;;
let _delete_SwapIndex arg = match _delete_SwapIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AUDLibor_f : c_obj list -> c_obj list = "_wrap_new_AUDLibor__SWIG_0QuantLib" ;;
let _new_AUDLibor arg = match _new_AUDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AUDLibor_f : c_obj list -> c_obj list = "_wrap_new_AUDLiborQuantLib" ;;
let _new_AUDLibor arg = match _new_AUDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AUDLibor_f : c_obj list -> c_obj list = "_wrap_delete_AUDLiborQuantLib" ;;
let _delete_AUDLibor arg = match _delete_AUDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CADLibor_f : c_obj list -> c_obj list = "_wrap_new_CADLibor__SWIG_0QuantLib" ;;
let _new_CADLibor arg = match _new_CADLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CADLibor_f : c_obj list -> c_obj list = "_wrap_new_CADLiborQuantLib" ;;
let _new_CADLibor arg = match _new_CADLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CADLibor_f : c_obj list -> c_obj list = "_wrap_delete_CADLiborQuantLib" ;;
let _delete_CADLibor arg = match _delete_CADLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cdor_f : c_obj list -> c_obj list = "_wrap_new_Cdor__SWIG_0QuantLib" ;;
let _new_Cdor arg = match _new_Cdor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cdor_f : c_obj list -> c_obj list = "_wrap_new_CdorQuantLib" ;;
let _new_Cdor arg = match _new_Cdor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Cdor_f : c_obj list -> c_obj list = "_wrap_delete_CdorQuantLib" ;;
let _delete_Cdor arg = match _delete_Cdor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CHFLibor_f : c_obj list -> c_obj list = "_wrap_new_CHFLibor__SWIG_0QuantLib" ;;
let _new_CHFLibor arg = match _new_CHFLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CHFLibor_f : c_obj list -> c_obj list = "_wrap_new_CHFLiborQuantLib" ;;
let _new_CHFLibor arg = match _new_CHFLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CHFLibor_f : c_obj list -> c_obj list = "_wrap_delete_CHFLiborQuantLib" ;;
let _delete_CHFLibor arg = match _delete_CHFLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DKKLibor_f : c_obj list -> c_obj list = "_wrap_new_DKKLibor__SWIG_0QuantLib" ;;
let _new_DKKLibor arg = match _new_DKKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DKKLibor_f : c_obj list -> c_obj list = "_wrap_new_DKKLiborQuantLib" ;;
let _new_DKKLibor arg = match _new_DKKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DKKLibor_f : c_obj list -> c_obj list = "_wrap_delete_DKKLiborQuantLib" ;;
let _delete_DKKLibor arg = match _delete_DKKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor_f : c_obj list -> c_obj list = "_wrap_new_Euribor__SWIG_0QuantLib" ;;
let _new_Euribor arg = match _new_Euribor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor_f : c_obj list -> c_obj list = "_wrap_new_EuriborQuantLib" ;;
let _new_Euribor arg = match _new_Euribor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor_f : c_obj list -> c_obj list = "_wrap_delete_EuriborQuantLib" ;;
let _delete_Euribor arg = match _delete_Euribor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSW_f : c_obj list -> c_obj list = "_wrap_new_EuriborSW__SWIG_0QuantLib" ;;
let _new_EuriborSW arg = match _new_EuriborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSW_f : c_obj list -> c_obj list = "_wrap_new_EuriborSWQuantLib" ;;
let _new_EuriborSW arg = match _new_EuriborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSW_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSWQuantLib" ;;
let _delete_EuriborSW arg = match _delete_EuriborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor2W__SWIG_0QuantLib" ;;
let _new_Euribor2W arg = match _new_Euribor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor2WQuantLib" ;;
let _new_Euribor2W arg = match _new_Euribor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor2W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor2WQuantLib" ;;
let _delete_Euribor2W arg = match _delete_Euribor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor3W__SWIG_0QuantLib" ;;
let _new_Euribor3W arg = match _new_Euribor3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor3WQuantLib" ;;
let _new_Euribor3W arg = match _new_Euribor3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor3W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor3WQuantLib" ;;
let _delete_Euribor3W arg = match _delete_Euribor3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor1M__SWIG_0QuantLib" ;;
let _new_Euribor1M arg = match _new_Euribor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor1MQuantLib" ;;
let _new_Euribor1M arg = match _new_Euribor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor1M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor1MQuantLib" ;;
let _delete_Euribor1M arg = match _delete_Euribor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor2M__SWIG_0QuantLib" ;;
let _new_Euribor2M arg = match _new_Euribor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor2MQuantLib" ;;
let _new_Euribor2M arg = match _new_Euribor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor2M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor2MQuantLib" ;;
let _delete_Euribor2M arg = match _delete_Euribor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor3M__SWIG_0QuantLib" ;;
let _new_Euribor3M arg = match _new_Euribor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor3MQuantLib" ;;
let _new_Euribor3M arg = match _new_Euribor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor3M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor3MQuantLib" ;;
let _delete_Euribor3M arg = match _delete_Euribor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor4M__SWIG_0QuantLib" ;;
let _new_Euribor4M arg = match _new_Euribor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor4MQuantLib" ;;
let _new_Euribor4M arg = match _new_Euribor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor4M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor4MQuantLib" ;;
let _delete_Euribor4M arg = match _delete_Euribor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor5M__SWIG_0QuantLib" ;;
let _new_Euribor5M arg = match _new_Euribor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor5MQuantLib" ;;
let _new_Euribor5M arg = match _new_Euribor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor5M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor5MQuantLib" ;;
let _delete_Euribor5M arg = match _delete_Euribor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor6M__SWIG_0QuantLib" ;;
let _new_Euribor6M arg = match _new_Euribor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor6MQuantLib" ;;
let _new_Euribor6M arg = match _new_Euribor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor6M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor6MQuantLib" ;;
let _delete_Euribor6M arg = match _delete_Euribor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor7M__SWIG_0QuantLib" ;;
let _new_Euribor7M arg = match _new_Euribor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor7MQuantLib" ;;
let _new_Euribor7M arg = match _new_Euribor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor7M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor7MQuantLib" ;;
let _delete_Euribor7M arg = match _delete_Euribor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor8M__SWIG_0QuantLib" ;;
let _new_Euribor8M arg = match _new_Euribor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor8MQuantLib" ;;
let _new_Euribor8M arg = match _new_Euribor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor8M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor8MQuantLib" ;;
let _delete_Euribor8M arg = match _delete_Euribor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor9M__SWIG_0QuantLib" ;;
let _new_Euribor9M arg = match _new_Euribor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor9MQuantLib" ;;
let _new_Euribor9M arg = match _new_Euribor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor9M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor9MQuantLib" ;;
let _delete_Euribor9M arg = match _delete_Euribor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor10M__SWIG_0QuantLib" ;;
let _new_Euribor10M arg = match _new_Euribor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor10MQuantLib" ;;
let _new_Euribor10M arg = match _new_Euribor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor10M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor10MQuantLib" ;;
let _delete_Euribor10M arg = match _delete_Euribor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor11M__SWIG_0QuantLib" ;;
let _new_Euribor11M arg = match _new_Euribor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor11MQuantLib" ;;
let _new_Euribor11M arg = match _new_Euribor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor11M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor11MQuantLib" ;;
let _delete_Euribor11M arg = match _delete_Euribor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor1Y__SWIG_0QuantLib" ;;
let _new_Euribor1Y arg = match _new_Euribor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor1YQuantLib" ;;
let _new_Euribor1Y arg = match _new_Euribor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor1Y_f : c_obj list -> c_obj list = "_wrap_delete_Euribor1YQuantLib" ;;
let _delete_Euribor1Y arg = match _delete_Euribor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_f : c_obj list -> c_obj list = "_wrap_new_Euribor365__SWIG_0QuantLib" ;;
let _new_Euribor365 arg = match _new_Euribor365_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_f : c_obj list -> c_obj list = "_wrap_new_Euribor365QuantLib" ;;
let _new_Euribor365 arg = match _new_Euribor365_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365QuantLib" ;;
let _delete_Euribor365 arg = match _delete_Euribor365_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_SW_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_SW__SWIG_0QuantLib" ;;
let _new_Euribor365_SW arg = match _new_Euribor365_SW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_SW_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_SWQuantLib" ;;
let _new_Euribor365_SW arg = match _new_Euribor365_SW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_SW_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_SWQuantLib" ;;
let _delete_Euribor365_SW arg = match _delete_Euribor365_SW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2W__SWIG_0QuantLib" ;;
let _new_Euribor365_2W arg = match _new_Euribor365_2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2WQuantLib" ;;
let _new_Euribor365_2W arg = match _new_Euribor365_2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_2W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_2WQuantLib" ;;
let _delete_Euribor365_2W arg = match _delete_Euribor365_2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3W__SWIG_0QuantLib" ;;
let _new_Euribor365_3W arg = match _new_Euribor365_3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3WQuantLib" ;;
let _new_Euribor365_3W arg = match _new_Euribor365_3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_3W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_3WQuantLib" ;;
let _delete_Euribor365_3W arg = match _delete_Euribor365_3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1M__SWIG_0QuantLib" ;;
let _new_Euribor365_1M arg = match _new_Euribor365_1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1MQuantLib" ;;
let _new_Euribor365_1M arg = match _new_Euribor365_1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_1M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_1MQuantLib" ;;
let _delete_Euribor365_1M arg = match _delete_Euribor365_1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2M__SWIG_0QuantLib" ;;
let _new_Euribor365_2M arg = match _new_Euribor365_2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2MQuantLib" ;;
let _new_Euribor365_2M arg = match _new_Euribor365_2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_2M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_2MQuantLib" ;;
let _delete_Euribor365_2M arg = match _delete_Euribor365_2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3M__SWIG_0QuantLib" ;;
let _new_Euribor365_3M arg = match _new_Euribor365_3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3MQuantLib" ;;
let _new_Euribor365_3M arg = match _new_Euribor365_3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_3M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_3MQuantLib" ;;
let _delete_Euribor365_3M arg = match _delete_Euribor365_3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_4M__SWIG_0QuantLib" ;;
let _new_Euribor365_4M arg = match _new_Euribor365_4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_4MQuantLib" ;;
let _new_Euribor365_4M arg = match _new_Euribor365_4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_4M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_4MQuantLib" ;;
let _delete_Euribor365_4M arg = match _delete_Euribor365_4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_5M__SWIG_0QuantLib" ;;
let _new_Euribor365_5M arg = match _new_Euribor365_5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_5MQuantLib" ;;
let _new_Euribor365_5M arg = match _new_Euribor365_5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_5M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_5MQuantLib" ;;
let _delete_Euribor365_5M arg = match _delete_Euribor365_5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_6M__SWIG_0QuantLib" ;;
let _new_Euribor365_6M arg = match _new_Euribor365_6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_6MQuantLib" ;;
let _new_Euribor365_6M arg = match _new_Euribor365_6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_6M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_6MQuantLib" ;;
let _delete_Euribor365_6M arg = match _delete_Euribor365_6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_7M__SWIG_0QuantLib" ;;
let _new_Euribor365_7M arg = match _new_Euribor365_7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_7MQuantLib" ;;
let _new_Euribor365_7M arg = match _new_Euribor365_7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_7M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_7MQuantLib" ;;
let _delete_Euribor365_7M arg = match _delete_Euribor365_7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_8M__SWIG_0QuantLib" ;;
let _new_Euribor365_8M arg = match _new_Euribor365_8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_8MQuantLib" ;;
let _new_Euribor365_8M arg = match _new_Euribor365_8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_8M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_8MQuantLib" ;;
let _delete_Euribor365_8M arg = match _delete_Euribor365_8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_9M__SWIG_0QuantLib" ;;
let _new_Euribor365_9M arg = match _new_Euribor365_9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_9MQuantLib" ;;
let _new_Euribor365_9M arg = match _new_Euribor365_9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_9M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_9MQuantLib" ;;
let _delete_Euribor365_9M arg = match _delete_Euribor365_9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_10M__SWIG_0QuantLib" ;;
let _new_Euribor365_10M arg = match _new_Euribor365_10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_10MQuantLib" ;;
let _new_Euribor365_10M arg = match _new_Euribor365_10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_10M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_10MQuantLib" ;;
let _delete_Euribor365_10M arg = match _delete_Euribor365_10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_11M__SWIG_0QuantLib" ;;
let _new_Euribor365_11M arg = match _new_Euribor365_11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_11MQuantLib" ;;
let _new_Euribor365_11M arg = match _new_Euribor365_11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_11M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_11MQuantLib" ;;
let _delete_Euribor365_11M arg = match _delete_Euribor365_11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1Y__SWIG_0QuantLib" ;;
let _new_Euribor365_1Y arg = match _new_Euribor365_1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1YQuantLib" ;;
let _new_Euribor365_1Y arg = match _new_Euribor365_1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_1Y_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_1YQuantLib" ;;
let _delete_Euribor365_1Y arg = match _delete_Euribor365_1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor_f : c_obj list -> c_obj list = "_wrap_new_EURLibor__SWIG_0QuantLib" ;;
let _new_EURLibor arg = match _new_EURLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor_f : c_obj list -> c_obj list = "_wrap_new_EURLiborQuantLib" ;;
let _new_EURLibor arg = match _new_EURLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor_f : c_obj list -> c_obj list = "_wrap_delete_EURLiborQuantLib" ;;
let _delete_EURLibor arg = match _delete_EURLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLiborSW_f : c_obj list -> c_obj list = "_wrap_new_EURLiborSW__SWIG_0QuantLib" ;;
let _new_EURLiborSW arg = match _new_EURLiborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLiborSW_f : c_obj list -> c_obj list = "_wrap_new_EURLiborSWQuantLib" ;;
let _new_EURLiborSW arg = match _new_EURLiborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLiborSW_f : c_obj list -> c_obj list = "_wrap_delete_EURLiborSWQuantLib" ;;
let _delete_EURLiborSW arg = match _delete_EURLiborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2W_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2W__SWIG_0QuantLib" ;;
let _new_EURLibor2W arg = match _new_EURLibor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2W_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2WQuantLib" ;;
let _new_EURLibor2W arg = match _new_EURLibor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor2W_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor2WQuantLib" ;;
let _delete_EURLibor2W arg = match _delete_EURLibor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1M__SWIG_0QuantLib" ;;
let _new_EURLibor1M arg = match _new_EURLibor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1MQuantLib" ;;
let _new_EURLibor1M arg = match _new_EURLibor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor1M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor1MQuantLib" ;;
let _delete_EURLibor1M arg = match _delete_EURLibor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2M__SWIG_0QuantLib" ;;
let _new_EURLibor2M arg = match _new_EURLibor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2MQuantLib" ;;
let _new_EURLibor2M arg = match _new_EURLibor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor2M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor2MQuantLib" ;;
let _delete_EURLibor2M arg = match _delete_EURLibor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor3M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor3M__SWIG_0QuantLib" ;;
let _new_EURLibor3M arg = match _new_EURLibor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor3M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor3MQuantLib" ;;
let _new_EURLibor3M arg = match _new_EURLibor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor3M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor3MQuantLib" ;;
let _delete_EURLibor3M arg = match _delete_EURLibor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor4M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor4M__SWIG_0QuantLib" ;;
let _new_EURLibor4M arg = match _new_EURLibor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor4M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor4MQuantLib" ;;
let _new_EURLibor4M arg = match _new_EURLibor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor4M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor4MQuantLib" ;;
let _delete_EURLibor4M arg = match _delete_EURLibor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor5M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor5M__SWIG_0QuantLib" ;;
let _new_EURLibor5M arg = match _new_EURLibor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor5M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor5MQuantLib" ;;
let _new_EURLibor5M arg = match _new_EURLibor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor5M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor5MQuantLib" ;;
let _delete_EURLibor5M arg = match _delete_EURLibor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor6M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor6M__SWIG_0QuantLib" ;;
let _new_EURLibor6M arg = match _new_EURLibor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor6M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor6MQuantLib" ;;
let _new_EURLibor6M arg = match _new_EURLibor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor6M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor6MQuantLib" ;;
let _delete_EURLibor6M arg = match _delete_EURLibor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor7M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor7M__SWIG_0QuantLib" ;;
let _new_EURLibor7M arg = match _new_EURLibor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor7M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor7MQuantLib" ;;
let _new_EURLibor7M arg = match _new_EURLibor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor7M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor7MQuantLib" ;;
let _delete_EURLibor7M arg = match _delete_EURLibor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor8M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor8M__SWIG_0QuantLib" ;;
let _new_EURLibor8M arg = match _new_EURLibor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor8M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor8MQuantLib" ;;
let _new_EURLibor8M arg = match _new_EURLibor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor8M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor8MQuantLib" ;;
let _delete_EURLibor8M arg = match _delete_EURLibor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor9M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor9M__SWIG_0QuantLib" ;;
let _new_EURLibor9M arg = match _new_EURLibor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor9M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor9MQuantLib" ;;
let _new_EURLibor9M arg = match _new_EURLibor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor9M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor9MQuantLib" ;;
let _delete_EURLibor9M arg = match _delete_EURLibor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor10M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor10M__SWIG_0QuantLib" ;;
let _new_EURLibor10M arg = match _new_EURLibor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor10M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor10MQuantLib" ;;
let _new_EURLibor10M arg = match _new_EURLibor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor10M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor10MQuantLib" ;;
let _delete_EURLibor10M arg = match _delete_EURLibor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor11M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor11M__SWIG_0QuantLib" ;;
let _new_EURLibor11M arg = match _new_EURLibor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor11M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor11MQuantLib" ;;
let _new_EURLibor11M arg = match _new_EURLibor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor11M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor11MQuantLib" ;;
let _delete_EURLibor11M arg = match _delete_EURLibor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1Y_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1Y__SWIG_0QuantLib" ;;
let _new_EURLibor1Y arg = match _new_EURLibor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1Y_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1YQuantLib" ;;
let _new_EURLibor1Y arg = match _new_EURLibor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor1Y_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor1YQuantLib" ;;
let _delete_EURLibor1Y arg = match _delete_EURLibor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GBPLibor_f : c_obj list -> c_obj list = "_wrap_new_GBPLibor__SWIG_0QuantLib" ;;
let _new_GBPLibor arg = match _new_GBPLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GBPLibor_f : c_obj list -> c_obj list = "_wrap_new_GBPLiborQuantLib" ;;
let _new_GBPLibor arg = match _new_GBPLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GBPLibor_f : c_obj list -> c_obj list = "_wrap_delete_GBPLiborQuantLib" ;;
let _delete_GBPLibor arg = match _delete_GBPLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Jibar_f : c_obj list -> c_obj list = "_wrap_new_Jibar__SWIG_0QuantLib" ;;
let _new_Jibar arg = match _new_Jibar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Jibar_f : c_obj list -> c_obj list = "_wrap_new_JibarQuantLib" ;;
let _new_Jibar arg = match _new_Jibar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Jibar_f : c_obj list -> c_obj list = "_wrap_delete_JibarQuantLib" ;;
let _delete_Jibar arg = match _delete_Jibar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JPYLibor_f : c_obj list -> c_obj list = "_wrap_new_JPYLibor__SWIG_0QuantLib" ;;
let _new_JPYLibor arg = match _new_JPYLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JPYLibor_f : c_obj list -> c_obj list = "_wrap_new_JPYLiborQuantLib" ;;
let _new_JPYLibor arg = match _new_JPYLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_JPYLibor_f : c_obj list -> c_obj list = "_wrap_delete_JPYLiborQuantLib" ;;
let _delete_JPYLibor arg = match _delete_JPYLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NZDLibor_f : c_obj list -> c_obj list = "_wrap_new_NZDLibor__SWIG_0QuantLib" ;;
let _new_NZDLibor arg = match _new_NZDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NZDLibor_f : c_obj list -> c_obj list = "_wrap_new_NZDLiborQuantLib" ;;
let _new_NZDLibor arg = match _new_NZDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NZDLibor_f : c_obj list -> c_obj list = "_wrap_delete_NZDLiborQuantLib" ;;
let _delete_NZDLibor arg = match _delete_NZDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Tibor_f : c_obj list -> c_obj list = "_wrap_new_Tibor__SWIG_0QuantLib" ;;
let _new_Tibor arg = match _new_Tibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Tibor_f : c_obj list -> c_obj list = "_wrap_new_TiborQuantLib" ;;
let _new_Tibor arg = match _new_Tibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Tibor_f : c_obj list -> c_obj list = "_wrap_delete_TiborQuantLib" ;;
let _delete_Tibor arg = match _delete_Tibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRLibor_f : c_obj list -> c_obj list = "_wrap_new_TRLibor__SWIG_0QuantLib" ;;
let _new_TRLibor arg = match _new_TRLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRLibor_f : c_obj list -> c_obj list = "_wrap_new_TRLiborQuantLib" ;;
let _new_TRLibor arg = match _new_TRLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TRLibor_f : c_obj list -> c_obj list = "_wrap_delete_TRLiborQuantLib" ;;
let _delete_TRLibor arg = match _delete_TRLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USDLibor_f : c_obj list -> c_obj list = "_wrap_new_USDLibor__SWIG_0QuantLib" ;;
let _new_USDLibor arg = match _new_USDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USDLibor_f : c_obj list -> c_obj list = "_wrap_new_USDLiborQuantLib" ;;
let _new_USDLibor arg = match _new_USDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_USDLibor_f : c_obj list -> c_obj list = "_wrap_delete_USDLiborQuantLib" ;;
let _delete_USDLibor arg = match _delete_USDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Zibor_f : c_obj list -> c_obj list = "_wrap_new_Zibor__SWIG_0QuantLib" ;;
let _new_Zibor arg = match _new_Zibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Zibor_f : c_obj list -> c_obj list = "_wrap_new_ZiborQuantLib" ;;
let _new_Zibor arg = match _new_Zibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Zibor_f : c_obj list -> c_obj list = "_wrap_delete_ZiborQuantLib" ;;
let _delete_Zibor arg = match _delete_Zibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixAvs3M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixAvs3M__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixAvs3M arg = match _new_EuriborSwapFixAvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixAvs3M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixAvs3MQuantLib" ;;
let _new_EuriborSwapFixAvs3M arg = match _new_EuriborSwapFixAvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixAvs3M_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixAvs3MQuantLib" ;;
let _delete_EuriborSwapFixAvs3M arg = match _delete_EuriborSwapFixAvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixAvs6M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixAvs6M__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixAvs6M arg = match _new_EuriborSwapFixAvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixAvs6M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixAvs6MQuantLib" ;;
let _new_EuriborSwapFixAvs6M arg = match _new_EuriborSwapFixAvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixAvs6M_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixAvs6MQuantLib" ;;
let _delete_EuriborSwapFixAvs6M arg = match _delete_EuriborSwapFixAvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA1Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA1Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA1Y arg = match _new_EuriborSwapFixA1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA1Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA1YQuantLib" ;;
let _new_EuriborSwapFixA1Y arg = match _new_EuriborSwapFixA1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA1Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA1YQuantLib" ;;
let _delete_EuriborSwapFixA1Y arg = match _delete_EuriborSwapFixA1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA2Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA2Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA2Y arg = match _new_EuriborSwapFixA2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA2Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA2YQuantLib" ;;
let _new_EuriborSwapFixA2Y arg = match _new_EuriborSwapFixA2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA2Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA2YQuantLib" ;;
let _delete_EuriborSwapFixA2Y arg = match _delete_EuriborSwapFixA2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA3Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA3Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA3Y arg = match _new_EuriborSwapFixA3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA3Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA3YQuantLib" ;;
let _new_EuriborSwapFixA3Y arg = match _new_EuriborSwapFixA3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA3Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA3YQuantLib" ;;
let _delete_EuriborSwapFixA3Y arg = match _delete_EuriborSwapFixA3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA4Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA4Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA4Y arg = match _new_EuriborSwapFixA4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA4Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA4YQuantLib" ;;
let _new_EuriborSwapFixA4Y arg = match _new_EuriborSwapFixA4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA4Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA4YQuantLib" ;;
let _delete_EuriborSwapFixA4Y arg = match _delete_EuriborSwapFixA4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA5Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA5Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA5Y arg = match _new_EuriborSwapFixA5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA5Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA5YQuantLib" ;;
let _new_EuriborSwapFixA5Y arg = match _new_EuriborSwapFixA5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA5Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA5YQuantLib" ;;
let _delete_EuriborSwapFixA5Y arg = match _delete_EuriborSwapFixA5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA6Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA6Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA6Y arg = match _new_EuriborSwapFixA6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA6Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA6YQuantLib" ;;
let _new_EuriborSwapFixA6Y arg = match _new_EuriborSwapFixA6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA6Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA6YQuantLib" ;;
let _delete_EuriborSwapFixA6Y arg = match _delete_EuriborSwapFixA6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA7Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA7Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA7Y arg = match _new_EuriborSwapFixA7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA7Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA7YQuantLib" ;;
let _new_EuriborSwapFixA7Y arg = match _new_EuriborSwapFixA7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA7Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA7YQuantLib" ;;
let _delete_EuriborSwapFixA7Y arg = match _delete_EuriborSwapFixA7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA8Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA8Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA8Y arg = match _new_EuriborSwapFixA8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA8Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA8YQuantLib" ;;
let _new_EuriborSwapFixA8Y arg = match _new_EuriborSwapFixA8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA8Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA8YQuantLib" ;;
let _delete_EuriborSwapFixA8Y arg = match _delete_EuriborSwapFixA8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA9Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA9Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA9Y arg = match _new_EuriborSwapFixA9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA9Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA9YQuantLib" ;;
let _new_EuriborSwapFixA9Y arg = match _new_EuriborSwapFixA9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA9Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA9YQuantLib" ;;
let _delete_EuriborSwapFixA9Y arg = match _delete_EuriborSwapFixA9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA10Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA10Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA10Y arg = match _new_EuriborSwapFixA10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA10Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA10YQuantLib" ;;
let _new_EuriborSwapFixA10Y arg = match _new_EuriborSwapFixA10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA10Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA10YQuantLib" ;;
let _delete_EuriborSwapFixA10Y arg = match _delete_EuriborSwapFixA10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA12Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA12Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA12Y arg = match _new_EuriborSwapFixA12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA12Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA12YQuantLib" ;;
let _new_EuriborSwapFixA12Y arg = match _new_EuriborSwapFixA12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA12Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA12YQuantLib" ;;
let _delete_EuriborSwapFixA12Y arg = match _delete_EuriborSwapFixA12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA15Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA15Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA15Y arg = match _new_EuriborSwapFixA15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA15Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA15YQuantLib" ;;
let _new_EuriborSwapFixA15Y arg = match _new_EuriborSwapFixA15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA15Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA15YQuantLib" ;;
let _delete_EuriborSwapFixA15Y arg = match _delete_EuriborSwapFixA15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA20Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA20Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA20Y arg = match _new_EuriborSwapFixA20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA20Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA20YQuantLib" ;;
let _new_EuriborSwapFixA20Y arg = match _new_EuriborSwapFixA20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA20Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA20YQuantLib" ;;
let _delete_EuriborSwapFixA20Y arg = match _delete_EuriborSwapFixA20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA25Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA25Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA25Y arg = match _new_EuriborSwapFixA25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA25Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA25YQuantLib" ;;
let _new_EuriborSwapFixA25Y arg = match _new_EuriborSwapFixA25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA25Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA25YQuantLib" ;;
let _delete_EuriborSwapFixA25Y arg = match _delete_EuriborSwapFixA25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA30Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA30Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixA30Y arg = match _new_EuriborSwapFixA30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixA30Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixA30YQuantLib" ;;
let _new_EuriborSwapFixA30Y arg = match _new_EuriborSwapFixA30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixA30Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixA30YQuantLib" ;;
let _delete_EuriborSwapFixA30Y arg = match _delete_EuriborSwapFixA30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFRvs3M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFRvs3M__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFRvs3M arg = match _new_EuriborSwapFixIFRvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFRvs3M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFRvs3MQuantLib" ;;
let _new_EuriborSwapFixIFRvs3M arg = match _new_EuriborSwapFixIFRvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFRvs3M_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFRvs3MQuantLib" ;;
let _delete_EuriborSwapFixIFRvs3M arg = match _delete_EuriborSwapFixIFRvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFRvs6M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFRvs6M__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFRvs6M arg = match _new_EuriborSwapFixIFRvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFRvs6M_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFRvs6MQuantLib" ;;
let _new_EuriborSwapFixIFRvs6M arg = match _new_EuriborSwapFixIFRvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFRvs6M_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFRvs6MQuantLib" ;;
let _delete_EuriborSwapFixIFRvs6M arg = match _delete_EuriborSwapFixIFRvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR1Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR1Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR1Y arg = match _new_EuriborSwapFixIFR1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR1Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR1YQuantLib" ;;
let _new_EuriborSwapFixIFR1Y arg = match _new_EuriborSwapFixIFR1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR1Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR1YQuantLib" ;;
let _delete_EuriborSwapFixIFR1Y arg = match _delete_EuriborSwapFixIFR1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR2Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR2Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR2Y arg = match _new_EuriborSwapFixIFR2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR2Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR2YQuantLib" ;;
let _new_EuriborSwapFixIFR2Y arg = match _new_EuriborSwapFixIFR2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR2Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR2YQuantLib" ;;
let _delete_EuriborSwapFixIFR2Y arg = match _delete_EuriborSwapFixIFR2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR3Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR3Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR3Y arg = match _new_EuriborSwapFixIFR3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR3Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR3YQuantLib" ;;
let _new_EuriborSwapFixIFR3Y arg = match _new_EuriborSwapFixIFR3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR3Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR3YQuantLib" ;;
let _delete_EuriborSwapFixIFR3Y arg = match _delete_EuriborSwapFixIFR3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR4Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR4Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR4Y arg = match _new_EuriborSwapFixIFR4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR4Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR4YQuantLib" ;;
let _new_EuriborSwapFixIFR4Y arg = match _new_EuriborSwapFixIFR4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR4Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR4YQuantLib" ;;
let _delete_EuriborSwapFixIFR4Y arg = match _delete_EuriborSwapFixIFR4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR5Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR5Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR5Y arg = match _new_EuriborSwapFixIFR5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR5Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR5YQuantLib" ;;
let _new_EuriborSwapFixIFR5Y arg = match _new_EuriborSwapFixIFR5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR5Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR5YQuantLib" ;;
let _delete_EuriborSwapFixIFR5Y arg = match _delete_EuriborSwapFixIFR5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR6Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR6Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR6Y arg = match _new_EuriborSwapFixIFR6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR6Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR6YQuantLib" ;;
let _new_EuriborSwapFixIFR6Y arg = match _new_EuriborSwapFixIFR6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR6Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR6YQuantLib" ;;
let _delete_EuriborSwapFixIFR6Y arg = match _delete_EuriborSwapFixIFR6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR7Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR7Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR7Y arg = match _new_EuriborSwapFixIFR7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR7Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR7YQuantLib" ;;
let _new_EuriborSwapFixIFR7Y arg = match _new_EuriborSwapFixIFR7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR7Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR7YQuantLib" ;;
let _delete_EuriborSwapFixIFR7Y arg = match _delete_EuriborSwapFixIFR7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR8Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR8Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR8Y arg = match _new_EuriborSwapFixIFR8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR8Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR8YQuantLib" ;;
let _new_EuriborSwapFixIFR8Y arg = match _new_EuriborSwapFixIFR8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR8Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR8YQuantLib" ;;
let _delete_EuriborSwapFixIFR8Y arg = match _delete_EuriborSwapFixIFR8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR9Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR9Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR9Y arg = match _new_EuriborSwapFixIFR9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR9Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR9YQuantLib" ;;
let _new_EuriborSwapFixIFR9Y arg = match _new_EuriborSwapFixIFR9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR9Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR9YQuantLib" ;;
let _delete_EuriborSwapFixIFR9Y arg = match _delete_EuriborSwapFixIFR9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR10Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR10Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR10Y arg = match _new_EuriborSwapFixIFR10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR10Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR10YQuantLib" ;;
let _new_EuriborSwapFixIFR10Y arg = match _new_EuriborSwapFixIFR10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR10Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR10YQuantLib" ;;
let _delete_EuriborSwapFixIFR10Y arg = match _delete_EuriborSwapFixIFR10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR12Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR12Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR12Y arg = match _new_EuriborSwapFixIFR12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR12Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR12YQuantLib" ;;
let _new_EuriborSwapFixIFR12Y arg = match _new_EuriborSwapFixIFR12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR12Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR12YQuantLib" ;;
let _delete_EuriborSwapFixIFR12Y arg = match _delete_EuriborSwapFixIFR12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR15Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR15Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR15Y arg = match _new_EuriborSwapFixIFR15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR15Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR15YQuantLib" ;;
let _new_EuriborSwapFixIFR15Y arg = match _new_EuriborSwapFixIFR15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR15Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR15YQuantLib" ;;
let _delete_EuriborSwapFixIFR15Y arg = match _delete_EuriborSwapFixIFR15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR20Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR20Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR20Y arg = match _new_EuriborSwapFixIFR20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR20Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR20YQuantLib" ;;
let _new_EuriborSwapFixIFR20Y arg = match _new_EuriborSwapFixIFR20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR20Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR20YQuantLib" ;;
let _delete_EuriborSwapFixIFR20Y arg = match _delete_EuriborSwapFixIFR20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR25Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR25Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR25Y arg = match _new_EuriborSwapFixIFR25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR25Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR25YQuantLib" ;;
let _new_EuriborSwapFixIFR25Y arg = match _new_EuriborSwapFixIFR25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR25Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR25YQuantLib" ;;
let _delete_EuriborSwapFixIFR25Y arg = match _delete_EuriborSwapFixIFR25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR30Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR30Y__SWIG_0QuantLib" ;;
let _new_EuriborSwapFixIFR30Y arg = match _new_EuriborSwapFixIFR30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapFixIFR30Y_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapFixIFR30YQuantLib" ;;
let _new_EuriborSwapFixIFR30Y arg = match _new_EuriborSwapFixIFR30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapFixIFR30Y_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapFixIFR30YQuantLib" ;;
let _delete_EuriborSwapFixIFR30Y arg = match _delete_EuriborSwapFixIFR30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixAvs3M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixAvs3M__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixAvs3M arg = match _new_EurliborSwapFixAvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixAvs3M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixAvs3MQuantLib" ;;
let _new_EurliborSwapFixAvs3M arg = match _new_EurliborSwapFixAvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixAvs3M_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixAvs3MQuantLib" ;;
let _delete_EurliborSwapFixAvs3M arg = match _delete_EurliborSwapFixAvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixAvs6M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixAvs6M__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixAvs6M arg = match _new_EurliborSwapFixAvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixAvs6M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixAvs6MQuantLib" ;;
let _new_EurliborSwapFixAvs6M arg = match _new_EurliborSwapFixAvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixAvs6M_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixAvs6MQuantLib" ;;
let _delete_EurliborSwapFixAvs6M arg = match _delete_EurliborSwapFixAvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA1Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA1Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA1Y arg = match _new_EurliborSwapFixA1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA1Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA1YQuantLib" ;;
let _new_EurliborSwapFixA1Y arg = match _new_EurliborSwapFixA1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA1Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA1YQuantLib" ;;
let _delete_EurliborSwapFixA1Y arg = match _delete_EurliborSwapFixA1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA2Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA2Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA2Y arg = match _new_EurliborSwapFixA2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA2Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA2YQuantLib" ;;
let _new_EurliborSwapFixA2Y arg = match _new_EurliborSwapFixA2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA2Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA2YQuantLib" ;;
let _delete_EurliborSwapFixA2Y arg = match _delete_EurliborSwapFixA2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA3Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA3Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA3Y arg = match _new_EurliborSwapFixA3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA3Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA3YQuantLib" ;;
let _new_EurliborSwapFixA3Y arg = match _new_EurliborSwapFixA3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA3Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA3YQuantLib" ;;
let _delete_EurliborSwapFixA3Y arg = match _delete_EurliborSwapFixA3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA4Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA4Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA4Y arg = match _new_EurliborSwapFixA4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA4Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA4YQuantLib" ;;
let _new_EurliborSwapFixA4Y arg = match _new_EurliborSwapFixA4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA4Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA4YQuantLib" ;;
let _delete_EurliborSwapFixA4Y arg = match _delete_EurliborSwapFixA4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA5Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA5Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA5Y arg = match _new_EurliborSwapFixA5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA5Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA5YQuantLib" ;;
let _new_EurliborSwapFixA5Y arg = match _new_EurliborSwapFixA5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA5Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA5YQuantLib" ;;
let _delete_EurliborSwapFixA5Y arg = match _delete_EurliborSwapFixA5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA6Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA6Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA6Y arg = match _new_EurliborSwapFixA6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA6Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA6YQuantLib" ;;
let _new_EurliborSwapFixA6Y arg = match _new_EurliborSwapFixA6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA6Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA6YQuantLib" ;;
let _delete_EurliborSwapFixA6Y arg = match _delete_EurliborSwapFixA6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA7Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA7Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA7Y arg = match _new_EurliborSwapFixA7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA7Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA7YQuantLib" ;;
let _new_EurliborSwapFixA7Y arg = match _new_EurliborSwapFixA7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA7Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA7YQuantLib" ;;
let _delete_EurliborSwapFixA7Y arg = match _delete_EurliborSwapFixA7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA8Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA8Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA8Y arg = match _new_EurliborSwapFixA8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA8Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA8YQuantLib" ;;
let _new_EurliborSwapFixA8Y arg = match _new_EurliborSwapFixA8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA8Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA8YQuantLib" ;;
let _delete_EurliborSwapFixA8Y arg = match _delete_EurliborSwapFixA8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA9Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA9Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA9Y arg = match _new_EurliborSwapFixA9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA9Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA9YQuantLib" ;;
let _new_EurliborSwapFixA9Y arg = match _new_EurliborSwapFixA9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA9Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA9YQuantLib" ;;
let _delete_EurliborSwapFixA9Y arg = match _delete_EurliborSwapFixA9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA10Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA10Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA10Y arg = match _new_EurliborSwapFixA10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA10Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA10YQuantLib" ;;
let _new_EurliborSwapFixA10Y arg = match _new_EurliborSwapFixA10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA10Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA10YQuantLib" ;;
let _delete_EurliborSwapFixA10Y arg = match _delete_EurliborSwapFixA10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA12Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA12Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA12Y arg = match _new_EurliborSwapFixA12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA12Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA12YQuantLib" ;;
let _new_EurliborSwapFixA12Y arg = match _new_EurliborSwapFixA12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA12Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA12YQuantLib" ;;
let _delete_EurliborSwapFixA12Y arg = match _delete_EurliborSwapFixA12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA15Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA15Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA15Y arg = match _new_EurliborSwapFixA15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA15Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA15YQuantLib" ;;
let _new_EurliborSwapFixA15Y arg = match _new_EurliborSwapFixA15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA15Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA15YQuantLib" ;;
let _delete_EurliborSwapFixA15Y arg = match _delete_EurliborSwapFixA15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA20Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA20Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA20Y arg = match _new_EurliborSwapFixA20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA20Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA20YQuantLib" ;;
let _new_EurliborSwapFixA20Y arg = match _new_EurliborSwapFixA20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA20Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA20YQuantLib" ;;
let _delete_EurliborSwapFixA20Y arg = match _delete_EurliborSwapFixA20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA25Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA25Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA25Y arg = match _new_EurliborSwapFixA25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA25Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA25YQuantLib" ;;
let _new_EurliborSwapFixA25Y arg = match _new_EurliborSwapFixA25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA25Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA25YQuantLib" ;;
let _delete_EurliborSwapFixA25Y arg = match _delete_EurliborSwapFixA25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA30Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA30Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixA30Y arg = match _new_EurliborSwapFixA30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixA30Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixA30YQuantLib" ;;
let _new_EurliborSwapFixA30Y arg = match _new_EurliborSwapFixA30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixA30Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixA30YQuantLib" ;;
let _delete_EurliborSwapFixA30Y arg = match _delete_EurliborSwapFixA30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixBvs3M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixBvs3M__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixBvs3M arg = match _new_EurliborSwapFixBvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixBvs3M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixBvs3MQuantLib" ;;
let _new_EurliborSwapFixBvs3M arg = match _new_EurliborSwapFixBvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixBvs3M_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixBvs3MQuantLib" ;;
let _delete_EurliborSwapFixBvs3M arg = match _delete_EurliborSwapFixBvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixBvs6M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixBvs6M__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixBvs6M arg = match _new_EurliborSwapFixBvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixBvs6M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixBvs6MQuantLib" ;;
let _new_EurliborSwapFixBvs6M arg = match _new_EurliborSwapFixBvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixBvs6M_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixBvs6MQuantLib" ;;
let _delete_EurliborSwapFixBvs6M arg = match _delete_EurliborSwapFixBvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB1Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB1Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB1Y arg = match _new_EurliborSwapFixB1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB1Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB1YQuantLib" ;;
let _new_EurliborSwapFixB1Y arg = match _new_EurliborSwapFixB1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB1Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB1YQuantLib" ;;
let _delete_EurliborSwapFixB1Y arg = match _delete_EurliborSwapFixB1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB2Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB2Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB2Y arg = match _new_EurliborSwapFixB2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB2Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB2YQuantLib" ;;
let _new_EurliborSwapFixB2Y arg = match _new_EurliborSwapFixB2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB2Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB2YQuantLib" ;;
let _delete_EurliborSwapFixB2Y arg = match _delete_EurliborSwapFixB2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB3Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB3Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB3Y arg = match _new_EurliborSwapFixB3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB3Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB3YQuantLib" ;;
let _new_EurliborSwapFixB3Y arg = match _new_EurliborSwapFixB3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB3Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB3YQuantLib" ;;
let _delete_EurliborSwapFixB3Y arg = match _delete_EurliborSwapFixB3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB4Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB4Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB4Y arg = match _new_EurliborSwapFixB4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB4Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB4YQuantLib" ;;
let _new_EurliborSwapFixB4Y arg = match _new_EurliborSwapFixB4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB4Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB4YQuantLib" ;;
let _delete_EurliborSwapFixB4Y arg = match _delete_EurliborSwapFixB4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB5Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB5Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB5Y arg = match _new_EurliborSwapFixB5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB5Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB5YQuantLib" ;;
let _new_EurliborSwapFixB5Y arg = match _new_EurliborSwapFixB5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB5Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB5YQuantLib" ;;
let _delete_EurliborSwapFixB5Y arg = match _delete_EurliborSwapFixB5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB6Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB6Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB6Y arg = match _new_EurliborSwapFixB6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB6Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB6YQuantLib" ;;
let _new_EurliborSwapFixB6Y arg = match _new_EurliborSwapFixB6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB6Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB6YQuantLib" ;;
let _delete_EurliborSwapFixB6Y arg = match _delete_EurliborSwapFixB6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB7Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB7Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB7Y arg = match _new_EurliborSwapFixB7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB7Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB7YQuantLib" ;;
let _new_EurliborSwapFixB7Y arg = match _new_EurliborSwapFixB7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB7Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB7YQuantLib" ;;
let _delete_EurliborSwapFixB7Y arg = match _delete_EurliborSwapFixB7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB8Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB8Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB8Y arg = match _new_EurliborSwapFixB8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB8Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB8YQuantLib" ;;
let _new_EurliborSwapFixB8Y arg = match _new_EurliborSwapFixB8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB8Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB8YQuantLib" ;;
let _delete_EurliborSwapFixB8Y arg = match _delete_EurliborSwapFixB8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB9Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB9Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB9Y arg = match _new_EurliborSwapFixB9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB9Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB9YQuantLib" ;;
let _new_EurliborSwapFixB9Y arg = match _new_EurliborSwapFixB9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB9Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB9YQuantLib" ;;
let _delete_EurliborSwapFixB9Y arg = match _delete_EurliborSwapFixB9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB10Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB10Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB10Y arg = match _new_EurliborSwapFixB10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB10Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB10YQuantLib" ;;
let _new_EurliborSwapFixB10Y arg = match _new_EurliborSwapFixB10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB10Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB10YQuantLib" ;;
let _delete_EurliborSwapFixB10Y arg = match _delete_EurliborSwapFixB10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB12Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB12Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB12Y arg = match _new_EurliborSwapFixB12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB12Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB12YQuantLib" ;;
let _new_EurliborSwapFixB12Y arg = match _new_EurliborSwapFixB12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB12Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB12YQuantLib" ;;
let _delete_EurliborSwapFixB12Y arg = match _delete_EurliborSwapFixB12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB15Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB15Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB15Y arg = match _new_EurliborSwapFixB15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB15Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB15YQuantLib" ;;
let _new_EurliborSwapFixB15Y arg = match _new_EurliborSwapFixB15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB15Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB15YQuantLib" ;;
let _delete_EurliborSwapFixB15Y arg = match _delete_EurliborSwapFixB15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB20Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB20Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB20Y arg = match _new_EurliborSwapFixB20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB20Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB20YQuantLib" ;;
let _new_EurliborSwapFixB20Y arg = match _new_EurliborSwapFixB20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB20Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB20YQuantLib" ;;
let _delete_EurliborSwapFixB20Y arg = match _delete_EurliborSwapFixB20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB25Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB25Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB25Y arg = match _new_EurliborSwapFixB25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB25Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB25YQuantLib" ;;
let _new_EurliborSwapFixB25Y arg = match _new_EurliborSwapFixB25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB25Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB25YQuantLib" ;;
let _delete_EurliborSwapFixB25Y arg = match _delete_EurliborSwapFixB25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB30Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB30Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixB30Y arg = match _new_EurliborSwapFixB30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixB30Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixB30YQuantLib" ;;
let _new_EurliborSwapFixB30Y arg = match _new_EurliborSwapFixB30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixB30Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixB30YQuantLib" ;;
let _delete_EurliborSwapFixB30Y arg = match _delete_EurliborSwapFixB30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFRvs3M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFRvs3M__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFRvs3M arg = match _new_EurliborSwapFixIFRvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFRvs3M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFRvs3MQuantLib" ;;
let _new_EurliborSwapFixIFRvs3M arg = match _new_EurliborSwapFixIFRvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFRvs3M_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFRvs3MQuantLib" ;;
let _delete_EurliborSwapFixIFRvs3M arg = match _delete_EurliborSwapFixIFRvs3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFRvs6M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFRvs6M__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFRvs6M arg = match _new_EurliborSwapFixIFRvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFRvs6M_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFRvs6MQuantLib" ;;
let _new_EurliborSwapFixIFRvs6M arg = match _new_EurliborSwapFixIFRvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFRvs6M_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFRvs6MQuantLib" ;;
let _delete_EurliborSwapFixIFRvs6M arg = match _delete_EurliborSwapFixIFRvs6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR1Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR1Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR1Y arg = match _new_EurliborSwapFixIFR1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR1Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR1YQuantLib" ;;
let _new_EurliborSwapFixIFR1Y arg = match _new_EurliborSwapFixIFR1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR1Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR1YQuantLib" ;;
let _delete_EurliborSwapFixIFR1Y arg = match _delete_EurliborSwapFixIFR1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR2Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR2Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR2Y arg = match _new_EurliborSwapFixIFR2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR2Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR2YQuantLib" ;;
let _new_EurliborSwapFixIFR2Y arg = match _new_EurliborSwapFixIFR2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR2Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR2YQuantLib" ;;
let _delete_EurliborSwapFixIFR2Y arg = match _delete_EurliborSwapFixIFR2Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR3Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR3Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR3Y arg = match _new_EurliborSwapFixIFR3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR3Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR3YQuantLib" ;;
let _new_EurliborSwapFixIFR3Y arg = match _new_EurliborSwapFixIFR3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR3Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR3YQuantLib" ;;
let _delete_EurliborSwapFixIFR3Y arg = match _delete_EurliborSwapFixIFR3Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR4Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR4Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR4Y arg = match _new_EurliborSwapFixIFR4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR4Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR4YQuantLib" ;;
let _new_EurliborSwapFixIFR4Y arg = match _new_EurliborSwapFixIFR4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR4Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR4YQuantLib" ;;
let _delete_EurliborSwapFixIFR4Y arg = match _delete_EurliborSwapFixIFR4Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR5Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR5Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR5Y arg = match _new_EurliborSwapFixIFR5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR5Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR5YQuantLib" ;;
let _new_EurliborSwapFixIFR5Y arg = match _new_EurliborSwapFixIFR5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR5Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR5YQuantLib" ;;
let _delete_EurliborSwapFixIFR5Y arg = match _delete_EurliborSwapFixIFR5Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR6Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR6Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR6Y arg = match _new_EurliborSwapFixIFR6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR6Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR6YQuantLib" ;;
let _new_EurliborSwapFixIFR6Y arg = match _new_EurliborSwapFixIFR6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR6Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR6YQuantLib" ;;
let _delete_EurliborSwapFixIFR6Y arg = match _delete_EurliborSwapFixIFR6Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR7Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR7Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR7Y arg = match _new_EurliborSwapFixIFR7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR7Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR7YQuantLib" ;;
let _new_EurliborSwapFixIFR7Y arg = match _new_EurliborSwapFixIFR7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR7Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR7YQuantLib" ;;
let _delete_EurliborSwapFixIFR7Y arg = match _delete_EurliborSwapFixIFR7Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR8Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR8Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR8Y arg = match _new_EurliborSwapFixIFR8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR8Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR8YQuantLib" ;;
let _new_EurliborSwapFixIFR8Y arg = match _new_EurliborSwapFixIFR8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR8Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR8YQuantLib" ;;
let _delete_EurliborSwapFixIFR8Y arg = match _delete_EurliborSwapFixIFR8Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR9Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR9Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR9Y arg = match _new_EurliborSwapFixIFR9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR9Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR9YQuantLib" ;;
let _new_EurliborSwapFixIFR9Y arg = match _new_EurliborSwapFixIFR9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR9Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR9YQuantLib" ;;
let _delete_EurliborSwapFixIFR9Y arg = match _delete_EurliborSwapFixIFR9Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR10Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR10Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR10Y arg = match _new_EurliborSwapFixIFR10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR10Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR10YQuantLib" ;;
let _new_EurliborSwapFixIFR10Y arg = match _new_EurliborSwapFixIFR10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR10Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR10YQuantLib" ;;
let _delete_EurliborSwapFixIFR10Y arg = match _delete_EurliborSwapFixIFR10Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR12Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR12Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR12Y arg = match _new_EurliborSwapFixIFR12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR12Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR12YQuantLib" ;;
let _new_EurliborSwapFixIFR12Y arg = match _new_EurliborSwapFixIFR12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR12Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR12YQuantLib" ;;
let _delete_EurliborSwapFixIFR12Y arg = match _delete_EurliborSwapFixIFR12Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR15Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR15Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR15Y arg = match _new_EurliborSwapFixIFR15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR15Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR15YQuantLib" ;;
let _new_EurliborSwapFixIFR15Y arg = match _new_EurliborSwapFixIFR15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR15Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR15YQuantLib" ;;
let _delete_EurliborSwapFixIFR15Y arg = match _delete_EurliborSwapFixIFR15Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR20Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR20Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR20Y arg = match _new_EurliborSwapFixIFR20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR20Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR20YQuantLib" ;;
let _new_EurliborSwapFixIFR20Y arg = match _new_EurliborSwapFixIFR20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR20Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR20YQuantLib" ;;
let _delete_EurliborSwapFixIFR20Y arg = match _delete_EurliborSwapFixIFR20Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR25Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR25Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR25Y arg = match _new_EurliborSwapFixIFR25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR25Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR25YQuantLib" ;;
let _new_EurliborSwapFixIFR25Y arg = match _new_EurliborSwapFixIFR25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR25Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR25YQuantLib" ;;
let _delete_EurliborSwapFixIFR25Y arg = match _delete_EurliborSwapFixIFR25Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR30Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR30Y__SWIG_0QuantLib" ;;
let _new_EurliborSwapFixIFR30Y arg = match _new_EurliborSwapFixIFR30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurliborSwapFixIFR30Y_f : c_obj list -> c_obj list = "_wrap_new_EurliborSwapFixIFR30YQuantLib" ;;
let _new_EurliborSwapFixIFR30Y arg = match _new_EurliborSwapFixIFR30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurliborSwapFixIFR30Y_f : c_obj list -> c_obj list = "_wrap_delete_EurliborSwapFixIFR30YQuantLib" ;;
let _delete_EurliborSwapFixIFR30Y arg = match _delete_EurliborSwapFixIFR30Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_Schedule__SWIG_0QuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_Schedule__SWIG_1QuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_Schedule__SWIG_2QuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_ScheduleQuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Schedule_size_f : c_obj list -> c_obj list = "_wrap_Schedule_sizeQuantLib" ;;
let _Schedule_size arg = match _Schedule_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Schedule_date_f : c_obj list -> c_obj list = "_wrap_Schedule_dateQuantLib" ;;
let _Schedule_date arg = match _Schedule_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Schedule_isRegular_f : c_obj list -> c_obj list = "_wrap_Schedule_isRegularQuantLib" ;;
let _Schedule_isRegular arg = match _Schedule_isRegular_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Schedule_f : c_obj list -> c_obj list = "_wrap_delete_ScheduleQuantLib" ;;
let _delete_Schedule arg = match _delete_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow___deref___f : c_obj list -> c_obj list = "_wrap_CashFlow___deref__QuantLib" ;;
let _CashFlow___deref__ arg = match _CashFlow___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_isNull_f : c_obj list -> c_obj list = "_wrap_CashFlow_isNullQuantLib" ;;
let _CashFlow_isNull arg = match _CashFlow_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_asObservable_f : c_obj list -> c_obj list = "_wrap_CashFlow_asObservableQuantLib" ;;
let _CashFlow_asObservable arg = match _CashFlow_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CashFlow_f : c_obj list -> c_obj list = "_wrap_new_CashFlowQuantLib" ;;
let _new_CashFlow arg = match _new_CashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CashFlow_f : c_obj list -> c_obj list = "_wrap_delete_CashFlowQuantLib" ;;
let _delete_CashFlow arg = match _delete_CashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_amount_f : c_obj list -> c_obj list = "_wrap_CashFlow_amountQuantLib" ;;
let _CashFlow_amount arg = match _CashFlow_amount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_date_f : c_obj list -> c_obj list = "_wrap_CashFlow_dateQuantLib" ;;
let _CashFlow_date arg = match _CashFlow_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpleCashFlow_f : c_obj list -> c_obj list = "_wrap_new_SimpleCashFlowQuantLib" ;;
let _new_SimpleCashFlow arg = match _new_SimpleCashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpleCashFlow_f : c_obj list -> c_obj list = "_wrap_delete_SimpleCashFlowQuantLib" ;;
let _delete_SimpleCashFlow arg = match _delete_SimpleCashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateCoupon_f : c_obj list -> c_obj list = "_wrap_new_FixedRateCoupon__SWIG_0QuantLib" ;;
let _new_FixedRateCoupon arg = match _new_FixedRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateCoupon_f : c_obj list -> c_obj list = "_wrap_new_FixedRateCoupon__SWIG_1QuantLib" ;;
let _new_FixedRateCoupon arg = match _new_FixedRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateCoupon_f : c_obj list -> c_obj list = "_wrap_new_FixedRateCouponQuantLib" ;;
let _new_FixedRateCoupon arg = match _new_FixedRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedRateCoupon_f : c_obj list -> c_obj list = "_wrap_delete_FixedRateCouponQuantLib" ;;
let _delete_FixedRateCoupon arg = match _delete_FixedRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborCoupon_f : c_obj list -> c_obj list = "_wrap_new_IborCoupon__SWIG_0QuantLib" ;;
let _new_IborCoupon arg = match _new_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborCoupon_f : c_obj list -> c_obj list = "_wrap_new_IborCoupon__SWIG_1QuantLib" ;;
let _new_IborCoupon arg = match _new_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborCoupon_f : c_obj list -> c_obj list = "_wrap_new_IborCoupon__SWIG_2QuantLib" ;;
let _new_IborCoupon arg = match _new_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborCoupon_f : c_obj list -> c_obj list = "_wrap_new_IborCoupon__SWIG_3QuantLib" ;;
let _new_IborCoupon arg = match _new_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborCoupon_f : c_obj list -> c_obj list = "_wrap_new_IborCoupon__SWIG_4QuantLib" ;;
let _new_IborCoupon arg = match _new_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborCoupon_f : c_obj list -> c_obj list = "_wrap_new_IborCouponQuantLib" ;;
let _new_IborCoupon arg = match _new_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborCoupon_rate_f : c_obj list -> c_obj list = "_wrap_IborCoupon_rateQuantLib" ;;
let _IborCoupon_rate arg = match _IborCoupon_rate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborCoupon_indexFixing_f : c_obj list -> c_obj list = "_wrap_IborCoupon_indexFixingQuantLib" ;;
let _IborCoupon_indexFixing arg = match _IborCoupon_indexFixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborCoupon_nominal_f : c_obj list -> c_obj list = "_wrap_IborCoupon_nominalQuantLib" ;;
let _IborCoupon_nominal arg = match _IborCoupon_nominal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IborCoupon_f : c_obj list -> c_obj list = "_wrap_delete_IborCouponQuantLib" ;;
let _delete_IborCoupon arg = match _delete_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_rate_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_rateQuantLib" ;;
let _FloatingRateCoupon_rate arg = match _FloatingRateCoupon_rate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_fixingDays_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_fixingDaysQuantLib" ;;
let _FloatingRateCoupon_fixingDays arg = match _FloatingRateCoupon_fixingDays_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_spread_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_spreadQuantLib" ;;
let _FloatingRateCoupon_spread arg = match _FloatingRateCoupon_spread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_indexFixing_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_indexFixingQuantLib" ;;
let _FloatingRateCoupon_indexFixing arg = match _FloatingRateCoupon_indexFixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_fixingDate_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_fixingDateQuantLib" ;;
let _FloatingRateCoupon_fixingDate arg = match _FloatingRateCoupon_fixingDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloatingRateCoupon_f : c_obj list -> c_obj list = "_wrap_new_FloatingRateCouponQuantLib" ;;
let _new_FloatingRateCoupon arg = match _new_FloatingRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FloatingRateCoupon_f : c_obj list -> c_obj list = "_wrap_delete_FloatingRateCouponQuantLib" ;;
let _delete_FloatingRateCoupon arg = match _delete_FloatingRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_Leg__SWIG_0QuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_Leg__SWIG_1QuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_Leg__SWIG_2QuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_LegQuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_size_f : c_obj list -> c_obj list = "_wrap_Leg_sizeQuantLib" ;;
let _Leg_size arg = match _Leg_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_empty_f : c_obj list -> c_obj list = "_wrap_Leg_emptyQuantLib" ;;
let _Leg_empty arg = match _Leg_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_clear_f : c_obj list -> c_obj list = "_wrap_Leg_clearQuantLib" ;;
let _Leg_clear arg = match _Leg_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_push_back_f : c_obj list -> c_obj list = "_wrap_Leg_push_backQuantLib" ;;
let _Leg_push_back arg = match _Leg_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_Leg_operator_bB___QuantLib" ;;
let _Leg_operator_xx_xx_lbrace_xx_rbrace arg = match _Leg_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_Leg_operator_e___QuantLib" ;;
let _Leg_operator_xx_xx_equals arg = match _Leg_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_set_f : c_obj list -> c_obj list = "_wrap_Leg_setQuantLib" ;;
let _Leg_set arg = match _Leg_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_to_array_f : c_obj list -> c_obj list = "_wrap_Leg_to_arrayQuantLib" ;;
let _Leg_to_array arg = match _Leg_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Leg_f : c_obj list -> c_obj list = "_wrap_delete_LegQuantLib" ;;
let _delete_Leg arg = match _delete_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateLeg_f : c_obj list -> c_obj list = "_wrap_FixedRateLeg__SWIG_0QuantLib" ;;
let _FixedRateLeg arg = match _FixedRateLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateLeg_f : c_obj list -> c_obj list = "_wrap_FixedRateLeg__SWIG_1QuantLib" ;;
let _FixedRateLeg arg = match _FixedRateLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateLeg_f : c_obj list -> c_obj list = "_wrap_FixedRateLegQuantLib" ;;
let _FixedRateLeg arg = match _FixedRateLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborLeg_f : c_obj list -> c_obj list = "_wrap_IborLegQuantLib" ;;
let _IborLeg arg = match _IborLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CmsLeg_f : c_obj list -> c_obj list = "_wrap_CmsLegQuantLib" ;;
let _CmsLeg arg = match _CmsLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CmsZeroLeg_f : c_obj list -> c_obj list = "_wrap_CmsZeroLegQuantLib" ;;
let _CmsZeroLeg arg = match _CmsZeroLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Duration::Type_marker" (`Type)
external _Macaulay : c_obj -> Swig.c_obj = "_wrap_Macaulay" 
external _Modified : c_obj -> Swig.c_obj = "_wrap_Modified" 
external _new_Duration_f : c_obj list -> c_obj list = "_wrap_new_DurationQuantLib" ;;
let _new_Duration arg = match _new_Duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Duration_f : c_obj list -> c_obj list = "_wrap_delete_DurationQuantLib" ;;
let _delete_Duration arg = match _delete_Duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_startDate_f : c_obj list -> c_obj list = "_wrap_CashFlows_startDateQuantLib" ;;
let _CashFlows_startDate arg = match _CashFlows_startDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_maturityDate_f : c_obj list -> c_obj list = "_wrap_CashFlows_maturityDateQuantLib" ;;
let _CashFlows_maturityDate arg = match _CashFlows_maturityDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_0QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_1QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npvQuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_0QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_1QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bpsQuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRate__SWIG_0QuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRate__SWIG_1QuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRate__SWIG_2QuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRate__SWIG_3QuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRateQuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_irr_f : c_obj list -> c_obj list = "_wrap_CashFlows_irr__SWIG_0QuantLib" ;;
let _CashFlows_irr arg = match _CashFlows_irr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_irr_f : c_obj list -> c_obj list = "_wrap_CashFlows_irr__SWIG_1QuantLib" ;;
let _CashFlows_irr arg = match _CashFlows_irr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_irr_f : c_obj list -> c_obj list = "_wrap_CashFlows_irr__SWIG_2QuantLib" ;;
let _CashFlows_irr arg = match _CashFlows_irr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_irr_f : c_obj list -> c_obj list = "_wrap_CashFlows_irr__SWIG_3QuantLib" ;;
let _CashFlows_irr arg = match _CashFlows_irr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_irr_f : c_obj list -> c_obj list = "_wrap_CashFlows_irr__SWIG_4QuantLib" ;;
let _CashFlows_irr arg = match _CashFlows_irr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_irr_f : c_obj list -> c_obj list = "_wrap_CashFlows_irrQuantLib" ;;
let _CashFlows_irr arg = match _CashFlows_irr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_duration__SWIG_0QuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_duration__SWIG_1QuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_durationQuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexity__SWIG_0QuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexityQuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CashFlows_f : c_obj list -> c_obj list = "_wrap_delete_CashFlowsQuantLib" ;;
let _delete_CashFlows arg = match _delete_CashFlows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_settlementDate_f : c_obj list -> c_obj list = "_wrap_Bond_settlementDateQuantLib" ;;
let _Bond_settlementDate arg = match _Bond_settlementDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cashflows_f : c_obj list -> c_obj list = "_wrap_Bond_cashflowsQuantLib" ;;
let _Bond_cashflows arg = match _Bond_cashflows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_redemption_f : c_obj list -> c_obj list = "_wrap_Bond_redemptionQuantLib" ;;
let _Bond_redemption arg = match _Bond_redemption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_calendar_f : c_obj list -> c_obj list = "_wrap_Bond_calendarQuantLib" ;;
let _Bond_calendar arg = match _Bond_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_paymentConvention_f : c_obj list -> c_obj list = "_wrap_Bond_paymentConventionQuantLib" ;;
let _Bond_paymentConvention arg = match _Bond_paymentConvention_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_dayCounter_f : c_obj list -> c_obj list = "_wrap_Bond_dayCounterQuantLib" ;;
let _Bond_dayCounter arg = match _Bond_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_frequency_f : c_obj list -> c_obj list = "_wrap_Bond_frequencyQuantLib" ;;
let _Bond_frequency arg = match _Bond_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cleanPrice_f : c_obj list -> c_obj list = "_wrap_Bond_cleanPrice__SWIG_0QuantLib" ;;
let _Bond_cleanPrice arg = match _Bond_cleanPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cleanPrice_f : c_obj list -> c_obj list = "_wrap_Bond_cleanPrice__SWIG_1QuantLib" ;;
let _Bond_cleanPrice arg = match _Bond_cleanPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cleanPrice_f : c_obj list -> c_obj list = "_wrap_Bond_cleanPriceQuantLib" ;;
let _Bond_cleanPrice arg = match _Bond_cleanPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_dirtyPrice_f : c_obj list -> c_obj list = "_wrap_Bond_dirtyPrice__SWIG_0QuantLib" ;;
let _Bond_dirtyPrice arg = match _Bond_dirtyPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_dirtyPrice_f : c_obj list -> c_obj list = "_wrap_Bond_dirtyPrice__SWIG_1QuantLib" ;;
let _Bond_dirtyPrice arg = match _Bond_dirtyPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_dirtyPrice_f : c_obj list -> c_obj list = "_wrap_Bond_dirtyPriceQuantLib" ;;
let _Bond_dirtyPrice arg = match _Bond_dirtyPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_0QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_1QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_2QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_3QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_4QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_5QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yieldQuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_accruedAmount_f : c_obj list -> c_obj list = "_wrap_Bond_accruedAmount__SWIG_0QuantLib" ;;
let _Bond_accruedAmount arg = match _Bond_accruedAmount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_accruedAmount_f : c_obj list -> c_obj list = "_wrap_Bond_accruedAmountQuantLib" ;;
let _Bond_accruedAmount arg = match _Bond_accruedAmount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Bond_f : c_obj list -> c_obj list = "_wrap_delete_BondQuantLib" ;;
let _delete_Bond arg = match _delete_Bond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ZeroCouponBondQuantLib" ;;
let _new_ZeroCouponBond arg = match _new_ZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_delete_ZeroCouponBondQuantLib" ;;
let _delete_ZeroCouponBond arg = match _delete_ZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateBond_f : c_obj list -> c_obj list = "_wrap_new_FixedRateBondQuantLib" ;;
let _new_FixedRateBond arg = match _new_FixedRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedRateBond_f : c_obj list -> c_obj list = "_wrap_delete_FixedRateBondQuantLib" ;;
let _delete_FixedRateBond arg = match _delete_FixedRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloatingRateBond_f : c_obj list -> c_obj list = "_wrap_new_FloatingRateBondQuantLib" ;;
let _new_FloatingRateBond arg = match _new_FloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FloatingRateBond_f : c_obj list -> c_obj list = "_wrap_delete_FloatingRateBondQuantLib" ;;
let _delete_FloatingRateBond arg = match _delete_FloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "CallabilityPrice::Type_marker" (`Type)
external _Dirty : c_obj -> Swig.c_obj = "_wrap_Dirty" 
external _Clean : c_obj -> Swig.c_obj = "_wrap_Clean" 
external _new_CallabilityPrice_f : c_obj list -> c_obj list = "_wrap_new_CallabilityPriceQuantLib" ;;
let _new_CallabilityPrice arg = match _new_CallabilityPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityPrice_amount_f : c_obj list -> c_obj list = "_wrap_CallabilityPrice_amountQuantLib" ;;
let _CallabilityPrice_amount arg = match _CallabilityPrice_amount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityPrice_type_f : c_obj list -> c_obj list = "_wrap_CallabilityPrice_typeQuantLib" ;;
let _CallabilityPrice_type arg = match _CallabilityPrice_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CallabilityPrice_f : c_obj list -> c_obj list = "_wrap_delete_CallabilityPriceQuantLib" ;;
let _delete_CallabilityPrice arg = match _delete_CallabilityPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability___deref___f : c_obj list -> c_obj list = "_wrap_Callability___deref__QuantLib" ;;
let _Callability___deref__ arg = match _Callability___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_isNull_f : c_obj list -> c_obj list = "_wrap_Callability_isNullQuantLib" ;;
let _Callability_isNull arg = match _Callability_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_Call : c_obj -> Swig.c_obj = "_wrap_Callability_Call" 
external _Callability_Put : c_obj -> Swig.c_obj = "_wrap_Callability_Put" 
external _new_Callability_f : c_obj list -> c_obj list = "_wrap_new_CallabilityQuantLib" ;;
let _new_Callability arg = match _new_Callability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Callability_f : c_obj list -> c_obj list = "_wrap_delete_CallabilityQuantLib" ;;
let _delete_Callability arg = match _delete_Callability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_price_f : c_obj list -> c_obj list = "_wrap_Callability_priceQuantLib" ;;
let _Callability_price arg = match _Callability_price_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_type_f : c_obj list -> c_obj list = "_wrap_Callability_typeQuantLib" ;;
let _Callability_type arg = match _Callability_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_date_f : c_obj list -> c_obj list = "_wrap_Callability_dateQuantLib" ;;
let _Callability_date arg = match _Callability_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SoftCallability_f : c_obj list -> c_obj list = "_wrap_new_SoftCallabilityQuantLib" ;;
let _new_SoftCallability arg = match _new_SoftCallability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SoftCallability_f : c_obj list -> c_obj list = "_wrap_delete_SoftCallabilityQuantLib" ;;
let _delete_SoftCallability arg = match _delete_SoftCallability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilityVector_f : c_obj list -> c_obj list = "_wrap_new_CallabilityVector__SWIG_0QuantLib" ;;
let _new_CallabilityVector arg = match _new_CallabilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilityVector_f : c_obj list -> c_obj list = "_wrap_new_CallabilityVector__SWIG_1QuantLib" ;;
let _new_CallabilityVector arg = match _new_CallabilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilityVector_f : c_obj list -> c_obj list = "_wrap_new_CallabilityVector__SWIG_2QuantLib" ;;
let _new_CallabilityVector arg = match _new_CallabilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilityVector_f : c_obj list -> c_obj list = "_wrap_new_CallabilityVectorQuantLib" ;;
let _new_CallabilityVector arg = match _new_CallabilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_size_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_sizeQuantLib" ;;
let _CallabilityVector_size arg = match _CallabilityVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_empty_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_emptyQuantLib" ;;
let _CallabilityVector_empty arg = match _CallabilityVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_clear_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_clearQuantLib" ;;
let _CallabilityVector_clear arg = match _CallabilityVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_push_back_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_push_backQuantLib" ;;
let _CallabilityVector_push_back arg = match _CallabilityVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_operator_bB___QuantLib" ;;
let _CallabilityVector_operator_xx_xx_lbrace_xx_rbrace arg = match _CallabilityVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_operator_e___QuantLib" ;;
let _CallabilityVector_operator_xx_xx_equals arg = match _CallabilityVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_set_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_setQuantLib" ;;
let _CallabilityVector_set arg = match _CallabilityVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityVector_to_array_f : c_obj list -> c_obj list = "_wrap_CallabilityVector_to_arrayQuantLib" ;;
let _CallabilityVector_to_array arg = match _CallabilityVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CallabilityVector_f : c_obj list -> c_obj list = "_wrap_delete_CallabilityVectorQuantLib" ;;
let _delete_CallabilityVector arg = match _delete_CallabilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_0QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_1QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_2QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_3QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatilityQuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapFloor_f : c_obj list -> c_obj list = "_wrap_new_CapFloorQuantLib" ;;
let _new_CapFloor arg = match _new_CapFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapFloor_f : c_obj list -> c_obj list = "_wrap_delete_CapFloorQuantLib" ;;
let _delete_CapFloor arg = match _delete_CapFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cap_f : c_obj list -> c_obj list = "_wrap_new_CapQuantLib" ;;
let _new_Cap arg = match _new_Cap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Cap_f : c_obj list -> c_obj list = "_wrap_delete_CapQuantLib" ;;
let _delete_Cap arg = match _delete_Cap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Floor_f : c_obj list -> c_obj list = "_wrap_new_FloorQuantLib" ;;
let _new_Floor arg = match _new_Floor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Floor_f : c_obj list -> c_obj list = "_wrap_delete_FloorQuantLib" ;;
let _delete_Floor arg = match _delete_Floor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Collar_f : c_obj list -> c_obj list = "_wrap_new_CollarQuantLib" ;;
let _new_Collar arg = match _new_Collar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Collar_f : c_obj list -> c_obj list = "_wrap_delete_CollarQuantLib" ;;
let _delete_Collar arg = match _delete_Collar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_new_BlackCapFloorEngine__SWIG_0QuantLib" ;;
let _new_BlackCapFloorEngine arg = match _new_BlackCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_new_BlackCapFloorEngineQuantLib" ;;
let _new_BlackCapFloorEngine arg = match _new_BlackCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_delete_BlackCapFloorEngineQuantLib" ;;
let _delete_BlackCapFloorEngine arg = match _delete_BlackCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CompoundForward_f : c_obj list -> c_obj list = "_wrap_new_CompoundForwardQuantLib" ;;
let _new_CompoundForward arg = match _new_CompoundForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompoundForward_dates_f : c_obj list -> c_obj list = "_wrap_CompoundForward_datesQuantLib" ;;
let _CompoundForward_dates arg = match _CompoundForward_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompoundForward_compoundForward_f : c_obj list -> c_obj list = "_wrap_CompoundForward_compoundForward__SWIG_0QuantLib" ;;
let _CompoundForward_compoundForward arg = match _CompoundForward_compoundForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompoundForward_compoundForward_f : c_obj list -> c_obj list = "_wrap_CompoundForward_compoundForward__SWIG_1QuantLib" ;;
let _CompoundForward_compoundForward arg = match _CompoundForward_compoundForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompoundForward_compoundForward_f : c_obj list -> c_obj list = "_wrap_CompoundForward_compoundForward__SWIG_2QuantLib" ;;
let _CompoundForward_compoundForward arg = match _CompoundForward_compoundForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompoundForward_compoundForward_f : c_obj list -> c_obj list = "_wrap_CompoundForward_compoundForwardQuantLib" ;;
let _CompoundForward_compoundForward arg = match _CompoundForward_compoundForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CompoundForward_f : c_obj list -> c_obj list = "_wrap_delete_CompoundForwardQuantLib" ;;
let _delete_CompoundForward arg = match _delete_CompoundForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend___deref___f : c_obj list -> c_obj list = "_wrap_Dividend___deref__QuantLib" ;;
let _Dividend___deref__ arg = match _Dividend___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend_isNull_f : c_obj list -> c_obj list = "_wrap_Dividend_isNullQuantLib" ;;
let _Dividend_isNull arg = match _Dividend_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Dividend_f : c_obj list -> c_obj list = "_wrap_new_DividendQuantLib" ;;
let _new_Dividend arg = match _new_Dividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Dividend_f : c_obj list -> c_obj list = "_wrap_delete_DividendQuantLib" ;;
let _delete_Dividend arg = match _delete_Dividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend_amount_f : c_obj list -> c_obj list = "_wrap_Dividend_amountQuantLib" ;;
let _Dividend_amount arg = match _Dividend_amount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend_date_f : c_obj list -> c_obj list = "_wrap_Dividend_dateQuantLib" ;;
let _Dividend_date arg = match _Dividend_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedDividend_f : c_obj list -> c_obj list = "_wrap_new_FixedDividendQuantLib" ;;
let _new_FixedDividend arg = match _new_FixedDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedDividend_f : c_obj list -> c_obj list = "_wrap_delete_FixedDividendQuantLib" ;;
let _delete_FixedDividend arg = match _delete_FixedDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FractionalDividend_f : c_obj list -> c_obj list = "_wrap_new_FractionalDividendQuantLib" ;;
let _new_FractionalDividend arg = match _new_FractionalDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FractionalDividend_f : c_obj list -> c_obj list = "_wrap_delete_FractionalDividendQuantLib" ;;
let _delete_FractionalDividend arg = match _delete_FractionalDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleZeroCouponBond__SWIG_0QuantLib" ;;
let _new_ConvertibleZeroCouponBond arg = match _new_ConvertibleZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleZeroCouponBondQuantLib" ;;
let _new_ConvertibleZeroCouponBond arg = match _new_ConvertibleZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConvertibleZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_delete_ConvertibleZeroCouponBondQuantLib" ;;
let _delete_ConvertibleZeroCouponBond arg = match _delete_ConvertibleZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFixedCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFixedCouponBond__SWIG_0QuantLib" ;;
let _new_ConvertibleFixedCouponBond arg = match _new_ConvertibleFixedCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFixedCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFixedCouponBondQuantLib" ;;
let _new_ConvertibleFixedCouponBond arg = match _new_ConvertibleFixedCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConvertibleFixedCouponBond_f : c_obj list -> c_obj list = "_wrap_delete_ConvertibleFixedCouponBondQuantLib" ;;
let _delete_ConvertibleFixedCouponBond arg = match _delete_ConvertibleFixedCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFloatingRateBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFloatingRateBond__SWIG_0QuantLib" ;;
let _new_ConvertibleFloatingRateBond arg = match _new_ConvertibleFloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFloatingRateBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFloatingRateBondQuantLib" ;;
let _new_ConvertibleFloatingRateBond arg = match _new_ConvertibleFloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConvertibleFloatingRateBond_f : c_obj list -> c_obj list = "_wrap_delete_ConvertibleFloatingRateBondQuantLib" ;;
let _delete_ConvertibleFloatingRateBond arg = match _delete_ConvertibleFloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BinomialConvertibleEngine_f : c_obj list -> c_obj list = "_wrap_new_BinomialConvertibleEngineQuantLib" ;;
let _new_BinomialConvertibleEngine arg = match _new_BinomialConvertibleEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BinomialConvertibleEngine_f : c_obj list -> c_obj list = "_wrap_delete_BinomialConvertibleEngineQuantLib" ;;
let _delete_BinomialConvertibleEngine arg = match _delete_BinomialConvertibleEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_new_DiscountCurve__SWIG_0QuantLib" ;;
let _new_DiscountCurve arg = match _new_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_new_DiscountCurve__SWIG_1QuantLib" ;;
let _new_DiscountCurve arg = match _new_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_new_DiscountCurveQuantLib" ;;
let _new_DiscountCurve arg = match _new_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscountCurve_dates_f : c_obj list -> c_obj list = "_wrap_DiscountCurve_datesQuantLib" ;;
let _DiscountCurve_dates arg = match _DiscountCurve_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscountCurve_discounts_f : c_obj list -> c_obj list = "_wrap_DiscountCurve_discountsQuantLib" ;;
let _DiscountCurve_discounts arg = match _DiscountCurve_discounts_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscountCurve_nodes_f : c_obj list -> c_obj list = "_wrap_DiscountCurve_nodesQuantLib" ;;
let _DiscountCurve_nodes arg = match _DiscountCurve_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_delete_DiscountCurveQuantLib" ;;
let _delete_DiscountCurve arg = match _delete_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_NormalDistribution__SWIG_0QuantLib" ;;
let _new_NormalDistribution arg = match _new_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_NormalDistribution__SWIG_1QuantLib" ;;
let _new_NormalDistribution arg = match _new_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_NormalDistributionQuantLib" ;;
let _new_NormalDistribution arg = match _new_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NormalDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_NormalDistribution_operator_pP___QuantLib" ;;
let _NormalDistribution_operator_xx_xx_lparen_xx_rparen arg = match _NormalDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NormalDistribution_derivative_f : c_obj list -> c_obj list = "_wrap_NormalDistribution_derivativeQuantLib" ;;
let _NormalDistribution_derivative arg = match _NormalDistribution_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_delete_NormalDistributionQuantLib" ;;
let _delete_NormalDistribution arg = match _delete_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeNormalDistribution__SWIG_0QuantLib" ;;
let _new_CumulativeNormalDistribution arg = match _new_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeNormalDistribution__SWIG_1QuantLib" ;;
let _new_CumulativeNormalDistribution arg = match _new_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeNormalDistributionQuantLib" ;;
let _new_CumulativeNormalDistribution arg = match _new_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CumulativeNormalDistribution_operator_pP___QuantLib" ;;
let _CumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen arg = match _CumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CumulativeNormalDistribution_derivative_f : c_obj list -> c_obj list = "_wrap_CumulativeNormalDistribution_derivativeQuantLib" ;;
let _CumulativeNormalDistribution_derivative arg = match _CumulativeNormalDistribution_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_delete_CumulativeNormalDistributionQuantLib" ;;
let _delete_CumulativeNormalDistribution arg = match _delete_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeNormal__SWIG_0QuantLib" ;;
let _new_InverseCumulativeNormal arg = match _new_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeNormal__SWIG_1QuantLib" ;;
let _new_InverseCumulativeNormal arg = match _new_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeNormalQuantLib" ;;
let _new_InverseCumulativeNormal arg = match _new_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_InverseCumulativeNormal_operator_pP___QuantLib" ;;
let _InverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen arg = match _InverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_delete_InverseCumulativeNormalQuantLib" ;;
let _delete_InverseCumulativeNormal arg = match _delete_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_MoroInverseCumulativeNormal__SWIG_0QuantLib" ;;
let _new_MoroInverseCumulativeNormal arg = match _new_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_MoroInverseCumulativeNormal__SWIG_1QuantLib" ;;
let _new_MoroInverseCumulativeNormal arg = match _new_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_MoroInverseCumulativeNormalQuantLib" ;;
let _new_MoroInverseCumulativeNormal arg = match _new_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MoroInverseCumulativeNormal_operator_pP___QuantLib" ;;
let _MoroInverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen arg = match _MoroInverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_delete_MoroInverseCumulativeNormalQuantLib" ;;
let _delete_MoroInverseCumulativeNormal arg = match _delete_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Money_f : c_obj list -> c_obj list = "_wrap_new_Money__SWIG_0QuantLib" ;;
let _new_Money arg = match _new_Money_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Money_f : c_obj list -> c_obj list = "_wrap_new_MoneyQuantLib" ;;
let _new_Money arg = match _new_Money_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_currency_f : c_obj list -> c_obj list = "_wrap_Money_currencyQuantLib" ;;
let _Money_currency arg = match _Money_currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_value_f : c_obj list -> c_obj list = "_wrap_Money_valueQuantLib" ;;
let _Money_value arg = match _Money_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_rounded_f : c_obj list -> c_obj list = "_wrap_Money_roundedQuantLib" ;;
let _Money_rounded arg = match _Money_rounded_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Money::ConversionType_marker" (`ConversionType)
external _NoConversion : c_obj -> Swig.c_obj = "_wrap_NoConversion" 
external _BaseCurrencyConversion : c_obj -> Swig.c_obj = "_wrap_BaseCurrencyConversion" 
external _AutomatedConversion : c_obj -> Swig.c_obj = "_wrap_AutomatedConversion" 
external _Money_setConversionType_f : c_obj list -> c_obj list = "_wrap_Money_setConversionTypeQuantLib" ;;
let _Money_setConversionType arg = match _Money_setConversionType_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_setBaseCurrency_f : c_obj list -> c_obj list = "_wrap_Money_setBaseCurrencyQuantLib" ;;
let _Money_setBaseCurrency arg = match _Money_setBaseCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Money_f : c_obj list -> c_obj list = "_wrap_delete_MoneyQuantLib" ;;
let _delete_Money arg = match _delete_Money_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "ExchangeRate::Type_marker" (`Type)
external _Direct : c_obj -> Swig.c_obj = "_wrap_Direct" 
external _Derived : c_obj -> Swig.c_obj = "_wrap_Derived" 
external _new_ExchangeRate_f : c_obj list -> c_obj list = "_wrap_new_ExchangeRateQuantLib" ;;
let _new_ExchangeRate arg = match _new_ExchangeRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_source_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_sourceQuantLib" ;;
let _ExchangeRate_source arg = match _ExchangeRate_source_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_target_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_targetQuantLib" ;;
let _ExchangeRate_target arg = match _ExchangeRate_target_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_type_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_typeQuantLib" ;;
let _ExchangeRate_type arg = match _ExchangeRate_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_rate_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_rateQuantLib" ;;
let _ExchangeRate_rate arg = match _ExchangeRate_rate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_exchange_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_exchangeQuantLib" ;;
let _ExchangeRate_exchange arg = match _ExchangeRate_exchange_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_chain_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_chainQuantLib" ;;
let _ExchangeRate_chain arg = match _ExchangeRate_chain_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ExchangeRate_f : c_obj list -> c_obj list = "_wrap_delete_ExchangeRateQuantLib" ;;
let _delete_ExchangeRate arg = match _delete_ExchangeRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_instance_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_instanceQuantLib" ;;
let _ExchangeRateManager_instance arg = match _ExchangeRateManager_instance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_add_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_add__SWIG_0QuantLib" ;;
let _ExchangeRateManager_add arg = match _ExchangeRateManager_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_add_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_add__SWIG_1QuantLib" ;;
let _ExchangeRateManager_add arg = match _ExchangeRateManager_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_add_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_addQuantLib" ;;
let _ExchangeRateManager_add arg = match _ExchangeRateManager_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_lookup_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_lookup__SWIG_0QuantLib" ;;
let _ExchangeRateManager_lookup arg = match _ExchangeRateManager_lookup_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_lookup_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_lookupQuantLib" ;;
let _ExchangeRateManager_lookup arg = match _ExchangeRateManager_lookup_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_clear_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_clearQuantLib" ;;
let _ExchangeRateManager_clear arg = match _ExchangeRateManager_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ExchangeRateManager_f : c_obj list -> c_obj list = "_wrap_delete_ExchangeRateManagerQuantLib" ;;
let _delete_ExchangeRateManager arg = match _delete_ExchangeRateManager_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardCurve_f : c_obj list -> c_obj list = "_wrap_new_ForwardCurve__SWIG_0QuantLib" ;;
let _new_ForwardCurve arg = match _new_ForwardCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardCurve_f : c_obj list -> c_obj list = "_wrap_new_ForwardCurveQuantLib" ;;
let _new_ForwardCurve arg = match _new_ForwardCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardCurve_dates_f : c_obj list -> c_obj list = "_wrap_ForwardCurve_datesQuantLib" ;;
let _ForwardCurve_dates arg = match _ForwardCurve_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardCurve_forwards_f : c_obj list -> c_obj list = "_wrap_ForwardCurve_forwardsQuantLib" ;;
let _ForwardCurve_forwards arg = match _ForwardCurve_forwards_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardCurve_nodes_f : c_obj list -> c_obj list = "_wrap_ForwardCurve_nodesQuantLib" ;;
let _ForwardCurve_nodes arg = match _ForwardCurve_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardCurve_f : c_obj list -> c_obj list = "_wrap_delete_ForwardCurveQuantLib" ;;
let _delete_ForwardCurve arg = match _delete_ForwardCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGrid__SWIG_0QuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGrid__SWIG_1QuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGrid__SWIG_2QuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGridQuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TimeGrid_size_f : c_obj list -> c_obj list = "_wrap_TimeGrid_sizeQuantLib" ;;
let _TimeGrid_size arg = match _TimeGrid_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TimeGrid_f : c_obj list -> c_obj list = "_wrap_delete_TimeGridQuantLib" ;;
let _delete_TimeGrid arg = match _delete_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SegmentIntegral_f : c_obj list -> c_obj list = "_wrap_new_SegmentIntegralQuantLib" ;;
let _new_SegmentIntegral arg = match _new_SegmentIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SegmentIntegral_f : c_obj list -> c_obj list = "_wrap_delete_SegmentIntegralQuantLib" ;;
let _delete_SegmentIntegral arg = match _delete_SegmentIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TrapezoidIntegral_f : c_obj list -> c_obj list = "_wrap_new_TrapezoidIntegralQuantLib" ;;
let _new_TrapezoidIntegral arg = match _new_TrapezoidIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TrapezoidIntegral_f : c_obj list -> c_obj list = "_wrap_delete_TrapezoidIntegralQuantLib" ;;
let _delete_TrapezoidIntegral arg = match _delete_TrapezoidIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpsonIntegral_f : c_obj list -> c_obj list = "_wrap_new_SimpsonIntegralQuantLib" ;;
let _new_SimpsonIntegral arg = match _new_SimpsonIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpsonIntegral_f : c_obj list -> c_obj list = "_wrap_delete_SimpsonIntegralQuantLib" ;;
let _delete_SimpsonIntegral arg = match _delete_SimpsonIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussKronrodAdaptive_f : c_obj list -> c_obj list = "_wrap_new_GaussKronrodAdaptive__SWIG_0QuantLib" ;;
let _new_GaussKronrodAdaptive arg = match _new_GaussKronrodAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussKronrodAdaptive_f : c_obj list -> c_obj list = "_wrap_new_GaussKronrodAdaptiveQuantLib" ;;
let _new_GaussKronrodAdaptive arg = match _new_GaussKronrodAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussKronrodAdaptive_f : c_obj list -> c_obj list = "_wrap_delete_GaussKronrodAdaptiveQuantLib" ;;
let _delete_GaussKronrodAdaptive arg = match _delete_GaussKronrodAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussKronrodNonAdaptive_f : c_obj list -> c_obj list = "_wrap_new_GaussKronrodNonAdaptiveQuantLib" ;;
let _new_GaussKronrodNonAdaptive arg = match _new_GaussKronrodNonAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussKronrodNonAdaptive_f : c_obj list -> c_obj list = "_wrap_delete_GaussKronrodNonAdaptiveQuantLib" ;;
let _delete_GaussKronrodNonAdaptive arg = match _delete_GaussKronrodNonAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleNumber_value_f : c_obj list -> c_obj list = "_wrap_SampleNumber_valueQuantLib" ;;
let _SampleNumber_value arg = match _SampleNumber_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleNumber_weight_f : c_obj list -> c_obj list = "_wrap_SampleNumber_weightQuantLib" ;;
let _SampleNumber_weight arg = match _SampleNumber_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleNumber_f : c_obj list -> c_obj list = "_wrap_delete_SampleNumberQuantLib" ;;
let _delete_SampleNumber arg = match _delete_SampleNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleArray_value_f : c_obj list -> c_obj list = "_wrap_SampleArray_valueQuantLib" ;;
let _SampleArray_value arg = match _SampleArray_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleArray_weight_f : c_obj list -> c_obj list = "_wrap_SampleArray_weightQuantLib" ;;
let _SampleArray_weight arg = match _SampleArray_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleArray_f : c_obj list -> c_obj list = "_wrap_delete_SampleArrayQuantLib" ;;
let _delete_SampleArray arg = match _delete_SampleArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleRealVector_value_f : c_obj list -> c_obj list = "_wrap_SampleRealVector_valueQuantLib" ;;
let _SampleRealVector_value arg = match _SampleRealVector_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleRealVector_weight_f : c_obj list -> c_obj list = "_wrap_SampleRealVector_weightQuantLib" ;;
let _SampleRealVector_weight arg = match _SampleRealVector_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleRealVector_f : c_obj list -> c_obj list = "_wrap_delete_SampleRealVectorQuantLib" ;;
let _delete_SampleRealVector arg = match _delete_SampleRealVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LecuyerUniformRng_f : c_obj list -> c_obj list = "_wrap_new_LecuyerUniformRng__SWIG_0QuantLib" ;;
let _new_LecuyerUniformRng arg = match _new_LecuyerUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LecuyerUniformRng_f : c_obj list -> c_obj list = "_wrap_new_LecuyerUniformRngQuantLib" ;;
let _new_LecuyerUniformRng arg = match _new_LecuyerUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LecuyerUniformRng_next_f : c_obj list -> c_obj list = "_wrap_LecuyerUniformRng_nextQuantLib" ;;
let _LecuyerUniformRng_next arg = match _LecuyerUniformRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LecuyerUniformRng_f : c_obj list -> c_obj list = "_wrap_delete_LecuyerUniformRngQuantLib" ;;
let _delete_LecuyerUniformRng arg = match _delete_LecuyerUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KnuthUniformRng_f : c_obj list -> c_obj list = "_wrap_delete_KnuthUniformRngQuantLib" ;;
let _delete_KnuthUniformRng arg = match _delete_KnuthUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MersenneTwisterUniformRng_f : c_obj list -> c_obj list = "_wrap_delete_MersenneTwisterUniformRngQuantLib" ;;
let _delete_MersenneTwisterUniformRng arg = match _delete_MersenneTwisterUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformRandomGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformRandomGenerator__SWIG_0QuantLib" ;;
let _new_UniformRandomGenerator arg = match _new_UniformRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformRandomGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformRandomGeneratorQuantLib" ;;
let _new_UniformRandomGenerator arg = match _new_UniformRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformRandomGenerator_next_f : c_obj list -> c_obj list = "_wrap_UniformRandomGenerator_nextQuantLib" ;;
let _UniformRandomGenerator_next arg = match _UniformRandomGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UniformRandomGenerator_f : c_obj list -> c_obj list = "_wrap_delete_UniformRandomGeneratorQuantLib" ;;
let _delete_UniformRandomGenerator arg = match _delete_UniformRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CentralLimitLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_CentralLimitLecuyerGaussianRngQuantLib" ;;
let _new_CentralLimitLecuyerGaussianRng arg = match _new_CentralLimitLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CentralLimitLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_CentralLimitLecuyerGaussianRng_nextQuantLib" ;;
let _CentralLimitLecuyerGaussianRng_next arg = match _CentralLimitLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CentralLimitLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_CentralLimitLecuyerGaussianRngQuantLib" ;;
let _delete_CentralLimitLecuyerGaussianRng arg = match _delete_CentralLimitLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CentralLimitKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_CentralLimitKnuthGaussianRngQuantLib" ;;
let _new_CentralLimitKnuthGaussianRng arg = match _new_CentralLimitKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CentralLimitKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_CentralLimitKnuthGaussianRng_nextQuantLib" ;;
let _CentralLimitKnuthGaussianRng_next arg = match _CentralLimitKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CentralLimitKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_CentralLimitKnuthGaussianRngQuantLib" ;;
let _delete_CentralLimitKnuthGaussianRng arg = match _delete_CentralLimitKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CentralLimitMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_CentralLimitMersenneTwisterGaussianRngQuantLib" ;;
let _new_CentralLimitMersenneTwisterGaussianRng arg = match _new_CentralLimitMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CentralLimitMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_CentralLimitMersenneTwisterGaussianRng_nextQuantLib" ;;
let _CentralLimitMersenneTwisterGaussianRng_next arg = match _CentralLimitMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CentralLimitMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_CentralLimitMersenneTwisterGaussianRngQuantLib" ;;
let _delete_CentralLimitMersenneTwisterGaussianRng arg = match _delete_CentralLimitMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoxMullerLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_BoxMullerLecuyerGaussianRngQuantLib" ;;
let _new_BoxMullerLecuyerGaussianRng arg = match _new_BoxMullerLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoxMullerLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_BoxMullerLecuyerGaussianRng_nextQuantLib" ;;
let _BoxMullerLecuyerGaussianRng_next arg = match _BoxMullerLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoxMullerLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_BoxMullerLecuyerGaussianRngQuantLib" ;;
let _delete_BoxMullerLecuyerGaussianRng arg = match _delete_BoxMullerLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoxMullerKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_BoxMullerKnuthGaussianRngQuantLib" ;;
let _new_BoxMullerKnuthGaussianRng arg = match _new_BoxMullerKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoxMullerKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_BoxMullerKnuthGaussianRng_nextQuantLib" ;;
let _BoxMullerKnuthGaussianRng_next arg = match _BoxMullerKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoxMullerKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_BoxMullerKnuthGaussianRngQuantLib" ;;
let _delete_BoxMullerKnuthGaussianRng arg = match _delete_BoxMullerKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoxMullerMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_BoxMullerMersenneTwisterGaussianRngQuantLib" ;;
let _new_BoxMullerMersenneTwisterGaussianRng arg = match _new_BoxMullerMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoxMullerMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_BoxMullerMersenneTwisterGaussianRng_nextQuantLib" ;;
let _BoxMullerMersenneTwisterGaussianRng_next arg = match _BoxMullerMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoxMullerMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_BoxMullerMersenneTwisterGaussianRngQuantLib" ;;
let _delete_BoxMullerMersenneTwisterGaussianRng arg = match _delete_BoxMullerMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeLecuyerGaussianRngQuantLib" ;;
let _new_MoroInvCumulativeLecuyerGaussianRng arg = match _new_MoroInvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeLecuyerGaussianRng_nextQuantLib" ;;
let _MoroInvCumulativeLecuyerGaussianRng_next arg = match _MoroInvCumulativeLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeLecuyerGaussianRngQuantLib" ;;
let _delete_MoroInvCumulativeLecuyerGaussianRng arg = match _delete_MoroInvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeKnuthGaussianRngQuantLib" ;;
let _new_MoroInvCumulativeKnuthGaussianRng arg = match _new_MoroInvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeKnuthGaussianRng_nextQuantLib" ;;
let _MoroInvCumulativeKnuthGaussianRng_next arg = match _MoroInvCumulativeKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeKnuthGaussianRngQuantLib" ;;
let _delete_MoroInvCumulativeKnuthGaussianRng arg = match _delete_MoroInvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _new_MoroInvCumulativeMersenneTwisterGaussianRng arg = match _new_MoroInvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeMersenneTwisterGaussianRng_nextQuantLib" ;;
let _MoroInvCumulativeMersenneTwisterGaussianRng_next arg = match _MoroInvCumulativeMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _delete_MoroInvCumulativeMersenneTwisterGaussianRng arg = match _delete_MoroInvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeLecuyerGaussianRngQuantLib" ;;
let _new_InvCumulativeLecuyerGaussianRng arg = match _new_InvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_InvCumulativeLecuyerGaussianRng_nextQuantLib" ;;
let _InvCumulativeLecuyerGaussianRng_next arg = match _InvCumulativeLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeLecuyerGaussianRngQuantLib" ;;
let _delete_InvCumulativeLecuyerGaussianRng arg = match _delete_InvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeKnuthGaussianRngQuantLib" ;;
let _new_InvCumulativeKnuthGaussianRng arg = match _new_InvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_InvCumulativeKnuthGaussianRng_nextQuantLib" ;;
let _InvCumulativeKnuthGaussianRng_next arg = match _InvCumulativeKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeKnuthGaussianRngQuantLib" ;;
let _delete_InvCumulativeKnuthGaussianRng arg = match _delete_InvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _new_InvCumulativeMersenneTwisterGaussianRng arg = match _new_InvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_InvCumulativeMersenneTwisterGaussianRng_nextQuantLib" ;;
let _InvCumulativeMersenneTwisterGaussianRng_next arg = match _InvCumulativeMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _delete_InvCumulativeMersenneTwisterGaussianRng arg = match _delete_InvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianRandomGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianRandomGeneratorQuantLib" ;;
let _new_GaussianRandomGenerator arg = match _new_GaussianRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianRandomGenerator_next_f : c_obj list -> c_obj list = "_wrap_GaussianRandomGenerator_nextQuantLib" ;;
let _GaussianRandomGenerator_next arg = match _GaussianRandomGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianRandomGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianRandomGeneratorQuantLib" ;;
let _delete_GaussianRandomGenerator arg = match _delete_GaussianRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HaltonRsg_f : c_obj list -> c_obj list = "_wrap_new_HaltonRsgQuantLib" ;;
let _new_HaltonRsg arg = match _new_HaltonRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HaltonRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_HaltonRsg_nextSequenceQuantLib" ;;
let _HaltonRsg_nextSequence arg = match _HaltonRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HaltonRsg_dimension_f : c_obj list -> c_obj list = "_wrap_HaltonRsg_dimensionQuantLib" ;;
let _HaltonRsg_dimension arg = match _HaltonRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HaltonRsg_f : c_obj list -> c_obj list = "_wrap_delete_HaltonRsgQuantLib" ;;
let _delete_HaltonRsg arg = match _delete_HaltonRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SobolRsg_f : c_obj list -> c_obj list = "_wrap_new_SobolRsg__SWIG_0QuantLib" ;;
let _new_SobolRsg arg = match _new_SobolRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SobolRsg_f : c_obj list -> c_obj list = "_wrap_new_SobolRsgQuantLib" ;;
let _new_SobolRsg arg = match _new_SobolRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SobolRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_SobolRsg_nextSequenceQuantLib" ;;
let _SobolRsg_nextSequence arg = match _SobolRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SobolRsg_dimension_f : c_obj list -> c_obj list = "_wrap_SobolRsg_dimensionQuantLib" ;;
let _SobolRsg_dimension arg = match _SobolRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SobolRsg_f : c_obj list -> c_obj list = "_wrap_delete_SobolRsgQuantLib" ;;
let _delete_SobolRsg arg = match _delete_SobolRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LecuyerUniformRsg_f : c_obj list -> c_obj list = "_wrap_new_LecuyerUniformRsgQuantLib" ;;
let _new_LecuyerUniformRsg arg = match _new_LecuyerUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LecuyerUniformRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_LecuyerUniformRsg_nextSequenceQuantLib" ;;
let _LecuyerUniformRsg_nextSequence arg = match _LecuyerUniformRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LecuyerUniformRsg_dimension_f : c_obj list -> c_obj list = "_wrap_LecuyerUniformRsg_dimensionQuantLib" ;;
let _LecuyerUniformRsg_dimension arg = match _LecuyerUniformRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LecuyerUniformRsg_f : c_obj list -> c_obj list = "_wrap_delete_LecuyerUniformRsgQuantLib" ;;
let _delete_LecuyerUniformRsg arg = match _delete_LecuyerUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KnuthUniformRsg_f : c_obj list -> c_obj list = "_wrap_new_KnuthUniformRsgQuantLib" ;;
let _new_KnuthUniformRsg arg = match _new_KnuthUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KnuthUniformRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_KnuthUniformRsg_nextSequenceQuantLib" ;;
let _KnuthUniformRsg_nextSequence arg = match _KnuthUniformRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KnuthUniformRsg_dimension_f : c_obj list -> c_obj list = "_wrap_KnuthUniformRsg_dimensionQuantLib" ;;
let _KnuthUniformRsg_dimension arg = match _KnuthUniformRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KnuthUniformRsg_f : c_obj list -> c_obj list = "_wrap_delete_KnuthUniformRsgQuantLib" ;;
let _delete_KnuthUniformRsg arg = match _delete_KnuthUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MersenneTwisterUniformRsg_f : c_obj list -> c_obj list = "_wrap_new_MersenneTwisterUniformRsgQuantLib" ;;
let _new_MersenneTwisterUniformRsg arg = match _new_MersenneTwisterUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MersenneTwisterUniformRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MersenneTwisterUniformRsg_nextSequenceQuantLib" ;;
let _MersenneTwisterUniformRsg_nextSequence arg = match _MersenneTwisterUniformRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MersenneTwisterUniformRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MersenneTwisterUniformRsg_dimensionQuantLib" ;;
let _MersenneTwisterUniformRsg_dimension arg = match _MersenneTwisterUniformRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MersenneTwisterUniformRsg_f : c_obj list -> c_obj list = "_wrap_delete_MersenneTwisterUniformRsgQuantLib" ;;
let _delete_MersenneTwisterUniformRsg arg = match _delete_MersenneTwisterUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformRandomSequenceGeneratorQuantLib" ;;
let _new_UniformRandomSequenceGenerator arg = match _new_UniformRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformRandomSequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_UniformRandomSequenceGenerator_nextSequenceQuantLib" ;;
let _UniformRandomSequenceGenerator_nextSequence arg = match _UniformRandomSequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformRandomSequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_UniformRandomSequenceGenerator_dimensionQuantLib" ;;
let _UniformRandomSequenceGenerator_dimension arg = match _UniformRandomSequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UniformRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_UniformRandomSequenceGeneratorQuantLib" ;;
let _delete_UniformRandomSequenceGenerator arg = match _delete_UniformRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformLowDiscrepancySequenceGeneratorQuantLib" ;;
let _new_UniformLowDiscrepancySequenceGenerator arg = match _new_UniformLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformLowDiscrepancySequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_UniformLowDiscrepancySequenceGenerator_nextSequenceQuantLib" ;;
let _UniformLowDiscrepancySequenceGenerator_nextSequence arg = match _UniformLowDiscrepancySequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformLowDiscrepancySequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_UniformLowDiscrepancySequenceGenerator_dimensionQuantLib" ;;
let _UniformLowDiscrepancySequenceGenerator_dimension arg = match _UniformLowDiscrepancySequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UniformLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_UniformLowDiscrepancySequenceGeneratorQuantLib" ;;
let _delete_UniformLowDiscrepancySequenceGenerator arg = match _delete_UniformLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeLecuyerGaussianRsg arg = match _new_MoroInvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeLecuyerGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeLecuyerGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeLecuyerGaussianRsg_nextSequence arg = match _MoroInvCumulativeLecuyerGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeLecuyerGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeLecuyerGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeLecuyerGaussianRsg_dimension arg = match _MoroInvCumulativeLecuyerGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeLecuyerGaussianRsg arg = match _delete_MoroInvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeKnuthGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeKnuthGaussianRsg arg = match _new_MoroInvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeKnuthGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeKnuthGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeKnuthGaussianRsg_nextSequence arg = match _MoroInvCumulativeKnuthGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeKnuthGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeKnuthGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeKnuthGaussianRsg_dimension arg = match _MoroInvCumulativeKnuthGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeKnuthGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeKnuthGaussianRsg arg = match _delete_MoroInvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeMersenneTwisterGaussianRsg arg = match _new_MoroInvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence arg = match _MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeMersenneTwisterGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeMersenneTwisterGaussianRsg_dimension arg = match _MoroInvCumulativeMersenneTwisterGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeMersenneTwisterGaussianRsg arg = match _delete_MoroInvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeHaltonGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeHaltonGaussianRsg arg = match _new_MoroInvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeHaltonGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeHaltonGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeHaltonGaussianRsg_nextSequence arg = match _MoroInvCumulativeHaltonGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeHaltonGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeHaltonGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeHaltonGaussianRsg_dimension arg = match _MoroInvCumulativeHaltonGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeHaltonGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeHaltonGaussianRsg arg = match _delete_MoroInvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _new_InvCumulativeLecuyerGaussianRsg arg = match _new_InvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeLecuyerGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeLecuyerGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeLecuyerGaussianRsg_nextSequence arg = match _InvCumulativeLecuyerGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeLecuyerGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeLecuyerGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeLecuyerGaussianRsg_dimension arg = match _InvCumulativeLecuyerGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _delete_InvCumulativeLecuyerGaussianRsg arg = match _delete_InvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeKnuthGaussianRsgQuantLib" ;;
let _new_InvCumulativeKnuthGaussianRsg arg = match _new_InvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeKnuthGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeKnuthGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeKnuthGaussianRsg_nextSequence arg = match _InvCumulativeKnuthGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeKnuthGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeKnuthGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeKnuthGaussianRsg_dimension arg = match _InvCumulativeKnuthGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeKnuthGaussianRsgQuantLib" ;;
let _delete_InvCumulativeKnuthGaussianRsg arg = match _delete_InvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _new_InvCumulativeMersenneTwisterGaussianRsg arg = match _new_InvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeMersenneTwisterGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeMersenneTwisterGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeMersenneTwisterGaussianRsg_nextSequence arg = match _InvCumulativeMersenneTwisterGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeMersenneTwisterGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeMersenneTwisterGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeMersenneTwisterGaussianRsg_dimension arg = match _InvCumulativeMersenneTwisterGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _delete_InvCumulativeMersenneTwisterGaussianRsg arg = match _delete_InvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeHaltonGaussianRsgQuantLib" ;;
let _new_InvCumulativeHaltonGaussianRsg arg = match _new_InvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeHaltonGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeHaltonGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeHaltonGaussianRsg_nextSequence arg = match _InvCumulativeHaltonGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeHaltonGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeHaltonGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeHaltonGaussianRsg_dimension arg = match _InvCumulativeHaltonGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeHaltonGaussianRsgQuantLib" ;;
let _delete_InvCumulativeHaltonGaussianRsg arg = match _delete_InvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianRandomSequenceGeneratorQuantLib" ;;
let _new_GaussianRandomSequenceGenerator arg = match _new_GaussianRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianRandomSequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_GaussianRandomSequenceGenerator_nextSequenceQuantLib" ;;
let _GaussianRandomSequenceGenerator_nextSequence arg = match _GaussianRandomSequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianRandomSequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_GaussianRandomSequenceGenerator_dimensionQuantLib" ;;
let _GaussianRandomSequenceGenerator_dimension arg = match _GaussianRandomSequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianRandomSequenceGeneratorQuantLib" ;;
let _delete_GaussianRandomSequenceGenerator arg = match _delete_GaussianRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianLowDiscrepancySequenceGeneratorQuantLib" ;;
let _new_GaussianLowDiscrepancySequenceGenerator arg = match _new_GaussianLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianLowDiscrepancySequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_GaussianLowDiscrepancySequenceGenerator_nextSequenceQuantLib" ;;
let _GaussianLowDiscrepancySequenceGenerator_nextSequence arg = match _GaussianLowDiscrepancySequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianLowDiscrepancySequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_GaussianLowDiscrepancySequenceGenerator_dimensionQuantLib" ;;
let _GaussianLowDiscrepancySequenceGenerator_dimension arg = match _GaussianLowDiscrepancySequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianLowDiscrepancySequenceGeneratorQuantLib" ;;
let _delete_GaussianLowDiscrepancySequenceGenerator arg = match _delete_GaussianLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _getCovariance_f : c_obj list -> c_obj list = "_wrap_getCovarianceQuantLib" ;;
let _getCovariance arg = match _getCovariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_length_f : c_obj list -> c_obj list = "_wrap_Path_lengthQuantLib" ;;
let _Path_length arg = match _Path_length_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_value_f : c_obj list -> c_obj list = "_wrap_Path_valueQuantLib" ;;
let _Path_value arg = match _Path_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_time_f : c_obj list -> c_obj list = "_wrap_Path_timeQuantLib" ;;
let _Path_time arg = match _Path_time_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Path_f : c_obj list -> c_obj list = "_wrap_delete_PathQuantLib" ;;
let _delete_Path arg = match _delete_Path_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SamplePath_value_f : c_obj list -> c_obj list = "_wrap_SamplePath_valueQuantLib" ;;
let _SamplePath_value arg = match _SamplePath_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SamplePath_weight_f : c_obj list -> c_obj list = "_wrap_SamplePath_weightQuantLib" ;;
let _SamplePath_weight arg = match _SamplePath_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SamplePath_f : c_obj list -> c_obj list = "_wrap_delete_SamplePathQuantLib" ;;
let _delete_SamplePath arg = match _delete_SamplePath_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianPathGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianPathGeneratorQuantLib" ;;
let _new_GaussianPathGenerator arg = match _new_GaussianPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianPathGenerator_next_f : c_obj list -> c_obj list = "_wrap_GaussianPathGenerator_nextQuantLib" ;;
let _GaussianPathGenerator_next arg = match _GaussianPathGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianPathGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianPathGeneratorQuantLib" ;;
let _delete_GaussianPathGenerator arg = match _delete_GaussianPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiPath_pathSize_f : c_obj list -> c_obj list = "_wrap_MultiPath_pathSizeQuantLib" ;;
let _MultiPath_pathSize arg = match _MultiPath_pathSize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiPath_assetNumber_f : c_obj list -> c_obj list = "_wrap_MultiPath_assetNumberQuantLib" ;;
let _MultiPath_assetNumber arg = match _MultiPath_assetNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MultiPath_f : c_obj list -> c_obj list = "_wrap_delete_MultiPathQuantLib" ;;
let _delete_MultiPath arg = match _delete_MultiPath_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleMultiPath_value_f : c_obj list -> c_obj list = "_wrap_SampleMultiPath_valueQuantLib" ;;
let _SampleMultiPath_value arg = match _SampleMultiPath_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleMultiPath_weight_f : c_obj list -> c_obj list = "_wrap_SampleMultiPath_weightQuantLib" ;;
let _SampleMultiPath_weight arg = match _SampleMultiPath_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleMultiPath_f : c_obj list -> c_obj list = "_wrap_delete_SampleMultiPathQuantLib" ;;
let _delete_SampleMultiPath arg = match _delete_SampleMultiPath_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianMultiPathGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianMultiPathGenerator__SWIG_0QuantLib" ;;
let _new_GaussianMultiPathGenerator arg = match _new_GaussianMultiPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianMultiPathGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianMultiPathGeneratorQuantLib" ;;
let _new_GaussianMultiPathGenerator arg = match _new_GaussianMultiPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianMultiPathGenerator_next_f : c_obj list -> c_obj list = "_wrap_GaussianMultiPathGenerator_nextQuantLib" ;;
let _GaussianMultiPathGenerator_next arg = match _GaussianMultiPathGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianMultiPathGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianMultiPathGeneratorQuantLib" ;;
let _delete_GaussianMultiPathGenerator arg = match _delete_GaussianMultiPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoundaryCondition___deref___f : c_obj list -> c_obj list = "_wrap_BoundaryCondition___deref__QuantLib" ;;
let _BoundaryCondition___deref__ arg = match _BoundaryCondition___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoundaryCondition_isNull_f : c_obj list -> c_obj list = "_wrap_BoundaryCondition_isNullQuantLib" ;;
let _BoundaryCondition_isNull arg = match _BoundaryCondition_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoundaryCondition_NoSide : c_obj -> Swig.c_obj = "_wrap_BoundaryCondition_NoSide" 
external _BoundaryCondition_Upper : c_obj -> Swig.c_obj = "_wrap_BoundaryCondition_Upper" 
external _BoundaryCondition_Lower : c_obj -> Swig.c_obj = "_wrap_BoundaryCondition_Lower" 
external _new_BoundaryCondition_f : c_obj list -> c_obj list = "_wrap_new_BoundaryConditionQuantLib" ;;
let _new_BoundaryCondition arg = match _new_BoundaryCondition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoundaryCondition_f : c_obj list -> c_obj list = "_wrap_delete_BoundaryConditionQuantLib" ;;
let _delete_BoundaryCondition arg = match _delete_BoundaryCondition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NeumannBC_f : c_obj list -> c_obj list = "_wrap_new_NeumannBCQuantLib" ;;
let _new_NeumannBC arg = match _new_NeumannBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NeumannBC_f : c_obj list -> c_obj list = "_wrap_delete_NeumannBCQuantLib" ;;
let _delete_NeumannBC arg = match _delete_NeumannBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DirichletBC_f : c_obj list -> c_obj list = "_wrap_new_DirichletBCQuantLib" ;;
let _new_DirichletBC arg = match _new_DirichletBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DirichletBC_f : c_obj list -> c_obj list = "_wrap_delete_DirichletBCQuantLib" ;;
let _delete_DirichletBC arg = match _delete_DirichletBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TridiagonalOperator_f : c_obj list -> c_obj list = "_wrap_new_TridiagonalOperatorQuantLib" ;;
let _new_TridiagonalOperator arg = match _new_TridiagonalOperator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_solveFor_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_solveForQuantLib" ;;
let _TridiagonalOperator_solveFor arg = match _TridiagonalOperator_solveFor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_applyTo_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_applyToQuantLib" ;;
let _TridiagonalOperator_applyTo arg = match _TridiagonalOperator_applyTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_size_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_sizeQuantLib" ;;
let _TridiagonalOperator_size arg = match _TridiagonalOperator_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setFirstRow_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setFirstRowQuantLib" ;;
let _TridiagonalOperator_setFirstRow arg = match _TridiagonalOperator_setFirstRow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setMidRow_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setMidRowQuantLib" ;;
let _TridiagonalOperator_setMidRow arg = match _TridiagonalOperator_setMidRow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setMidRows_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setMidRowsQuantLib" ;;
let _TridiagonalOperator_setMidRows arg = match _TridiagonalOperator_setMidRows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setLastRow_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setLastRowQuantLib" ;;
let _TridiagonalOperator_setLastRow arg = match _TridiagonalOperator_setLastRow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_identity_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_identityQuantLib" ;;
let _TridiagonalOperator_identity arg = match _TridiagonalOperator_identity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TridiagonalOperator_f : c_obj list -> c_obj list = "_wrap_delete_TridiagonalOperatorQuantLib" ;;
let _delete_TridiagonalOperator arg = match _delete_TridiagonalOperator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DPlus_f : c_obj list -> c_obj list = "_wrap_new_DPlusQuantLib" ;;
let _new_DPlus arg = match _new_DPlus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DPlus_f : c_obj list -> c_obj list = "_wrap_delete_DPlusQuantLib" ;;
let _delete_DPlus arg = match _delete_DPlus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DMinus_f : c_obj list -> c_obj list = "_wrap_new_DMinusQuantLib" ;;
let _new_DMinus arg = match _new_DMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DMinus_f : c_obj list -> c_obj list = "_wrap_delete_DMinusQuantLib" ;;
let _delete_DMinus arg = match _delete_DMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DZero_f : c_obj list -> c_obj list = "_wrap_new_DZeroQuantLib" ;;
let _new_DZero arg = match _new_DZero_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DZero_f : c_obj list -> c_obj list = "_wrap_delete_DZeroQuantLib" ;;
let _delete_DZero arg = match _delete_DZero_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DPlusDMinus_f : c_obj list -> c_obj list = "_wrap_new_DPlusDMinusQuantLib" ;;
let _new_DPlusDMinus arg = match _new_DPlusDMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DPlusDMinus_f : c_obj list -> c_obj list = "_wrap_delete_DPlusDMinusQuantLib" ;;
let _delete_DPlusDMinus arg = match _delete_DPlusDMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Brent_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Brent_setMaxEvaluationsQuantLib" ;;
let _Brent_setMaxEvaluations arg = match _Brent_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Brent_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Brent_setLowerBoundQuantLib" ;;
let _Brent_setLowerBound arg = match _Brent_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Brent_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Brent_setUpperBoundQuantLib" ;;
let _Brent_setUpperBound arg = match _Brent_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Brent_f : c_obj list -> c_obj list = "_wrap_new_BrentQuantLib" ;;
let _new_Brent arg = match _new_Brent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Brent_f : c_obj list -> c_obj list = "_wrap_delete_BrentQuantLib" ;;
let _delete_Brent arg = match _delete_Brent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bisection_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Bisection_setMaxEvaluationsQuantLib" ;;
let _Bisection_setMaxEvaluations arg = match _Bisection_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bisection_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Bisection_setLowerBoundQuantLib" ;;
let _Bisection_setLowerBound arg = match _Bisection_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bisection_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Bisection_setUpperBoundQuantLib" ;;
let _Bisection_setUpperBound arg = match _Bisection_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Bisection_f : c_obj list -> c_obj list = "_wrap_new_BisectionQuantLib" ;;
let _new_Bisection arg = match _new_Bisection_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Bisection_f : c_obj list -> c_obj list = "_wrap_delete_BisectionQuantLib" ;;
let _delete_Bisection arg = match _delete_Bisection_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FalsePosition_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_FalsePosition_setMaxEvaluationsQuantLib" ;;
let _FalsePosition_setMaxEvaluations arg = match _FalsePosition_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FalsePosition_setLowerBound_f : c_obj list -> c_obj list = "_wrap_FalsePosition_setLowerBoundQuantLib" ;;
let _FalsePosition_setLowerBound arg = match _FalsePosition_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FalsePosition_setUpperBound_f : c_obj list -> c_obj list = "_wrap_FalsePosition_setUpperBoundQuantLib" ;;
let _FalsePosition_setUpperBound arg = match _FalsePosition_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FalsePosition_f : c_obj list -> c_obj list = "_wrap_new_FalsePositionQuantLib" ;;
let _new_FalsePosition arg = match _new_FalsePosition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FalsePosition_f : c_obj list -> c_obj list = "_wrap_delete_FalsePositionQuantLib" ;;
let _delete_FalsePosition arg = match _delete_FalsePosition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Ridder_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Ridder_setMaxEvaluationsQuantLib" ;;
let _Ridder_setMaxEvaluations arg = match _Ridder_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Ridder_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Ridder_setLowerBoundQuantLib" ;;
let _Ridder_setLowerBound arg = match _Ridder_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Ridder_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Ridder_setUpperBoundQuantLib" ;;
let _Ridder_setUpperBound arg = match _Ridder_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Ridder_f : c_obj list -> c_obj list = "_wrap_new_RidderQuantLib" ;;
let _new_Ridder arg = match _new_Ridder_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Ridder_f : c_obj list -> c_obj list = "_wrap_delete_RidderQuantLib" ;;
let _delete_Ridder arg = match _delete_Ridder_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Secant_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Secant_setMaxEvaluationsQuantLib" ;;
let _Secant_setMaxEvaluations arg = match _Secant_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Secant_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Secant_setLowerBoundQuantLib" ;;
let _Secant_setLowerBound arg = match _Secant_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Secant_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Secant_setUpperBoundQuantLib" ;;
let _Secant_setUpperBound arg = match _Secant_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Secant_f : c_obj list -> c_obj list = "_wrap_new_SecantQuantLib" ;;
let _new_Secant arg = match _new_Secant_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Secant_f : c_obj list -> c_obj list = "_wrap_delete_SecantQuantLib" ;;
let _delete_Secant arg = match _delete_Secant_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Constraint_f : c_obj list -> c_obj list = "_wrap_delete_ConstraintQuantLib" ;;
let _delete_Constraint arg = match _delete_Constraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoundaryConstraint_f : c_obj list -> c_obj list = "_wrap_new_BoundaryConstraintQuantLib" ;;
let _new_BoundaryConstraint arg = match _new_BoundaryConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoundaryConstraint_f : c_obj list -> c_obj list = "_wrap_delete_BoundaryConstraintQuantLib" ;;
let _delete_BoundaryConstraint arg = match _delete_BoundaryConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NoConstraint_f : c_obj list -> c_obj list = "_wrap_new_NoConstraintQuantLib" ;;
let _new_NoConstraint arg = match _new_NoConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NoConstraint_f : c_obj list -> c_obj list = "_wrap_delete_NoConstraintQuantLib" ;;
let _delete_NoConstraint arg = match _delete_NoConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PositiveConstraint_f : c_obj list -> c_obj list = "_wrap_new_PositiveConstraintQuantLib" ;;
let _new_PositiveConstraint arg = match _new_PositiveConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PositiveConstraint_f : c_obj list -> c_obj list = "_wrap_delete_PositiveConstraintQuantLib" ;;
let _delete_PositiveConstraint arg = match _delete_PositiveConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "EndCriteria::Type_marker" (`Type)
external _MaxIterations : c_obj -> Swig.c_obj = "_wrap_MaxIterations" 
external _StationaryPoint : c_obj -> Swig.c_obj = "_wrap_StationaryPoint" 
external _StationaryFunctionValue : c_obj -> Swig.c_obj = "_wrap_StationaryFunctionValue" 
external _StationaryFunctionAccuracy : c_obj -> Swig.c_obj = "_wrap_StationaryFunctionAccuracy" 
external _ZeroGradientNorm : c_obj -> Swig.c_obj = "_wrap_ZeroGradientNorm" 
external _Unknown : c_obj -> Swig.c_obj = "_wrap_Unknown" 
external _new_EndCriteria_f : c_obj list -> c_obj list = "_wrap_new_EndCriteriaQuantLib" ;;
let _new_EndCriteria arg = match _new_EndCriteria_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _EndCriteria_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_EndCriteria_operator_pP___QuantLib" ;;
let _EndCriteria_operator_xx_xx_lparen_xx_rparen arg = match _EndCriteria_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EndCriteria_f : c_obj list -> c_obj list = "_wrap_delete_EndCriteriaQuantLib" ;;
let _delete_EndCriteria arg = match _delete_EndCriteria_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_OptimizationMethod_f : c_obj list -> c_obj list = "_wrap_delete_OptimizationMethodQuantLib" ;;
let _delete_OptimizationMethod arg = match _delete_OptimizationMethod_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConjugateGradient_f : c_obj list -> c_obj list = "_wrap_new_ConjugateGradientQuantLib" ;;
let _new_ConjugateGradient arg = match _new_ConjugateGradient_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConjugateGradient_f : c_obj list -> c_obj list = "_wrap_delete_ConjugateGradientQuantLib" ;;
let _delete_ConjugateGradient arg = match _delete_ConjugateGradient_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Simplex_f : c_obj list -> c_obj list = "_wrap_new_SimplexQuantLib" ;;
let _new_Simplex arg = match _new_Simplex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Simplex_f : c_obj list -> c_obj list = "_wrap_delete_SimplexQuantLib" ;;
let _delete_Simplex arg = match _delete_Simplex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SteepestDescent_f : c_obj list -> c_obj list = "_wrap_new_SteepestDescentQuantLib" ;;
let _new_SteepestDescent arg = match _new_SteepestDescent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SteepestDescent_f : c_obj list -> c_obj list = "_wrap_delete_SteepestDescentQuantLib" ;;
let _delete_SteepestDescent arg = match _delete_SteepestDescent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Optimizer_f : c_obj list -> c_obj list = "_wrap_new_OptimizerQuantLib" ;;
let _new_Optimizer arg = match _new_Optimizer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Optimizer_f : c_obj list -> c_obj list = "_wrap_delete_OptimizerQuantLib" ;;
let _delete_Optimizer arg = match _delete_Optimizer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelper___deref___f : c_obj list -> c_obj list = "_wrap_RateHelper___deref__QuantLib" ;;
let _RateHelper___deref__ arg = match _RateHelper___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelper_isNull_f : c_obj list -> c_obj list = "_wrap_RateHelper_isNullQuantLib" ;;
let _RateHelper_isNull arg = match _RateHelper_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelper_f : c_obj list -> c_obj list = "_wrap_new_RateHelperQuantLib" ;;
let _new_RateHelper arg = match _new_RateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RateHelper_f : c_obj list -> c_obj list = "_wrap_delete_RateHelperQuantLib" ;;
let _delete_RateHelper arg = match _delete_RateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DepositRateHelper_f : c_obj list -> c_obj list = "_wrap_new_DepositRateHelper__SWIG_0QuantLib" ;;
let _new_DepositRateHelper arg = match _new_DepositRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DepositRateHelper_f : c_obj list -> c_obj list = "_wrap_new_DepositRateHelperQuantLib" ;;
let _new_DepositRateHelper arg = match _new_DepositRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DepositRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_DepositRateHelperQuantLib" ;;
let _delete_DepositRateHelper arg = match _delete_DepositRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FraRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FraRateHelper__SWIG_0QuantLib" ;;
let _new_FraRateHelper arg = match _new_FraRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FraRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FraRateHelperQuantLib" ;;
let _new_FraRateHelper arg = match _new_FraRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FraRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_FraRateHelperQuantLib" ;;
let _delete_FraRateHelper arg = match _delete_FraRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelper__SWIG_0QuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelper__SWIG_1QuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelper__SWIG_2QuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelper__SWIG_3QuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelperQuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_FuturesRateHelperQuantLib" ;;
let _delete_FuturesRateHelper arg = match _delete_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelper__SWIG_0QuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelperQuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_SwapRateHelperQuantLib" ;;
let _delete_SwapRateHelper arg = match _delete_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedCouponBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedCouponBondHelper__SWIG_0QuantLib" ;;
let _new_FixedCouponBondHelper arg = match _new_FixedCouponBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedCouponBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedCouponBondHelper__SWIG_1QuantLib" ;;
let _new_FixedCouponBondHelper arg = match _new_FixedCouponBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedCouponBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedCouponBondHelper__SWIG_2QuantLib" ;;
let _new_FixedCouponBondHelper arg = match _new_FixedCouponBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedCouponBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedCouponBondHelperQuantLib" ;;
let _new_FixedCouponBondHelper arg = match _new_FixedCouponBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedCouponBondHelper_f : c_obj list -> c_obj list = "_wrap_delete_FixedCouponBondHelperQuantLib" ;;
let _delete_FixedCouponBondHelper arg = match _delete_FixedCouponBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVector__SWIG_0QuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVector__SWIG_1QuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVector__SWIG_2QuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVectorQuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_size_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_sizeQuantLib" ;;
let _RateHelperVector_size arg = match _RateHelperVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_empty_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_emptyQuantLib" ;;
let _RateHelperVector_empty arg = match _RateHelperVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_clear_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_clearQuantLib" ;;
let _RateHelperVector_clear arg = match _RateHelperVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_push_back_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_push_backQuantLib" ;;
let _RateHelperVector_push_back arg = match _RateHelperVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_operator_bB___QuantLib" ;;
let _RateHelperVector_operator_xx_xx_lbrace_xx_rbrace arg = match _RateHelperVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_operator_e___QuantLib" ;;
let _RateHelperVector_operator_xx_xx_equals arg = match _RateHelperVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_set_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_setQuantLib" ;;
let _RateHelperVector_set arg = match _RateHelperVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_to_array_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_to_arrayQuantLib" ;;
let _RateHelperVector_to_array arg = match _RateHelperVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_delete_RateHelperVectorQuantLib" ;;
let _delete_RateHelperVector arg = match _delete_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Discount_f : c_obj list -> c_obj list = "_wrap_new_DiscountQuantLib" ;;
let _new_Discount arg = match _new_Discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Discount_f : c_obj list -> c_obj list = "_wrap_delete_DiscountQuantLib" ;;
let _delete_Discount arg = match _delete_Discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroYield_f : c_obj list -> c_obj list = "_wrap_new_ZeroYieldQuantLib" ;;
let _new_ZeroYield arg = match _new_ZeroYield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroYield_f : c_obj list -> c_obj list = "_wrap_delete_ZeroYieldQuantLib" ;;
let _delete_ZeroYield arg = match _delete_ZeroYield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardRate_f : c_obj list -> c_obj list = "_wrap_new_ForwardRateQuantLib" ;;
let _new_ForwardRate arg = match _new_ForwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardRate_f : c_obj list -> c_obj list = "_wrap_delete_ForwardRateQuantLib" ;;
let _delete_ForwardRate arg = match _delete_ForwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_0QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_1QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_2QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_3QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_4QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForwardQuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatForward_dates_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatForward_datesQuantLib" ;;
let _PiecewiseFlatForward_dates arg = match _PiecewiseFlatForward_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatForward_times_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatForward_timesQuantLib" ;;
let _PiecewiseFlatForward_times arg = match _PiecewiseFlatForward_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatForward_nodes_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatForward_nodesQuantLib" ;;
let _PiecewiseFlatForward_nodes arg = match _PiecewiseFlatForward_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_delete_PiecewiseFlatForwardQuantLib" ;;
let _delete_PiecewiseFlatForward arg = match _delete_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SampledCurve_f : c_obj list -> c_obj list = "_wrap_new_SampledCurve__SWIG_0QuantLib" ;;
let _new_SampledCurve arg = match _new_SampledCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SampledCurve_f : c_obj list -> c_obj list = "_wrap_new_SampledCurveQuantLib" ;;
let _new_SampledCurve arg = match _new_SampledCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_grid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_gridQuantLib" ;;
let _SampledCurve_grid arg = match _SampledCurve_grid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_values_f : c_obj list -> c_obj list = "_wrap_SampledCurve_valuesQuantLib" ;;
let _SampledCurve_values arg = match _SampledCurve_values_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_gridValue_f : c_obj list -> c_obj list = "_wrap_SampledCurve_gridValueQuantLib" ;;
let _SampledCurve_gridValue arg = match _SampledCurve_gridValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_value_f : c_obj list -> c_obj list = "_wrap_SampledCurve_valueQuantLib" ;;
let _SampledCurve_value arg = match _SampledCurve_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_size_f : c_obj list -> c_obj list = "_wrap_SampledCurve_sizeQuantLib" ;;
let _SampledCurve_size arg = match _SampledCurve_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_empty_f : c_obj list -> c_obj list = "_wrap_SampledCurve_emptyQuantLib" ;;
let _SampledCurve_empty arg = match _SampledCurve_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_setGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_setGridQuantLib" ;;
let _SampledCurve_setGrid arg = match _SampledCurve_setGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_setValues_f : c_obj list -> c_obj list = "_wrap_SampledCurve_setValuesQuantLib" ;;
let _SampledCurve_setValues arg = match _SampledCurve_setValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_swap_f : c_obj list -> c_obj list = "_wrap_SampledCurve_swapQuantLib" ;;
let _SampledCurve_swap arg = match _SampledCurve_swap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_setLogGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_setLogGridQuantLib" ;;
let _SampledCurve_setLogGrid arg = match _SampledCurve_setLogGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_regridLogGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_regridLogGridQuantLib" ;;
let _SampledCurve_regridLogGrid arg = match _SampledCurve_regridLogGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_shiftGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_shiftGridQuantLib" ;;
let _SampledCurve_shiftGrid arg = match _SampledCurve_shiftGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_scaleGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_scaleGridQuantLib" ;;
let _SampledCurve_scaleGrid arg = match _SampledCurve_scaleGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_regrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_regridQuantLib" ;;
let _SampledCurve_regrid arg = match _SampledCurve_regrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampledCurve_f : c_obj list -> c_obj list = "_wrap_delete_SampledCurveQuantLib" ;;
let _delete_SampledCurve arg = match _delete_SampledCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_instance_f : c_obj list -> c_obj list = "_wrap_Settings_instanceQuantLib" ;;
let _Settings_instance arg = match _Settings_instance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_getEvaluationDate_f : c_obj list -> c_obj list = "_wrap_Settings_getEvaluationDateQuantLib" ;;
let _Settings_getEvaluationDate arg = match _Settings_getEvaluationDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_setEvaluationDate_f : c_obj list -> c_obj list = "_wrap_Settings_setEvaluationDateQuantLib" ;;
let _Settings_setEvaluationDate arg = match _Settings_setEvaluationDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Settings_f : c_obj list -> c_obj list = "_wrap_delete_SettingsQuantLib" ;;
let _delete_Settings arg = match _delete_Settings_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper___deref___f : c_obj list -> c_obj list = "_wrap_CalibrationHelper___deref__QuantLib" ;;
let _CalibrationHelper___deref__ arg = match _CalibrationHelper___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_isNull_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_isNullQuantLib" ;;
let _CalibrationHelper_isNull arg = match _CalibrationHelper_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelper_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperQuantLib" ;;
let _new_CalibrationHelper arg = match _new_CalibrationHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CalibrationHelper_f : c_obj list -> c_obj list = "_wrap_delete_CalibrationHelperQuantLib" ;;
let _delete_CalibrationHelper arg = match _delete_CalibrationHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_setPricingEngine_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_setPricingEngineQuantLib" ;;
let _CalibrationHelper_setPricingEngine arg = match _CalibrationHelper_setPricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_marketValue_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_marketValueQuantLib" ;;
let _CalibrationHelper_marketValue arg = match _CalibrationHelper_marketValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_modelValue_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_modelValueQuantLib" ;;
let _CalibrationHelper_modelValue arg = match _CalibrationHelper_modelValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_impliedVolatilityQuantLib" ;;
let _CalibrationHelper_impliedVolatility arg = match _CalibrationHelper_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_blackPrice_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_blackPriceQuantLib" ;;
let _CalibrationHelper_blackPrice arg = match _CalibrationHelper_blackPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionHelper_f : c_obj list -> c_obj list = "_wrap_new_SwaptionHelper__SWIG_0QuantLib" ;;
let _new_SwaptionHelper arg = match _new_SwaptionHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionHelper_f : c_obj list -> c_obj list = "_wrap_new_SwaptionHelperQuantLib" ;;
let _new_SwaptionHelper arg = match _new_SwaptionHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionHelper_times_f : c_obj list -> c_obj list = "_wrap_SwaptionHelper_timesQuantLib" ;;
let _SwaptionHelper_times arg = match _SwaptionHelper_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionHelper_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionHelperQuantLib" ;;
let _delete_SwaptionHelper arg = match _delete_SwaptionHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapHelper_f : c_obj list -> c_obj list = "_wrap_new_CapHelperQuantLib" ;;
let _new_CapHelper arg = match _new_CapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapHelper_times_f : c_obj list -> c_obj list = "_wrap_CapHelper_timesQuantLib" ;;
let _CapHelper_times arg = match _CapHelper_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapHelper_f : c_obj list -> c_obj list = "_wrap_delete_CapHelperQuantLib" ;;
let _delete_CapHelper arg = match _delete_CapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVector__SWIG_0QuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVector__SWIG_1QuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVector__SWIG_2QuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVectorQuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_size_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_sizeQuantLib" ;;
let _CalibrationHelperVector_size arg = match _CalibrationHelperVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_empty_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_emptyQuantLib" ;;
let _CalibrationHelperVector_empty arg = match _CalibrationHelperVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_clear_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_clearQuantLib" ;;
let _CalibrationHelperVector_clear arg = match _CalibrationHelperVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_push_back_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_push_backQuantLib" ;;
let _CalibrationHelperVector_push_back arg = match _CalibrationHelperVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_operator_bB___QuantLib" ;;
let _CalibrationHelperVector_operator_xx_xx_lbrace_xx_rbrace arg = match _CalibrationHelperVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_operator_e___QuantLib" ;;
let _CalibrationHelperVector_operator_xx_xx_equals arg = match _CalibrationHelperVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_set_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_setQuantLib" ;;
let _CalibrationHelperVector_set arg = match _CalibrationHelperVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_to_array_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_to_arrayQuantLib" ;;
let _CalibrationHelperVector_to_array arg = match _CalibrationHelperVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_delete_CalibrationHelperVectorQuantLib" ;;
let _delete_CalibrationHelperVector arg = match _delete_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel___deref___f : c_obj list -> c_obj list = "_wrap_ShortRateModel___deref__QuantLib" ;;
let _ShortRateModel___deref__ arg = match _ShortRateModel___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_isNull_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_isNullQuantLib" ;;
let _ShortRateModel_isNull arg = match _ShortRateModel_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_asObservable_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_asObservableQuantLib" ;;
let _ShortRateModel_asObservable arg = match _ShortRateModel_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ShortRateModel_f : c_obj list -> c_obj list = "_wrap_new_ShortRateModelQuantLib" ;;
let _new_ShortRateModel arg = match _new_ShortRateModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ShortRateModel_f : c_obj list -> c_obj list = "_wrap_delete_ShortRateModelQuantLib" ;;
let _delete_ShortRateModel arg = match _delete_ShortRateModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_params_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_paramsQuantLib" ;;
let _ShortRateModel_params arg = match _ShortRateModel_params_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_calibrate_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_calibrate__SWIG_0QuantLib" ;;
let _ShortRateModel_calibrate arg = match _ShortRateModel_calibrate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_calibrate_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_calibrate__SWIG_1QuantLib" ;;
let _ShortRateModel_calibrate arg = match _ShortRateModel_calibrate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_calibrate_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_calibrateQuantLib" ;;
let _ShortRateModel_calibrate arg = match _ShortRateModel_calibrate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HullWhite_f : c_obj list -> c_obj list = "_wrap_new_HullWhite__SWIG_0QuantLib" ;;
let _new_HullWhite arg = match _new_HullWhite_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HullWhite_f : c_obj list -> c_obj list = "_wrap_new_HullWhite__SWIG_1QuantLib" ;;
let _new_HullWhite arg = match _new_HullWhite_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HullWhite_f : c_obj list -> c_obj list = "_wrap_new_HullWhiteQuantLib" ;;
let _new_HullWhite arg = match _new_HullWhite_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HullWhite_f : c_obj list -> c_obj list = "_wrap_delete_HullWhiteQuantLib" ;;
let _delete_HullWhite arg = match _delete_HullWhite_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackKarasinski_f : c_obj list -> c_obj list = "_wrap_new_BlackKarasinski__SWIG_0QuantLib" ;;
let _new_BlackKarasinski arg = match _new_BlackKarasinski_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackKarasinski_f : c_obj list -> c_obj list = "_wrap_new_BlackKarasinski__SWIG_1QuantLib" ;;
let _new_BlackKarasinski arg = match _new_BlackKarasinski_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackKarasinski_f : c_obj list -> c_obj list = "_wrap_new_BlackKarasinskiQuantLib" ;;
let _new_BlackKarasinski arg = match _new_BlackKarasinski_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackKarasinski_f : c_obj list -> c_obj list = "_wrap_delete_BlackKarasinskiQuantLib" ;;
let _delete_BlackKarasinski arg = match _delete_BlackKarasinski_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_G2_f : c_obj list -> c_obj list = "_wrap_new_G2__SWIG_0QuantLib" ;;
let _new_G2 arg = match _new_G2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_G2_f : c_obj list -> c_obj list = "_wrap_new_G2__SWIG_1QuantLib" ;;
let _new_G2 arg = match _new_G2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_G2_f : c_obj list -> c_obj list = "_wrap_new_G2__SWIG_2QuantLib" ;;
let _new_G2 arg = match _new_G2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_G2_f : c_obj list -> c_obj list = "_wrap_new_G2__SWIG_3QuantLib" ;;
let _new_G2 arg = match _new_G2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_G2_f : c_obj list -> c_obj list = "_wrap_new_G2__SWIG_4QuantLib" ;;
let _new_G2 arg = match _new_G2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_G2_f : c_obj list -> c_obj list = "_wrap_new_G2QuantLib" ;;
let _new_G2 arg = match _new_G2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_G2_f : c_obj list -> c_obj list = "_wrap_delete_G2QuantLib" ;;
let _delete_G2 arg = match _delete_G2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JamshidianSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_new_JamshidianSwaptionEngineQuantLib" ;;
let _new_JamshidianSwaptionEngine arg = match _new_JamshidianSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_JamshidianSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_delete_JamshidianSwaptionEngineQuantLib" ;;
let _delete_JamshidianSwaptionEngine arg = match _delete_JamshidianSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TreeSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_new_TreeSwaptionEngine__SWIG_0QuantLib" ;;
let _new_TreeSwaptionEngine arg = match _new_TreeSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TreeSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_new_TreeSwaptionEngineQuantLib" ;;
let _new_TreeSwaptionEngine arg = match _new_TreeSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TreeSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_delete_TreeSwaptionEngineQuantLib" ;;
let _delete_TreeSwaptionEngine arg = match _delete_TreeSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticCapFloorEngineQuantLib" ;;
let _new_AnalyticCapFloorEngine arg = match _new_AnalyticCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticCapFloorEngineQuantLib" ;;
let _delete_AnalyticCapFloorEngine arg = match _delete_AnalyticCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TreeCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_new_TreeCapFloorEngine__SWIG_0QuantLib" ;;
let _new_TreeCapFloorEngine arg = match _new_TreeCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TreeCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_new_TreeCapFloorEngineQuantLib" ;;
let _new_TreeCapFloorEngine arg = match _new_TreeCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TreeCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_delete_TreeCapFloorEngineQuantLib" ;;
let _delete_TreeCapFloorEngine arg = match _delete_TreeCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_G2SwaptionEngine_f : c_obj list -> c_obj list = "_wrap_new_G2SwaptionEngineQuantLib" ;;
let _new_G2SwaptionEngine arg = match _new_G2SwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_G2SwaptionEngine_f : c_obj list -> c_obj list = "_wrap_delete_G2SwaptionEngineQuantLib" ;;
let _delete_G2SwaptionEngine arg = match _delete_G2SwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_samples_f : c_obj list -> c_obj list = "_wrap_Statistics_samplesQuantLib" ;;
let _Statistics_samples arg = match _Statistics_samples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_weightSum_f : c_obj list -> c_obj list = "_wrap_Statistics_weightSumQuantLib" ;;
let _Statistics_weightSum arg = match _Statistics_weightSum_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_mean_f : c_obj list -> c_obj list = "_wrap_Statistics_meanQuantLib" ;;
let _Statistics_mean arg = match _Statistics_mean_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_variance_f : c_obj list -> c_obj list = "_wrap_Statistics_varianceQuantLib" ;;
let _Statistics_variance arg = match _Statistics_variance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_standardDeviation_f : c_obj list -> c_obj list = "_wrap_Statistics_standardDeviationQuantLib" ;;
let _Statistics_standardDeviation arg = match _Statistics_standardDeviation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_errorEstimate_f : c_obj list -> c_obj list = "_wrap_Statistics_errorEstimateQuantLib" ;;
let _Statistics_errorEstimate arg = match _Statistics_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_skewness_f : c_obj list -> c_obj list = "_wrap_Statistics_skewnessQuantLib" ;;
let _Statistics_skewness arg = match _Statistics_skewness_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_kurtosis_f : c_obj list -> c_obj list = "_wrap_Statistics_kurtosisQuantLib" ;;
let _Statistics_kurtosis arg = match _Statistics_kurtosis_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_min_f : c_obj list -> c_obj list = "_wrap_Statistics_minQuantLib" ;;
let _Statistics_min arg = match _Statistics_min_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_max_f : c_obj list -> c_obj list = "_wrap_Statistics_maxQuantLib" ;;
let _Statistics_max arg = match _Statistics_max_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_reset_f : c_obj list -> c_obj list = "_wrap_Statistics_resetQuantLib" ;;
let _Statistics_reset arg = match _Statistics_reset_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_add_f : c_obj list -> c_obj list = "_wrap_Statistics_add__SWIG_0QuantLib" ;;
let _Statistics_add arg = match _Statistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_add_f : c_obj list -> c_obj list = "_wrap_Statistics_add__SWIG_1QuantLib" ;;
let _Statistics_add arg = match _Statistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_add_f : c_obj list -> c_obj list = "_wrap_Statistics_add__SWIG_2QuantLib" ;;
let _Statistics_add arg = match _Statistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Statistics_add_f : c_obj list -> c_obj list = "_wrap_Statistics_addQuantLib" ;;
let _Statistics_add arg = match _Statistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Statistics_f : c_obj list -> c_obj list = "_wrap_new_StatisticsQuantLib" ;;
let _new_Statistics arg = match _new_Statistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Statistics_f : c_obj list -> c_obj list = "_wrap_delete_StatisticsQuantLib" ;;
let _delete_Statistics arg = match _delete_Statistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_semiVariance_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_semiVarianceQuantLib" ;;
let _RiskStatistics_semiVariance arg = match _RiskStatistics_semiVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_semiDeviation_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_semiDeviationQuantLib" ;;
let _RiskStatistics_semiDeviation arg = match _RiskStatistics_semiDeviation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_downsideVariance_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_downsideVarianceQuantLib" ;;
let _RiskStatistics_downsideVariance arg = match _RiskStatistics_downsideVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_downsideDeviation_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_downsideDeviationQuantLib" ;;
let _RiskStatistics_downsideDeviation arg = match _RiskStatistics_downsideDeviation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_regret_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_regretQuantLib" ;;
let _RiskStatistics_regret arg = match _RiskStatistics_regret_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_potentialUpside_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_potentialUpsideQuantLib" ;;
let _RiskStatistics_potentialUpside arg = match _RiskStatistics_potentialUpside_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_valueAtRisk_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_valueAtRiskQuantLib" ;;
let _RiskStatistics_valueAtRisk arg = match _RiskStatistics_valueAtRisk_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_expectedShortfall_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_expectedShortfallQuantLib" ;;
let _RiskStatistics_expectedShortfall arg = match _RiskStatistics_expectedShortfall_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_shortfall_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_shortfallQuantLib" ;;
let _RiskStatistics_shortfall arg = match _RiskStatistics_shortfall_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RiskStatistics_averageShortfall_f : c_obj list -> c_obj list = "_wrap_RiskStatistics_averageShortfallQuantLib" ;;
let _RiskStatistics_averageShortfall arg = match _RiskStatistics_averageShortfall_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RiskStatistics_f : c_obj list -> c_obj list = "_wrap_new_RiskStatisticsQuantLib" ;;
let _new_RiskStatistics arg = match _new_RiskStatistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RiskStatistics_f : c_obj list -> c_obj list = "_wrap_delete_RiskStatisticsQuantLib" ;;
let _delete_RiskStatistics arg = match _delete_RiskStatistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MultipleStatistics_f : c_obj list -> c_obj list = "_wrap_new_MultipleStatisticsQuantLib" ;;
let _new_MultipleStatistics arg = match _new_MultipleStatistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_size_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_sizeQuantLib" ;;
let _MultipleStatistics_size arg = match _MultipleStatistics_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_samples_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_samplesQuantLib" ;;
let _MultipleStatistics_samples arg = match _MultipleStatistics_samples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_weightSum_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_weightSumQuantLib" ;;
let _MultipleStatistics_weightSum arg = match _MultipleStatistics_weightSum_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_mean_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_meanQuantLib" ;;
let _MultipleStatistics_mean arg = match _MultipleStatistics_mean_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_variance_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_varianceQuantLib" ;;
let _MultipleStatistics_variance arg = match _MultipleStatistics_variance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_standardDeviation_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_standardDeviationQuantLib" ;;
let _MultipleStatistics_standardDeviation arg = match _MultipleStatistics_standardDeviation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_errorEstimate_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_errorEstimateQuantLib" ;;
let _MultipleStatistics_errorEstimate arg = match _MultipleStatistics_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_skewness_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_skewnessQuantLib" ;;
let _MultipleStatistics_skewness arg = match _MultipleStatistics_skewness_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_kurtosis_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_kurtosisQuantLib" ;;
let _MultipleStatistics_kurtosis arg = match _MultipleStatistics_kurtosis_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_min_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_minQuantLib" ;;
let _MultipleStatistics_min arg = match _MultipleStatistics_min_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_max_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_maxQuantLib" ;;
let _MultipleStatistics_max arg = match _MultipleStatistics_max_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_covariance_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_covarianceQuantLib" ;;
let _MultipleStatistics_covariance arg = match _MultipleStatistics_covariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_correlation_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_correlationQuantLib" ;;
let _MultipleStatistics_correlation arg = match _MultipleStatistics_correlation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_reset_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_resetQuantLib" ;;
let _MultipleStatistics_reset arg = match _MultipleStatistics_reset_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_add_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_add__SWIG_0QuantLib" ;;
let _MultipleStatistics_add arg = match _MultipleStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_add_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_add__SWIG_1QuantLib" ;;
let _MultipleStatistics_add arg = match _MultipleStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_add_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_add__SWIG_2QuantLib" ;;
let _MultipleStatistics_add arg = match _MultipleStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultipleStatistics_add_f : c_obj list -> c_obj list = "_wrap_MultipleStatistics_addQuantLib" ;;
let _MultipleStatistics_add arg = match _MultipleStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MultipleStatistics_f : c_obj list -> c_obj list = "_wrap_delete_MultipleStatisticsQuantLib" ;;
let _delete_MultipleStatistics arg = match _delete_MultipleStatistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SequenceStatistics_f : c_obj list -> c_obj list = "_wrap_new_SequenceStatisticsQuantLib" ;;
let _new_SequenceStatistics arg = match _new_SequenceStatistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_size_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_sizeQuantLib" ;;
let _SequenceStatistics_size arg = match _SequenceStatistics_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_samples_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_samplesQuantLib" ;;
let _SequenceStatistics_samples arg = match _SequenceStatistics_samples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_weightSum_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_weightSumQuantLib" ;;
let _SequenceStatistics_weightSum arg = match _SequenceStatistics_weightSum_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_mean_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_meanQuantLib" ;;
let _SequenceStatistics_mean arg = match _SequenceStatistics_mean_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_variance_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_varianceQuantLib" ;;
let _SequenceStatistics_variance arg = match _SequenceStatistics_variance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_standardDeviation_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_standardDeviationQuantLib" ;;
let _SequenceStatistics_standardDeviation arg = match _SequenceStatistics_standardDeviation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_errorEstimate_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_errorEstimateQuantLib" ;;
let _SequenceStatistics_errorEstimate arg = match _SequenceStatistics_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_skewness_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_skewnessQuantLib" ;;
let _SequenceStatistics_skewness arg = match _SequenceStatistics_skewness_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_kurtosis_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_kurtosisQuantLib" ;;
let _SequenceStatistics_kurtosis arg = match _SequenceStatistics_kurtosis_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_min_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_minQuantLib" ;;
let _SequenceStatistics_min arg = match _SequenceStatistics_min_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_max_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_maxQuantLib" ;;
let _SequenceStatistics_max arg = match _SequenceStatistics_max_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_covariance_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_covarianceQuantLib" ;;
let _SequenceStatistics_covariance arg = match _SequenceStatistics_covariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_correlation_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_correlationQuantLib" ;;
let _SequenceStatistics_correlation arg = match _SequenceStatistics_correlation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_reset_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_resetQuantLib" ;;
let _SequenceStatistics_reset arg = match _SequenceStatistics_reset_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_add_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_add__SWIG_0QuantLib" ;;
let _SequenceStatistics_add arg = match _SequenceStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_add_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_add__SWIG_1QuantLib" ;;
let _SequenceStatistics_add arg = match _SequenceStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_add_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_add__SWIG_2QuantLib" ;;
let _SequenceStatistics_add arg = match _SequenceStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SequenceStatistics_add_f : c_obj list -> c_obj list = "_wrap_SequenceStatistics_addQuantLib" ;;
let _SequenceStatistics_add arg = match _SequenceStatistics_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SequenceStatistics_f : c_obj list -> c_obj list = "_wrap_delete_SequenceStatisticsQuantLib" ;;
let _delete_SequenceStatistics arg = match _delete_SequenceStatistics_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeBasket_f : c_obj list -> c_obj list = "_wrap_new_TimeBasket__SWIG_0QuantLib" ;;
let _new_TimeBasket arg = match _new_TimeBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeBasket_f : c_obj list -> c_obj list = "_wrap_new_TimeBasketQuantLib" ;;
let _new_TimeBasket arg = match _new_TimeBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TimeBasket_size_f : c_obj list -> c_obj list = "_wrap_TimeBasket_sizeQuantLib" ;;
let _TimeBasket_size arg = match _TimeBasket_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TimeBasket_rebin_f : c_obj list -> c_obj list = "_wrap_TimeBasket_rebinQuantLib" ;;
let _TimeBasket_rebin arg = match _TimeBasket_rebin_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TimeBasket_f : c_obj list -> c_obj list = "_wrap_delete_TimeBasketQuantLib" ;;
let _delete_TimeBasket arg = match _delete_TimeBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Swap_f : c_obj list -> c_obj list = "_wrap_new_SwapQuantLib" ;;
let _new_Swap arg = match _new_Swap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Swap_startDate_f : c_obj list -> c_obj list = "_wrap_Swap_startDateQuantLib" ;;
let _Swap_startDate arg = match _Swap_startDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Swap_f : c_obj list -> c_obj list = "_wrap_delete_SwapQuantLib" ;;
let _delete_Swap arg = match _delete_Swap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_Receiver : c_obj -> Swig.c_obj = "_wrap_VanillaSwap_Receiver" 
external _VanillaSwap_Payer : c_obj -> Swig.c_obj = "_wrap_VanillaSwap_Payer" 
external _new_VanillaSwap_f : c_obj list -> c_obj list = "_wrap_new_VanillaSwapQuantLib" ;;
let _new_VanillaSwap arg = match _new_VanillaSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_fairRate_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_fairRateQuantLib" ;;
let _VanillaSwap_fairRate arg = match _VanillaSwap_fairRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_fairSpread_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_fairSpreadQuantLib" ;;
let _VanillaSwap_fairSpread arg = match _VanillaSwap_fairSpread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_fixedLegBPS_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_fixedLegBPSQuantLib" ;;
let _VanillaSwap_fixedLegBPS arg = match _VanillaSwap_fixedLegBPS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_floatingLegBPS_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_floatingLegBPSQuantLib" ;;
let _VanillaSwap_floatingLegBPS arg = match _VanillaSwap_floatingLegBPS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VanillaSwap_f : c_obj list -> c_obj list = "_wrap_delete_VanillaSwapQuantLib" ;;
let _delete_VanillaSwap arg = match _delete_VanillaSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Swaption_f : c_obj list -> c_obj list = "_wrap_new_SwaptionQuantLib" ;;
let _new_Swaption arg = match _new_Swaption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Swaption_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionQuantLib" ;;
let _delete_Swaption arg = match _delete_Swaption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_new_BlackSwaptionEngine__SWIG_0QuantLib" ;;
let _new_BlackSwaptionEngine arg = match _new_BlackSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_new_BlackSwaptionEngineQuantLib" ;;
let _new_BlackSwaptionEngine arg = match _new_BlackSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackSwaptionEngine_f : c_obj list -> c_obj list = "_wrap_delete_BlackSwaptionEngineQuantLib" ;;
let _delete_BlackSwaptionEngine arg = match _delete_BlackSwaptionEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Surface___deref___f : c_obj list -> c_obj list = "_wrap_Surface___deref__QuantLib" ;;
let _Surface___deref__ arg = match _Surface___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Surface_isNull_f : c_obj list -> c_obj list = "_wrap_Surface_isNullQuantLib" ;;
let _Surface_isNull arg = match _Surface_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Surface_f : c_obj list -> c_obj list = "_wrap_new_SurfaceQuantLib" ;;
let _new_Surface arg = match _new_Surface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Surface_f : c_obj list -> c_obj list = "_wrap_delete_SurfaceQuantLib" ;;
let _delete_Surface arg = match _delete_Surface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Surface_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_Surface_operator_pP___QuantLib" ;;
let _Surface_operator_xx_xx_lparen_xx_rparen arg = match _Surface_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Surface_domain_f : c_obj list -> c_obj list = "_wrap_Surface_domainQuantLib" ;;
let _Surface_domain arg = match _Surface_domain_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TestSurface_f : c_obj list -> c_obj list = "_wrap_new_TestSurfaceQuantLib" ;;
let _new_TestSurface arg = match _new_TestSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TestSurface_f : c_obj list -> c_obj list = "_wrap_delete_TestSurfaceQuantLib" ;;
let _delete_TestSurface arg = match _delete_TestSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantEstimator_f : c_obj list -> c_obj list = "_wrap_new_ConstantEstimatorQuantLib" ;;
let _new_ConstantEstimator arg = match _new_ConstantEstimator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ConstantEstimator_calculate_f : c_obj list -> c_obj list = "_wrap_ConstantEstimator_calculateQuantLib" ;;
let _ConstantEstimator_calculate arg = match _ConstantEstimator_calculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConstantEstimator_f : c_obj list -> c_obj list = "_wrap_delete_ConstantEstimatorQuantLib" ;;
let _delete_ConstantEstimator arg = match _delete_ConstantEstimator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ParkinsonSigma_f : c_obj list -> c_obj list = "_wrap_new_ParkinsonSigmaQuantLib" ;;
let _new_ParkinsonSigma arg = match _new_ParkinsonSigma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ParkinsonSigma_calculate_f : c_obj list -> c_obj list = "_wrap_ParkinsonSigma_calculateQuantLib" ;;
let _ParkinsonSigma_calculate arg = match _ParkinsonSigma_calculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ParkinsonSigma_f : c_obj list -> c_obj list = "_wrap_delete_ParkinsonSigmaQuantLib" ;;
let _delete_ParkinsonSigma arg = match _delete_ParkinsonSigma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GarmanKlassSigma1_f : c_obj list -> c_obj list = "_wrap_new_GarmanKlassSigma1QuantLib" ;;
let _new_GarmanKlassSigma1 arg = match _new_GarmanKlassSigma1_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GarmanKlassSigma1_calculate_f : c_obj list -> c_obj list = "_wrap_GarmanKlassSigma1_calculateQuantLib" ;;
let _GarmanKlassSigma1_calculate arg = match _GarmanKlassSigma1_calculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GarmanKlassSigma1_f : c_obj list -> c_obj list = "_wrap_delete_GarmanKlassSigma1QuantLib" ;;
let _delete_GarmanKlassSigma1 arg = match _delete_GarmanKlassSigma1_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GarmanKlassSigma3_f : c_obj list -> c_obj list = "_wrap_new_GarmanKlassSigma3QuantLib" ;;
let _new_GarmanKlassSigma3 arg = match _new_GarmanKlassSigma3_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GarmanKlassSigma3_calculate_f : c_obj list -> c_obj list = "_wrap_GarmanKlassSigma3_calculateQuantLib" ;;
let _GarmanKlassSigma3_calculate arg = match _GarmanKlassSigma3_calculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GarmanKlassSigma3_f : c_obj list -> c_obj list = "_wrap_delete_GarmanKlassSigma3QuantLib" ;;
let _delete_GarmanKlassSigma3 arg = match _delete_GarmanKlassSigma3_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GarmanKlassSigma4_f : c_obj list -> c_obj list = "_wrap_new_GarmanKlassSigma4QuantLib" ;;
let _new_GarmanKlassSigma4 arg = match _new_GarmanKlassSigma4_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GarmanKlassSigma4_calculate_f : c_obj list -> c_obj list = "_wrap_GarmanKlassSigma4_calculateQuantLib" ;;
let _GarmanKlassSigma4_calculate arg = match _GarmanKlassSigma4_calculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GarmanKlassSigma4_f : c_obj list -> c_obj list = "_wrap_delete_GarmanKlassSigma4QuantLib" ;;
let _delete_GarmanKlassSigma4 arg = match _delete_GarmanKlassSigma4_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GarmanKlassSigma5_f : c_obj list -> c_obj list = "_wrap_new_GarmanKlassSigma5QuantLib" ;;
let _new_GarmanKlassSigma5 arg = match _new_GarmanKlassSigma5_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GarmanKlassSigma5_calculate_f : c_obj list -> c_obj list = "_wrap_GarmanKlassSigma5_calculateQuantLib" ;;
let _GarmanKlassSigma5_calculate arg = match _GarmanKlassSigma5_calculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GarmanKlassSigma5_f : c_obj list -> c_obj list = "_wrap_delete_GarmanKlassSigma5QuantLib" ;;
let _delete_GarmanKlassSigma5 arg = match _delete_GarmanKlassSigma5_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GarmanKlassSigma6_f : c_obj list -> c_obj list = "_wrap_new_GarmanKlassSigma6QuantLib" ;;
let _new_GarmanKlassSigma6 arg = match _new_GarmanKlassSigma6_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GarmanKlassSigma6_calculate_f : c_obj list -> c_obj list = "_wrap_GarmanKlassSigma6_calculateQuantLib" ;;
let _GarmanKlassSigma6_calculate arg = match _GarmanKlassSigma6_calculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GarmanKlassSigma6_f : c_obj list -> c_obj list = "_wrap_delete_GarmanKlassSigma6QuantLib" ;;
let _delete_GarmanKlassSigma6 arg = match _delete_GarmanKlassSigma6_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCurve_f : c_obj list -> c_obj list = "_wrap_new_ZeroCurve__SWIG_0QuantLib" ;;
let _new_ZeroCurve arg = match _new_ZeroCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCurve_f : c_obj list -> c_obj list = "_wrap_new_ZeroCurveQuantLib" ;;
let _new_ZeroCurve arg = match _new_ZeroCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroCurve_dates_f : c_obj list -> c_obj list = "_wrap_ZeroCurve_datesQuantLib" ;;
let _ZeroCurve_dates arg = match _ZeroCurve_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroCurve_zeroRates_f : c_obj list -> c_obj list = "_wrap_ZeroCurve_zeroRatesQuantLib" ;;
let _ZeroCurve_zeroRates arg = match _ZeroCurve_zeroRates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroCurve_nodes_f : c_obj list -> c_obj list = "_wrap_ZeroCurve_nodesQuantLib" ;;
let _ZeroCurve_nodes arg = match _ZeroCurve_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroCurve_f : c_obj list -> c_obj list = "_wrap_delete_ZeroCurveQuantLib" ;;
let _delete_ZeroCurve arg = match _delete_ZeroCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscreteGeometricASO_f : c_obj list -> c_obj list = "_wrap_new_DiscreteGeometricASOQuantLib" ;;
let _new_DiscreteGeometricASO arg = match _new_DiscreteGeometricASO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteGeometricASO_value_f : c_obj list -> c_obj list = "_wrap_DiscreteGeometricASO_valueQuantLib" ;;
let _DiscreteGeometricASO_value arg = match _DiscreteGeometricASO_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DiscreteGeometricASO_f : c_obj list -> c_obj list = "_wrap_delete_DiscreteGeometricASOQuantLib" ;;
let _delete_DiscreteGeometricASO arg = match _delete_DiscreteGeometricASO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureVector__SWIG_0QuantLib" ;;
let _new_YieldTermStructureVector arg = match _new_YieldTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureVector__SWIG_1QuantLib" ;;
let _new_YieldTermStructureVector arg = match _new_YieldTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureVector__SWIG_2QuantLib" ;;
let _new_YieldTermStructureVector arg = match _new_YieldTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureVectorQuantLib" ;;
let _new_YieldTermStructureVector arg = match _new_YieldTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_size_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_sizeQuantLib" ;;
let _YieldTermStructureVector_size arg = match _YieldTermStructureVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_empty_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_emptyQuantLib" ;;
let _YieldTermStructureVector_empty arg = match _YieldTermStructureVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_clear_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_clearQuantLib" ;;
let _YieldTermStructureVector_clear arg = match _YieldTermStructureVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_push_back_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_push_backQuantLib" ;;
let _YieldTermStructureVector_push_back arg = match _YieldTermStructureVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_operator_bB___QuantLib" ;;
let _YieldTermStructureVector_operator_xx_xx_lbrace_xx_rbrace arg = match _YieldTermStructureVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_operator_e___QuantLib" ;;
let _YieldTermStructureVector_operator_xx_xx_equals arg = match _YieldTermStructureVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_set_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_setQuantLib" ;;
let _YieldTermStructureVector_set arg = match _YieldTermStructureVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureVector_to_array_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureVector_to_arrayQuantLib" ;;
let _YieldTermStructureVector_to_array arg = match _YieldTermStructureVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YieldTermStructureVector_f : c_obj list -> c_obj list = "_wrap_delete_YieldTermStructureVectorQuantLib" ;;
let _delete_YieldTermStructureVector arg = match _delete_YieldTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureVector__SWIG_0QuantLib" ;;
let _new_BlackVolTermStructureVector arg = match _new_BlackVolTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureVector__SWIG_1QuantLib" ;;
let _new_BlackVolTermStructureVector arg = match _new_BlackVolTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureVector__SWIG_2QuantLib" ;;
let _new_BlackVolTermStructureVector arg = match _new_BlackVolTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureVector_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureVectorQuantLib" ;;
let _new_BlackVolTermStructureVector arg = match _new_BlackVolTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_size_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_sizeQuantLib" ;;
let _BlackVolTermStructureVector_size arg = match _BlackVolTermStructureVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_empty_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_emptyQuantLib" ;;
let _BlackVolTermStructureVector_empty arg = match _BlackVolTermStructureVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_clear_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_clearQuantLib" ;;
let _BlackVolTermStructureVector_clear arg = match _BlackVolTermStructureVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_push_back_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_push_backQuantLib" ;;
let _BlackVolTermStructureVector_push_back arg = match _BlackVolTermStructureVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_operator_bB___QuantLib" ;;
let _BlackVolTermStructureVector_operator_xx_xx_lbrace_xx_rbrace arg = match _BlackVolTermStructureVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_operator_e___QuantLib" ;;
let _BlackVolTermStructureVector_operator_xx_xx_equals arg = match _BlackVolTermStructureVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_set_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_setQuantLib" ;;
let _BlackVolTermStructureVector_set arg = match _BlackVolTermStructureVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureVector_to_array_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureVector_to_arrayQuantLib" ;;
let _BlackVolTermStructureVector_to_array arg = match _BlackVolTermStructureVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackVolTermStructureVector_f : c_obj list -> c_obj list = "_wrap_delete_BlackVolTermStructureVectorQuantLib" ;;
let _delete_BlackVolTermStructureVector arg = match _delete_BlackVolTermStructureVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McDiscreteArithmeticASO_f : c_obj list -> c_obj list = "_wrap_new_McDiscreteArithmeticASO__SWIG_0QuantLib" ;;
let _new_McDiscreteArithmeticASO arg = match _new_McDiscreteArithmeticASO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McDiscreteArithmeticASO_f : c_obj list -> c_obj list = "_wrap_new_McDiscreteArithmeticASOQuantLib" ;;
let _new_McDiscreteArithmeticASO arg = match _new_McDiscreteArithmeticASO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McDiscreteArithmeticASO_value_f : c_obj list -> c_obj list = "_wrap_McDiscreteArithmeticASO_value__SWIG_0QuantLib" ;;
let _McDiscreteArithmeticASO_value arg = match _McDiscreteArithmeticASO_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McDiscreteArithmeticASO_value_f : c_obj list -> c_obj list = "_wrap_McDiscreteArithmeticASO_valueQuantLib" ;;
let _McDiscreteArithmeticASO_value arg = match _McDiscreteArithmeticASO_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McDiscreteArithmeticASO_valueWithSamples_f : c_obj list -> c_obj list = "_wrap_McDiscreteArithmeticASO_valueWithSamplesQuantLib" ;;
let _McDiscreteArithmeticASO_valueWithSamples arg = match _McDiscreteArithmeticASO_valueWithSamples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McDiscreteArithmeticASO_errorEstimate_f : c_obj list -> c_obj list = "_wrap_McDiscreteArithmeticASO_errorEstimateQuantLib" ;;
let _McDiscreteArithmeticASO_errorEstimate arg = match _McDiscreteArithmeticASO_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_McDiscreteArithmeticASO_f : c_obj list -> c_obj list = "_wrap_delete_McDiscreteArithmeticASOQuantLib" ;;
let _delete_McDiscreteArithmeticASO arg = match _delete_McDiscreteArithmeticASO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McMaxBasket_f : c_obj list -> c_obj list = "_wrap_new_McMaxBasket__SWIG_0QuantLib" ;;
let _new_McMaxBasket arg = match _new_McMaxBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McMaxBasket_f : c_obj list -> c_obj list = "_wrap_new_McMaxBasketQuantLib" ;;
let _new_McMaxBasket arg = match _new_McMaxBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McMaxBasket_value_f : c_obj list -> c_obj list = "_wrap_McMaxBasket_value__SWIG_0QuantLib" ;;
let _McMaxBasket_value arg = match _McMaxBasket_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McMaxBasket_value_f : c_obj list -> c_obj list = "_wrap_McMaxBasket_valueQuantLib" ;;
let _McMaxBasket_value arg = match _McMaxBasket_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McMaxBasket_valueWithSamples_f : c_obj list -> c_obj list = "_wrap_McMaxBasket_valueWithSamplesQuantLib" ;;
let _McMaxBasket_valueWithSamples arg = match _McMaxBasket_valueWithSamples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McMaxBasket_errorEstimate_f : c_obj list -> c_obj list = "_wrap_McMaxBasket_errorEstimateQuantLib" ;;
let _McMaxBasket_errorEstimate arg = match _McMaxBasket_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_McMaxBasket_f : c_obj list -> c_obj list = "_wrap_delete_McMaxBasketQuantLib" ;;
let _delete_McMaxBasket arg = match _delete_McMaxBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McHimalaya_f : c_obj list -> c_obj list = "_wrap_new_McHimalaya__SWIG_0QuantLib" ;;
let _new_McHimalaya arg = match _new_McHimalaya_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McHimalaya_f : c_obj list -> c_obj list = "_wrap_new_McHimalayaQuantLib" ;;
let _new_McHimalaya arg = match _new_McHimalaya_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McHimalaya_value_f : c_obj list -> c_obj list = "_wrap_McHimalaya_value__SWIG_0QuantLib" ;;
let _McHimalaya_value arg = match _McHimalaya_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McHimalaya_value_f : c_obj list -> c_obj list = "_wrap_McHimalaya_valueQuantLib" ;;
let _McHimalaya_value arg = match _McHimalaya_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McHimalaya_valueWithSamples_f : c_obj list -> c_obj list = "_wrap_McHimalaya_valueWithSamplesQuantLib" ;;
let _McHimalaya_valueWithSamples arg = match _McHimalaya_valueWithSamples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McHimalaya_errorEstimate_f : c_obj list -> c_obj list = "_wrap_McHimalaya_errorEstimateQuantLib" ;;
let _McHimalaya_errorEstimate arg = match _McHimalaya_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_McHimalaya_f : c_obj list -> c_obj list = "_wrap_delete_McHimalayaQuantLib" ;;
let _delete_McHimalaya arg = match _delete_McHimalaya_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McEverest_f : c_obj list -> c_obj list = "_wrap_new_McEverest__SWIG_0QuantLib" ;;
let _new_McEverest arg = match _new_McEverest_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McEverest_f : c_obj list -> c_obj list = "_wrap_new_McEverestQuantLib" ;;
let _new_McEverest arg = match _new_McEverest_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McEverest_value_f : c_obj list -> c_obj list = "_wrap_McEverest_value__SWIG_0QuantLib" ;;
let _McEverest_value arg = match _McEverest_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McEverest_value_f : c_obj list -> c_obj list = "_wrap_McEverest_valueQuantLib" ;;
let _McEverest_value arg = match _McEverest_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McEverest_valueWithSamples_f : c_obj list -> c_obj list = "_wrap_McEverest_valueWithSamplesQuantLib" ;;
let _McEverest_valueWithSamples arg = match _McEverest_valueWithSamples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McEverest_errorEstimate_f : c_obj list -> c_obj list = "_wrap_McEverest_errorEstimateQuantLib" ;;
let _McEverest_errorEstimate arg = match _McEverest_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_McEverest_f : c_obj list -> c_obj list = "_wrap_delete_McEverestQuantLib" ;;
let _delete_McEverest arg = match _delete_McEverest_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McPagoda_f : c_obj list -> c_obj list = "_wrap_new_McPagoda__SWIG_0QuantLib" ;;
let _new_McPagoda arg = match _new_McPagoda_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_McPagoda_f : c_obj list -> c_obj list = "_wrap_new_McPagodaQuantLib" ;;
let _new_McPagoda arg = match _new_McPagoda_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McPagoda_value_f : c_obj list -> c_obj list = "_wrap_McPagoda_value__SWIG_0QuantLib" ;;
let _McPagoda_value arg = match _McPagoda_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McPagoda_value_f : c_obj list -> c_obj list = "_wrap_McPagoda_valueQuantLib" ;;
let _McPagoda_value arg = match _McPagoda_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McPagoda_valueWithSamples_f : c_obj list -> c_obj list = "_wrap_McPagoda_valueWithSamplesQuantLib" ;;
let _McPagoda_valueWithSamples arg = match _McPagoda_valueWithSamples_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _McPagoda_errorEstimate_f : c_obj list -> c_obj list = "_wrap_McPagoda_errorEstimateQuantLib" ;;
let _McPagoda_errorEstimate arg = match _McPagoda_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_McPagoda_f : c_obj list -> c_obj list = "_wrap_delete_McPagodaQuantLib" ;;
let _delete_McPagoda arg = match _delete_McPagoda_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructure___deref___f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructure___deref__QuantLib" ;;
let _CapVolatilityStructure___deref__ arg = match _CapVolatilityStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructure_isNull_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructure_isNullQuantLib" ;;
let _CapVolatilityStructure_isNull arg = match _CapVolatilityStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructure_asObservableQuantLib" ;;
let _CapVolatilityStructure_asObservable arg = match _CapVolatilityStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_new_CapVolatilityStructureQuantLib" ;;
let _new_CapVolatilityStructure arg = match _new_CapVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_delete_CapVolatilityStructureQuantLib" ;;
let _delete_CapVolatilityStructure arg = match _delete_CapVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructure_volatility__SWIG_0QuantLib" ;;
let _CapVolatilityStructure_volatility arg = match _CapVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructure_volatilityQuantLib" ;;
let _CapVolatilityStructure_volatility arg = match _CapVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_CapVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_CapVolatilityStructureHandle arg = match _new_CapVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_CapVolatilityStructureHandleQuantLib" ;;
let _new_CapVolatilityStructureHandle arg = match _new_CapVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructureHandle___deref__QuantLib" ;;
let _CapVolatilityStructureHandle___deref__ arg = match _CapVolatilityStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructureHandle_emptyQuantLib" ;;
let _CapVolatilityStructureHandle_empty arg = match _CapVolatilityStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructureHandle_asObservableQuantLib" ;;
let _CapVolatilityStructureHandle_asObservable arg = match _CapVolatilityStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_CapVolatilityStructureHandleQuantLib" ;;
let _delete_CapVolatilityStructureHandle arg = match _delete_CapVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructureHandle_volatility__SWIG_0QuantLib" ;;
let _CapVolatilityStructureHandle_volatility arg = match _CapVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_CapVolatilityStructureHandle_volatilityQuantLib" ;;
let _CapVolatilityStructureHandle_volatility arg = match _CapVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableCapVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableCapVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableCapVolatilityStructureHandle arg = match _new_RelinkableCapVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableCapVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableCapVolatilityStructureHandleQuantLib" ;;
let _new_RelinkableCapVolatilityStructureHandle arg = match _new_RelinkableCapVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableCapVolatilityStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableCapVolatilityStructureHandle_linkToQuantLib" ;;
let _RelinkableCapVolatilityStructureHandle_linkTo arg = match _RelinkableCapVolatilityStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableCapVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableCapVolatilityStructureHandleQuantLib" ;;
let _delete_RelinkableCapVolatilityStructureHandle arg = match _delete_RelinkableCapVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapVolatilityVector_f : c_obj list -> c_obj list = "_wrap_new_CapVolatilityVector__SWIG_0QuantLib" ;;
let _new_CapVolatilityVector arg = match _new_CapVolatilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapVolatilityVector_f : c_obj list -> c_obj list = "_wrap_new_CapVolatilityVectorQuantLib" ;;
let _new_CapVolatilityVector arg = match _new_CapVolatilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapVolatilityVector_f : c_obj list -> c_obj list = "_wrap_delete_CapVolatilityVectorQuantLib" ;;
let _delete_CapVolatilityVector arg = match _delete_CapVolatilityVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external f_init : unit -> unit = "f_QuantLib_init" ;;
let _ = f_init ()
let enum_to_int x (v : c_obj) =
   match v with
     C_enum _y ->
     (let y = _y in match (x : c_enum_type) with
       `unknown ->          (match y with
           `Int x -> (Swig.C_int x)
           | _ -> raise (LabelNotFromThisEnum v))
| `Weekday -> (match y with
 | `Sunday -> _Sunday C_void
 | `Monday -> _Monday C_void
 | `Tuesday -> _Tuesday C_void
 | `Wednesday -> _Wednesday C_void
 | `Thursday -> _Thursday C_void
 | `Friday -> _Friday C_void
 | `Saturday -> _Saturday C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Month -> (match y with
 | `January -> _January C_void
 | `February -> _February C_void
 | `March -> _March C_void
 | `April -> _April C_void
 | `May -> _May C_void
 | `June -> _June C_void
 | `July -> _July C_void
 | `August -> _August C_void
 | `September -> _September C_void
 | `October -> _October C_void
 | `November -> _November C_void
 | `December -> _December C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `TimeUnit -> (match y with
 | `Days -> _Days C_void
 | `Weeks -> _Weeks C_void
 | `Months -> _Months C_void
 | `Years -> _Years C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Frequency -> (match y with
 | `NoFrequency -> _NoFrequency C_void
 | `Once -> _Once C_void
 | `Annual -> _Annual C_void
 | `Semiannual -> _Semiannual C_void
 | `EveryFourthMonth -> _EveryFourthMonth C_void
 | `Quarterly -> _Quarterly C_void
 | `Bimonthly -> _Bimonthly C_void
 | `Monthly -> _Monthly C_void
 | `Biweekly -> _Biweekly C_void
 | `Weekly -> _Weekly C_void
 | `Daily -> _Daily C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Month -> (match y with
 | `F -> _F C_void
 | `G -> _G C_void
 | `H -> _H C_void
 | `J -> _J C_void
 | `K -> _K C_void
 | `M -> _M C_void
 | `N -> _N C_void
 | `Q -> _Q C_void
 | `U -> _U C_void
 | `V -> _V C_void
 | `X -> _X C_void
 | `Z -> _Z C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `None -> _None C_void
 | `Spectral -> _Spectral C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Convention -> (match y with
 | `USA -> _USA C_void
 | `BondBasis -> _BondBasis C_void
 | `European -> _European C_void
 | `EurobondBasis -> _EurobondBasis C_void
 | `Italian -> _Italian C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Convention -> (match y with
 | `ISMA -> _ISMA C_void
 | `Bond -> _Bond C_void
 | `ISDA -> _ISDA C_void
 | `Historical -> _Historical C_void
 | `Actual365 -> _Actual365 C_void
 | `AFB -> _AFB C_void
 | `Euro -> _Euro C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Compounding -> (match y with
 | `Simple -> _Simple C_void
 | `Compounded -> _Compounded C_void
 | `Continuous -> _Continuous C_void
 | `SimpleThenCompounded -> _SimpleThenCompounded C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `BusinessDayConvention -> (match y with
 | `Following -> _Following C_void
 | `ModifiedFollowing -> _ModifiedFollowing C_void
 | `Preceding -> _Preceding C_void
 | `ModifiedPreceding -> _ModifiedPreceding C_void
 | `Unadjusted -> _Unadjusted C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `JointCalendarRule -> (match y with
 | `JoinHolidays -> _JoinHolidays C_void
 | `JoinBusinessDays -> _JoinBusinessDays C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `Merval -> _Merval C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `Settlement -> _Settlement C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `PSE -> _PSE C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `FrankfurtStockExchange -> _FrankfurtStockExchange C_void
 | `Xetra -> _Xetra C_void
 | `Eurex -> _Eurex C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `HKEx -> _HKEx C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `ICEX -> _ICEX C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `NSE -> _NSE C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `BEJ -> _BEJ C_void
 | `JSX -> _JSX C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `Exchange -> _Exchange C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `BMV -> _BMV C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `Tadawul -> _Tadawul C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `SGX -> _SGX C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `BSSE -> _BSSE C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `KRX -> _KRX C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `TSEC -> _TSEC C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `USE -> _USE C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `Metals -> _Metals C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Market -> (match y with
 | `NYSE -> _NYSE C_void
 | `GovernmentBond -> _GovernmentBond C_void
 | `NERC -> _NERC C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `Put -> _Put C_void
 | `Call -> _Call C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `DownIn -> _DownIn C_void
 | `UpIn -> _UpIn C_void
 | `DownOut -> _DownOut C_void
 | `UpOut -> _UpOut C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `Open -> _Open C_void
 | `Close -> _Close C_void
 | `High -> _High C_void
 | `Low -> _Low C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `Macaulay -> _Macaulay C_void
 | `Modified -> _Modified C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `Dirty -> _Dirty C_void
 | `Clean -> _Clean C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `ConversionType -> (match y with
 | `NoConversion -> _NoConversion C_void
 | `BaseCurrencyConversion -> _BaseCurrencyConversion C_void
 | `AutomatedConversion -> _AutomatedConversion C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `Direct -> _Direct C_void
 | `Derived -> _Derived C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
| `Type -> (match y with
 | `MaxIterations -> _MaxIterations C_void
 | `StationaryPoint -> _StationaryPoint C_void
 | `StationaryFunctionValue -> _StationaryFunctionValue C_void
 | `StationaryFunctionAccuracy -> _StationaryFunctionAccuracy C_void
 | `ZeroGradientNorm -> _ZeroGradientNorm C_void
 | `Unknown -> _Unknown C_void
| `Int x -> Swig.C_int x
| _ -> raise (LabelNotFromThisEnum v))
) | _ -> (C_int (get_int v))
let _ = Callback.register "QuantLib_enum_to_int" enum_to_int
let int_to_enum x y =
    match (x : c_enum_type) with
      `unknown -> C_enum (`Int y)
| `Weekday -> C_enum (
 if y = (get_int (_Sunday C_void)) then `Sunday else
 if y = (get_int (_Monday C_void)) then `Monday else
 if y = (get_int (_Tuesday C_void)) then `Tuesday else
 if y = (get_int (_Wednesday C_void)) then `Wednesday else
 if y = (get_int (_Thursday C_void)) then `Thursday else
 if y = (get_int (_Friday C_void)) then `Friday else
 if y = (get_int (_Saturday C_void)) then `Saturday else
`Int y)
| `Month -> C_enum (
 if y = (get_int (_January C_void)) then `January else
 if y = (get_int (_February C_void)) then `February else
 if y = (get_int (_March C_void)) then `March else
 if y = (get_int (_April C_void)) then `April else
 if y = (get_int (_May C_void)) then `May else
 if y = (get_int (_June C_void)) then `June else
 if y = (get_int (_July C_void)) then `July else
 if y = (get_int (_August C_void)) then `August else
 if y = (get_int (_September C_void)) then `September else
 if y = (get_int (_October C_void)) then `October else
 if y = (get_int (_November C_void)) then `November else
 if y = (get_int (_December C_void)) then `December else
`Int y)
| `TimeUnit -> C_enum (
 if y = (get_int (_Days C_void)) then `Days else
 if y = (get_int (_Weeks C_void)) then `Weeks else
 if y = (get_int (_Months C_void)) then `Months else
 if y = (get_int (_Years C_void)) then `Years else
`Int y)
| `Frequency -> C_enum (
 if y = (get_int (_NoFrequency C_void)) then `NoFrequency else
 if y = (get_int (_Once C_void)) then `Once else
 if y = (get_int (_Annual C_void)) then `Annual else
 if y = (get_int (_Semiannual C_void)) then `Semiannual else
 if y = (get_int (_EveryFourthMonth C_void)) then `EveryFourthMonth else
 if y = (get_int (_Quarterly C_void)) then `Quarterly else
 if y = (get_int (_Bimonthly C_void)) then `Bimonthly else
 if y = (get_int (_Monthly C_void)) then `Monthly else
 if y = (get_int (_Biweekly C_void)) then `Biweekly else
 if y = (get_int (_Weekly C_void)) then `Weekly else
 if y = (get_int (_Daily C_void)) then `Daily else
`Int y)
| `Month -> C_enum (
 if y = (get_int (_F C_void)) then `F else
 if y = (get_int (_G C_void)) then `G else
 if y = (get_int (_H C_void)) then `H else
 if y = (get_int (_J C_void)) then `J else
 if y = (get_int (_K C_void)) then `K else
 if y = (get_int (_M C_void)) then `M else
 if y = (get_int (_N C_void)) then `N else
 if y = (get_int (_Q C_void)) then `Q else
 if y = (get_int (_U C_void)) then `U else
 if y = (get_int (_V C_void)) then `V else
 if y = (get_int (_X C_void)) then `X else
 if y = (get_int (_Z C_void)) then `Z else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_None C_void)) then `None else
 if y = (get_int (_Spectral C_void)) then `Spectral else
`Int y)
| `Convention -> C_enum (
 if y = (get_int (_USA C_void)) then `USA else
 if y = (get_int (_BondBasis C_void)) then `BondBasis else
 if y = (get_int (_European C_void)) then `European else
 if y = (get_int (_EurobondBasis C_void)) then `EurobondBasis else
 if y = (get_int (_Italian C_void)) then `Italian else
`Int y)
| `Convention -> C_enum (
 if y = (get_int (_ISMA C_void)) then `ISMA else
 if y = (get_int (_Bond C_void)) then `Bond else
 if y = (get_int (_ISDA C_void)) then `ISDA else
 if y = (get_int (_Historical C_void)) then `Historical else
 if y = (get_int (_Actual365 C_void)) then `Actual365 else
 if y = (get_int (_AFB C_void)) then `AFB else
 if y = (get_int (_Euro C_void)) then `Euro else
`Int y)
| `Compounding -> C_enum (
 if y = (get_int (_Simple C_void)) then `Simple else
 if y = (get_int (_Compounded C_void)) then `Compounded else
 if y = (get_int (_Continuous C_void)) then `Continuous else
 if y = (get_int (_SimpleThenCompounded C_void)) then `SimpleThenCompounded else
`Int y)
| `BusinessDayConvention -> C_enum (
 if y = (get_int (_Following C_void)) then `Following else
 if y = (get_int (_ModifiedFollowing C_void)) then `ModifiedFollowing else
 if y = (get_int (_Preceding C_void)) then `Preceding else
 if y = (get_int (_ModifiedPreceding C_void)) then `ModifiedPreceding else
 if y = (get_int (_Unadjusted C_void)) then `Unadjusted else
`Int y)
| `JointCalendarRule -> C_enum (
 if y = (get_int (_JoinHolidays C_void)) then `JoinHolidays else
 if y = (get_int (_JoinBusinessDays C_void)) then `JoinBusinessDays else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_Merval C_void)) then `Merval else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_Settlement C_void)) then `Settlement else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_PSE C_void)) then `PSE else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_FrankfurtStockExchange C_void)) then `FrankfurtStockExchange else
 if y = (get_int (_Xetra C_void)) then `Xetra else
 if y = (get_int (_Eurex C_void)) then `Eurex else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_HKEx C_void)) then `HKEx else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_ICEX C_void)) then `ICEX else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_NSE C_void)) then `NSE else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_BEJ C_void)) then `BEJ else
 if y = (get_int (_JSX C_void)) then `JSX else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_Exchange C_void)) then `Exchange else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_BMV C_void)) then `BMV else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_Tadawul C_void)) then `Tadawul else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_SGX C_void)) then `SGX else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_BSSE C_void)) then `BSSE else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_KRX C_void)) then `KRX else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_TSEC C_void)) then `TSEC else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_USE C_void)) then `USE else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_Metals C_void)) then `Metals else
`Int y)
| `Market -> C_enum (
 if y = (get_int (_NYSE C_void)) then `NYSE else
 if y = (get_int (_GovernmentBond C_void)) then `GovernmentBond else
 if y = (get_int (_NERC C_void)) then `NERC else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_Put C_void)) then `Put else
 if y = (get_int (_Call C_void)) then `Call else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_DownIn C_void)) then `DownIn else
 if y = (get_int (_UpIn C_void)) then `UpIn else
 if y = (get_int (_DownOut C_void)) then `DownOut else
 if y = (get_int (_UpOut C_void)) then `UpOut else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_Open C_void)) then `Open else
 if y = (get_int (_Close C_void)) then `Close else
 if y = (get_int (_High C_void)) then `High else
 if y = (get_int (_Low C_void)) then `Low else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_Macaulay C_void)) then `Macaulay else
 if y = (get_int (_Modified C_void)) then `Modified else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_Dirty C_void)) then `Dirty else
 if y = (get_int (_Clean C_void)) then `Clean else
`Int y)
| `ConversionType -> C_enum (
 if y = (get_int (_NoConversion C_void)) then `NoConversion else
 if y = (get_int (_BaseCurrencyConversion C_void)) then `BaseCurrencyConversion else
 if y = (get_int (_AutomatedConversion C_void)) then `AutomatedConversion else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_Direct C_void)) then `Direct else
 if y = (get_int (_Derived C_void)) then `Derived else
`Int y)
| `Type -> C_enum (
 if y = (get_int (_MaxIterations C_void)) then `MaxIterations else
 if y = (get_int (_StationaryPoint C_void)) then `StationaryPoint else
 if y = (get_int (_StationaryFunctionValue C_void)) then `StationaryFunctionValue else
 if y = (get_int (_StationaryFunctionAccuracy C_void)) then `StationaryFunctionAccuracy else
 if y = (get_int (_ZeroGradientNorm C_void)) then `ZeroGradientNorm else
 if y = (get_int (_Unknown C_void)) then `Unknown else
`Int y)
let _ = Callback.register "QuantLib_int_to_enum" int_to_enum

let create_std_xxbasic_string_xx_ldbrace_xx_lparenchar_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _string_size ;
    "[]", _string_operator_xx_xx_lbrace_xx_rbrace ;
    "c_str", _string_c_str ;
    "=", _string_operator_xx_xx_equals ;
    "=", _string_operator_xx_xx_equals ;
    "append", _string_append ;
    "append", _string_append ;
    "push_back", _string_push_back ;
    "clear", _string_clear ;
    "reserve", _string_reserve ;
    "resize", _string_resize ;
    "resize", _string_resize ;
    "compare", _string_compare ;
    "compare", _string_compare ;
    "insert", _string_insert ;
    "find", _string_find ;
    "find", _string_find ;
    "find", _string_find ;
    "find", _string_find ;
    "==", _string_operator_xx_xx_equals_xx_equals ;
    "!=", _string_operator_xx_xx_not_xx_equals ;
    "<", _string_operator_xx_xx_ldbrace ;
    ">", _string_operator_xx_xx_rdbrace ;
    "<=", _string_operator_xx_xx_ldbrace_xx_equals ;
    ">=", _string_operator_xx_xx_rdbrace_xx_equals ;
    "~", _delete_string ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "std::basic_string<(char)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"std::basic_string<(char)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_std::basic_string<char >_from_ptr"
          create_std_xxbasic_string_xx_ldbrace_xx_lparenchar_xx_rparen_xx_rdbrace_from_ptr



let create_std_xxbasic_string_xx_ldbrace_xx_lparenwchar_t_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _wstring_size ;
    "[]", _wstring_operator_xx_xx_lbrace_xx_rbrace ;
    "c_str", _wstring_c_str ;
    "=", _wstring_operator_xx_xx_equals ;
    "=", _wstring_operator_xx_xx_equals ;
    "append", _wstring_append ;
    "append", _wstring_append ;
    "push_back", _wstring_push_back ;
    "clear", _wstring_clear ;
    "reserve", _wstring_reserve ;
    "resize", _wstring_resize ;
    "resize", _wstring_resize ;
    "compare", _wstring_compare ;
    "compare", _wstring_compare ;
    "insert", _wstring_insert ;
    "find", _wstring_find ;
    "find", _wstring_find ;
    "find", _wstring_find ;
    "find", _wstring_find ;
    "==", _wstring_operator_xx_xx_equals_xx_equals ;
    "!=", _wstring_operator_xx_xx_not_xx_equals ;
    "<", _wstring_operator_xx_xx_ldbrace ;
    ">", _wstring_operator_xx_xx_rdbrace ;
    "<=", _wstring_operator_xx_xx_ldbrace_xx_equals ;
    ">=", _wstring_operator_xx_xx_rdbrace_xx_equals ;
    "~", _delete_wstring ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "std::basic_string<(wchar_t)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"std::basic_string<(wchar_t)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_std::basic_string<wchar_t >_from_ptr"
          create_std_xxbasic_string_xx_ldbrace_xx_lparenwchar_t_xx_rparen_xx_rdbrace_from_ptr



let create_Period_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "length", _Period_length ;
    "units", _Period_units ;
    "__str__", _Period___str__ ;
    "__repr__", _Period___repr__ ;
    "~", _delete_Period ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Period") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Period"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Period_from_ptr"
          create_Period_from_ptr



let create_std_xxvector_xx_ldbrace_xx_lparenPeriod_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _PeriodVector_size ;
    "empty", _PeriodVector_empty ;
    "clear", _PeriodVector_clear ;
    "push_back", _PeriodVector_push_back ;
    "[]", _PeriodVector_operator_xx_xx_lbrace_xx_rbrace ;
    "=", _PeriodVector_operator_xx_xx_equals ;
    "set", _PeriodVector_set ;
    "to_array", _PeriodVector_to_array ;
    "~", _delete_PeriodVector ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "std::vector<(Period)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"std::vector<(Period)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_std::vector<Period >_from_ptr"
          create_std_xxvector_xx_ldbrace_xx_lparenPeriod_xx_rparen_xx_rdbrace_from_ptr



let create_Date_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "weekday", _Date_weekday ;
    "dayOfMonth", _Date_dayOfMonth ;
    "dayOfYear", _Date_dayOfYear ;
    "month", _Date_month ;
    "year", _Date_year ;
    "serialNumber", _Date_serialNumber ;
    "weekdayNumber", _Date_weekdayNumber ;
    "__str__", _Date___str__ ;
    "__repr__", _Date___repr__ ;
    "ISO", _Date_ISO ;
    "~", _delete_Date ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Date") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Date"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Date_from_ptr"
          create_Date_from_ptr



let create_DateParser_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_DateParser ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "DateParser") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"DateParser"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_DateParser_from_ptr"
          create_DateParser_from_ptr



let create_PeriodParser_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_PeriodParser ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "PeriodParser") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"PeriodParser"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_PeriodParser_from_ptr"
          create_PeriodParser_from_ptr



let create_std_xxvector_xx_ldbrace_xx_lparenDate_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _DateVector_size ;
    "empty", _DateVector_empty ;
    "clear", _DateVector_clear ;
    "push_back", _DateVector_push_back ;
    "[]", _DateVector_operator_xx_xx_lbrace_xx_rbrace ;
    "=", _DateVector_operator_xx_xx_equals ;
    "set", _DateVector_set ;
    "to_array", _DateVector_to_array ;
    "~", _delete_DateVector ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "std::vector<(Date)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"std::vector<(Date)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_std::vector<Date >_from_ptr"
          create_std_xxvector_xx_ldbrace_xx_lparenDate_xx_rparen_xx_rdbrace_from_ptr



let create_IMM_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_IMM ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "IMM") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"IMM"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_IMM_from_ptr"
          create_IMM_from_ptr



let create_boost_xxshared_ptr_xx_ldbrace_xx_lparenExercise_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "->", _Exercise___deref__ ;
    "isNull", _Exercise_isNull ;
    "~", _delete_Exercise ;
    "type", _Exercise_type ;
    "dates", _Exercise_dates ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "boost::shared_ptr<(Exercise)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"boost::shared_ptr<(Exercise)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_boost::shared_ptr<Exercise >_from_ptr"
          create_boost_xxshared_ptr_xx_ldbrace_xx_lparenExercise_xx_rparen_xx_rdbrace_from_ptr



let create_EuropeanExercisePtr_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_EuropeanExercise ;
   "::boost::shared_ptr<(Exercise)>", (fun args -> (create_class "boost::shared_ptr<(Exercise)>") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "EuropeanExercisePtr") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "boost::shared_ptr<(Exercise)>") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"EuropeanExercisePtr"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_EuropeanExercisePtr_from_ptr"
          create_EuropeanExercisePtr_from_ptr



let create_AmericanExercisePtr_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_AmericanExercise ;
   "::boost::shared_ptr<(Exercise)>", (fun args -> (create_class "boost::shared_ptr<(Exercise)>") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "AmericanExercisePtr") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "boost::shared_ptr<(Exercise)>") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"AmericanExercisePtr"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_AmericanExercisePtr_from_ptr"
          create_AmericanExercisePtr_from_ptr



let create_BermudanExercisePtr_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_BermudanExercise ;
   "::boost::shared_ptr<(Exercise)>", (fun args -> (create_class "boost::shared_ptr<(Exercise)>") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "BermudanExercisePtr") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "boost::shared_ptr<(Exercise)>") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"BermudanExercisePtr"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_BermudanExercisePtr_from_ptr"
          create_BermudanExercisePtr_from_ptr



let create_boost_xxshared_ptr_xx_ldbrace_xx_lparenObservable_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "->", _Observable___deref__ ;
    "isNull", _Observable_isNull ;
    "~", _delete_Observable ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "boost::shared_ptr<(Observable)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"boost::shared_ptr<(Observable)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_boost::shared_ptr<Observable >_from_ptr"
          create_boost_xxshared_ptr_xx_ldbrace_xx_lparenObservable_xx_rparen_xx_rdbrace_from_ptr



let create_Array_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _Array_size ;
    "__str__", _Array___str__ ;
    "~", _delete_Array ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Array") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Array"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Array_from_ptr"
          create_Array_from_ptr



let create_LexicographicalView_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "xSize", _LexicographicalView_xSize ;
    "ySize", _LexicographicalView_ySize ;
    "__str__", _LexicographicalView___str__ ;
    "~", _delete_LexicographicalView ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "LexicographicalView") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"LexicographicalView"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_LexicographicalView_from_ptr"
          create_LexicographicalView_from_ptr



let create_Matrix_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "rows", _Matrix_rows ;
    "columns", _Matrix_columns ;
    "__str__", _Matrix___str__ ;
    "~", _delete_Matrix ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Matrix") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Matrix"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Matrix_from_ptr"
          create_Matrix_from_ptr



let create_SalvagingAlgorithm_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_SalvagingAlgorithm ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "SalvagingAlgorithm") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"SalvagingAlgorithm"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_SalvagingAlgorithm_from_ptr"
          create_SalvagingAlgorithm_from_ptr



let create_SVD_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "U", _SVD_U ;
    "V", _SVD_V ;
    "S", _SVD_S ;
    "singularValues", _SVD_singularValues ;
    "~", _delete_SVD ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "SVD") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"SVD"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_SVD_from_ptr"
          create_SVD_from_ptr



let create_Disposable_xx_ldbrace_xx_lparenArray_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_DisposableArray ;
   "::Array", (fun args -> (create_class "Array") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Disposable<(Array)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Array") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Disposable<(Array)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Disposable<Array >_from_ptr"
          create_Disposable_xx_ldbrace_xx_lparenArray_xx_rparen_xx_rdbrace_from_ptr



let create_boost_xxshared_ptr_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "->", _Quote___deref__ ;
    "isNull", _Quote_isNull ;
    "asObservable", _Quote_asObservable ;
    "~", _delete_Quote ;
    "value", _Quote_value ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "boost::shared_ptr<(Quote)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"boost::shared_ptr<(Quote)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_boost::shared_ptr<Quote >_from_ptr"
          create_boost_xxshared_ptr_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_from_ptr



let create_Handle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "->", _QuoteHandle___deref__ ;
    "empty", _QuoteHandle_empty ;
    "asObservable", _QuoteHandle_asObservable ;
    "~", _delete_QuoteHandle ;
    "value", _QuoteHandle_value ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Handle<(Quote)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Handle<(Quote)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Handle<Quote >_from_ptr"
          create_Handle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_from_ptr



let create_RelinkableHandle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "linkTo", _RelinkableQuoteHandle_linkTo ;
    "~", _delete_RelinkableQuoteHandle ;
   "::Handle<(Quote)>", (fun args -> (create_class "Handle<(Quote)>") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "RelinkableHandle<(Quote)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Handle<(Quote)>") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"RelinkableHandle<(Quote)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_RelinkableHandle<Quote >_from_ptr"
          create_RelinkableHandle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_from_ptr



let create_SimpleQuotePtr_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "setValue", _SimpleQuote_setValue ;
    "~", _delete_SimpleQuote ;
   "::boost::shared_ptr<(Quote)>", (fun args -> (create_class "boost::shared_ptr<(Quote)>") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "SimpleQuotePtr") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "boost::shared_ptr<(Quote)>") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"SimpleQuotePtr"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_SimpleQuotePtr_from_ptr"
          create_SimpleQuotePtr_from_ptr



let create_std_xxvector_xx_ldbrace_xx_lparenboost_xxshared_ptr_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _QuoteVector_size ;
    "empty", _QuoteVector_empty ;
    "clear", _QuoteVector_clear ;
    "push_back", _QuoteVector_push_back ;
    "[]", _QuoteVector_operator_xx_xx_lbrace_xx_rbrace ;
    "=", _QuoteVector_operator_xx_xx_equals ;
    "set", _QuoteVector_set ;
    "to_array", _QuoteVector_to_array ;
    "~", _delete_QuoteVector ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "std::vector<(boost::shared_ptr<(Quote)>)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"std::vector<(boost::shared_ptr<(Quote)>)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_std::vector<boost::shared_ptr<Quote > >_from_ptr"
          create_std_xxvector_xx_ldbrace_xx_lparenboost_xxshared_ptr_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_xx_rparen_xx_rdbrace_from_ptr



let create_std_xxvector_xx_ldbrace_xx_lparenHandle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _QuoteHandleVector_size ;
    "empty", _QuoteHandleVector_empty ;
    "clear", _QuoteHandleVector_clear ;
    "push_back", _QuoteHandleVector_push_back ;
    "[]", _QuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace ;
    "=", _QuoteHandleVector_operator_xx_xx_equals ;
    "set", _QuoteHandleVector_set ;
    "to_array", _QuoteHandleVector_to_array ;
    "~", _delete_QuoteHandleVector ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "std::vector<(Handle<(Quote)>)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"std::vector<(Handle<(Quote)>)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_std::vector<Handle<Quote > >_from_ptr"
          create_std_xxvector_xx_ldbrace_xx_lparenHandle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_xx_rparen_xx_rdbrace_from_ptr



let create_std_xxvector_xx_ldbrace_xx_lparenRelinkableHandle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_xx_rparen_xx_rdbrace_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "size", _RelinkableQuoteHandleVector_size ;
    "empty", _RelinkableQuoteHandleVector_empty ;
    "clear", _RelinkableQuoteHandleVector_clear ;
    "push_back", _RelinkableQuoteHandleVector_push_back ;
    "[]", _RelinkableQuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace ;
    "=", _RelinkableQuoteHandleVector_operator_xx_xx_equals ;
    "set", _RelinkableQuoteHandleVector_set ;
    "to_array", _RelinkableQuoteHandleVector_to_array ;
    "~", _delete_RelinkableQuoteHandleVector ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "std::vector<(RelinkableHandle<(Quote)>)>") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"std::vector<(RelinkableHandle<(Quote)>)>"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_std::vector<RelinkableHandle<Quote > >_from_ptr"
          create_std_xxvector_xx_ldbrace_xx_lparenRelinkableHandle_xx_ldbrace_xx_lparenQuote_xx_rparen_xx_rdbrace_xx_rparen_xx_rdbrace_from_ptr



let create_DayCounter_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "dayCount", _DayCounter_dayCount ;
    "yearFraction", _DayCounter_yearFraction ;
    "yearFraction", _DayCounter_yearFraction ;
    "yearFraction", _DayCounter_yearFraction ;
    "__str__", _DayCounter___str__ ;
    "~", _delete_DayCounter ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "DayCounter") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"DayCounter"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_DayCounter_from_ptr"
          create_DayCounter_from_ptr



let create_QuantLib_xxActual360_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Actual360 ;
   "::DayCounter", (fun args -> (create_class "DayCounter") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Actual360") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "DayCounter") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Actual360"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Actual360_from_ptr"
          create_QuantLib_xxActual360_from_ptr



let create_QuantLib_xxActual365Fixed_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Actual365Fixed ;
   "::DayCounter", (fun args -> (create_class "DayCounter") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Actual365Fixed") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "DayCounter") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Actual365Fixed"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Actual365Fixed_from_ptr"
          create_QuantLib_xxActual365Fixed_from_ptr



let create_QuantLib_xxThirty360_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Thirty360 ;
   "::DayCounter", (fun args -> (create_class "DayCounter") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Thirty360") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "DayCounter") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Thirty360"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Thirty360_from_ptr"
          create_QuantLib_xxThirty360_from_ptr



let create_QuantLib_xxActualActual_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_ActualActual ;
   "::DayCounter", (fun args -> (create_class "DayCounter") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::ActualActual") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "DayCounter") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::ActualActual"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::ActualActual_from_ptr"
          create_QuantLib_xxActualActual_from_ptr



let create_QuantLib_xxOneDayCounter_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_OneDayCounter ;
   "::DayCounter", (fun args -> (create_class "DayCounter") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::OneDayCounter") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "DayCounter") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::OneDayCounter"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::OneDayCounter_from_ptr"
          create_QuantLib_xxOneDayCounter_from_ptr



let create_QuantLib_xxSimpleDayCounter_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_SimpleDayCounter ;
   "::DayCounter", (fun args -> (create_class "DayCounter") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::SimpleDayCounter") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "DayCounter") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::SimpleDayCounter"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::SimpleDayCounter_from_ptr"
          create_QuantLib_xxSimpleDayCounter_from_ptr



let create_InterestRate_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "rate", _InterestRate_rate ;
    "dayCounter", _InterestRate_dayCounter ;
    "compounding", _InterestRate_compounding ;
    "frequency", _InterestRate_frequency ;
    "discountFactor", _InterestRate_discountFactor ;
    "discountFactor", _InterestRate_discountFactor ;
    "compoundFactor", _InterestRate_compoundFactor ;
    "compoundFactor", _InterestRate_compoundFactor ;
    "equivalentRate", _InterestRate_equivalentRate ;
    "equivalentRate", _InterestRate_equivalentRate ;
    "equivalentRate", _InterestRate_equivalentRate ;
    "equivalentRate", _InterestRate_equivalentRate ;
    "__str__", _InterestRate___str__ ;
    "~", _delete_InterestRate ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "InterestRate") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"InterestRate"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_InterestRate_from_ptr"
          create_InterestRate_from_ptr



let create_Calendar_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "isBusinessDay", _Calendar_isBusinessDay ;
    "isHoliday", _Calendar_isHoliday ;
    "isEndOfMonth", _Calendar_isEndOfMonth ;
    "addHoliday", _Calendar_addHoliday ;
    "removeHoliday", _Calendar_removeHoliday ;
    "adjust", _Calendar_adjust ;
    "adjust", _Calendar_adjust ;
    "advance", _Calendar_advance ;
    "advance", _Calendar_advance ;
    "advance", _Calendar_advance ;
    "advance", _Calendar_advance ;
    "advance", _Calendar_advance ;
    "advance", _Calendar_advance ;
    "businessDaysBetween", _Calendar_businessDaysBetween ;
    "businessDaysBetween", _Calendar_businessDaysBetween ;
    "businessDaysBetween", _Calendar_businessDaysBetween ;
    "__str__", _Calendar___str__ ;
    "~", _delete_Calendar ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Calendar") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Calendar"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Calendar_from_ptr"
          create_Calendar_from_ptr



let create_QuantLib_xxArgentina_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Argentina ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Argentina") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Argentina"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Argentina_from_ptr"
          create_QuantLib_xxArgentina_from_ptr



let create_QuantLib_xxAustralia_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Australia ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Australia") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Australia"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Australia_from_ptr"
          create_QuantLib_xxAustralia_from_ptr



let create_QuantLib_xxBrazil_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Brazil ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Brazil") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Brazil"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Brazil_from_ptr"
          create_QuantLib_xxBrazil_from_ptr



let create_QuantLib_xxCanada_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Canada ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Canada") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Canada"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Canada_from_ptr"
          create_QuantLib_xxCanada_from_ptr



let create_QuantLib_xxChina_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_China ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::China") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::China"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::China_from_ptr"
          create_QuantLib_xxChina_from_ptr



let create_QuantLib_xxCzechRepublic_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_CzechRepublic ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::CzechRepublic") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::CzechRepublic"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::CzechRepublic_from_ptr"
          create_QuantLib_xxCzechRepublic_from_ptr



let create_QuantLib_xxDenmark_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Denmark ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Denmark") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Denmark"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Denmark_from_ptr"
          create_QuantLib_xxDenmark_from_ptr



let create_QuantLib_xxFinland_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Finland ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Finland") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Finland"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Finland_from_ptr"
          create_QuantLib_xxFinland_from_ptr



let create_QuantLib_xxGermany_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Germany ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Germany") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Germany"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Germany_from_ptr"
          create_QuantLib_xxGermany_from_ptr



let create_QuantLib_xxHongKong_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_HongKong ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::HongKong") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::HongKong"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::HongKong_from_ptr"
          create_QuantLib_xxHongKong_from_ptr



let create_QuantLib_xxHungary_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Hungary ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Hungary") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Hungary"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Hungary_from_ptr"
          create_QuantLib_xxHungary_from_ptr



let create_QuantLib_xxIceland_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Iceland ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Iceland") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Iceland"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Iceland_from_ptr"
          create_QuantLib_xxIceland_from_ptr



let create_QuantLib_xxIndia_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_India ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::India") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::India"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::India_from_ptr"
          create_QuantLib_xxIndia_from_ptr



let create_QuantLib_xxIndonesia_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Indonesia ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Indonesia") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Indonesia"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Indonesia_from_ptr"
          create_QuantLib_xxIndonesia_from_ptr



let create_QuantLib_xxItaly_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Italy ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Italy") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Italy"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Italy_from_ptr"
          create_QuantLib_xxItaly_from_ptr



let create_QuantLib_xxJapan_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Japan ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Japan") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Japan"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Japan_from_ptr"
          create_QuantLib_xxJapan_from_ptr



let create_QuantLib_xxMexico_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Mexico ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Mexico") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Mexico"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Mexico_from_ptr"
          create_QuantLib_xxMexico_from_ptr



let create_QuantLib_xxNewZealand_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_NewZealand ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::NewZealand") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::NewZealand"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::NewZealand_from_ptr"
          create_QuantLib_xxNewZealand_from_ptr



let create_QuantLib_xxNorway_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Norway ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Norway") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Norway"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Norway_from_ptr"
          create_QuantLib_xxNorway_from_ptr



let create_QuantLib_xxPoland_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Poland ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Poland") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Poland"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Poland_from_ptr"
          create_QuantLib_xxPoland_from_ptr



let create_QuantLib_xxSaudiArabia_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_SaudiArabia ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::SaudiArabia") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::SaudiArabia"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::SaudiArabia_from_ptr"
          create_QuantLib_xxSaudiArabia_from_ptr



let create_QuantLib_xxSingapore_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Singapore ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Singapore") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Singapore"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Singapore_from_ptr"
          create_QuantLib_xxSingapore_from_ptr



let create_QuantLib_xxSlovakia_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Slovakia ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Slovakia") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Slovakia"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Slovakia_from_ptr"
          create_QuantLib_xxSlovakia_from_ptr



let create_QuantLib_xxSouthAfrica_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_SouthAfrica ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::SouthAfrica") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::SouthAfrica"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::SouthAfrica_from_ptr"
          create_QuantLib_xxSouthAfrica_from_ptr



let create_QuantLib_xxSouthKorea_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_SouthKorea ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::SouthKorea") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::SouthKorea"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::SouthKorea_from_ptr"
          create_QuantLib_xxSouthKorea_from_ptr



let create_QuantLib_xxSweden_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Sweden ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Sweden") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Sweden"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Sweden_from_ptr"
          create_QuantLib_xxSweden_from_ptr



let create_QuantLib_xxSwitzerland_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Switzerland ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Switzerland") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Switzerland"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Switzerland_from_ptr"
          create_QuantLib_xxSwitzerland_from_ptr



let create_QuantLib_xxTaiwan_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Taiwan ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Taiwan") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Taiwan"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Taiwan_from_ptr"
          create_QuantLib_xxTaiwan_from_ptr



let create_QuantLib_xxTARGET_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_TARGET ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::TARGET") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::TARGET"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::TARGET_from_ptr"
          create_QuantLib_xxTARGET_from_ptr



let create_QuantLib_xxTurkey_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Turkey ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Turkey") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Turkey"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Turkey_from_ptr"
          create_QuantLib_xxTurkey_from_ptr



let create_QuantLib_xxUkraine_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_Ukraine ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::Ukraine") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::Ukraine"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::Ukraine_from_ptr"
          create_QuantLib_xxUkraine_from_ptr



let create_QuantLib_xxUnitedKingdom_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_UnitedKingdom ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::UnitedKingdom") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::UnitedKingdom"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::UnitedKingdom_from_ptr"
          create_QuantLib_xxUnitedKingdom_from_ptr



let create_QuantLib_xxUnitedStates_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_UnitedStates ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::UnitedStates") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::UnitedStates"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::UnitedStates_from_ptr"
          create_QuantLib_xxUnitedStates_from_ptr



let create_QuantLib_xxNullCalendar_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_NullCalendar ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::NullCalendar") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::NullCalendar"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::NullCalendar_from_ptr"
          create_QuantLib_xxNullCalendar_from_ptr



let create_QuantLib_xxJointCalendar_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_JointCalendar ;
   "::Calendar", (fun args -> (create_class "Calendar") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::JointCalendar") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Calendar") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::JointCalendar"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::JointCalendar_from_ptr"
          create_QuantLib_xxJointCalendar_from_ptr



let create_Rounding_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "()", _Rounding_operator_xx_xx_lparen_xx_rparen ;
    "~", _delete_Rounding ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Rounding") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Rounding"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Rounding_from_ptr"
          create_Rounding_from_ptr



let create_UpRounding_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_UpRounding ;
   "::Rounding", (fun args -> (create_class "Rounding") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "UpRounding") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Rounding") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"UpRounding"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_UpRounding_from_ptr"
          create_UpRounding_from_ptr



let create_DownRounding_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_DownRounding ;
   "::Rounding", (fun args -> (create_class "Rounding") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "DownRounding") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Rounding") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"DownRounding"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_DownRounding_from_ptr"
          create_DownRounding_from_ptr



let create_ClosestRounding_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_ClosestRounding ;
   "::Rounding", (fun args -> (create_class "Rounding") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "ClosestRounding") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Rounding") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"ClosestRounding"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_ClosestRounding_from_ptr"
          create_ClosestRounding_from_ptr



let create_CeilingTruncation_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_CeilingTruncation ;
   "::Rounding", (fun args -> (create_class "Rounding") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "CeilingTruncation") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Rounding") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"CeilingTruncation"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_CeilingTruncation_from_ptr"
          create_CeilingTruncation_from_ptr



let create_FloorTruncation_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_FloorTruncation ;
   "::Rounding", (fun args -> (create_class "Rounding") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "FloorTruncation") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Rounding") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"FloorTruncation"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_FloorTruncation_from_ptr"
          create_FloorTruncation_from_ptr



let create_Currency_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "name", _Currency_name ;
    "code", _Currency_code ;
    "numericCode", _Currency_numericCode ;
    "symbol", _Currency_symbol ;
    "fractionSymbol", _Currency_fractionSymbol ;
    "fractionsPerUnit", _Currency_fractionsPerUnit ;
    "rounding", _Currency_rounding ;
    "format", _Currency_format ;
    "empty", _Currency_empty ;
    "triangulationCurrency", _Currency_triangulationCurrency ;
    "__str__", _Currency___str__ ;
    "~", _delete_Currency ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "Currency") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    
		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"Currency"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_Currency_from_ptr"
          create_Currency_from_ptr



let create_QuantLib_xxARSCurrency_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_ARSCurrency ;
   "::Currency", (fun args -> (create_class "Currency") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::ARSCurrency") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Currency") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::ARSCurrency"))
		  in try_parent parent_classes raw_ptr
		end
	end in
	  (fun mth arg -> invoke_inner raw_ptr mth arg)
end

let _ = Callback.register 
          "create_QuantLib::ARSCurrency_from_ptr"
          create_QuantLib_xxARSCurrency_from_ptr



let create_QuantLib_xxATSCurrency_from_ptr raw_ptr =
  C_obj 
begin
  let h = Hashtbl.create 20 in
    List.iter (fun (nm,fn) -> Hashtbl.replace h nm fn) 
	[ "nop", (fun args -> C_void) ;
	      "~", _delete_ATSCurrency ;
   "::Currency", (fun args -> (create_class "Currency") args) ;
 
	 "&", (fun args -> raw_ptr) ;
       ":parents",
       (fun args ->
          C_list
	  (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (x,y) :: !out) h ;
          (List.map	
	     (fun (x,y) ->
		C_string (String.sub x 2 ((String.length x) - 2)))
	     (List.filter
		(fun (x,y) ->
		   ((String.length x) > 2)
		   && x.[0] == ':' && x.[1] == ':') !out)))) ;
       ":classof", (fun args -> C_string "QuantLib::ATSCurrency") ;
       ":methods", (fun args -> 
	  C_list (let out = ref [] in 
	    Hashtbl.iter (fun x y -> out := (C_string x) :: !out) h ; !out))
	] ; 
	let rec invoke_inner raw_ptr mth arg = 
	begin
	  try
	    let application = Hashtbl.find h mth in
	      application
		(match arg with 
		     C_list l -> (C_list (raw_ptr :: l)) 
		   | C_void -> (C_list [ raw_ptr ])
		   | v -> (C_list [ raw_ptr ; v ]))
	  with Not_found -> 
		(* Try parent classes *)
		begin
		  let parent_classes = [
		    (create_class "Currency") ;

		  ] in
		  let rec try_parent plist raw_ptr =
		    match plist with
			p :: tl -> 
			  begin
			    try
			      (invoke (p raw_ptr)) mth arg
			    with (BadMethodName (p,m,s)) -> 
			      try_parent tl raw_ptr
			  end
		      | [] ->
			  raise (BadMethodName (raw_ptr,mth,"QuantLib::ATSCurrency"))
		  in try_parent parent_classes raw_ptr
	