/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2003 StatPro Italia srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <http://quantlib.org/reference/license.html>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

#ifndef quantlib_core_hpp
#define quantlib_core_hpp

#include <ql/qldefines.hpp>

#include <ql/argsandresults.hpp>
#include <ql/calendar.hpp>
#include <ql/capvolstructures.hpp>
#include <ql/cashflow.hpp>
#include <ql/currency.hpp>
#include <ql/date.hpp>
#include <ql/daycounter.hpp>
#include <ql/discretizedasset.hpp>
#include <ql/errors.hpp>
#include <ql/exchangerate.hpp>
#include <ql/exercise.hpp>
#include <ql/grid.hpp>
#include <ql/handle.hpp>
#include <ql/history.hpp>
#include <ql/index.hpp>
#include <ql/instrument.hpp>
#include <ql/money.hpp>
#include <ql/numericalmethod.hpp>
#include <ql/option.hpp>
#include <ql/payoff.hpp>
#include <ql/pricingengine.hpp>
#include <ql/quote.hpp>
#include <ql/schedule.hpp>
#include <ql/settings.hpp>
#include <ql/solver1d.hpp>
#include <ql/stochasticprocess.hpp>
#include <ql/swaptionvolstructure.hpp>
#include <ql/termstructure.hpp>
#include <ql/timegrid.hpp>
#include <ql/types.hpp>
#include <ql/voltermstructure.hpp>
#include <ql/yieldtermstructure.hpp>


#endif
