/*
 *  Copyright (C) 1999
 *  Original author:  Robert Lissner
 *
 *  Current owner:  Bob 
 *
 */


#include "includes.h"
#include "globals.h"

/* prototypes */
void actual_paste (gint cb_row, gint sheet_row, gint col);
void clear_the_range ();
void dim_sum_menu ();
void put_range_on_clipboard ();




/* |--------------------------------|
   |   activate_callback            |
   |--------------------------------|
*/ 
gint activate_callback (GtkSheet *sheet, gint row, gint col) {
  char* textp;
  gboolean flag;
  gint colx, rowx;

  if (row < 0 || col < 0)
    return (TRUE); /* row or column buttons */ 
  
  if (row >=  front->last_row) {
    flag = FALSE;
    if (front->last_row < 7)
      flag = TRUE;
    else 
      for (rowx = front->last_row - 4; 
	   rowx <= front->last_row && !flag; rowx++)
	for (colx = 0; colx <= front->last_field; colx++)
	  if (gtk_sheet_cell_get_text (GTK_SHEET (front->sheet),
				       rowx, colx)) {
	    flag = TRUE;
	    break;
	  }
    if (flag) {
      big_draw_start ();
      add1row (); 
      big_draw_end (); 
    }
  }
  front->sel_range.row0 = front->sel_range.rowi = row;
  front->sel_range.col0 = front->sel_range.coli = col;
  front->sel_type = 'E';
  dim_sum_menu ();

  if (row == front->activate_row && col == front->activate_col)
    return (TRUE);

  check_if_changed ();
  
  if (front->activate_text) {
    g_free (front->activate_text);
    front->activate_text = NULL;
  }

  /* save this activate */
  front->activate_row = row;
  front->activate_col = col;
  front->activate_text = textp = 
    gtk_sheet_cell_get_text (GTK_SHEET (front->sheet), row, col);
  if (textp)
    front->activate_text = g_strdup (textp);
  return (TRUE);
}

/* |--------------------------------|
   |       actual_paste             |
   |--------------------------------|
   Paste one row from clipboard into sheet, at row and col */ 
void actual_paste (gint sheet_row, gint cb_row, gint col) {
  char* linebufp;
  char* prevbufp;
  gint colx;
  gint fieldx;
  prevbufp = linebufp = cb [cb_row];
  colx = col;
  while (*linebufp != '\0') {
    if (*linebufp != '\t')
      linebufp++;
    else {
      if (colx >  front->last_field)
	return;
      *linebufp  = '\0'; /* actually change the clipboard */
      fieldx = front->col_to_field [colx];
      gtk_sheet_set_cell_text (GTK_SHEET (front->sheet), sheet_row, colx,
			       prevbufp);
      *linebufp  = '\t'; /* restore the clipboard */
      
      prevbufp = ++linebufp;
      colx++;
    }
  }
} /* end of actual_paste */ 


/* |--------------------------------|
   |   clear_the_range              |
   |--------------------------------|
*/ 
void clear_the_range () { /*this clears, not for deleting */
  gint rowx;
  gint16 colx;
  big_draw_start ();
  for (rowx = front->sel_range.row0;
       rowx <= front->sel_range.rowi; rowx++) {
  
    if (row_is_visible (rowx))  
      for (colx = front->sel_range.col0; colx <= front->sel_range.coli; colx++)
	gtk_sheet_cell_clear (GTK_SHEET (front->sheet), rowx, colx);
  }
  big_draw_end ();
  front_is_changed ();
} /* end of clear_the_range */


void dim_sum_menu () {
  dim_list_edit_menu ();  
  dim_list_sort_menu ();
  dim_list_column_menu ();  
}

/* |--------------------------------|
   |   edit_cut                     |
   |--------------------------------|
*/ 
 
/* for Edit Menu */
void edit_cut (GtkWidget *w, gpointer *data) {
  gint rowx;
  if (check_if_changed ())
    return;
  big_draw_start ();
  put_range_on_clipboard ();
  if (front->sel_type == 'R') { /* work backwards to keep rowx right */
    for (rowx = front->sel_range.rowi; rowx >= front->sel_range.row0; rowx--)
      if (rowx != front->last_row) {
	if (row_is_visible (rowx)) {
	  unselect ();
	  gtk_sheet_delete_rows (GTK_SHEET (front->sheet), rowx, 1);
	  front->last_row--;
	}
      }
    gtk_sheet_select_row (GTK_SHEET (front->sheet), front->sel_range.row0);
  }
  else 
    clear_the_range ();

  dim_sum_menu ();
  big_draw_end ();
  front_is_changed ();
}


/* |--------------------------------|
   |   edit_ditto                   |
   |--------------------------------|
   Routine copies the cell above.  Intentionally does not work for rows */ 
void edit_ditto (GtkWidget *w, gpointer *data) {
  gint row0;
  gint col0;
  gint rowx;
  char* text;

   if (check_if_changed ())
    return;
if (front->sel_type != 'E')
    return;
  row0 = front->sel_range.row0;
  col0 = front->sel_range.col0;
  for (rowx = row0 - 1; rowx >= 0; rowx--)
    if (row_is_visible (rowx)) {
      text = gtk_sheet_cell_get_text (GTK_SHEET (front->sheet),
				  rowx, col0);
      if (text)
	gtk_sheet_set_cell_text (GTK_SHEET (front->sheet), 
				 row0, col0, text);	
      else 
	gtk_sheet_cell_clear (GTK_SHEET (front->sheet), row0, col0);
      break;
    }
} /* end of edit_ditto */


/* |--------------------------------|
   |        edit_copy               |
   |--------------------------------|
*/
void edit_copy (GtkWidget *w, gpointer *data) {
  if (check_if_changed ())
    return;
  put_range_on_clipboard ();
}



/* |--------------------------------|
   |      edit_clear                |
   |--------------------------------|
*/ 
void edit_clear (GtkWidget *w, gpointer *data){ 
   if (check_if_changed ())
    return;
   big_draw_start ();
   clear_the_range ();
   big_draw_end ();
   front_is_changed ();
}

/* |--------------------------------|
   |      edit_fill_down            |
   |--------------------------------|
*/
void edit_fill_down (GtkWidget *w, gpointer *data){
  gint colx, rowx;
  gchar* text;

   if (check_if_changed ())
     return;
   big_draw_start ();
  if (front->sel_type && front->sel_range.row0 != front->sel_range.rowi) 
    for (colx = front->sel_range.col0; 
	 colx <= front->sel_range.coli; colx++) {
      text = gtk_sheet_cell_get_text (GTK_SHEET (front->sheet),
				      front->sel_range.row0, colx);
      for (rowx = front->sel_range.row0 +1; 
	   rowx <= front->sel_range.rowi; rowx++)  
	if (row_is_visible (rowx)) {
	  if (text)
	    gtk_sheet_set_cell_text (GTK_SHEET (front->sheet), 
				 rowx, colx, text);
	  else
	    gtk_sheet_cell_clear (GTK_SHEET (front->sheet), 
				 rowx, colx);
	}
    }
  big_draw_end ();
  front_is_changed ();
}

/* |--------------------------------|
   |   edit_paste                   |
   |--------------------------------|
*/ 
 
void edit_paste (GtkWidget *w, gpointer *data){
  gint rowx;
  gint start_row = front->sel_range.row0;
  gint start_col = front->sel_range.col0;
  gint cb_row;
  gint sheet_row;
  if (check_if_changed ())
    return;
   if (!paste_is_ok() )
    return;
  big_draw_start ();
  
  /* --------------- paste rows ---------------- */
  if (cb_sel_type == 'R') {
    gtk_sheet_insert_rows (GTK_SHEET (front->sheet), 
			   start_row, cb_rows);
    front->last_row += cb_rows;
    for (rowx = 0; rowx < cb_rows; rowx++) {
      gtk_sheet_row_button_add_label (GTK_SHEET (front->sheet), 
				      start_row + rowx, " "); 
      actual_paste (start_row + rowx, rowx, 0);
    }
    big_draw_end ();
    front_is_changed ();
    return;
  } /* end of type R */

  /* --------------- paste the rest  ---------------- */
  cb_row = 0;
  sheet_row = start_row;
  while (cb_row < cb_rows) {
    if (sheet_row >= front->last_row)
      add1row ();
    if (row_is_visible (sheet_row)) {
      actual_paste (sheet_row, cb_row, start_col);
      cb_row++;
    }
    sheet_row++;
  }
  big_draw_end ();
  front_is_changed ();
} /* end of edit_paste */


void edit_select_all (GtkWidget *w, gpointer *data){
  GtkSheetRange range;
  if (check_if_changed ())
     return;
  range.row0 = range.col0 = 0;
  range.rowi = front->last_row - 1;
  range.coli = front->last_field;
  gtk_sheet_select_range (GTK_SHEET (front->sheet), &range);
}


/* |--------------------------------|
   |      edit_insert_rows          |
   |--------------------------------|
*/
void edit_insert_rows (GtkWidget *w, gpointer *data){
  if (check_if_changed ())
    return;
  if (front->sel_type == 'C')
    return;
  gtk_sheet_insert_rows	(GTK_SHEET (front->sheet), front->sel_range.row0, 1);
  gtk_sheet_row_button_add_label (GTK_SHEET (front->sheet), 
				  front->sel_range.row0, " "); 
  front_is_changed ();
  front->last_row++;  
}


/* |--------------------------------|
   |   new_column_width             |
   |--------------------------------|
*/ 
void new_column_width (GtkSheet *sheet, gint col, gint width) {
  gint fieldx;
  front_is_changed ();
  fieldx = front->col_to_field [col];
  front->fields [fieldx].width = width / 8;
}


/* |--------------------------------|
   |  put_range_on_clipboard        |
   |--------------------------------|
*/ 
void put_range_on_clipboard () {
  gchar linebuf [4096];
  gchar* text;
  char* linebufp;
  gint rowx;
  gint16 colx;
  if (cb_rows) /* get rid of previous contents, if any */
    for (rowx = 0; rowx < cb_rows; rowx++)
      g_free (cb [rowx]);
  cb_sel_type = front->sel_type;
  cb_rows = 0;
  cb_cols = front->sel_range.coli - front->sel_range.col0 + 1;

  for (rowx = front->sel_range.row0;
       rowx <= front->sel_range.rowi; rowx++) {
    if (row_is_visible (rowx)) {
      if (cb_rows >= MAX_CLIPBOARD - 2)
	level1_error ("Clipboard is limited to 5,000 rows", "Go back");
      linebufp = linebuf;
      for (colx = front->sel_range.col0; 
	   colx <= front->sel_range.coli; colx++) {
	text = gtk_sheet_cell_get_text ( GTK_SHEET (front->sheet),
					rowx, colx);
	if (text) {
	 strcpy (linebufp, text);
	 linebufp += strlen (text);
	}
	*linebufp++ = '\t';
     } 
    *linebufp = '\0';
    cb [cb_rows] = g_strdup (linebuf);
    cb_rows++;
    }
  }
}

/* |--------------------------------|
   |        row_is_visible          |
   |--------------------------------|
*/
gboolean row_is_visible (gint testrow) {
  return (GTK_SHEET (front->sheet)->row [testrow].is_visible);
}

/* |--------------------------------|
   |   select_range_callback        |
   |--------------------------------|
*/ 

void select_range_callback (GtkSheet *sheet, GtkSheetRange *range) {
  front->sel_range = *range;
  if (!front->sel_range.row0 && front->sel_range.rowi >= front->last_row)
    front->sel_type = 'C';
  else if (!front->sel_range.col0 
     && front->sel_range.coli >=  front->last_field)
    front->sel_type = 'R';  
  else {
    if (front->sel_range.row0 == front->sel_range.rowi &&
	front->sel_range.col0 == front->sel_range.coli)
      front->sel_type ='E';
    else 
      front->sel_type = 'B';
  }
  dim_sum_menu (); 
}













