/***************************************************************************
 *            help.c
 *
 *  Sun Sep  2 18:16:30 2007
 *  Copyright  2007  Neil Williams
 *  <linux@codehelp.co.uk>
 ****************************************************************************/
/** @file help.c
	@author Copyright 2006, 2007  Neil Williams <linux@codehelp.co.uk>
*/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "config.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <gtkextra/gtksheet.h>
#include "types.h"
#include "dialog_initial.h"
#include "main.h"
#include "quicklist.xpm"
#include "help.h"

void
qlhelp_credits (GtkAction G_GNUC_UNUSED * w, gpointer G_GNUC_UNUSED data)
{
	GtkWidget *aboutdialog;
	const gchar *authors[] = {
		"Neil Williams <linux@codehelp.co.uk>",
		"Jay MacDonald <jay@aztech-cs.com>",
		"Sam Phillips <sam@usaworks.com>",
		"Keith Wesolowski <theman@cs.unr.edu>",
		NULL
	};
	/* TRANSLATORS: Replace this string with your names, one name per line. */
	gchar *translators = _("translator-credits");
	GdkPixbuf *aboutdialog_logo_pixbuf;

	aboutdialog = gtk_about_dialog_new ();
	gtk_about_dialog_set_version (GTK_ABOUT_DIALOG (aboutdialog), VERSION);
	gtk_about_dialog_set_copyright (GTK_ABOUT_DIALOG (aboutdialog),
		"Copyright 2006 Neil Williams <linux@codehelp.co.uk>\n"
			"1999 the QuickList team:");
	gtk_about_dialog_set_comments (GTK_ABOUT_DIALOG (aboutdialog),
		_("GTK2 utility for making lists of things."));
	gtk_about_dialog_set_license (GTK_ABOUT_DIALOG (aboutdialog),
		"This package is free software; you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation; either version 3 of the License, or\n"
		"(at your option) any later version.\n\n"
		"This program is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n"
		"GNU General Public License for more details.\n\n"
		"You should have received a copy of the GNU General Public License \n"
		"along with this program.  If not, see <http://www.gnu.org/licenses/>.\n");
	/* this doesn't give a button unless we make quicklist a gnome app */
	gtk_about_dialog_set_website (GTK_ABOUT_DIALOG (aboutdialog),
		"http://quicklist.sourceforge.net/");
	gtk_about_dialog_set_website_label (GTK_ABOUT_DIALOG (aboutdialog),
		_("Homepage:"));
	gtk_about_dialog_set_authors (GTK_ABOUT_DIALOG (aboutdialog), authors);
	gtk_about_dialog_set_translator_credits (GTK_ABOUT_DIALOG
		(aboutdialog), translators);
	aboutdialog_logo_pixbuf =
		gdk_pixbuf_new_from_xpm_data ((const gchar **)&quicklist_xpm);
	gtk_about_dialog_set_logo (GTK_ABOUT_DIALOG (aboutdialog),
		aboutdialog_logo_pixbuf);
	gtk_dialog_run (GTK_DIALOG(aboutdialog));
	gtk_widget_destroy (aboutdialog);
}

/** \brief find a usable help browser

First preference is yelp with the XML file.
Next is dwww with the HTML version,
x-www-browser with HTML and finally
www-browser with HTML.
*/
void
qlhelp_manual (GtkAction G_GNUC_UNUSED * w, gpointer data)
{
	gchar * cmd;
	GError * err;

	err = NULL;
	if (g_file_test ("/usr/bin/yelp", G_FILE_TEST_EXISTS))
		cmd = g_strconcat ("/usr/bin/yelp ", HELPDIR, "/quicklist.xml", NULL);
	else if (g_file_test ("/usr/bin/dwww", G_FILE_TEST_EXISTS))
		cmd = g_strconcat ("/usr/bin/www-browser ", PACKAGE, NULL);
	else if (g_file_test ("/usr/bin/x-www-browser", G_FILE_TEST_EXISTS))
		cmd = g_strconcat ("/usr/bin/x-www-browser ", DOCDIR, "/index.html", NULL);
	else if (g_file_test ("/usr/bin/www-browser", G_FILE_TEST_EXISTS))
		cmd = g_strconcat ("/usr/bin/www-browser ", DOCDIR, "/index.html", NULL);
	else
	{
		QlContext * qlc;
		GtkWidget * dlg;
		qlc = ql_get_context (GTK_WIDGET(data));
		dlg = gtk_message_dialog_new (GTK_WINDOW(qlc->parent), 
			GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
			"%s", "No help viewer found, please install yelp.");
		g_signal_connect (GTK_OBJECT (dlg), "response", 
			G_CALLBACK (gtk_widget_destroy), dlg);
		gtk_dialog_run (GTK_DIALOG (dlg));
		gtk_widget_destroy (dlg);
		g_warning ("Cannot load quicklist manual, install yelp.");
		return;
	}
	g_spawn_command_line_async (cmd, &err);
	g_free (cmd);
	if (err)
		g_warning (err->message);
	g_clear_error (&err);
}
