/***************************************************************************
 *            edit.h
 *
 *  Fri Aug 25 14:50:51 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/** @file edit.h
	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Robert Lissner
*/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/* callbacks for quickList */

#ifndef _EDIT_H
#define _EDIT_H

#include "main.h"

gboolean row_is_visible (QlTabData * tab, gint testrow);  
void undo_clicked (GtkAction * w, gpointer data);

/* for Edit Menu */
void edit_cut (GtkAction * w, gpointer data);
void edit_copy (GtkAction * w, gpointer data);
/** \brief Routine copies the cell above.

Intentionally does not work for rows */
void edit_ditto (GtkAction * w, gpointer data);
void edit_paste (GtkAction * w, gpointer data);
void edit_clear (GtkAction * w, gpointer data);
void edit_fill_down (GtkAction * w, gpointer data);
void edit_select_all (GtkAction * w, gpointer data);
void edit_insert_rows (GtkAction * w, gpointer data);

void select_range_callback (GtkSheet * sheet, 
	GtkSheetRange * range, gpointer data);
gboolean activate_callback (GtkSheet * sheet, 
	gint row, gint column, gpointer data);
void new_column_width (GtkSheet * sheet, 
	gint col, gint width, gpointer data);

#endif /* _EDIT_H */
