/***************************************************************************
                          qextensionwidget.h  -  description
                             -------------------
    begin                : Sun Aug 20 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef QEXTENSIONWIDGET_H
#define QEXTENSIONWIDGET_H

#include <qdialog.h>
#include <qstring.h>
#include "quiteinsanenamespace.h"
/**
  *@author M. Herder
  */

class QButtonGroup;
class QCheckBox;
class QComboBox;
class QDoubleSpinBox;
class QGridLayout;
class QLabel;
class QLineEdit;
class QListBox;
class QPushButton;
class QRadioButton;
class QSlider;
class QSpinBox;
class QToolButton;
class QWidgetStack;

class QExtensionWidget : public QDialog
{
   Q_OBJECT
public: 
  QExtensionWidget(QWidget* parent=0,const char* name=0,bool modal = true,
                   WFlags f=0);
	~QExtensionWidget();
  /**  */
  bool nonBlockingIO();
  /**  */
  void loadSettings();
  /**  */
  void setPage(int index);
private: // Private attributes
  /**  */
  QLabel* mpWarningLabel;
  /**  */
  QSpinBox* mpWarningSpinBox;
  /**  */
  QGridLayout* mpMainLayout;
  /**  */
  QDoubleSpinBox* mpAutoColorSpin;
  /**  */
  QDoubleSpinBox* mpAutoGraySpin;
  /**  */
  QDoubleSpinBox* mpAutoSizeSpin;
  /**  */
  QCheckBox* mpAutoCheckBox;
  /**  */
  QCheckBox* mpAutoTemplateCheckBox;
  /**  */
  QRadioButton* mpAutoSmallerRadio;
  /**  */
  QSpinBox* mpAutoSmallerSpin;
  /**  */
  QRadioButton* mpAutoGreaterRadio;
  /**  */
  QSpinBox* mpAutoGreaterSpin;
  /**  */
  QButtonGroup* mpAutoButtonGroup;
  /**  */
  QCheckBox* mpWhatsThisCheckBox;
  /**  */
  QCheckBox* mpCheckIoMode;
  /**  */
  QCheckBox* mpSmoothPreviewCheckBox;
  /**  */
  QCheckBox* mpTranslationsCheckBox;
  /**  */
  QRadioButton* mpRadioMM;
  /**  */
  QRadioButton* mpRadioInch;
  /**  */
  QRadioButton* mpRadioCM;
  /**  */
  QComboBox* mpStyleCombo;
  /**  */
  QRadioButton* mpRadioScrollLayout;
  /**  */
  QRadioButton* mpRadioTabLayout;
  /**  */
  QRadioButton* mpRadioListLayout;
  /**  */
  QToolButton* mpButtonDocPath;
  /**  */
  QToolButton* mpButtonTransPath;
  /**  */
  QCheckBox* mpContinousUpdateCheckBox;
  /**  */
  QCheckBox* mpLimitPreviewCheckBox;
  /**  */
  QSpinBox* mpLimitPreviewSpin;
  /**  */
  QToolButton* mpWhatsThisButton;
  /**  */
  QLineEdit* mpEditTransPath;
  /**  */
  QLineEdit* mpEditDocPath;
  /**  */
  QButtonGroup* mpBGroupDrag;
  /**  */
  QButtonGroup* mpBGroupMetricSystem;
  /**  */
  QButtonGroup* mpBGroupLayout;
  /**  */
  QRadioButton* mpTextRadio;
  /**  */
  QLabel* mpTitleLabel;
  /**  */
  QListBox* mpPageListBox;
  /**  */
  QRadioButton* mpImageRadio;
  /**  */
  QWidgetStack* mpPagesStack;
  /**  */
  QCheckBox* mpCheckBoxHistory;
  /**  */
  QCheckBox* mpTransPathCheckBox;
private: //methods
  /**  */
  void createWhatsThisHelp();
  /**  */
  void initWidget();
private slots: // Private slots
  /**  */
  void slotChangeTransPath();
  /**  */
  void slotChangePage(int index);
protected slots:
  void accept();
};
#endif
