"""quixote.mod_python_handler
$HeadURL: svn://svn/repos/trunk/quixote/mod_python_handler.py $
$Id: mod_python_handler.py 20965 2003-03-05 18:40:37Z akuchlin $

mod_python handler for Quixote.  See the "mod_python configuration"
section of doc/web-server.txt for details.
"""

__revision__ = "$Id: mod_python_handler.py 20965 2003-03-05 18:40:37Z akuchlin $"

# adapted from Erno Kuusela's quixote_handler.py, 2001/09/19 GPW

import os, sys
from mod_python import apache
from quixote import Publisher, enable_ptl

class ModPythonPublisher(Publisher):
    def publish_modpython(self, req):
        """publish_modpython() -> None

        Entry point from mod_python.
        """
        self.publish(apache.CGIStdin(req),
                     apache.CGIStdout(req),
                     sys.stderr,
                     apache.build_cgi_env(req))
        return apache.OK

enable_ptl()

name2publisher = {}

def handler(req):
    opts = req.get_options()
    try:
        package = opts['quixote-root-namespace']
    except KeyError:
        package = None

    if not package:
        return apache.HTTP_INTERNAL_SERVER_ERROR
    else:
        pub = name2publisher.get(package)
        if pub is None:
            pub = ModPythonPublisher(package)
            pub.setup_logs()
            name2publisher[package] = pub
        return pub.publish_modpython(req)
