#!/usr/bin/env python
#$HeadURL: svn+ssh://svn/repos/trunk/quixote/setup.py $
#$Id: setup.py 22003 2003-07-14 23:07:08Z nascheme $

# Setup script for Quixote

__revision__ = "$Id: setup.py 22003 2003-07-14 23:07:08Z nascheme $"

import sys, os
from distutils import core
from distutils.extension import Extension
from qx_distutils import qx_build_py

htmltext = Extension(name="quixote._c_htmltext",
                     sources=["src/_c_htmltext.c"])

kw = {'name': "Quixote",
      'version': "0.6.1",
      'description': "A highly Pythonic Web application framework",
      'author': "MEMS Exchange",
      'author_email': "quixote@mems-exchange.org",
      'url': "http://www.mems-exchange.org/software/quixote/",

      'package_dir': {'quixote':os.curdir},
      'packages': ['quixote',  'quixote.demo', 'quixote.form',
                   'quixote.server'],

      'ext_modules': [],

      'cmdclass': {'build_py': qx_build_py},
     }

# The _c_htmltext module requires Python 2.2 features.
if sys.hexversion >= 0x20200a1:
    # Comment out to use the Python implementation of the htmltext type
    kw['ext_modules'].append(htmltext)
    pass

# If we're running Python 2.3, add extra information
if hasattr(core, 'setup_keywords'):
    if 'classifiers' in core.setup_keywords:
        kw['classifiers'] = ['Development Status :: 4 - Beta',
          'Environment :: No Input/Output (Daemon)',
          'License :: OSI Approved :: Python License (CNRI Python License)',
          'Intended Audience :: Developers',
          'Operating System :: Unix',
          'Operating System :: Microsoft :: Windows',
          'Operating System :: MacOS :: MacOS X',
          'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
          ]
    if 'download_url' in core.setup_keywords:
        kw['download_url'] = ('http://www.mems-exchange.org/software/files'
                              '/quixote/Quixote-%s.tar.gz' % kw['version'])

core.setup(**kw)
