# vim: ft=python fileencoding=utf-8 sts=4 sw=4 et:

# Copyright 2016-2021 Florian Bruhin (The Compiler) <mail@qutebrowser.org>
#
# This file is part of qutebrowser.
#
# qutebrowser is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# qutebrowser is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qutebrowser.  If not, see <https://www.gnu.org/licenses/>.

"""Tests for the qutebrowser.app module."""

from PyQt5.QtCore import QBuffer

from qutebrowser.misc import objects
from qutebrowser import app


def test_on_focus_changed_issue1484(monkeypatch, qapp, caplog):
    """Check what happens when on_focus_changed is called with wrong args.

    For some reason, Qt sometimes calls on_focus_changed() with a QBuffer as
    argument. Let's make sure we handle that gracefully.
    """
    monkeypatch.setattr(objects, 'qapp', qapp)

    buf = QBuffer()
    app.on_focus_changed(buf, buf)

    expected = "on_focus_changed called with non-QWidget {!r}".format(buf)
    assert caplog.messages == [expected]
