#ifndef ENCRYPTIONMANAGER_H
#define ENCRYPTIONMANAGER_H

#include <QObject>
#include <QtDebug>
#include <QSettings>
#include <QFile>
#include "qutdes.h"
#include "keysmanager.h"

class EncryptionManager
{
public:
	// management
	EncryptionManager();
	~EncryptionManager();

	// static functions to get default system keys
	static QString getDefaultKey1();
	static QString getDefaultKey2();

	// encrypts with single DES encryption
	QString encryptDES(const QString &_text, const QString &_key);
	// decrypts with single DES decryption
	QString decryptDES(const QString &_cryptogram, const QString &_key);

	// encrypts with  for triple DES encryption
	QString encrypt3DES(const QString &_text, const QString &_key1, const QString &_key2);
	// decrypts with for triple DES decryption
	QString decrypt3DES(const QString &_cryptogram, const QString &_key1, const QString &_key2);

	// function used for password encryption. if des is true 3DES is used
	QString encrypPassword(QString _password, const bool DES);
	// decrypts with password from cryptogram. if des is true 3DES is used
	QString decryptPassword(QString _cryptogram, const bool DES);

	// calls for key management dialog box, keys are passed to pointers targets
	bool callKeysManager(QString &_key1, QString &_key2); 

	// encrypts history file, returning result as Qstring object
	QString giveMeEncryptedXML(QFile *_file);
	// decrypts history
	QString giveMeDecryptedXML(const QString &_string);

	bool checkIfEncrypted(const QString &_string);

	// diagnostics
	void testRun();

private:
	QutDES *cryper;
	KeysManager *KeysMan;
};

#endif // ENCRYPTIONMANAGER_H
