/*
    emoticonMenu

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "emoticonmenu.h"

emoticonMenu::emoticonMenu(QWidget *parent)
    : QWidget(parent)
{
	ui.setupUi(this);

	
}

emoticonMenu::~emoticonMenu()
{
	clearList();
}

void emoticonMenu::setEmoticons(const QHash<QString, QString> &list, const QString &path)
{
	emotList = list;
	emotPath = path;
	clearList();
	int sq  = std::ceil(std::sqrt(list.count()));
	
	int i = 0, j = 0;
	foreach(QString name, list)
	{
		movieLabel *l = new movieLabel;
		QMovie *movie = new QMovie(path + "/" + list.key(name));

		movieList.append(movie);
		l->setMovie(movie);
		movie->setCacheMode(QMovie::CacheAll);
		movie->start();
		labelList.append(l);
		l->setToolTip(name);
		connect(l, SIGNAL(sendMovieTip(const QString &)), this, SIGNAL(insertSmile(const QString &)));
		ui.gridLayout->addWidget(l,i,j);
		if ( j < sq )
			j++;
		else
		{
			i++;
			j = 0;
		}
		movie->stop();
	}
	

}

void emoticonMenu::clearList()
{
	foreach(movieLabel *l, labelList)
		delete l;
	labelList.clear();
	
	foreach(QMovie *m, movieList)
		delete m;
	movieList.clear();
}


void emoticonMenu::hideEvent(QHideEvent *e)
{
	foreach(QMovie *m, movieList)
		m->stop();
//	clearList();
	QWidget::hideEvent(e);
}

void emoticonMenu::showEvent(QShowEvent *e)
{
//	setEmoticons(emotList, emotPath);
	foreach(QMovie *m, movieList)
	{
		m->setCacheMode(QMovie::CacheAll);
		m->start();
	}
	QWidget::showEvent(e);
}
