/*
    icqAccount

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "icqaccount.h"

icqAccount::icqAccount(QObject *parent)
    : QObject(parent)
{
	
}

icqAccount::icqAccount(QSystemTrayIcon *tray, QTreeWidget *contactTree, QString string, QObject *parent)
	: QObject(parent), icqUin(string), contactListTree(contactTree), trayIcon(tray)
{
	currentTrayStatus = false;
	statusTrayMenuExist = false;
	deleteingAccount = false;
	menuExist = false;
	firsTrayMessageIsShown = false;
	positionInStack = 1;
	currentXstatus = 0;
	
	connect ( this, SIGNAL(addToEventList(bool)),
								parent, SLOT(addToEventList(bool)));
	connect ( this, SIGNAL(updateTrayToolTip()),
									parent, SLOT(updateTrayToolTip()));
	
	
	thisIcqProtocol = new oscarProtocol(icqUin,contactListTree,this);
	connect( thisIcqProtocol, SIGNAL(statusChanged(accountStatus)),
			this, SLOT(setStatusIcon(accountStatus)));
	connect( thisIcqProtocol, SIGNAL(systemMessage(const QString &)),
			this, SLOT(systemMessage(const QString &)));
	connect( thisIcqProtocol, SIGNAL(userMessage(const QString &, const QString &, const QString &, userMessageType, bool)),
				this, SLOT(userMessage(const QString &, const QString &, const QString &, userMessageType, bool)));
	connect( thisIcqProtocol, SIGNAL(getNewMessage()),
					this, SLOT(gettingNewMessage()));
	connect( thisIcqProtocol, SIGNAL(readAllMessages()),
						this, SIGNAL(readAllMessages()));
	connect( thisIcqProtocol, SIGNAL(readAllMessages()),
							parent, SLOT(accountReadAllMessages()));
	connect ( thisIcqProtocol->getContactListClass(), SIGNAL(sendGroupList(QHash<quint16, treeGroupItem *>)),
			parent, SLOT(getGroupList(QHash<quint16, treeGroupItem *>)));
	connect ( thisIcqProtocol->getContactListClass(), SIGNAL(buddyChangeStatus(treeBuddyItem *, bool)),
				parent, SLOT(buddyChangeStatus(treeBuddyItem *, bool)));
	connect ( thisIcqProtocol->getContactListClass(), SIGNAL(updateOnlineList()),
					parent, SLOT(updateSorting()));
	connect ( thisIcqProtocol->getContactListClass(), SIGNAL(reupdateList()),
						parent, SLOT(reupdateList()));
	
	
	createIcons();
	createStatusMenu();
	
	chooseStatus = new QAction(*currentIcon, icqUin, this);
	chooseStatus->setCheckable(true);
	connect ( chooseStatus, SIGNAL(triggered()),
			this, SLOT(emitChangeStatus()));
	
	loadAccountSettings();
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	configPath = settings.fileName().section('/', 0, -2);
	
	
//	plugins = new pluginSystem(icqUin, this);
//	thisIcqProtocol->getContactListClass()->plugins = plugins;
//	if (icqUin == "177275187")
//		trayUserMessage("", "me", "hi");
//	createContacts();
}

icqAccount::~icqAccount()
{
	if ( !deleteingAccount )
		saveAccountSettings();
//	delete thisIcqProtocol;

	delete privacyStatus;
	delete statusMenu;
}

void icqAccount::createAccountButton(QGridLayout * gridLayout, QWidget *line, int index)
{
	accountLineButton = new accountButton(line);
	gridLayout->addWidget(accountLineButton, 0, index);
	accountLineButton->setToolTip(icqUin);
	accountLineButton->setIcon(*currentIcon);
	accountLineButton->setPopupMode(QToolButton::InstantPopup);
	accountLineButton->setMenu(statusMenu);

}

void icqAccount::createMenuAccount(QMenu *menu, QAction *before)
{
	accountAction = menu->insertMenu(before, statusMenu);
	menuExist = true;
}

void icqAccount::removeMenuAccount(QMenu *menu)
{
	menuExist = false;
	menu->removeAction(accountAction);
}

void icqAccount::removeAccountButton()
{
	delete accountLineButton;
}

void icqAccount::createSettings(QTreeWidget *settingsTree, QStackedWidget *settingsStack)
{
	settingsChanged = false;
	icqGeneral = new QTreeWidgetItem(settingsTree);
	icqGeneral->setText(0, icqUin);
	icqGeneral->setIcon(0, QIcon(":/icons/qutim.png"));
	generalSettings = new icqSettings;
	settingsStack->addWidget(generalSettings);
	
	
	icqNetwork = new QTreeWidgetItem(settingsTree);
	icqNetwork->setText(0, tr("Network"));
	icqNetwork->setIcon(0, QIcon(":/icons/crystal_project/network.png"));
	icqnetworkSettings = new networkSettings;
	settingsStack->addWidget(icqnetworkSettings);
	
	
	icqCl = new QTreeWidgetItem(settingsTree);
	icqCl->setText(0,tr("Contact list"));
	icqCl->setIcon(0,QIcon(":/icons/crystal_project/contactlist.png"));
	clSettings = new contactListSettings;
	settingsStack->addWidget(clSettings);
	
	msgSett = new QTreeWidgetItem(settingsTree);
	msgSett->setText(0,tr("Messaging"));
	msgSett->setIcon(0,QIcon(":/icons/crystal_project/messaging.png"));
	msgSettings = new messagingSettings;
	settingsStack->addWidget(msgSettings);
	
	statSett = new QTreeWidgetItem(settingsTree);
	statSett->setText(0,tr("Statuses"));
	statSett->setIcon(0,QIcon(":/icons/crystal_project/statuses.png"));
	statSettings = new statusSettings;
	settingsStack->addWidget(statSettings);
	
	histSett = new QTreeWidgetItem(settingsTree);
	histSett->setText(0,tr("History"));
	histSett->setIcon(0,QIcon(":/icons/crystal_project/history.png"));
	histSettings = new historySettings;
	settingsStack->addWidget(histSettings);
	
	eventSett = new QTreeWidgetItem(settingsTree);
	eventSett->setText(0,tr("Events"));
	eventSett->setIcon(0,QIcon(":/icons/crystal_project/events.png"));
	evSettings = new eventsSettings;
	settingsStack->addWidget(evSettings);
	
	antiSpamSett = new QTreeWidgetItem(settingsTree);
	antiSpamSett->setText(0,tr("Anti-spam"));
	antiSpamSett->setIcon(0,QIcon(":/icons/crystal_project/antispam.png"));
	antiSpSettings = new antiSpamSettings;
	settingsStack->addWidget(antiSpSettings);
	
	emoticSett = new QTreeWidgetItem(settingsTree);
	emoticSett->setText(0,tr("Emoticons"));
	emoticSett->setIcon(0,QIcon(":/icons/crystal_project/emoticon.png"));
	emoticSettings = new emoticonSettings;
	settingsStack->addWidget(emoticSettings);
	
	
	loadAllSettings();
	connect(generalSettings, SIGNAL(settingsChanged()),
			this, SLOT(icqSettingsChanged()));
	connect(icqnetworkSettings, SIGNAL(settingsChanged()),
				this, SLOT(icqSettingsChanged()));
	connect(clSettings, SIGNAL(settingsChanged()),
					this, SLOT(icqSettingsChanged()));
	connect(msgSettings, SIGNAL(settingsChanged()),
						this, SLOT(icqSettingsChanged()));
	connect(statSettings, SIGNAL(settingsChanged()),
							this, SLOT(icqSettingsChanged()));
	connect(histSettings, SIGNAL(settingsChanged()),
								this, SLOT(icqSettingsChanged()));
	connect(evSettings, SIGNAL(settingsChanged()),
									this, SLOT(icqSettingsChanged()));
	connect(antiSpSettings, SIGNAL(settingsChanged()),
										this, SLOT(icqSettingsChanged()));
	connect(emoticSettings, SIGNAL(settingsChanged()),
										this, SLOT(icqSettingsChanged()));
	
	connect(generalSettings, SIGNAL(settingsSaved()),
						this, SLOT(generalSettingsChanged()));
	
	connect(icqnetworkSettings, SIGNAL(settingsSaved()),
					this, SLOT(networkSettingsChanged()));
	connect(clSettings, SIGNAL(settingsSaved()),
						thisIcqProtocol->getContactListClass(), SLOT(clSettingsChanged()));
	connect(msgSettings, SIGNAL(settingsSaved()),
							thisIcqProtocol->getContactListClass(), SLOT(msgSettingsChanged()));
	connect(statSettings, SIGNAL(settingsSaved()),
								thisIcqProtocol->getContactListClass(), SLOT(statusSettingsChanged()));
	connect(histSettings, SIGNAL(settingsSaved()),
					thisIcqProtocol->getContactListClass(), SLOT(historySettingsChanged()));
	connect(evSettings, SIGNAL(settingsSaved()),
						thisIcqProtocol->getContactListClass(), SLOT(eventsSettingsChanged()));
	connect(evSettings, SIGNAL(settingsSaved()),
						this, SLOT(eventsSettingsChanged()));
	connect(antiSpSettings, SIGNAL(settingsSaved()),
						thisIcqProtocol->getContactListClass(), SLOT(antispamSettingsChanged()));
	connect(emoticSettings, SIGNAL(settingsSaved()),
						thisIcqProtocol->getContactListClass(), SLOT(emoticonSettingsChanged()));
	
	
//	plugins->addSettings(settingsTree, settingsStack);

}


void icqAccount::removeSettings()
{
	delete icqGeneral;
	delete generalSettings;
	delete icqNetwork;
	delete icqnetworkSettings;
	delete icqCl;
	delete clSettings;
	delete msgSett;
	delete msgSettings;
	delete statSett;
	delete statSettings;
	delete histSett;
	delete histSettings;
	delete eventSett;
	delete evSettings;
	delete antiSpSettings;
	delete antiSpamSett;
	delete emoticSett;
	delete emoticSettings;
	
//	plugins->deleteSettings();
}

void icqAccount::loadAllSettings()
{
	generalSettings->loadSettings(icqUin);
	icqnetworkSettings->loadSettings(icqUin);
	clSettings->loadSettings(icqUin);
	msgSettings->loadSettings(icqUin);
	statSettings->loadSettings(icqUin);
	histSettings->loadSettings(icqUin);
	evSettings->loadSettings(icqUin);
	antiSpSettings->loadSettings(icqUin);
	emoticSettings->loadSettings(icqUin);
}

void icqAccount::saveAllSettings()
{
	generalSettings->saveSettings(icqUin);
	icqnetworkSettings->saveSettings(icqUin);
	clSettings->saveSettings(icqUin);
	msgSettings->saveSettings(icqUin);
	statSettings->saveSettings(icqUin);
	histSettings->saveSettings(icqUin);
	evSettings->saveSettings(icqUin);
	antiSpSettings->saveSettings(icqUin);
	emoticSettings->saveSettings(icqUin);
	settingsChanged = false;
}

void icqAccount::icqSettingsChanged()
{
	emit changeSettingsApply();
	settingsChanged = true;
}

void icqAccount::createIcons()
{
	onlineIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.onlineIcon);
	offlineIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.offlineIcon);
	ffcIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.ffcIcon);
	awayIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.awayIcon);
	naIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.naIcon);
	occupiedIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.occupiedIcon);
	dndIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.dndIcon);
	invisibleIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.invisibleIcon);
	connectingIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.connectingIcon);
	currentIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.offlineIcon);
	
	currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.offlinePath;
	
	lunchIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.lunchIcon);
	evilIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.evilIcon);
	depressionIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.depressionIcon);
	atHomeIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.atHomeIcon);
	atWorkIcon = new QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.atWorkIcon);
	
	
	
}
void icqAccount::createStatusMenu()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	showCustomStatus = settings.value("statuses/customstat",true).toBool();
	
	onlineAction = new QAction(*onlineIcon, tr("Online"), this);
	connect(onlineAction, SIGNAL(triggered()), this, SLOT(setOnlineStatus()));
	
	offlineAction = new QAction(*offlineIcon, tr("Offline"), this);
	connect(offlineAction, SIGNAL(triggered()), this, SLOT(setOfflineStatus()));
	
	ffcAction = new QAction(*ffcIcon, tr("Free for chat"), this);
	connect(ffcAction, SIGNAL(triggered()), this, SLOT(setFfcStatus()));
	
	awayAction = new QAction(*awayIcon, tr("Away"), this);
	connect(awayAction, SIGNAL(triggered()), this, SLOT(setAwayStatus()));
	
	naAction = new QAction(*naIcon, tr("NA"), this);
	connect(naAction, SIGNAL(triggered()), this, SLOT(setNaStatus()));
	
	occupiedAction = new QAction(*occupiedIcon, tr("Occupied"), this);
	connect(occupiedAction, SIGNAL(triggered()), this, SLOT(setOccupiedStatus()));
	
	dndAction = new QAction(*dndIcon, tr("DND"), this);
	connect(dndAction, SIGNAL(triggered()), this, SLOT(setDndStatus()));
	
	invisibleAction = new QAction(*invisibleIcon, tr("Invisible"), this);
	connect(invisibleAction, SIGNAL(triggered()), this, SLOT(setInvisibleStatus()));
	
	lunchAction = new QAction(*lunchIcon, tr("Lunch"), this);
	connect(lunchAction, SIGNAL(triggered()), this, SLOT(setLunchStatus()));
	
	evilAction = new QAction(*evilIcon, tr("Evil"), this);
	connect(evilAction, SIGNAL(triggered()), this, SLOT(setEvilStatus()));
	
	depressionAction = new QAction(*depressionIcon, tr("Depression"), this);
	connect(depressionAction, SIGNAL(triggered()), this, SLOT(setDepressionStatus()));
	
	atHomeAction = new QAction(*atHomeIcon, tr("At Home"), this);
	connect(atHomeAction, SIGNAL(triggered()), this, SLOT(setAtHomeStatus()));
	
	atWorkAction = new QAction(*atWorkIcon, tr("At Work"), this);
	connect(atWorkAction, SIGNAL(triggered()), this, SLOT(setAtWorkStatus()));
	
	
	customStatus = new QAction(tr("Custom status"), this);
	connect(customStatus, SIGNAL(triggered()), this, SLOT(customStatusTriggered()));
	

	
	statusMenu = new QMenu;
	privacyStatus = new QMenu(tr("Privacy status"));
	privacyStatus->setIcon(QIcon(":/icons/crystal_project/privacy.png"));
	
	privacyGroup = new QActionGroup(this);
	
	visibleForAll = new QAction(tr("Visible for all"), this);
	visibleForAll->setCheckable(true);
	privacyGroup->addAction(visibleForAll);
	connect(visibleForAll, SIGNAL(triggered()), this, SLOT(setVisibleForAll()));
	
	visibleForVis = new QAction(tr("Visible only for visible list"), this);
	visibleForVis->setCheckable(true);
	privacyGroup->addAction(visibleForVis);
	connect(visibleForVis, SIGNAL(triggered()), this, SLOT(setVisibleForVis()));
	
	notVisibleForInv = new QAction(tr("Invisible only for invisible list"), this);
	notVisibleForInv->setCheckable(true);
	privacyGroup->addAction(notVisibleForInv);
	connect(notVisibleForInv, SIGNAL(triggered()), this, SLOT(setNotVisibleForInv()));
	
	visibleForContact = new QAction(tr("Visible only for contact list"), this);
	visibleForContact->setCheckable(true);
	privacyGroup->addAction(visibleForContact);
	connect(visibleForContact, SIGNAL(triggered()), this, SLOT(setVisibleForContact()));
		
	invisibleForAll = new QAction(tr("Invisible for all"), this);
	invisibleForAll->setCheckable(true);
	privacyGroup->addAction(invisibleForAll);
	connect(invisibleForAll, SIGNAL(triggered()), this, SLOT(setInvisibleForAll()));
	
	privacyStatus->addAction(visibleForAll);
	privacyStatus->addAction(visibleForVis);
	privacyStatus->addAction(notVisibleForInv);
	privacyStatus->addAction(visibleForContact);
	privacyStatus->addAction(invisibleForAll);
	
	
	
	statusMenu->setTitle(icqUin);
	statusMenu->setIcon(*currentIcon);
	statusMenu->addAction(onlineAction);
	statusMenu->addAction(ffcAction);
	statusMenu->addAction(awayAction);
	
	statusMenu->addAction(lunchAction);
	statusMenu->addAction(evilAction);
	statusMenu->addAction(depressionAction);
	statusMenu->addAction(atHomeAction);
	statusMenu->addAction(atWorkAction);
	
	statusMenu->addAction(naAction);
	statusMenu->addAction(occupiedAction);
	statusMenu->addAction(dndAction);
	statusMenu->addAction(invisibleAction);
	statusMenu->addSeparator();
	statusMenu->addAction(customStatus);
	statusMenu->addSeparator();
	statusMenu->addMenu(privacyStatus);
	statusMenu->addAction(offlineAction);
	
	updateStatusMenu(showCustomStatus);
	
	
	
	quint32 privacy = settings.value("statuses/privacy", 4).toUInt();
	
	switch( privacy )
	{
	case 1:
		visibleForAll->setChecked(true);
		break;
	case 2:
		visibleForVis->setChecked(true);
		break;
	case 3:
		notVisibleForInv->setChecked(true);
		break;
	case 4:
		visibleForContact->setChecked(true);
		break;
	case 5:
		invisibleForAll->setChecked(true);
		break;
	default:	
		visibleForContact->setChecked(true);
	}
	
}

void icqAccount::setStatusIcon(accountStatus status)
{
	switch ( status )
	{
	case online:
		*currentIcon = *onlineIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.onlinePath;
		break;
	
	case ffc:
		*currentIcon = *ffcIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.ffcPath;
		break;
		
	case away:
		*currentIcon = *awayIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.awayPath;
		break;
		
	case na:
		*currentIcon = *naIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.naPath;
		break;
		
	case occupied:
		*currentIcon = *occupiedIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.occupiedPath;
		break;
	
	case dnd:
		*currentIcon = *dndIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.dndPath;
		break;
		
	case invisible:
		*currentIcon = *invisibleIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.invisiblePath;
		break;
		
	case offline:
		*currentIcon = *offlineIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.offlinePath;
		break;
		
	case connecting:
		*currentIcon = *connectingIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.connectingPath;
		break;
	
	case lunch:
		*currentIcon = *lunchIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.lunchPath;
		break;
		
	case evil:
		*currentIcon = *evilIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.evilPath;
		break;
			
	case depression:
		*currentIcon = *depressionIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.depressionPath;
		break;
	
	case athome:
		*currentIcon = *atHomeIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.atHomePath;
		break;
	case atwork:
		*currentIcon = *atWorkIcon;
		currentIconPath = thisIcqProtocol->getContactListClass()->statusIconObject.atWorkPath;
		break;
			
	default:
		break;
	}
	
	updateIconStatus();
	emit updateTrayToolTip();
}

void icqAccount::setOnlineStatus()
{
	
	
	
	thisIcqProtocol->setStatus(online);
}

void icqAccount::setOfflineStatus()
{
	thisIcqProtocol->userDisconnected = true;
	thisIcqProtocol->setStatus(offline);
}

void icqAccount::setFfcStatus()
{
	thisIcqProtocol->setStatus(ffc);
}

void icqAccount::setAwayStatus()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	if ( !settings.value("autoreply/awaydshow", false).toBool())
	{
		statusDialog sDialog;
		sDialog.setStatusMessage(settings.value("autoreply/awaymsg", "").toString());
		if ( sDialog.exec() )
		{
			settings.setValue("autoreply/awaydshow", sDialog.dontShow);
			settings.setValue("autoreply/awaymsg", sDialog.statusMessage.left(1000));
			thisIcqProtocol->setStatus(away);
		}
	} else 
		thisIcqProtocol->setStatus(away);
}

void icqAccount::setNaStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/nadshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/namsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/nadshow", sDialog.dontShow);
				settings.setValue("autoreply/namsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(na);
			}
		} else 
			thisIcqProtocol->setStatus(na);
}

void icqAccount::setOccupiedStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/occupieddshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/occupiedmsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/occupieddshow", sDialog.dontShow);
				settings.setValue("autoreply/occupiedmsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(occupied);
			}
		} else 
			thisIcqProtocol->setStatus(occupied);
}

void icqAccount::setDndStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/dnddshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/dndmsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/dnddshow", sDialog.dontShow);
				settings.setValue("autoreply/dndmsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(dnd);
			}
		} else 
			thisIcqProtocol->setStatus(dnd);
}

void icqAccount::setInvisibleStatus()
{
	thisIcqProtocol->setStatus(invisible);
	
	
}

void icqAccount::setLunchStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/lunchdshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/lunchmsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/lunchdshow", sDialog.dontShow);
				settings.setValue("autoreply/lunchmsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(lunch);
			}
		} else 
			thisIcqProtocol->setStatus(lunch);
}


void icqAccount::setEvilStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/evildshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/evilmsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/evildshow", sDialog.dontShow);
				settings.setValue("autoreply/evilmsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(evil);
			}
		} else 
			thisIcqProtocol->setStatus(evil);
}

void icqAccount::setDepressionStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/depressiondshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/depressionmsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/depressiondshow", sDialog.dontShow);
				settings.setValue("autoreply/depressionmsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(depression);
			}
		} else 
			thisIcqProtocol->setStatus(depression);
}

void icqAccount::setAtHomeStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/athomedshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/athomemsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/athomedshow", sDialog.dontShow);
				settings.setValue("autoreply/athomemsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(athome);
			}
		} else 
			thisIcqProtocol->setStatus(athome);
}

void icqAccount::setAtWorkStatus()
{
	
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
		if ( !settings.value("autoreply/atworkdshow", false).toBool())
		{
			statusDialog sDialog;
			sDialog.setStatusMessage(settings.value("autoreply/atworkmsg", "").toString());
			if ( sDialog.exec() )
			{
				settings.setValue("autoreply/atworkdshow", sDialog.dontShow);
				settings.setValue("autoreply/atworkmsg", sDialog.statusMessage.left(1000));
				thisIcqProtocol->setStatus(atwork);
			}
		} else 
			thisIcqProtocol->setStatus(atwork);
}


void icqAccount::updateIconStatus()
{
	accountLineButton->setIcon(*currentIcon);
	if ( menuExist )
		accountAction->setIcon(*currentIcon);
	if ( statusTrayMenuExist)
		chooseStatus->setIcon(*currentIcon);
	
	if ( currentTrayStatus )
		emit statusChanged(currentIcon);
}

void icqAccount::createTrayMenuStatus(QMenu *menu)
{
	menu->addAction(chooseStatus);
	chooseStatus->setIcon(*currentIcon);
	statusTrayMenuExist = true;
}

void icqAccount::removeTrayMenuStatus(QMenu *menu)
{
	menu->removeAction(chooseStatus);
	statusTrayMenuExist = false;
}

void icqAccount::emitChangeStatus()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim", "mainsettings");
	settings.setValue("systray/current", icqUin);
	emit changeStatusInTrayMenu(icqUin); 
}

void icqAccount::loadAccountSettings()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	autoConnect = settings.value("connection/auto", true).toBool();
	
	thisIcqProtocol->reconnectOnDisc = settings.value("connection/reconnect", true).toBool();
	
	settings.beginGroup("clientid");
	
	clientIndex = settings.value("index", 0).toUInt();
	protocolVersion = settings.value("protocol", 1).toUInt();

		clientCap1 = settings.value("cap1").toString();
		clientCap2 = settings.value("cap2").toString();
		clientCap3 = settings.value("cap3").toString();
	
	settings.endGroup();
	
	
	networkSettingsChanged();
	
	
	settings.beginGroup("events");
	showBalloon = settings.value("showballoon", false).toBool();
	
	balloonTime = settings.value("balloontime", 5).toInt();
	balloonTime = balloonTime < 1 ? 1 : balloonTime;
	balloonTime = balloonTime > 60 ? 60 : balloonTime;
	
	dontShowifNA = settings.value("dshowna", false).toBool();
	
	showTrayMessages = settings.value("showtray", true).toBool();
	
	int width = settings.value("width", 200).toInt();
	width = width < 100 ? 100 : width;
	width = width > 500 ? 500 : width;
	trayMessageWidth = width;
	
	int height = settings.value("height", 150).toInt();
	height = height < 100 ? 100 : height;
	height = height > 400 ? 400 : height;
	trayMessageHeight = height;
	
	int trayTime = settings.value("traytime", 6).toInt();
	trayTime = trayTime < 1 ? 1 : trayTime;
	trayTime = trayTime > 60 ? 60 : trayTime;
	trayMessageTime = trayTime;
	
	
	int position = settings.value("position", 3).toInt();
	position = position < 0 ? 0 : position;
	position= position > 3 ? 3 : position;
	trayMessagePosition = position;
	
	int style = settings.value("style", 2).toInt();
	style = style < 0 ? 0 : style;
	style = style > 2 ? 2 : style;
	trayMessageStyle = style;
	
	settings.endGroup();
	
	currentXstatus = settings.value("xstatus/index", 0).toInt();
	if ( currentXstatus )
	{
		customStatus->setIcon(QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.xstatusList.at(currentXstatus - 1)));
	}else 
		customStatus->setIcon(QIcon());
}

void icqAccount::saveAccountSettings()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	if (  thisIcqProtocol->getStatus() != offline )
	{
		
		settings.setValue("connection/currstatus",thisIcqProtocol->getStatus());
	} else {
		settings.remove("connection/currstatus");
	}
}

bool icqAccount::getAutoConnect()
{
	return autoConnect;
}

void icqAccount::autoconnecting()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	if ( settings.value("connection/statonexit", true).toBool() )
		thisIcqProtocol->setStatus(static_cast<accountStatus>(settings.value("connection/currstatus", 0).toInt()));
	else
		thisIcqProtocol->setStatus(online);
}

void icqAccount::createContacts()
{
		
}

void icqAccount::systemMessage(const QString &message)
{
	bool showTrue = true;
	
	if ( dontShowifNA )
	{
		if ( thisIcqProtocol->getStatus() == na || 
				thisIcqProtocol->getStatus() == occupied)
			showTrue = false;
	}
	
	if ( showBalloon  && showTrue)
		trayIcon->showMessage(tr("System message for : %1").arg(icqUin), message, QSystemTrayIcon::NoIcon, balloonTime * 1000);
	if ( showTrayMessages && showTrue )
		traySystemMessage(message);
}

void icqAccount::userMessage(const QString &fromUin, const QString &from, const QString &message, userMessageType type, bool fromList)
{
	bool showTrue = true;
	QString trayMessageMsg;
		
	if ( dontShowifNA )
	{
		if ( thisIcqProtocol->getStatus() == na || 
				thisIcqProtocol->getStatus() == occupied)
			showTrue = false;
	}
	
	
	QString msg;
	switch ( type )
	{
	case statusNotyfication:	
				msg = from + " " + message;
				trayMessageMsg =  message;
				break;
			case messageNotification:
				msg = tr("Message from %1:\n%2").arg(from).arg(message);
				trayMessageMsg = message;
				break;
			case readNotification:
				msg = tr("%1 is reading your away message").arg(from);
				trayMessageMsg = tr("reading your away message");
				if ( !fromList )
					msg.append(tr("(not from list)"));
				
				
				break;
			case xstatusReadNotification:
				msg = tr("%1 is reading your xStatus message").arg(from);
				trayMessageMsg = tr("reading your xStatus message");
				if ( !fromList )
					msg.append(tr("(not from list)"));
				
				
				break;	
			case typingNotification:
				msg = tr("%1 is typing").arg(from);
				trayMessageMsg = tr("typing");
				
				if ( !fromList )
					msg.append(tr("(not from list)"));
				
				break;
			case blockedMessage:
				msg = tr("Blocked message from %1:\n%2").arg(from).arg(message);
				trayMessageMsg = "(BLOCKED)\n" + message;
				break;
			default:
				;
	}
	
	if ( showBalloon && showTrue)
	{
		
	trayIcon->showMessage(tr("User message for : %1").arg(icqUin), msg, QSystemTrayIcon::NoIcon, balloonTime * 1000);
	}
	
	if ( showTrayMessages && showTrue )
	{
		trayUserMessage(fromUin, from, trayMessageMsg);
	}
}

void icqAccount::removeContactList()
{
	thisIcqProtocol->removeContactList();
}

void icqAccount::readMessageStack()
{
	thisIcqProtocol->readreadMessageStack();
}

void icqAccount::networkSettingsChanged()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	thisIcqProtocol->sendKeepAlive(settings.value("connection/alive", true).toBool());
	
}

void icqAccount::updateStatusMenu(bool f)
{
	showCustomStatus = f;
	lunchAction->setVisible(f);
	evilAction->setVisible(f);
	depressionAction->setVisible(f);
	atHomeAction->setVisible(f);
	atWorkAction->setVisible(f);
}

void icqAccount::setVisibleForAll()
{
	thisIcqProtocol->getContactListClass()->changePrivacy(1);
}

void icqAccount::setVisibleForVis()
{
	thisIcqProtocol->getContactListClass()->changePrivacy(2);
}

void icqAccount::setNotVisibleForInv()
{
	thisIcqProtocol->getContactListClass()->changePrivacy(3);	
}

void icqAccount::setVisibleForContact()
{
	thisIcqProtocol->getContactListClass()->changePrivacy(4);
}

void icqAccount::setInvisibleForAll()
{
	thisIcqProtocol->getContactListClass()->changePrivacy(5);
}

void icqAccount::eventsSettingsChanged()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	
	settings.beginGroup("events");
	showBalloon = settings.value("showballoon", false).toBool();
		
	balloonTime = settings.value("balloontime", 5).toInt();
	balloonTime = balloonTime < 1 ? 1 : balloonTime;
	balloonTime = balloonTime > 60 ? 60 : balloonTime;
		
	dontShowifNA = settings.value("dshowna", false).toBool();
	
	
	showTrayMessages = showTrayMessages = settings.value("showtray", true).toBool();
	
	int width = settings.value("width", 200).toInt();
	width = width < 100 ? 100 : width;
	width = width > 500 ? 500 : width;
	trayMessageWidth = width;
	
	int height = settings.value("height", 150).toInt();
	height = height < 100 ? 100 : height;
	height = height > 400 ? 400 : height;
	trayMessageHeight = height;
	
	int trayTime = settings.value("traytime", 6).toInt();
	trayTime = trayTime < 1 ? 1 : trayTime;
	trayTime = trayTime > 60 ? 60 : trayTime;
	trayMessageTime = trayTime;
	
	
	int position = settings.value("position", 3).toInt();
	position = position < 0 ? 0 : position;
	position= position > 3 ? 3 : position;
	trayMessagePosition = position;
	
	int style = settings.value("style", 2).toInt();
	style = style < 0 ? 0 : style;
	style = style > 2 ? 2 : style;
	trayMessageStyle = style;
	
	
	settings.endGroup();	
}

void icqAccount::traySystemMessage(const QString &msg)
{
	if ( !firsTrayMessageIsShown )
		{
				firsTrayMessageIsShown = true;
				positionInStack = 1;
		}
		
		trayMessage *trayMessageWindow = new trayMessage("", trayMessageWidth, 
				trayMessageHeight, trayMessageTime, trayMessagePosition, 
				trayMessageStyle, positionInStack , false);
		
		
		trayMessageWindow->setSystemData(thisIcqProtocol->getContactListClass()->accountNickname,msg);
		
		
		trayMessageWindow->firstTrayWindow = firsTrayMessageIsShown;
		
		connect( trayMessageWindow, SIGNAL(destroyed ( QObject *)),
								this, SLOT(deleteTrayWindow(QObject *)));
		
		trayMessageWindow->showTrayMessage();
		
		if ( (++positionInStack) > 3)
			positionInStack = 3;
		
		trayMessagesList.append(trayMessageWindow);
}

void icqAccount::trayUserMessage(const QString &fromUin, const QString &from, const QString &msg )
{
	
	if ( !firsTrayMessageIsShown )
	{
			firsTrayMessageIsShown = true;
			positionInStack = 1;
	}
	
	trayMessage *trayMessageWindow = new trayMessage(fromUin, trayMessageWidth, 
			trayMessageHeight, trayMessageTime, trayMessagePosition, 
			trayMessageStyle, positionInStack );
	
	
	trayMessageWindow->setData(thisIcqProtocol->getContactListClass()->accountNickname,
			from, getIconPathForUin(fromUin), msg);
	
	
	trayMessageWindow->firstTrayWindow = firsTrayMessageIsShown;
	
	connect( trayMessageWindow, SIGNAL(destroyed ( QObject *)),
							this, SLOT(deleteTrayWindow(QObject *)));
	connect( trayMessageWindow, SIGNAL(startChat ( const QString &)),
								thisIcqProtocol->getContactListClass(), SLOT(startChatWith ( const QString &)));
	
	trayMessageWindow->showTrayMessage();
	
	if ( (++positionInStack) > 3)
		positionInStack = 3;
	
	trayMessagesList.append(trayMessageWindow);
}

void icqAccount::deleteTrayWindow(QObject *obj)
{
	trayMessage *tempWindow = (trayMessage *)(obj);
	
	if ( tempWindow->firstTrayWindow )
		firsTrayMessageIsShown = false;
	
	trayMessagesList.removeAll(tempWindow);
}

QString icqAccount::getIconPathForUin(const QString &uin)
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "contacts");
	
	
	QString hashName = settings.value((uin + "/iconhash"), "").toByteArray();
	if ( !hashName.isEmpty( ) )
		return (configPath + "/icqicons/" + hashName);
	else
		return QString("");
}

void icqAccount::generalSettingsChanged()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	thisIcqProtocol->getContactListClass()->setAvatarDisabled(settings.value("connection/disavatars", false).toBool());
	thisIcqProtocol->reconnectOnDisc = settings.value("connection/reconnect", true).toBool();
	
	
	settings.beginGroup("clientid");
	
	unsigned newClientIndex = settings.value("index", 0).toUInt();
	unsigned newProtocolVersion = settings.value("protocol", 1).toUInt();

	QString newClientCap1 = settings.value("cap1").toString();
	QString	newClientCap2 = settings.value("cap2").toString();
	QString	newClientCap3 = settings.value("cap3").toString();
	
	settings.endGroup();
	
	if (checkClientIdentification(newClientIndex, newProtocolVersion,
			newClientCap1, newClientCap2, newClientCap3))
		thisIcqProtocol->resendCapabilities();
	
}

bool icqAccount::checkClientIdentification(unsigned index, unsigned pVersion, const QString &cap1, const QString &cap2, const QString &cap3)
{
	bool changed = false;
	
	changed = (index == clientIndex ? changed : true); 
	changed = (pVersion == protocolVersion ? changed : true); 
	changed = (cap1 == clientCap1 ? changed : true); 
	changed = (cap2 == clientCap2 ? changed : true); 
	changed = (cap3 == clientCap3 ? changed : true); 
	
	
	clientIndex = index;
	protocolVersion = pVersion;
	clientCap1 = cap1;
	clientCap2 = cap2;
	clientCap3 = cap3;
	
	return changed;
}

void icqAccount::customStatusTriggered()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	settings.beginGroup("xstatus");
	customStatusDialog dialog;
	QPoint point = accountLineButton->mapToGlobal(QPoint(0,0));
	dialog.move(point.x() - dialog.width(), point.y() - dialog.height());
	dialog.setStatuses(settings.value("index", 0).toInt(), thisIcqProtocol->getContactListClass()->statusIconObject.xstatusList);
	dialog.setCaption(settings.value("caption", "").toString());
	dialog.setMessage(settings.value("message", "").toString());
	if ( dialog.exec() )
	{
		settings.setValue("index", dialog.status);
		settings.setValue("caption", dialog.statusCaption);
		settings.setValue("message", dialog.statusMessage);
		currentXstatus = dialog.status;
		if ( currentXstatus )
		{
			customStatus->setIcon(QIcon(thisIcqProtocol->getContactListClass()->statusIconObject.xstatusList.at(currentXstatus - 1)));
		} else 
			customStatus->setIcon(QIcon());
		thisIcqProtocol->sendOnlyCapabilities();
	}
	settings.endGroup();
	

}
