/*
    passwordChangeDialog

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "passwordchangedialog.h"

passwordChangeDialog::passwordChangeDialog(const QString &u,QWidget *parent)
    : QDialog(parent), ownerUin(u)
{
	ui.setupUi(this);
	setFixedSize(size());
	move(desktopCenter());
}

passwordChangeDialog::~passwordChangeDialog()
{

}

QPoint passwordChangeDialog::desktopCenter()
{
	QDesktopWidget desktop;
	return QPoint(desktop.width() / 2 - size().width() / 2, desktop.height() / 2 - size().height() / 2);
}

void passwordChangeDialog::on_changeButton_clicked()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+ownerUin, "account");	
//	QString pass = settings.value("main/password").toString();
	bool des3 = settings.value("encryption/pass3DES", false).toBool();
	EncryptionManager encrypt;
	QString pass = encrypt.decryptPassword(settings.value("main/password").toString(),des3);
	
	if ( ui.currentEdit->text() != pass )
	{
		QMessageBox::warning(this, tr("Password error"),
						                   tr("Current password is invalid"));
		return;
	}
	
	if ( ui.newEdit->text() != ui.lineEdit->text() )
	{
		QMessageBox::warning(this, tr("Password error"),
						                   tr("Confirm password does not match"));
		return;
	}
	
	newPass = ui.newEdit->text();
	settings.setValue("main/password",encrypt.encrypPassword(newPass, des3));
	
//	settings.setValue("main/password", newPass);
	accept();
}
