/*
    trayMessage

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "traymessage.h"

trayMessage::trayMessage(const QString & u,int width, int height, int t, int pos, int st, int psInStack, bool f, QWidget *parent)
    : QWidget(parent)
{
	ui.setupUi(this);
	ui.nickLabel->installEventFilter(this);
	
	connect(ui.textBrowser, SIGNAL(closeWindow()), this, SLOT(close()));
	connect(ui.textBrowser, SIGNAL(startChat()), this, SLOT(startChatSlot()));
	
	time = t;
	contactUin = u;
	position = pos;
	style = st;
	positionInStack = psInStack;
	firstTrayWindow = false;
	userMessage = f;
	setFixedSize(QSize(width, height));
	setAttribute(Qt::WA_QuitOnClose, false);
	setAttribute(Qt::WA_DeleteOnClose, true);
	QTimer::singleShot((time + 1) * 1000, this, SLOT(close()) );
	setWindowFlags(windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint | Qt::ToolTip);
}

trayMessage::~trayMessage()
{
	
}

void trayMessage::showTrayMessage()
{
	QDesktopWidget desktopSize;
	QRect geometry = desktopSize.availableGeometry();
	moveToPointX = 0;
	moveToPointY = 0;
	switch( position )
	{
	case 0:
		moveToPointX = geometry.x();
		moveToPointY = geometry.y() + ( positionInStack - 1 ) * height();
		break;
	case 1:
		moveToPointX = geometry.width() - width();
		moveToPointY = geometry.y() + ( positionInStack - 1 ) * height();
		break;
	case 2:
		moveToPointX = geometry.x();
		moveToPointY = geometry.height() - positionInStack * height();
		break;
	case 3:
		moveToPointX = geometry.width() - width();
		moveToPointY = geometry.height() - positionInStack * height();
		break;
	default:
		moveToPointX = geometry.width() - width();
		moveToPointY = geometry.height() - positionInStack * height();
	}
	slide();
}

void trayMessage::slide()
{
	fromX = 0;
	fromY = 0;
	switch (style )
	{
	case 0:
		move(moveToPointX, moveToPointY);
		show();
		break;
	case 1:
		if ( position == 0 || position == 1)
		{
			fromX = moveToPointX;
			fromY = moveToPointY - height();
			move(fromX, fromY);
			show();
			slideVerticallyDown();
		} else if ( position == 2 || position == 3)
		{
			fromX = moveToPointX;
			fromY = moveToPointY + height();
			move(fromX, fromY);
			show();
			slideVerticallyUp();
		}
		break;
	case 2:
		if ( position == 0 || position == 2)
		{
			fromX = moveToPointX - width();
			fromY = moveToPointY;
			move(fromX, fromY);
			show();
			slideHorizontallyRight();
		} else if ( position == 1 || position == 3)
		{
			fromX = moveToPointX + width();
			fromY = moveToPointY;
			move(fromX, fromY);
			show();
			slideHorizontallyLeft();
		}
		break;
	default:
		move(moveToPointX, moveToPointY);
		show();
	}
	
}

void trayMessage::slideVerticallyUp()
{
	fromY -= 5;
		
	if ( fromY >= moveToPointY)
		{
			move(moveToPointX, fromY);
			QTimer::singleShot(10, this, SLOT(slideVerticallyUp()) );
		}
}

void trayMessage::slideVerticallyDown()
{
	fromY += 5;
	if ( fromY <= moveToPointY)
	{
		move(moveToPointX, fromY);
		QTimer::singleShot(10, this, SLOT(slideVerticallyDown()) );
	}
}

void trayMessage::slideHorizontallyRight()
{
	fromX += 5;
	if ( fromX <= moveToPointX)
	{
		move(fromX, moveToPointY);
		QTimer::singleShot(10, this, SLOT(slideHorizontallyRight()) );
	}	
}

void trayMessage::slideHorizontallyLeft()
{
	fromX -= 5;
	if ( fromX >= moveToPointX)
	{
		move(fromX, moveToPointY);
		QTimer::singleShot(10, this, SLOT(slideHorizontallyLeft()) );
	}	
}

void trayMessage::setData(const QString &mineNick, const QString &from, 
		const QString &picturePath, const QString &msg)
{
	ui.nickLabel->setText(tr("<b>%1</b>").arg(Qt::escape(mineNick)));
//	ui.nickLabel->setStyleSheet("{ background-color: yellow }");
	
	ui.textBrowser->setData(from, picturePath, msg);
	
}

bool trayMessage::eventFilter(QObject *obj, QEvent *event)
{
	if(event->type() == QEvent::MouseButtonPress)
	{
		QMouseEvent *mevent = (QMouseEvent *) event;
		if ( mevent->button() == Qt::LeftButton )
			close();
		else if (mevent->button() == Qt::RightButton )
			startChatSlot();
	}
	return QWidget::eventFilter(obj,event);
}

void trayMessage::startChatSlot()
{
	if ( userMessage )
		emit startChat(contactUin);
	close();
}

void trayMessage::setSystemData(const QString& nickName, const QString &msg)
{
	ui.nickLabel->setText(tr("<b>%1</b>").arg(Qt::escape(nickName)));
	ui.textBrowser->setSystemData(msg);
}
