/*
    mainSettings

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/

#include "mainsettings.h"

mainSettings::mainSettings(QWidget *parent)
    : QWidget(parent)
{
	ui.setupUi(this);
	resetStates(); // reset widgets states
	connect(ui.sizePosBox, SIGNAL(stateChanged(int)),
			this, SLOT(sizePosBoxChanged(int)));
	connect(ui.hideBox, SIGNAL(stateChanged(int)),
				this, SLOT(hideBoxChanged(int)));
	connect(ui.loginDialogBox, SIGNAL(stateChanged(int)),
					this, SLOT(widgetStateChanged()));
	connect(ui.menuAccountBox,SIGNAL(stateChanged(int)),
			this, SLOT(widgetStateChanged()));
	connect(ui.showSettingsBox,SIGNAL(stateChanged(int)),
			this, SLOT(widgetStateChanged()));
	connect(ui.accountBox,SIGNAL(currentIndexChanged(int)),
			this, SLOT(widgetStateChanged()));
	connect(ui.noSysTrayButton,SIGNAL(toggled(bool)),
			this, SLOT(widgetStateChanged()));
	connect(ui.statusFromButton,SIGNAL(toggled(bool)),
				this, SLOT(widgetStateChanged()));
	connect(ui.trayAccountBox,SIGNAL(currentIndexChanged(int)),
				this, SLOT(widgetStateChanged()));
	connect(ui.inSysTrayBox, SIGNAL(stateChanged(int)),
			this, SLOT(widgetStateChanged()));
	connect(ui.clAccountsBox, SIGNAL(toggled(bool)),
				this, SLOT(widgetStateChanged()));
	connect(ui.showGroupsBox, SIGNAL(stateChanged(int)),
				this, SLOT(widgetStateChanged()));
	connect(ui.separatorBox, SIGNAL(stateChanged(int)),
					this, SLOT(widgetStateChanged()));
	connect(ui.hideGroupsBox, SIGNAL(stateChanged(int)),
					this, SLOT(widgetStateChanged()));
	connect(ui.unsortedButton,SIGNAL(toggled(bool)),
				this, SLOT(widgetStateChanged()));
	connect(ui.byStatusButton,SIGNAL(toggled(bool)),
				this, SLOT(widgetStateChanged()));
	connect(ui.byNameButton,SIGNAL(toggled(bool)),
				this, SLOT(widgetStateChanged()));
	connect(ui.offlineBox, SIGNAL(stateChanged(int)),
						this, SLOT(widgetStateChanged()));
	connect(ui.clientColumnBox, SIGNAL(stateChanged(int)),
						this, SLOT(widgetStateChanged()));
	connect(ui.onTopBox, SIGNAL(stateChanged(int)),
							this, SLOT(widgetStateChanged()));
	connect(ui.ahideBox, SIGNAL(stateChanged(int)),
							this, SLOT(widgetStateChanged()));
	connect(ui.secondsBox, SIGNAL(valueChanged(int)),
								this, SLOT(widgetStateChanged()));
	connect(ui.rowBox, SIGNAL(stateChanged(int)),
								this, SLOT(widgetStateChanged()));
	
	ui.styleComboBox->addItem(tr("Default"), QVariant(":/qss/default.qss"));
	ui.styleComboBox->addItem(tr("Simple"), QVariant(":/qss/simple.qss"));
	connect(ui.styleComboBox,SIGNAL(currentIndexChanged(int)),
				this, SLOT(widgetStateChanged()));
	connect(ui.translationComboBox,SIGNAL(currentIndexChanged(int)),
				this, SLOT(widgetStateChanged()));
	ui.label_2->setHidden(true);
	ui.translationComboBox->setHidden(true);
	
}

mainSettings::~mainSettings()
{

}


void mainSettings::resetStates()
{
	sizePosBoxChange = false;
	hideBoxChange = false;
}

void mainSettings::loadSettings()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim", "mainsettings");
	
	ui.styleComboBox->setCurrentIndex(settings.value("style/index", 0).toInt());
	
	settings.beginGroup("mainwindow");
	ui.sizePosBox->setChecked(settings.value("saveSizPos", true).toBool());
	ui.hideBox->setChecked(settings.value("hideStart", false).toBool());
	ui.menuAccountBox->setChecked(settings.value("accountMenu", true).toBool());
	settings.endGroup();
	ui.loginDialogBox->setChecked(settings.value("logindialog/showstart", true).toBool());
	QSettings settings2(QSettings::IniFormat, QSettings::UserScope, "qutim", "accounts");
	QStringList accountList = settings2.value("accounts/list").toStringList();
	foreach(QString account, accountList)
	{
		ui.accountBox->addItem(QIcon(":/icons/qutim.png"),account);
		ui.trayAccountBox->addItem(QIcon(":/icons/qutim.png"),account);
	}
	if ( settings.value("setting/bydefault", false).toBool() )
	{
		ui.showSettingsBox->setChecked(true);
		int index = accountList.indexOf(settings.value("setting/defacc").toString());
		ui.accountBox->setCurrentIndex(index > -1 ? index : 0);
	}
	
	
	int index = accountList.indexOf(settings.value("systray/current").toString());
	switch ( settings.value("systray/show", 1).toInt() )
	{
	case 0:
		ui.noSysTrayButton->setChecked(true);
		ui.trayAccountBox->setEnabled(false);
		ui.inSysTrayBox->setEnabled(false);
		break;
	case 1:
		ui.statusFromButton->setChecked(true);
		ui.trayAccountBox->setEnabled(true);
		ui.inSysTrayBox->setEnabled(true);
		ui.inSysTrayBox->setChecked(settings.value("systray/inmenu", false).toBool());
		ui.trayAccountBox->setCurrentIndex(index > -1 ? index : 0);
		break;
	default:
		break;
	}
	
	
	bool shwGrps = settings.value("contactlist/groups", false).toBool();
	ui.showGroupsBox->setChecked(shwGrps);
//	ui.hideGroupsBox->setEnabled(shwGrps);
	ui.separatorBox->setChecked(settings.value("contactlist/hidesep", false).toBool());
	ui.hideGroupsBox->setChecked(settings.value("contactlist/hideempty", false).toBool());
	ui.offlineBox->setChecked(settings.value("contactlist/offline", false).toBool());
	ui.clientColumnBox->setChecked(settings.value("contactlist/clicons", false).toBool());
	ui.clAccountsBox->setChecked(settings.value("contactlist/merge", false).toBool());
	if (!ui.clAccountsBox->isChecked() )
		ui.hideGroupsBox->setEnabled(false);
	
	switch(settings.value("contactlist/sort", 1).toInt())
	{
	case 0:
		ui.unsortedButton->setChecked(true);
		break;
	case 3:
		ui.byStatusButton->setChecked(true);
		break;
	case 1:
		ui.byNameButton->setChecked(true);
		break;
	default:
		ui.unsortedButton->setChecked(true);
	}
	ui.onTopBox->setChecked(settings.value("contactlist/ontop", false).toBool());
	ui.ahideBox->setChecked(settings.value("contactlist/ahide", false).toBool());
	ui.secondsBox->setValue(settings.value("contactlist/hidesec", 60).toInt());
	ui.rowBox->setChecked(settings.value("contactlist/colorrow", true).toBool());
}

void mainSettings::saveSettings()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim", "mainsettings");
	int index = ui.styleComboBox->currentIndex();
	
	settings.setValue("style/index", index);
	settings.setValue("style/path", ui.styleComboBox->itemData(index));
	
	settings.beginGroup("mainwindow");
	if( sizePosBoxChange ) settings.setValue("saveSizPos", ui.sizePosBox->isChecked());
	if( hideBoxChange ) settings.setValue("hideStart", ui.hideBox->isChecked());
	settings.setValue("accountMenu", ui.menuAccountBox->isChecked());
	settings.endGroup();
	settings.setValue("logindialog/showstart", ui.loginDialogBox->isChecked());
	if ( ui.showSettingsBox->isChecked() )
	{
		settings.setValue("setting/bydefault", true);
		settings.setValue("setting/defacc", ui.accountBox->currentText());
	} else {
		settings.remove("setting/bydefault");
		settings.remove("setting/defacc");
	}
	if ( ui.noSysTrayButton->isChecked() )
	{
		settings.setValue("systray/show", 0);
	}
	
	
	if ( ui.statusFromButton->isChecked() )
	{
		settings.setValue("systray/show", 1);
		settings.setValue("systray/current", ui.trayAccountBox->currentText());
		settings.setValue("systray/inmenu", ui.inSysTrayBox->isChecked());
	} else {
		settings.remove("systray/current");
		settings.remove("systray/inmenu");
	}
		settings.setValue("contactlist/merge", ui.clAccountsBox->isChecked());
		settings.setValue("contactlist/groups", ui.showGroupsBox->isChecked());
		settings.setValue("contactlist/hideempty", ui.hideGroupsBox->isChecked());
		settings.setValue("contactlist/hidesep", ui.separatorBox->isChecked());
	if ( ui.unsortedButton->isChecked() )
		settings.setValue("contactlist/sort",0);
	if ( ui.byStatusButton->isChecked() )
			settings.setValue("contactlist/sort",3);
	if ( ui.byNameButton->isChecked() )
			settings.setValue("contactlist/sort",1);
	settings.setValue("contactlist/offline", ui.offlineBox->isChecked());
	settings.setValue("contactlist/clicons", ui.clientColumnBox->isChecked());
	settings.setValue("contactlist/ontop",ui.onTopBox->isChecked());
	settings.setValue("contactlist/ahide",ui.ahideBox->isChecked());
	settings.setValue("contactlist/hidesec", ui.secondsBox->value());
	settings.setValue("contactlist/colorrow", ui.rowBox->isChecked());
}

void mainSettings::on_clAccountsBox_toggled(bool on)
{
	if ( on )
	if ( ui.showGroupsBox->isChecked() )
		ui.hideGroupsBox->setEnabled(true);
}
