#############################################################################
# ui.pm extension file, included from the puic-generated form implementation.
# If you wish to add, delete or rename signals or slots use
# the Perl-enabled Qt Designer which will update this file,
# preserving your code.
#
# 'SLOT:' markers are not meant to be created or edited manually.
# Please use the Slots dialog and/or the Object Browser.
#############################################################################


our $par_size;
our $zip_size;
our %group_size;
our $total_size;
our $install_size;


sub init
{
  for (my $i = 0; $i < pageCount (); $i++)
  {
    setHelpEnabled (page ($i), 0);
  }

  setBackEnabled (progress_page, 0);
  setNextEnabled (progress_page, 0);
  setFinishEnabled (finish_page, 1);

  my $prog_name = $ENV {"PAR_PROGNAME"};
  my $zip       = $PAR::LibCache {$prog_name};

  init_hack_zip ($zip);
  init_paths ();
  init_sizes ($prog_name, $zip);
  init_readme ($zip);
}


sub destroy
{
}


sub init_paths
{
  my ($inst_path, $link_path);

  if ($>)
  {
    # non-root
    my $home   = $ENV {"HOME"};
    $inst_path = "$home/qVamps";
    $link_path = "$home/bin";
    $link_path = $home unless (-w ($link_path));
  }
  else
  {
    # root
    $inst_path = "/opt/qVamps";
    $link_path = "/usr/local/bin";
    $inst_path = "/" unless (-w (dirname ($inst_path)));
    $link_path = "/" unless (-w ($link_path));
  }

  inst_path_label -> setText ($inst_path);
  link_path_label -> setText ($link_path);
}


sub file_size
{
  my $file = shift;

  my @stat = stat ($file);

  croak "$file: stat failed: $!" unless (@stat);

  return $stat [7];
}


sub compressed_zip_size
{
  my $zip = shift;

  my $rv = 0;

  foreach my $member ($zip -> members ())
  {
    $rv += $member -> compressedSize ();
  }

  return $rv;
}


sub init_sizes
{
  my $prog_name = shift;
  my $zip       = shift;

  $total_size = 0;
  $par_size   = file_size ($prog_name);
  $zip_size   = compressed_zip_size ($zip);

  foreach my $item (@InstCfg::items,
		    { "group" => "install_time",
		      "type"  => "f",
		      "src"   => "script/main.pl" })
  {
    my $group = $item -> {group};

    next unless ($item -> {type} eq "f");

    $group_size {$group} = {} unless ($group_size {$group});

    my $member = $zip -> memberNamed ($item -> {src});

    $group_size {$group} {compressed}   += $member -> compressedSize ();
    $group_size {$group} {uncompressed} += $member -> uncompressedSize ();
  }
}


sub init_readme
{
  my $zip = shift;

  readme_view -> setText ($zip -> contents ("instfiles/README"));
}


sub init_hack_zip
{
  my $zip = shift;

  foreach my $dir ("shlib/", "shlib/i686-linux/")
  {
    $zip -> removeMember ($dir);

    my $member = $zip -> addDirectory ($dir);
    $member -> unixFileAttributes (0755);
  }

  foreach my $file ("LibDvdRead.so", "libsmokeqt.so.1")
  {
    my $path     = "shlib/i686-linux/$file";
    my $contents = $zip -> contents ($path);

    $zip -> removeMember ($path);

    my $member = $zip -> addString ($contents, $path);
    $member -> unixFileAttributes (0755);
    $member -> desiredCompressionMethod (COMPRESSION_DEFLATED);
    $member -> desiredCompressionLevel (COMPRESSION_LEVEL_BEST_COMPRESSION);
  }

  $zip -> writeToFileNamed ("/dev/null") == AZ_OK or
    croak "/dev/null: writeToFileNamed failed";
}


sub inst_path_dialog
{
  my $inst_path = dirname (inst_path_label -> text ());

  {
    $inst_path =
      Qt::FileDialog::getExistingDirectory ($inst_path, this,
					    "inst_path_dialog",
					    "Installation Base Path Selection",
					    1, 0);

    return unless ($inst_path);

    $inst_path =~ s|/+$||;

    unless (-w ($inst_path))
    {
      error ("You do not have write permission to \"$inst_path\"");
      redo;
    }
  }

  inst_path_label -> setText ("$inst_path/qVamps");
}


sub link_path_dialog
{
  my $link_path = link_path_label -> text ();

  {
    $link_path =
      Qt::FileDialog::getExistingDirectory ($link_path, this,
					    "link_path_dialog",
					  "Executable Link Location Selection",
					    1, 0);

    return unless ($link_path);

    $link_path =~ s|/+$||;

    unless (-w ($link_path))
    {
      error ("You do not have write permission to \"$link_path\"");
      redo;
    }
  }

  link_path_label -> setText ($link_path);
}


sub make_groups
{
  my @rv;

  push @rv, "vamps"            if (vamps_check_box     -> isChecked ());
  push @rv, "dvdauthor"        if (dvdauthor_check_box -> isChecked ());
  push @rv, "mjpeg_tools"      if (mjpeg_check_box     -> isChecked ());
  push @rv, "menu_backgrounds" if (menubg_check_box    -> isChecked ());
  push @rv, "symbolic_link"    if (link_check_box      -> isChecked ());

  return @rv;
}


sub bytes_available
{
  my $dir = shift;

  my ($bsize, $frsize, $blocks, $bfree, $bavail, undef) = statvfs ($dir);

  croak "$dir: statvfs failed: $!" unless ($bavail && $bsize);

  return $bavail * $bsize;
}


sub bytes_required
{
  my $rv     = 0;
  my @groups = make_groups ();

  foreach my $group (keys %group_size)
  {
    $rv -= $group_size {$group} {compressed};
    $rv += $group_size {$group} {uncompressed}
      if (grep ($_ eq $group, @groups));
  }

  return $rv;
}


sub update_disk_space
{
  my $inst_path    = dirname (inst_path_label -> text ());
  my $available_mb = bytes_available ($inst_path)    / 1024. / 1024.;
  my $required_mb  = (bytes_required () + $par_size) / 1024. / 1024.;
  my $format       = ($available_mb < $required_mb) ?
    '<font color="#ff0000">%.1f</font> MB' : "%.1f MB";

  space_available_label -> setText (sprintf '%.1f MB', $available_mb);
  space_required_label  -> setText (sprintf $format, $required_mb);
}


sub update_summary_view
{
  summary_view -> clear ();

  my @groups    = make_groups ();
  my $inst_path = inst_path_label -> text ();
  my $link_path = link_path_label -> text ();

  foreach my $item ({ "type" => "d",
		      "dst"   => $inst_path }, @InstCfg::items)
  {
    my $group = $item -> {group};

    next if ($group && !grep ($_ eq $group, @groups));

    my $dst  = $item -> {dst};
    my $base = $group eq "symbolic_link" ? $link_path : $inst_path;

    $dst = "$base/$dst" unless ($dst =~ m|^/|);

    summary_view -> append ($dst);
  }
}


sub patch_driver
{
  my $inst_path = shift;

  my $drv = "$inst_path/bin/qvamps";

  open (DRV, "<", $drv) or croak "$drv: open for read failed: $!";

  local $/;
  my $script = <DRV>;
  $script    =~ s/_inst_path_/$inst_path/g;

  open (DRV, ">", $drv) or croak "$drv: open for write failed: $!";
  print DRV $script;
  close DRV;
}


sub install
{
  $install_size = bytes_required () + $zip_size;

#  print STDERR "install_size=$install_size, zip_size=$zip_size\n";

  my $inst_path = inst_path_label -> text ();
  my $link_path = link_path_label -> text ();
  my @groups    = make_groups ();

  Installer::run ($inst_path, $link_path, \@groups, \&update_progress_bar);
  patch_driver ($inst_path);
}


sub page_changed # SLOT: ( const QString & )
{
  for (currentPage ())
  {
    if ($_ eq comp_sel_page)
    {
      update_disk_space ();
      last;
    }

    if ($_ eq summary_page)
    {
      update_summary_view ();
      last;
    }

    if ($_ eq progress_page)
    {
      cancelButton () -> setEnabled (0);

      unless ($total_size)
      {
	install ();
	progress_bar -> setProgress (100);
	setNextEnabled (progress_page, 1);
	showPage (finish_page);
      }

      last;
    }

    if ($_ eq finish_page)
    {
      finishButton () -> setFocus ();
      last;
    }
  }
}


sub update_progress_bar
{
  my $size = shift;

  $total_size += $size;

#  print STDERR "total_size=$total_size, install_size=$install_size\n";

  my $percentage = sprintf "%d", ($total_size > $install_size ?
				  1 : $total_size / $install_size) * 99;

  progress_bar -> setProgress ($percentage);
  Qt::Application::processEvents ();
}


sub error
{
  my $msg = shift;

  Qt::MessageBox::warning (undef, &tr ("Error"), $msg, &tr ("Ok"));
}
