#! /usr/bin/perl
#
# This file is part of qVamps.
#
# qVamps is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# qVamps is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qVamps; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


use strict;
use warnings;
use Qt;
use InstWiz;
use InstSplash;
use DesignerMimeSourceFactory_qvamps;


my $app    = Qt::Application (\@ARGV);
my $pixmap = Qt::Pixmap ("images/inst_splash.png");
my $splash = InstSplash ($pixmap);
my $font   = $splash -> font ();

$splash -> show ();

$font   -> setPixelSize (22);
$splash -> setFont ($font);
$splash -> repaint ();

my $win  = InstWiz;
my $icon = Qt::Pixmap::fromMimeSource ("icon.png");

$win    -> setIcon ($icon);
$app    -> setMainWidget ($win);
$win    -> show ();
$splash -> finish ($win);

undef $pixmap;
undef $splash;

exit ($app -> exec ());
