/***************************************************************************
 *   Copyright (C) 2008-2009 by fra74   *
 *   francesco.b74@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SCHEDASTAZIONE_H
#define SCHEDASTAZIONE_H
//

#include <schedaviaggiatreno.h>
//

namespace Stazione {
	enum {colCategoria = 0, colNumero = 1, colStazione = 2, colBinProgrammato = 3,
		  colBinReale = 4, colOrario = 5, colRitardo = 6, colUltima = colRitardo};

//classe che memorizza i dati di ogni singolo treno in arrivo/partenza
class DatiTreno
{
	public:
	// restituisce la categoria del treno
	QString categoria() const {return m_categoria;}
	// imposta la categoria del treno
	void impostaCategoria(const QString& cat) { m_categoria = cat;}
	
	//restiuisce numero del treno
	QString numero() const { return m_numero; }
	//imposta il numero 
	void impostaNumero(const QString& num) { m_numero = num; }

	//restituisce il nome della stazione di origine/destinazione
	QString stazione() const { return m_stazione; }
	//imposta il nome della stazione di origine destinazione
	void impostaStazione(const QString& staz) {m_stazione = staz;}

	//restituisce il binario di arrivo/partenza previsto
	QString binarioProgrammato() const {return m_binario_prog;}
	//imposta il binario di arrivo/partenza previsto
	void impostaBinarioProgrammato(const QString& bp) {m_binario_prog = bp; }
	
	//restituisce il binario di arrivo/partenza reale
	QString binarioReale() const { return m_binario_reale; }
	//imposta il binario di arrivo/partenza reale
	void impostaBinarioReale(const QString& br) { m_binario_reale = br; }
	
	//restituisce l'orario di arrivo/partenza previsto
	QString orario() const { return m_orario; }
	//imposta l'orario di arrivo/partenza previsto
	void impostaOrario(const QString& ora) { m_orario = ora; }
	
	//restituisce il ritardo
	QString ritardo() const { return m_ritardo; }
	//imposta il ritardo
	void impostaRitardo(const QString& rit) { m_ritardo = rit; }
		
	private:
	QString m_categoria, m_numero, m_stazione, m_binario_prog, m_binario_reale, m_orario, m_ritardo;
};
};

class QViaggiaTreno;

class SchedaStazione : public SchedaViaggiaTreno
{
Q_OBJECT

public:
	SchedaStazione(QViaggiaTreno *parent, const QString& nome, const unsigned int intervalloStandard = 2);
	
	QString nomeStazione() const;
	QString codiceStazione() const { return m_codice; } 
	virtual QString titolo( bool titoloItem = false) const;
	virtual void salvaScheda(QSettings& settings);
	
public slots:
	virtual void aggiorna();
	void cambiaCodiceStazione(const QString& nuovoCodice);
	void modificaNomeStazione();
	
protected slots:
	virtual void downloadFinito(QNetworkReply* risposta);
	

private:
	int m_idTabella, m_idNomeSbagliato, m_idNomeAmbiguo;
	QString m_stazione, m_codice;
	QLabel *m_labelTitolo, *m_labelAggiornamento;
	QTableWidget *m_tabellaPartenze, *m_tabellaArrivi;
	QDomDocument *m_documentoDom;
	QList<Stazione::DatiTreno> m_arrivi, m_partenze;
	
	void analizzaDocumentoDom();
	QWidget* creaWidgetStazione();
	QWidget* creaWidgetErroreNome();
	
	void riempiTabelle();
	
private slots:
	void itemAttivato(QTableWidgetItem* item);
};


//widget che viene mostrato quando il nome della stazione introdotto risulta ambiguo
//codice nel file schedastazione_widget.cpp
class WidgetDisambiguaNome : public QWidget
{
Q_OBJECT

public:
	WidgetDisambiguaNome(const QString& rispostaVT, SchedaStazione* parent);
	
private:
	QListWidget* listaNomi;

private slots: 
	void sceltaNomeStazione();	
	
signals:
	void nomeDisambiguato(const QString& nuovoCodice);
};

class TabellaStazione : public QTableWidget
{
Q_OBJECT

public:
	TabellaStazione(QWidget *parent);

	void mouseMoveEvent(QMouseEvent *event);
};

#endif


