$LOAD_PATH << '..' unless $LOAD_PATH.include? '..'
require 'qwik/catalog-factory'
require 'qwik/gettext'

module Qwik
  class Action
    include GetText

    def init_gettext
      init_catalog(@memory.catalog, @req.accept_language)
    end

    def init_catalog(catalog_factory, langs)
      langs.each {|lang|
	catalog = catalog_factory.get_catalog(lang)
        if catalog
          set_catalog(catalog)	# GetText::set_catalog
          return
        end
      }
    end
  end
end

if $0 == __FILE__
  require 'qwik/test-common'
  $test = true
end

if defined?($test) && $test
  class TestCommonGettext < Test::Unit::TestCase
    include TestSession

    def test_init_catalog
      res = session

      accept_languages = ['en']
      @action.init_catalog(@memory.catalog, accept_languages)
      ok_eq('hello', @action._('hello'))

      accept_languages = ['ja']
      @action.init_catalog(@memory.catalog, accept_languages)
      ok_eq('ɂ', @action._('hello'))
    end
  end
end
