% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDelayedArray.R
\name{saveDelayedArray}
\alias{saveDelayedArray}
\alias{stageObject,DelayedArray-method}
\alias{stageObject,DelayedMatrix-method}
\alias{saveObject,DelayedArray-method}
\title{Save DelayedArrays to disk}
\usage{
\S4method{saveObject}{DelayedArray}(
  x,
  path,
  DelayedArray.dispatch.pristine = TRUE,
  DelayedArray.preserve.ops = FALSE,
  DelayedArray.store.args = list(),
  ...
)
}
\arguments{
\item{x}{A \linkS4class{DelayedArray} object.}

\item{path}{String containing a path to a directory in which to save \code{x}.}

\item{DelayedArray.dispatch.pristine}{Logical scalar indicating whether to call the \code{\link{saveObject}} methods of seeds of pristine arrays.}

\item{DelayedArray.preserve.ops}{Logical scalar indicating whether delayed operations should be preserved on-disk.}

\item{DelayedArray.store.args}{Named arguments to pass to \code{\link{storeDelayedObject}}.}

\item{...}{Further arguments, ignored.}
}
\value{
\code{x} is saved to \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save \link{DelayedArray} objects to their on-disk representation.
}
\examples{
mat <- Matrix::rsparsematrix(100, 200, density=0.2)
rownames(mat) <- paste0("GENE_", seq_len(nrow(mat)))
dmat <- DelayedArray::DelayedArray(mat) * 1

dir <- tempfile()
saveObject(dmat, dir, delayed.preserve.ops=TRUE)
list.files(dir)

}
\author{
Aaron Lun
}
