% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DESeqDataSet-class}
\alias{DESeqDataSet}
\alias{DESeqDataSet-class}
\alias{DESeqDataSetFromHTSeqCount}
\alias{DESeqDataSetFromMatrix}
\alias{DESeqDataSetFromTximport}
\title{DESeqDataSet object and constructors}
\usage{
DESeqDataSet(se, design, ignoreRank = FALSE)

DESeqDataSetFromMatrix(countData, colData, design, tidy = FALSE,
  ignoreRank = FALSE, ...)

DESeqDataSetFromHTSeqCount(sampleTable, directory = ".", design,
  ignoreRank = FALSE, ...)

DESeqDataSetFromTximport(txi, colData, design, ...)
}
\arguments{
\item{se}{a \code{RangedSummarizedExperiment} with columns of variables
indicating sample information in \code{colData},
and the counts as the first element in the assays list, which will
be renamed "counts". A \code{RangedSummarizedExperiment} object can be
generated by the function \code{summarizeOverlaps} in the GenomicAlignments
package.}

\item{design}{a \code{formula} which expresses how the counts for each gene
depend on the variables in \code{colData}. Many R \code{formula} are valid,
including designs with multiple variables, e.g., \code{~ group + condition},
and designs with interactions, e.g., \code{~ genotype + treatment + genotype:treatment}.
See \code{\link{results}} for a variety of designs and how to extract results tables.
By default, the functions in this package will use 
the last variable in the formula for building results tables and plotting.
\code{~ 1} can be used for no design, although users need to remember
to switch to another design for differential testing.}

\item{ignoreRank}{use of this argument is reserved for DEXSeq developers only.
Users will immediately encounter an error upon trying to estimate dispersion
using a design with a model matrix which is not full rank.}

\item{countData}{for matrix input: a matrix of non-negative integers}

\item{colData}{for matrix input: a \code{DataFrame} or \code{data.frame} with at least a single column.
Rows of colData correspond to columns of countData}

\item{tidy}{for matrix input: whether the first column of countData is the rownames for the count matrix}

\item{...}{arguments provided to \code{SummarizedExperiment} including rowRanges and metadata. Note that
for Bioconductor 3.1, rowRanges must be a GRanges or GRangesList, with potential metadata columns
as a DataFrame accessed and stored with \code{mcols}. If a user wants to store metadata columns
about the rows of the countData, but does not have GRanges or GRangesList information,
first construct the DESeqDataSet without rowRanges and then add the DataFrame with \code{mcols(dds)}.}

\item{sampleTable}{for htseq-count: a \code{data.frame} with three or more columns. Each row
describes one sample. The first column is the sample name, the second column
the file name of the count file generated by htseq-count, and the remaining
columns are sample metadata which will be stored in \code{colData}}

\item{directory}{for htseq-count: the directory relative to which the filenames are specified. defaults to current directory}

\item{txi}{for tximport: the simple list output of the \code{tximport} function}
}
\value{
A DESeqDataSet object.
}
\description{
\code{DESeqDataSet} is a subclass of \code{RangedSummarizedExperiment},
used to store the input values, intermediate calculations and results of an
analysis of differential expression.  The \code{DESeqDataSet} class
enforces non-negative integer values in the "counts" matrix stored as
the first element in the assay list.
In addition, a formula which specifies the design of the experiment must be provided.
The constructor functions create a DESeqDataSet object
from various types of input:
a RangedSummarizedExperiment, a matrix, count files generated by
the python package HTSeq, or a list from the tximport function in the
tximport package.
See the vignette for examples of construction from different types.
}
\details{
Note on the error message "assay colnames() must be NULL or equal colData rownames()":
this means that the colnames of countData are different than the rownames of colData.
Fix this with: \code{colnames(countData) <- NULL}
}
\examples{

countData <- matrix(1:100,ncol=4)
condition <- factor(c("A","A","B","B"))
dds <- DESeqDataSetFromMatrix(countData, DataFrame(condition), ~ condition)

}
\references{
See \url{http://www-huber.embl.de/users/anders/HTSeq} for htseq-count
}

