% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcriptToX.R
\name{cdsToTranscript}
\alias{cdsToTranscript}
\title{Map positions within the CDS to coordinates relative to the start of
the transcript}
\usage{
cdsToTranscript(x, db, id = "name")
}
\arguments{
\item{x}{\code{IRanges} with the coordinates within the CDS. Coordinates
are expected to be relative to the transcription start (the first
nucleotide of the transcript). The Ensembl IDs of the corresponding
transcripts have to be provided either as \code{names} of the \code{IRanges}, or
in one of its metadata columns.}

\item{db}{\code{EnsDb} object.}

\item{id}{\code{character(1)} specifying where the transcript identifier can be
found. Has to be either \code{"name"} or one of \code{colnames(mcols(prng))}.}
}
\value{
\code{IRanges} with the same length (and order) than the input \code{IRanges}
\code{x}. Each element in \code{IRanges} provides the coordinates within the
transcripts CDS. The transcript-relative coordinates are provided
as metadata columns.
\code{IRanges} with a start coordinate of \code{-1} is returned for transcripts
that are not known in the database, non-coding transcripts or if the
provided start and/or end coordinates are not within the coding region.
}
\description{
Converts CDS-relative coordinates to positions within the transcript, i.e.
relative to the start of the transcript and hence including its 5' UTR.
}
\examples{

library(EnsDb.Hsapiens.v86)
## Defining transcript-relative coordinates for 4 transcripts of the gene
## BCL2
txcoords <- IRanges(start = c(4, 3, 143, 147), width = 1,
    names = c("ENST00000398117", "ENST00000333681",
    "ENST00000590515", "ENST00000589955"))

cdsToTranscript(txcoords, EnsDb.Hsapiens.v86)

## Next we map the coordinate for variants within the gene PKP2 to the
## genome. The variants is PKP2 c.1643DelG and the provided
## position is thus relative to the CDS. We have to convert the
## position first to transcript-relative coordinates.
pkp2 <- IRanges(start = 1643, width = 1, name = "ENST00000070846")

## Map the coordinates by first converting the CDS- to transcript-relative
## coordinates
transcriptToGenome(cdsToTranscript(pkp2, EnsDb.Hsapiens.v86),
    EnsDb.Hsapiens.v86)
}
\seealso{
Other coordinate mapping functions: \code{\link{genomeToProtein}},
  \code{\link{genomeToTranscript}},
  \code{\link{proteinToGenome}},
  \code{\link{proteinToTranscript}},
  \code{\link{transcriptToCds}},
  \code{\link{transcriptToGenome}},
  \code{\link{transcriptToProtein}}
}
\author{
Johannes Rainer
}
