% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMeans.R
\name{rowMeans}
\alias{rowMeans}
\alias{colMeans}
\title{Calculates the mean for each row (column) of a matrix-like object}
\usage{
rowMeans(x, na.rm = FALSE, dims = 1, ...)

colMeans(x, na.rm = FALSE, dims = 1, ...)
}
\arguments{
\item{x}{An NxK matrix-like object, a numeric data frame, or an array-like
object of two or more dimensions.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{dims}{A single integer indicating which dimensions are regarded
as rows or columns to mean over. For \code{rowMeans}, the mean is over
dimensions \code{dims+1, ...}; for \code{colMeans} it is over
dimensions \code{1:dims}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the mean for each row (column) of a matrix-like object.
}
\details{
This man page documents the \code{rowMeans} and \code{colMeans}
\emph{S4 generic functions} defined in the \pkg{MatrixGenerics} package.
See \code{?base::\link[base]{colMeans}} for the default methods (defined
in the \pkg{base} package).
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowMeans(mat)
colMeans(mat)
}
\seealso{
\itemize{
\item \code{base::\link[base]{colMeans}} for the default
\code{rowMeans} and \code{colMeans} methods.
\item \code{Matrix::\link[Matrix]{colMeans}} in the \pkg{Matrix} package
for \code{rowMeans} and \code{colMeans} methods defined for
CsparseMatrix derivatives (e.g. dgCMatrix objects).
}
}
\keyword{algebra}
\keyword{arith}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
