% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spectrum.R
\name{plot_spectrum}
\alias{plot_spectrum}
\title{Plot point mutation spectrum}
\usage{
plot_spectrum(type_occurrences, CT = FALSE, by, colors, legend = TRUE)
}
\arguments{
\item{type_occurrences}{Type occurrences matrix}

\item{CT}{Distinction between C>T at CpG and C>T at other
sites, default = FALSE}

\item{by}{Optional grouping variable}

\item{colors}{Optional color vector with 7 values}

\item{legend}{Plot legend, default = TRUE}
}
\value{
Spectrum plot
}
\description{
Plot point mutation spectrum
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
                package="MutationalPatterns"))


## Load a reference genome.
ref_genome = "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

## Get the type occurrences for all VCF objects.
type_occurrences = mut_type_occurrences(vcfs, ref_genome)

## Plot the point mutation spectrum over all samples
plot_spectrum(type_occurrences)

## Or with distinction of C>T at CpG sites
plot_spectrum(type_occurrences, CT = TRUE)

## Or without legend
plot_spectrum(type_occurrences, CT = TRUE, legend = FALSE)

## Or plot spectrum per tissue
tissue <- c("colon", "colon", "colon",
            "intestine", "intestine", "intestine",
            "liver", "liver", "liver")
plot_spectrum(type_occurrences, by = tissue, CT = TRUE)

## You can also set custom colors.
my_colors = c("pink", "orange", "blue", "lightblue",
                "green", "red", "purple")

## And use them in a plot.
plot_spectrum(type_occurrences,
                CT = TRUE,
                legend = TRUE,
                colors = my_colors)

}
\seealso{
\code{\link{read_vcfs_as_granges}},
\code{\link{mut_type_occurrences}}
}
