% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GiladiHSCData.R
\name{GiladiHSCData}
\alias{GiladiHSCData}
\title{Obtain the Giladi HSC data}
\usage{
GiladiHSCData(
  mode = c("rna", "crispr"),
  filtered = TRUE,
  ensembl = FALSE,
  location = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{mode}{Character vector specifying which modalities should be returned.}

\item{filtered}{Logical scalar indicating whether to filter out cells that were not used by the authors.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers, when \code{mode} contains \code{"rna"}.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned, when \code{mode} contains \code{"rna"}.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a matrix of UMI counts for the scRNA-seq or CRISPR-seq data.
Alternatively, an object with both count matrices, where the second modality is stored as an alternative Experiment.
}
\description{
Obtain the mouse haematopoietic stem cell single-cell RNA-seq and CRISPR-seq dataset from Giladi et al. (2018).
}
\details{
Column metadata is scraped from GEO using the author-supplied TSV of per-cell annotations. 
This contains information such as the batch of origin for each cell plus an array of FACS measurements per cell.

If \code{filtered=TRUE}, only the cells used by the authors in their final analysis are returned.
Otherwise, an additional \code{filtered} field will be present in the \code{\link{colData}}, indicating whether the cell was retained by the authors. 

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.
For row names with multiple semi-colon-delimited symbols, the last symbol is used for matching against the Ensembl annotation.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
This is only relevant when \code{ensembl=TRUE}.

If \code{mode} contains multiple modalities, the intersection of cells that are present in both modalities is returned.
This is because not all cells have data across both modalities.
If \code{mode} contains only one modality, all cells for that modality are returned.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/giladi-hsc}.
}
\examples{
if (.Machine$sizeof.pointer > 4) { # too large for 32-bit machines!
    sce <- GiladiHSCData()
}
}
\references{
Giladi A et al. (2018).
Single-cell characterization of haematopoietic progenitors and their trajectories in homeostasis and perturbed haematopoiesis. 
\emph{Nat Cell Biol} 20, 836-846
}
\author{
Aaron Lun
}
