% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcv-tidiers.R
\name{tidy.gam}
\alias{tidy.gam}
\alias{mgcv_tidiers}
\alias{gam_tidiers}
\title{Tidy a(n) gam object}
\usage{
\method{tidy}{gam}(x, parametric = FALSE, ...)
}
\arguments{
\item{x}{A \code{gam} object returned from a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{parametric}{Logical indicating if parametric or smooth terms should
be tidied. Defaults to \code{FALSE}, meaning that smooth terms are tidied
by default.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
To tidy \code{Gam} objects created by calls to \code{\link[gam:gam]{gam::gam()}},
see \code{\link[=tidy.Gam]{tidy.Gam()}}.
}
\examples{

g <- mgcv::gam(mpg ~ s(hp) + am + qsec, data = mtcars)
  
tidy(g)
tidy(g, parametric = TRUE)
glance(g)


}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[mgcv:gam]{mgcv::gam()}}, \code{\link[=tidy.Gam]{tidy.Gam()}}

Other mgcv tidiers: \code{\link{glance.gam}}
}
\concept{mgcv tidiers}
