\name{knnreg}
\alias{knnreg}
\alias{knnregTrain}
\alias{knnreg.formula}
\alias{knnreg.default}
\alias{knnreg.matrix}
\alias{knnreg.data.frame}
\alias{knnreg}
\title{ k-Nearest Neighbour Regression }
\description{
  $k$-nearest neighbour regression that can return the average value for the neighbours.
}
\usage{

\method{knnreg}{default}(x, ...)

\method{knnreg}{formula}(formula, data, subset, na.action, k = 5, ...) 

\method{knnreg}{matrix}(x, y, k = 5, ...)

\method{knnreg}{data.frame}(x, y, k = 5, ...)

knnregTrain(train, test, y, k = 5, use.all=TRUE)

}
\arguments{
  \item{formula}{a formula of the form \code{lhs ~ rhs} where \code{lhs} 
                 is the response variable and \code{rhs} a set of
                 predictors.}
  \item{data}{optional data frame containing the variables in the
              model formula.} 
  \item{subset}{optional vector specifying a subset of observations
                to be used.}
  \item{na.action}{function which indicates what should happen when
                   the data contain \code{NA}s.}
  \item{k}{number of neighbours considered.}
  
  \item{x}{a matrix or data frame of training set predictors.}

  \item{y}{a numeric vector of outcomes.}

  \item{...}{additional parameters to pass to \code{knnregTrain}.}
  
  \item{train}{matrix or data frame of training set cases.}
  
  \item{test}{matrix or data frame of test set cases. A vector will be interpreted
  as a row vector for a single case.}
    
  \item{use.all}{controls handling of ties. If true, all distances equal to the \code{k}th
  largest are included. If false, a random selection of distances
  equal to the \code{k}th is chosen to use exactly \code{k} neighbours.}  
}

\details{
  \code{knnreg} is similar to \code{\link[ipred]{ipredknn}}
  and \code{knnregTrain} is a modification of \code{\link[class]{knn}}. The underlying 
  C code from the \code{class} package has been modified to return average outcome.
  
}

\value{
  An object of class \code{knnreg}. See \code{\link{predict.knnreg}}.
}

\author{\code{\link[class]{knn}} by  W. N. Venables and B. D. Ripley and 
\code{\link[ipred]{ipredknn}} by 
Torsten.Hothorn <Torsten.Hothorn@rzmail.uni-erlangen.de>,
modifications by Max Kuhn and Chris Keefer }

\examples{
data(BloodBrain)

inTrain <- createDataPartition(logBBB, p = .8)[[1]]

trainX <- bbbDescr[inTrain,]
trainY <- logBBB[inTrain]

testX <- bbbDescr[-inTrain,]
testY <- logBBB[-inTrain]

fit <- knnreg(trainX, trainY, k = 3)

plot(testY, predict(fit, testX))   
}
\keyword{multivariate}
