% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusionMatrix.R
\name{as.matrix.confusionMatrix}
\alias{as.matrix.confusionMatrix}
\alias{as.table.confusionMatrix}
\title{Confusion matrix as a table}
\usage{
\method{as.matrix}{confusionMatrix}(x, what = "xtabs", ...)
}
\arguments{
\item{x}{an object of class \code{\link{confusionMatrix}}}

\item{what}{data to convert to matrix. Either \code{"xtabs"}, \code{"overall"} or  \code{"classes"}}

\item{\dots}{not currently used}
}
\value{
A matrix or table
}
\description{
Conversion functions for class \code{confusionMatrix}
}
\details{
For \code{as.table}, the cross-tabulations are saved. For \code{as.matrix}, the three object types are saved in matrix format.
}
\examples{
###################
## 2 class example

lvs <- c("normal", "abnormal")
truth <- factor(rep(lvs, times = c(86, 258)),
                levels = rev(lvs))
pred <- factor(
               c(
                 rep(lvs, times = c(54, 32)),
                 rep(lvs, times = c(27, 231))),
               levels = rev(lvs))

xtab <- table(pred, truth)

results <- confusionMatrix(xtab)
as.table(results)
as.matrix(results)
as.matrix(results, what = "overall")
as.matrix(results, what = "classes")

###################
## 3 class example

xtab <- confusionMatrix(iris$Species, sample(iris$Species))
as.matrix(xtab)

}
\author{
Max Kuhn
}
\keyword{utilities}

