% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{slice}
\alias{slice}
\title{Choose rows by position}
\usage{
slice(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A tbl.}

\item{...}{Integer row values.  Provide either positive values to keep,
or negative values to drop. The values provided must be either all
positive or all negative.  Indices beyond the number of rows in the
input are silently ignored.

The arguments in \code{...} are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.}

\item{.preserve}{when \code{FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise it is kept as is.}
}
\description{
Choose rows by their ordinal position in the tbl.  Grouped tbls use
the ordinal position within the group.
}
\details{
Slice does not work with relational databases because they have no
intrinsic notion of row order. If you want to perform the equivalent
operation, use \code{\link[=filter]{filter()}} and \code{\link[=row_number]{row_number()}}.
}
\section{Tidy data}{

When applied to a data frame, row names are silently dropped. To preserve,
convert to an explicit variable with \code{\link[tibble:rownames_to_column]{tibble::rownames_to_column()}}.
}

\examples{
slice(mtcars, 1L)
# Similar to tail(mtcars, 1):
slice(mtcars, n())
slice(mtcars, 5:n())
# Rows can be dropped with negative indices:
slice(mtcars, -5:-n())
# In this case, the result will be equivalent to:
slice(mtcars, 1:4)

by_cyl <- group_by(mtcars, cyl)
slice(by_cyl, 1:2)

# Equivalent code using filter that will also work with databases,
# but won't be as fast for in-memory data. For many databases, you'll
# need to supply an explicit variable to use to compute the row number.
filter(mtcars, row_number() == 1L)
filter(mtcars, row_number() == n())
filter(mtcars, between(row_number(), 5, n()))
}
\seealso{
Other single table verbs: \code{\link{arrange}},
  \code{\link{filter}}, \code{\link{mutate}},
  \code{\link{select}}, \code{\link{summarise}}
}
\concept{single table verbs}
