% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{attsurf2df}
\alias{attsurf2df}
\title{Convert a list of attainment surfaces to a data.frame}
\usage{
attsurf2df(x)
}
\arguments{
\item{x}{(\code{list()}) List of data.frames or matrices. The names of the list
give the percentiles of the attainment surfaces.  This is the format
returned by \code{\link[=eafplot]{eafplot()}} (and the internal function \code{compute.eaf.as.list}).}
}
\value{
A data.frame with as many columns as objectives and an additional column \code{percentiles}.
}
\description{
Convert a list of attainment surfaces to a single data.frame.
}
\examples{

data(SPEA2relativeRichmond)
attsurfs <- eafplot (SPEA2relativeRichmond, percentiles = c(0,50,100),
                     xlab = expression(C[E]), ylab = "Total switches",
                     lty=0, pch=21, xlim = c(90, 140), ylim = c(0, 25))
attsurfs <- attsurf2df(attsurfs)
text(attsurfs[,1:2], labels = attsurfs[,3], adj = c(1.5,1.5))

}
\concept{eaf}
