% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_na.R
\name{fct_explicit_na}
\alias{fct_explicit_na}
\title{Make missing values explicit}
\usage{
fct_explicit_na(f, na_level = "(Missing)")
}
\arguments{
\item{f}{A factor (or character vector).}

\item{na_level}{Level to use for missing values: this is what \code{NA}s will be
changed to.}
}
\description{
This gives missing values an explicit factor level, ensuring that they
appear in summaries and on plots.
}
\examples{
f1 <- factor(c("a", "a", NA, NA, "a", "b", NA, "c", "a", "c", "b"))
fct_count(f1)
table(is.na(f1))

f2 <- fct_explicit_na(f1)
fct_count(f2)
table(is.na(f2))
}
