% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/furrr-options.R
\name{furrr_options}
\alias{furrr_options}
\title{Options to fine tune furrr}
\usage{
furrr_options(
  ...,
  stdout = TRUE,
  conditions = NULL,
  globals = TRUE,
  packages = NULL,
  lazy = FALSE,
  seed = FALSE,
  scheduling = 1,
  chunk_size = NULL,
  prefix = NULL
)
}
\arguments{
\item{...}{These dots are reserved for future extensibility and must
be empty.}

\item{stdout}{A logical.
\itemize{
\item If \code{TRUE}, standard output of the underlying futures is captured and
relayed as soon as possible.
\item If \code{FALSE}, output is silenced by sinking it to the null device.
\item If \code{NA}, output is not intercepted. This is not recommended.
}}

\item{conditions}{A character string of conditions classes to be captured
and relayed. The default is the same as the condition argument of
\code{\link[future:Future-class]{future::Future()}}. To not intercept conditions, use
\code{conditions = character(0L)}. Errors are always relayed.}

\item{globals}{A logical, a character vector, a named list, or \code{NULL} for
controlling how globals are handled. For details, see the
\verb{Global variables} section below.}

\item{packages}{A character vector, or \code{NULL}. If supplied, this specifies
packages that are guaranteed to be attached in the R environment where the
future is evaluated.}

\item{lazy}{A logical. Specifies whether futures should be resolved
lazily or eagerly.}

\item{seed}{A logical, an integer of length \code{1} or \code{7}, a list of
\code{length(.x)} with pre-generated random seeds, or \code{NULL}. For details, see
the \verb{Reproducible random number generation (RNG)} section below.}

\item{scheduling}{A single integer, logical, or \code{Inf}. This argument
controls the average number of futures ("chunks") per worker.
\itemize{
\item If \code{0}, then a single future is used to process all elements of \code{.x}.
\item If \code{1} or \code{TRUE}, then one future per worker is used.
\item If \code{2}, then each worker will process two futures (provided there
are enough elements in \code{.x}).
\item If \code{Inf} or \code{FALSE}, then one future per element of \code{.x} is used.
}

This argument is only used if \code{chunk_size} is \code{NULL}.}

\item{chunk_size}{A single integer, \code{Inf}, or \code{NULL}. This argument
controls the average number of elements per future (\code{"chunk"}). If \code{Inf},
then all elements are processed in a single future. If \code{NULL}, then
\code{scheduling} is used instead to determine how \code{.x} is chunked.}

\item{prefix}{A single character string, or \code{NULL}. If a character string,
then each future is assigned a label as \code{{prefix}-{chunk-id}}. If \code{NULL},
no labels are used.}
}
\description{
These options fine tune furrr functions, such as \code{\link[=future_map]{future_map()}}. They
are either used by furrr directly, or are passed on to \code{\link[future:future]{future::future()}}.
}
\section{Global variables}{


\code{globals} controls how globals are identified, similar to the \code{globals}
argument of \code{\link[future:future]{future::future()}}. Since all function calls use the same set of
globals, furrr gathers globals upfront (once), which is more efficient than
if it was done for each future independently.
\itemize{
\item If \code{TRUE} or \code{NULL}, then globals are automatically identified and
gathered.
\item If a character vector of names is specified, then those globals are
gathered.
\item If a named list, then those globals are used as is.
\item In all cases, \code{.f} and any \code{...} arguments are automatically passed as
globals to each future created, as they are always needed.
}
}

\section{Reproducible random number generation (RNG)}{


Unless \code{seed = FALSE}, furrr functions are guaranteed to generate
the exact same sequence of random numbers \emph{given the same initial
seed / RNG state} regardless of the type of futures and scheduling
("chunking") strategy.

Setting \code{seed = NULL} is equivalent to \code{seed = FALSE}, except that the
\code{future.rng.onMisuse} option is not consulted to potentially monitor the
future for faulty random number usage. See the \code{seed} argument of
\code{\link[future:future]{future::future()}} for more details.

RNG reproducibility is achieved by pre-generating the random seeds for all
iterations (over \code{.x}) by using L'Ecuyer-CMRG RNG streams. In each
iteration, these seeds are set before calling \code{.f(.x[[i]], ...)}.
\emph{Note, for large \code{length(.x)} this may introduce a large overhead.}

A fixed \code{seed} may be given as an integer vector, either as a full
L'Ecuyer-CMRG RNG seed of length \code{7}, or as a seed of length \code{1} that
will be used to generate a full L'Ecuyer-CMRG seed.

If \code{seed = TRUE}, then \code{.Random.seed} is returned if it holds a
L'Ecuyer-CMRG RNG seed, otherwise one is created randomly.

If \code{seed = NA}, a L'Ecuyer-CMRG RNG seed is randomly created.

If none of the function calls \code{.f(.x[[i]], ...)} use random number
generation, then \code{seed = FALSE} may be used.

In addition to the above, it is possible to specify a pre-generated
sequence of RNG seeds as a list such that \code{length(seed) == length(.x)} and
where each element is an integer seed that can be assigned to \code{.Random.seed}.
Use this alternative with caution. \emph{Note that \code{as.list(seq_along(.x))} is
not a valid set of such \code{.Random.seed} values.}

In all cases but \code{seed = FALSE}, after a furrr function returns, the RNG
state of the calling R process is guaranteed to be "forwarded one step" from
the RNG state before the call. This is true regardless of the future
strategy / scheduling used. This is done in order to guarantee that an R
script calling \code{future_map()} multiple times should be numerically
reproducible given the same initial seed.
}

\examples{
furrr_options()
}
