% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{git_repo}
\alias{git_repo}
\alias{git_init}
\alias{git_find}
\alias{git_info}
\title{Create or discover a local Git repository}
\usage{
git_init(path = ".", bare = FALSE)

git_find(path = ".")

git_info(repo = ".")
}
\arguments{
\item{path}{the location of the git repository, see details.}

\item{bare}{if true, a Git repository without a working directory is created}

\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}
}
\value{
The path to the Git repository.
}
\description{
Use \code{git_init()} to create a new repository or \code{git_find()} to discover an
existing local repository. \code{git_info()} shows basic information about a
repository, such as the SHA and branch of the current HEAD.
}
\details{
For \code{git_init()} the \code{path} parameter sets the directory of the git repository
to create. If this directory already exists, it must be empty. If it does
not exist, it is created, along with any intermediate directories that don't
yet exist. For \code{git_find()} the \code{path} arguments specifies the directory at
which to start the search for a git repository. If it is not a git repository
itself, then its parent directory is consulted, then the parent's parent, and
so on.
}
\examples{
# directory does not yet exist
r <- tempfile(pattern = "gert")
git_init(r)
git_find(r)

# create a child directory, then a grandchild, then search
r_grandchild_dir <- file.path(r, "aaa", "bbb")
dir.create(r_grandchild_dir, recursive = TRUE)
git_find(r_grandchild_dir)

# cleanup
unlink(r, recursive = TRUE)

# directory exists but is empty
r <- tempfile(pattern = "gert")
dir.create(r)
git_init(r)
git_find(r)

# cleanup
unlink(r, recursive = TRUE)
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_ignore}},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
