% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{glmmTMBControl}
\alias{glmmTMBControl}
\title{Control parameters for glmmTMB optimization}
\usage{
glmmTMBControl(
  optCtrl = NULL,
  optArgs = list(),
  optimizer = nlminb,
  profile = FALSE,
  collect = FALSE,
  parallel = getOption("glmmTMB.cores", 1L),
  eigval_check = TRUE,
  zerodisp_val = log(sqrt(.Machine$double.eps)),
  start_method = list(method = NULL, jitter.sd = 0),
  rank_check = c("warning", "adjust", "stop", "skip"),
  conv_check = c("warning", "skip")
)
}
\arguments{
\item{optCtrl}{Passed as argument \code{control} to optimizer. Default value (if default \code{nlminb} optimizer is used): \code{list(iter.max=300, eval.max=400)}}

\item{optArgs}{additional arguments to be passed to optimizer function (e.g.: \code{list(method="BFGS")} when \code{optimizer=optim})}

\item{optimizer}{Function to use in model fitting. See \code{Details} for required properties of this function.}

\item{profile}{(logical) Experimental option to improve speed and
robustness when a model has many fixed effects}

\item{collect}{(logical) Experimental option to improve speed by
recognizing duplicated observations.}

\item{parallel}{(integer) Set number of OpenMP threads to evaluate
the negative log-likelihood in parallel. The default is to evaluate
models serially (i.e. single-threaded); users can set a default value
for an R session via \code{options(glmmTMB.cores=<value>)}. At present
reduced-rank models (i.e., a covariance structure using \code{rr(...)})
cannot be fitted in parallel; the number of threads will be automatically
set to 1, with a warning if this overrides the user-specified value.}

\item{eigval_check}{Check eigenvalues of variance-covariance matrix? (This test may be very slow for models with large numbers of fixed-effect parameters.)}

\item{zerodisp_val}{value of the dispersion parameter when \code{dispformula=~0} is specified}

\item{start_method}{(list) Options to initialize the starting values when fitting models with reduced-rank (\code{rr}) covariance structures; \code{jitter.sd} adds variation to the starting values of latent variables when \code{method = "res"}.}

\item{rank_check}{Check whether all parameters in fixed-effects models are identifiable? This test may be slow for models with large numbers of fixed-effect parameters, therefore default value is 'warning'. Alternatives include 'skip' (no check), 'stop' (throw an error), and 'adjust' (drop redundant columns from the fixed-effect model matrix).}

\item{conv_check}{Do basic checks of convergence (check for non-positive definite Hessian and non-zero convergence code from optimizer). Default is 'warning'; 'skip' ignores these tests (not recommended for general use!)}
}
\description{
Control parameters for glmmTMB optimization
}
\details{
By default, \code{\link{glmmTMB}} uses the nonlinear optimizer
\code{\link{nlminb}} for parameter estimation. Users may sometimes
need to adjust optimizer settings in order to get models to
converge. For instance, the warning \sQuote{iteration limit reached
without convergence} may be fixed by increasing the number of
iterations using (e.g.)

\code{glmmTMBControl(optCtrl=list(iter.max=1e3,eval.max=1e3))}.

Setting \code{profile=TRUE} allows \code{glmmTMB} to use some special
properties of the optimization problem in order to speed up estimation
in cases with many fixed effects.

Control parameters may depend on the model specification. The value
of the controls is evaluated inside an R object that is derived from
the output of the \code{\link{mkTMBStruc}} function. For example,
to specify that \code{profile} should be enabled if the model has
more than 5 fixed-effect parameters, specify

\code{profile=quote(length(parameters$beta)>=5)}

The \code{optimizer} argument can be any optimization (minimizing) function, provided that:
\itemize{
\item the first three arguments, in order, are the starting values, objective function, and gradient function;
\item the function also takes a \code{control} argument;
\item the function returns a list with elements (at least) \code{par}, \code{objective}, \code{convergence} (0 if convergence is successful) and \code{message}
(\code{glmmTMB} automatically handles output from \code{optim()}, by renaming the \code{value} component to \code{objective})

}
}
\examples{
## fit with default (nlminb) and alternative (optim/BFGS) optimizer
m1 <- glmmTMB(count~ mined, family=poisson, data=Salamanders)
m1B <- update(m1, control=glmmTMBControl(optimizer=optim,
               optArgs=list(method="BFGS")))
## estimates are *nearly* identical:
all.equal(fixef(m1), fixef(m1B))
}
