% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_drive_update.R
\name{shared_drive_update}
\alias{shared_drive_update}
\title{Update a shared drive}
\usage{
shared_drive_update(shared_drive, ...)
}
\arguments{
\item{shared_drive}{Anything that identifies one specific shared drive: its
name, its id or URL marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}. The value
provided to \code{shared_drive} is pre-processed with \code{\link[=as_shared_drive]{as_shared_drive()}}. Read
more about \link[=shared_drives]{shared drives}.}

\item{...}{Properties to set in \code{name = value} form. See the "Request
body" section of the Drive API docs for this endpoint.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per shared drive.
}
\description{
Update the metadata of an existing shared drive, e.g. its background image or
theme.

A shared drive supports files owned by an organization rather than an
individual user. Shared drives follow different sharing and ownership models
from a specific user's "My Drive". Shared drives are the successors to the
earlier concept of Team Drives. Learn more about \link[=shared_drives]{shared drives}.
}
\examples{
\dontrun{
# create a shared drive
sd <- shared_drive_create("I love themes!")

# see the themes available to you
themes <- drive_about()$driveThemes
purrr::map_chr(themes, "id")

# cycle through various themes for this shared drive
sd <- shared_drive_update(sd, themeId = "bok_choy")
sd <- shared_drive_update(sd, themeId = "cocktails")

# clean up
shared_drive_rm(sd)
}
}
\seealso{
Wraps the \code{drives.update} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/reference/drives/update}
}
}
