% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_dependency.R
\name{htmlDependencies}
\alias{attachDependencies}
\alias{htmlDependencies}
\alias{htmlDependencies<-}
\title{HTML dependency metadata}
\usage{
htmlDependencies(x)

htmlDependencies(x) <- value

attachDependencies(x, value, append = FALSE)
}
\arguments{
\item{x}{An object which has (or should have) HTML dependencies.}

\item{value}{An HTML dependency, or a list of HTML dependencies.}

\item{append}{If FALSE (the default), replace any existing dependencies. If
TRUE, add the new dependencies to the existing ones.}
}
\description{
Gets or sets the HTML dependencies associated with an object (such as a tag).
}
\details{
\code{attachDependencies} provides an alternate syntax for setting
dependencies. It is similar to \code{local(\{htmlDependencies(x) <- value;
x\})}, except that if there are any existing dependencies,
\code{attachDependencies} will add to them, instead of replacing them.

As of htmltools 0.3.4, HTML dependencies can be attached without using
\code{attachDependencies}. Instead, they can be added inline, like a child
object of a tag or \code{\link{tagList}}.
}
\examples{
# Create a JavaScript dependency
dep <- htmlDependency("jqueryui", "1.11.4", c(href="shared/jqueryui"),
                      script = "jquery-ui.min.js")

# A CSS dependency
htmlDependency(
  "font-awesome", "4.5.0", c(href="shared/font-awesome"),
  stylesheet = "css/font-awesome.min.css"
)

# A few different ways to add the dependency to tag objects:
# Inline as a child of the div()
div("Code here", dep)
# Inline in a tagList
tagList(div("Code here"), dep)
# With attachDependencies
attachDependencies(div("Code here"), dep)

}

