% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{get.edge.ids}
\alias{get.edge.ids}
\title{Find the edge ids based on the incident vertices of the edges}
\usage{
get.edge.ids(graph, vp, directed = TRUE, error = FALSE, multi = NULL)
}
\arguments{
\item{graph}{The input graph.}

\item{vp}{The incident vertices, given as vertex ids or symbolic vertex
names. They are interpreted pairwise, i.e. the first and second are used for
the first edge, the third and fourth for the second, etc.}

\item{directed}{Logical scalar, whether to consider edge directions in
directed graphs. This argument is ignored for undirected graphs.}

\item{error}{Logical scalar, whether to report an error if an edge is not
found in the graph. If \code{FALSE}, then no error is reported, and zero is
returned for the non-existant edge(s).}

\item{multi}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A numeric vector of edge ids, one for each pair of input vertices.
If there is no edge in the input graph for a given pair of vertices, then
zero is reported. (If the \code{error} argument is \code{FALSE}.)
}
\description{
Find the edges in an igraph graph that have the specified end points. This
function handles multi-graph (graphs with multiple edges) and can consider
or ignore the edge directions in directed graphs.
}
\details{
igraph vertex ids are natural numbers, starting from one, up to the number
of vertices in the graph. Similarly, edges are also numbered from one, up to
the number of edges.

This function allows finding the edges of the graph, via their incident
vertices.
}
\examples{

g <- make_ring(10)
ei <- get.edge.ids(g, c(1, 2, 4, 5))
E(g)[ei]

## non-existant edge
get.edge.ids(g, c(2, 1, 1, 4, 5, 4))

## For multiple edges, a single edge id is returned,
## as many times as corresponding pairs in the vertex series.
g <- make_graph(rep(c(1, 2), 5))
eis <- get.edge.ids(g, c(1, 2, 1, 2))
eis
E(g)[eis]

}
\seealso{
Other structural queries: 
\code{\link{[.igraph}()},
\code{\link{[[.igraph}()},
\code{\link{adjacent_vertices}()},
\code{\link{are_adjacent}()},
\code{\link{ends}()},
\code{\link{gorder}()},
\code{\link{gsize}()},
\code{\link{head_of}()},
\code{\link{incident}()},
\code{\link{incident_edges}()},
\code{\link{is_directed}()},
\code{\link{neighbors}()},
\code{\link{tail_of}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural queries}
