% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordreg.R
\name{ordreg}
\alias{ordreg}
\title{Univariate cumulative link regression models}
\usage{
ordreg(formula, data = parent.frame(), offset,
  family = stats::binomial("probit"), start, fast = FALSE, ...)
}
\arguments{
\item{formula}{formula}

\item{data}{data.frame}

\item{offset}{offset}

\item{family}{family (default proportional odds)}

\item{start}{optional starting values}

\item{fast}{If TRUE standard errors etc. will not be calculated}

\item{...}{Additional arguments to lower level functions}
}
\description{
Ordinal regression models
}
\examples{
m <- lvm(y~x)
ordinal(m,K=3) <- ~y
d <- sim(m,100)
e <- ordreg(y~x,d)
}
\author{
Klaus K. Holst
}
