% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-vcov2.R
\name{vcov2}
\alias{vcov2}
\alias{vcov2.lvmfit}
\alias{vcov2.lvmfit2}
\alias{vcov.lvmfit2}
\title{Variance-Covariance With Small Sample Correction}
\usage{
vcov2(object, robust, cluster, as.lava, ...)

\method{vcov2}{lvmfit}(
  object,
  robust = FALSE,
  cluster = NULL,
  as.lava = TRUE,
  ssc = lava.options()$ssc,
  ...
)

\method{vcov2}{lvmfit2}(object, robust = FALSE, cluster = NULL, as.lava = TRUE, ...)

\method{vcov}{lvmfit2}(object, robust = FALSE, cluster = NULL, as.lava = TRUE, ...)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{robust}{[logical] should robust standard errors be used instead of the model based standard errors? Should be \code{TRUE} if argument cluster is not \code{NULL}.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{as.lava}{[logical] if \code{TRUE}, uses the same names as when using \code{stats::coef}.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}
}
\value{
A matrix with as many rows and columns as the number of coefficients.
}
\description{
Extract the variance-covariance matrix from a latent variable model.
Similar to \code{stats::vcov} but with small sample correction.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the variance-covariance matrix.
}
\examples{
#### simulate data ####
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- Sequence.lvm(0)
set.seed(10)
d <- lava::sim(m,n)

#### linear models ####
e.lm <- lm(formula.lvm,data=d)

#### latent variable models ####
e.lvm <- estimate(lvm(formula.lvm),data=d)
vcov0 <- vcov(e.lvm)
vcovSSC <- vcov2(e.lvm)

vcovSSC/vcov0
vcovSSC[1:4,1:4]/vcov(e.lm)

}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{extractor}
\keyword{smallSampleCorrection}
