% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_linter.R
\name{sort_linter}
\alias{sort_linter}
\title{Require usage of \code{sort()} over \code{.[order(.)]}}
\usage{
sort_linter()
}
\description{
\code{\link[=sort]{sort()}} is the dedicated option to sort a list or vector. It is more legible
and around twice as fast as \code{.[order(.)]}, with the gap in performance
growing with the vector size.
}
\examples{
# will produce lints
lint(
  text = "x[order(x)]",
  linters = sort_linter()
)

lint(
  text = "x[order(x, decreasing = TRUE)]",
  linters = sort_linter()
)

# okay
lint(
  text = "x[sample(order(x))]",
  linters = sort_linter()
)

lint(
  text = "y[order(x)]",
  linters = sort_linter()
)

# If you are sorting several objects based on the order of one of them, such
# as:
x <- sample(1:26)
y <- letters
newx <- x[order(x)]
newy <- y[order(x)]
# This will be flagged by the linter. However, in this very specific case,
# it would be clearer and more efficient to run order() once and assign it
# to an object, rather than mix and match order() and sort()
index <- order(x)
newx <- x[index]
newy <- y[index]

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
