% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periods.r
\name{quick_periods}
\alias{days}
\alias{hours}
\alias{microseconds}
\alias{milliseconds}
\alias{minutes}
\alias{months.numeric}
\alias{nanoseconds}
\alias{picoseconds}
\alias{quick_periods}
\alias{seconds}
\alias{weeks}
\alias{years}
\title{Quickly create period objects.}
\usage{
seconds(x = 1)

minutes(x = 1)

hours(x = 1)

days(x = 1)

weeks(x = 1)

years(x = 1)

milliseconds(x = 1)

microseconds(x = 1)

nanoseconds(x = 1)

picoseconds(x = 1)

\method{months}{numeric}(x, abbreviate)
}
\arguments{
\item{x}{numeric value of the number of units to be contained in the
period. With the exception of seconds(), x must be an integer.}

\item{abbreviate}{Ignored. For consistency with S3 generic in base namespace.}
}
\value{
a period object
}
\description{
Quickly create Period objects for easy date-time manipulation. The units of
the period created depend on the name of the function called. For Period
objects, units do not have a fixed length until they are added to a specific
date time, contrast this with \code{\link{duration}}. This makes periods useful
for manipulations with clock times because units expand or contract in length
to accomodate conventions such as leap years, leap seconds, and Daylight
Savings Time.
}
\details{
When paired with date-times, these functions allow date-times to be
manipulated in a method similar to object oriented programming. Period
objects can be added to Date, POSIXct, and POSIXlt objects to calculate new
date-times.

Note: Arithmetic with periods can results in undefined behavior when
non-existent dates are involved (such as February 29th in non-leap
years). Please see \code{\link{Period-class}} for more details and
\code{\link{\%m+\%}} and \code{\link{add_with_rollback}} for alternative
operations.
}
\examples{

x <- as.POSIXct("2009-08-03")
x + days(1) + hours(6) + minutes(30)
x + days(100) - hours(8)

class(as.Date("2009-08-09") + days(1)) # retains Date class
as.Date("2009-08-09") + hours(12)
class(as.Date("2009-08-09") + hours(12))
# converts to POSIXt class to accomodate time units

years(1) - months(7)
c(1:3) * hours(1)
hours(1:3)

#sequencing
y <- ymd(090101) # "2009-01-01 CST"
y + months(0:11)

# compare DST handling to durations
boundary <- as.POSIXct("2009-03-08 01:59:59")
boundary + days(1) # period
boundary + ddays(1) # duration
# seconds later)
}
\seealso{
\code{\link{Period-class}}, \code{\link{period}},
  \code{\link{ddays}}, \code{\link{\%m+\%}}, \code{\link{add_with_rollback}}
}
\keyword{chron}
\keyword{manip}

