% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{resample_partition}
\alias{resample_partition}
\title{Generate an exclusive partitioning of a data frame}
\usage{
resample_partition(data, p)
}
\arguments{
\item{data}{A data frame}

\item{p}{A named numeric vector giving where the value is the probability
that an observation will be assigned to that group.}
}
\description{
Generate an exclusive partitioning of a data frame
}
\examples{
ex <- resample_partition(mtcars, c(test = 0.3, train = 0.7))
mod <- lm(mpg ~ wt, data = ex$train)
rmse(mod, ex$test)
rmse(mod, ex$train)
}
