% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{block_section}
\alias{block_section}
\title{Section for 'Word'}
\usage{
block_section(property)
}
\arguments{
\item{property}{section properties defined with function \link{prop_section}}
}
\description{
Create a representation of a section.

A section affects preceding paragraphs or tables; i.e.
a section starts at the end of the previous section (or the beginning of
the document if no preceding section exists), and stops where the
section is declared.

When a new landscape section is needed, it is recommended to add a block_section
with \code{type = "continuous"}, to add the content to be appened in the new section
and finally to add a block_section with \code{page_size = page_size(orient = "landscape")}.
}
\examples{
ps <- prop_section(
  page_size = page_size(orient = "landscape"),
  page_margins = page_mar(top = 2),
  type = "continuous"
)
block_section(ps)
}
\seealso{
Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_list}()},
\code{\link{block_pour_docx}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{plot_instr}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
