% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_informations.R
\name{layout_properties}
\alias{layout_properties}
\title{Slide layout properties}
\usage{
layout_properties(x, layout = NULL, master = NULL)
}
\arguments{
\item{x}{an rpptx object}

\item{layout}{slide layout name to use}

\item{master}{master layout name where \code{layout} is located}
}
\description{
Get information about a particular slide layout
into a data.frame.
}
\examples{
x <- read_pptx()
layout_properties ( x = x, layout = "Title Slide", master = "Office Theme" )
layout_properties ( x = x, master = "Office Theme" )
layout_properties ( x = x, layout = "Two Content" )
layout_properties ( x = x )
}
\seealso{
Other functions for reading presentation informations: 
\code{\link{annotate_base}()},
\code{\link{color_scheme}()},
\code{\link{doc_properties}()},
\code{\link{layout_summary}()},
\code{\link{length.rpptx}()},
\code{\link{plot_layout_properties}()},
\code{\link{slide_size}()},
\code{\link{slide_summary}()}
}
\concept{functions for reading presentation informations}
