% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-scientific.R
\name{label_scientific}
\alias{label_scientific}
\title{Label numbers with scientific notation (e.g. 1e05, 1.5e-02)}
\usage{
label_scientific(
  digits = 3,
  scale = 1,
  prefix = "",
  suffix = "",
  decimal.mark = ".",
  trim = TRUE,
  ...
)
}
\arguments{
\item{digits}{Number of digits to show before exponent.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}

\item{prefix, suffix}{Symbols to display before and after value.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Label numbers with scientific notation (e.g. 1e05, 1.5e-02)
}
\examples{
demo_continuous(c(1, 10))
demo_continuous(c(1, 10), labels = label_scientific())
demo_continuous(c(1, 10), labels = label_scientific(digits = 3))

demo_log10(c(1, 1e9))
}
\seealso{
Other labels for continuous scales: 
\code{\link{label_bytes}()},
\code{\link{label_currency}()},
\code{\link{label_number_auto}()},
\code{\link{label_number_si}()},
\code{\link{label_ordinal}()},
\code{\link{label_parse}()},
\code{\link{label_percent}()},
\code{\link{label_pvalue}()}

Other labels for log scales: 
\code{\link{label_bytes}()},
\code{\link{label_log}()},
\code{\link{label_number_si}()}
}
\concept{labels for continuous scales}
\concept{labels for log scales}
