% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{VlnPlot}
\alias{VlnPlot}
\title{Single cell violin plot}
\usage{
VlnPlot(
  object,
  features,
  cols = NULL,
  pt.size = 1,
  idents = NULL,
  sort = FALSE,
  assay = NULL,
  group.by = NULL,
  split.by = NULL,
  adjust = 1,
  y.max = NULL,
  same.y.lims = FALSE,
  log = FALSE,
  ncol = NULL,
  slot = "data",
  split.plot = FALSE,
  combine = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Features to plot (gene expression, metrics, PC scores,
anything that can be retreived by FetchData)}

\item{cols}{Colors to use for plotting}

\item{pt.size}{Point size for geom_violin}

\item{idents}{Which classes to include in the plot (default is all)}

\item{sort}{Sort identity classes (on the x-axis) by the average
expression of the attribute being potted, can also pass 'increasing' or 'decreasing' to change sort direction}

\item{assay}{Name of assay to use, defaults to the active assay}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident)}

\item{split.by}{A variable to split the violin plots by,}

\item{adjust}{Adjust parameter for geom_violin}

\item{y.max}{Maximum y axis value}

\item{same.y.lims}{Set all the y-axis limits to the same values}

\item{log}{plot the feature axis on log scale}

\item{ncol}{Number of columns if multiple plots are displayed}

\item{slot}{Use non-normalized counts data for plotting}

\item{split.plot}{plot each group of the split violin plots by multiple or
single violin shapes.}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed}
ggplot object. If \code{FALSE}, return a list of ggplot objects}
}
\value{
A \code{\link[patchwork]{patchwork}ed} ggplot object if
\code{combine = TRUE}; otherwise, a list of ggplot objects
}
\description{
Draws a violin plot of single cell data (gene expression, metrics, PC
scores, etc.)
}
\examples{
VlnPlot(object = pbmc_small, features = 'PC_1')
VlnPlot(object = pbmc_small, features = 'LYZ', split.by = 'groups')

}
\seealso{
\code{\link{FetchData}}
}
